/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.celleditor.AbstractTextCellEditor;
import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxEditor;
import com.sibvisions.rad.ui.swing.ext.JVxScrollPane;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.model.ui.IEditorControl;
import javax.rad.ui.IAlignmentConstants;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxTextCellEditor
extends AbstractTextCellEditor
implements ICellRenderer<JComponent> {
    private DefaultTableCellRenderer cellRenderer = null;

    public JVxTextCellEditor() {
        this(null);
    }

    public JVxTextCellEditor(String string) {
        super(string);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, (ICellFormatterEditorListener)iCellEditorListener, iDataRow, string);
    }

    @Override
    public JComponent getCellRendererComponent(JComponent jComponent, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new DefaultTableCellRenderer();
            this.setEchoChar(new JPasswordField().getEchoChar());
        }
        this.cellRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.cellRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        try {
            String string2 = iDataRow.getRowDefinition().getColumnDefinition(string).getDataType().convertToString(iDataRow.getValue(string));
            if (string2 != null && this.contentType == "text/plain;password") {
                string2 = this.maskPassword(string2);
            }
            this.cellRenderer.setText(string2);
        }
        catch (Exception exception) {
            this.cellRenderer.setText(null);
        }
        return this.cellRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellEditorHandler
    implements ICellEditorHandler<JComponent>,
    DocumentListener,
    FocusListener,
    KeyListener,
    Runnable {
        private JVxTextCellEditor cellEditor;
        private ICellFormatterEditorListener cellEditorListener;
        private IAlignmentConstants dynamicAlignment = null;
        private IDataRow dataRow;
        private Border oldBorder;
        private String columnName;
        private int maxLength;
        private JComponent cellEditorComponent;
        private JTextComponent textComponent;
        private boolean enterKeyIsUnused;
        private boolean ignoreEvent;
        private boolean firstEditingStarted = true;

        public CellEditorHandler(JVxTextCellEditor jVxTextCellEditor, ICellFormatterEditorListener iCellFormatterEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxTextCellEditor;
            this.cellEditorListener = iCellFormatterEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            String string2 = this.cellEditor.getContentType();
            if (string2 == "text/plain;singleline") {
                this.textComponent = new JTextField(10);
                this.cellEditorComponent = this.textComponent;
                this.enterKeyIsUnused = true;
            } else if (string2 == "text/plain;password") {
                this.textComponent = new JPasswordField(10);
                this.cellEditorComponent = this.textComponent;
                this.enterKeyIsUnused = true;
            } else if (string2 == "text/plain;multiline" || string2 == "text/plain;wrappedmultiline") {
                this.textComponent = new JTextArea(4, 12);
                this.textComponent.setFont(new JTextField().getFont());
                ((JTextArea)this.textComponent).setWrapStyleWord(true);
                ((JTextArea)this.textComponent).setLineWrap(string2 == "text/plain;wrappedmultiline");
                this.enterKeyIsUnused = false;
                this.cellEditorComponent = new JVxScrollPane(this.textComponent);
            } else {
                this.textComponent = new JEditorPane();
                ((JEditorPane)this.textComponent).setContentType(string2);
                this.enterKeyIsUnused = false;
                this.cellEditorComponent = new JVxScrollPane(this.textComponent);
            }
            JVxUtil.installActions(this.textComponent);
            if (this.textComponent instanceof JTextField) {
                if (this.cellEditorListener.getControl() instanceof IAlignmentConstants && this.cellEditorListener.getControl() instanceof IEditorControl) {
                    this.dynamicAlignment = (IAlignmentConstants)((Object)this.cellEditorListener.getControl());
                } else {
                    ((JTextField)this.textComponent).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
                }
            }
            try {
                this.maxLength = ((StringDataType)this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType()).getSize();
            }
            catch (Exception exception) {
                this.maxLength = Integer.MAX_VALUE;
            }
            this.textComponent.getDocument().addDocumentListener(this);
            ((AbstractDocument)this.textComponent.getDocument()).setDocumentFilter(new TextDocumentFilter());
            this.textComponent.setFocusTraversalKeysEnabled(false);
            this.textComponent.addFocusListener(this);
            this.textComponent.addKeyListener(this);
        }

        @Override
        public void uninstallEditor() {
            this.textComponent.getDocument().removeDocumentListener(this);
            this.textComponent.removeFocusListener(this);
            this.textComponent.removeKeyListener(this);
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        @Override
        public void saveEditing() throws ModelException {
            IDataType iDataType = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType();
            Object object = this.dataRow.getValue(this.columnName);
            Object object2 = iDataType.convertToTypeClass(this.textComponent.getText());
            if (!this.cellEditorListener.isSavingImmediate() || iDataType.compareTo(object, object2) != 0) {
                this.dataRow.setValue(this.columnName, object2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void cancelEditing() throws ModelException {
            if (this.ignoreEvent) return;
            this.ignoreEvent = true;
            try {
                block23: {
                    try {
                        boolean bl;
                        ColumnDefinition columnDefinition = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName);
                        String string = columnDefinition.getDataType().convertToString(this.dataRow.getValue(this.columnName));
                        this.textComponent.setText(string);
                        Container container = this.textComponent.getParent();
                        if (container instanceof JViewport) {
                            container = container.getParent().getParent();
                        }
                        boolean bl2 = bl = container == null || container.isEnabled();
                        if (this.dataRow instanceof IDataBook) {
                            boolean bl3;
                            IDataBook iDataBook = (IDataBook)this.dataRow;
                            boolean bl4 = bl3 = bl && iDataBook.isUpdateAllowed() && !columnDefinition.isReadOnly() && iDataBook.getSelectedRow() >= 0;
                            if (bl3 && iDataBook.getReadOnlyChecker() != null) {
                                try {
                                    bl3 = !iDataBook.getReadOnlyChecker().isReadOnly(iDataBook, iDataBook.getDataPage(), iDataBook, this.columnName, iDataBook.getSelectedRow(), -1);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            this.textComponent.setEditable(bl3);
                        } else {
                            this.textComponent.setEditable(bl && !columnDefinition.isReadOnly());
                        }
                        this.styleEditor(columnDefinition);
                        if (this.textComponent.isEditable()) {
                            if (this.textComponent.hasFocus() && (this.cellEditor.getContentType() == "text/plain;singleline" || this.cellEditor.getContentType() == "text/plain;password")) {
                                this.textComponent.selectAll();
                            } else {
                                this.textComponent.select(0, 0);
                            }
                        } else {
                            this.textComponent.select(0, 0);
                        }
                        if (!(container instanceof JComponent)) break block23;
                        this.textComponent.putClientProperty("tabIndex", ((JComponent)container).getClientProperty("tabIndex"));
                    }
                    catch (Exception exception) {
                        this.textComponent.setText(null);
                        this.textComponent.setEditable(false);
                        this.textComponent.setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
                        throw new ModelException("Editor cannot be restored!", exception);
                    }
                }
                Object var9_9 = null;
                Container container = this.cellEditorComponent.getParent();
                if (container instanceof JVxEditor) {
                    if (!((JVxEditor)container).isBorderVisible()) {
                        this.oldBorder = this.cellEditorComponent.getBorder();
                        this.cellEditorComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
                    } else if (this.oldBorder != null) {
                        this.cellEditorComponent.setBorder(this.oldBorder);
                    }
                }
                this.firstEditingStarted = true;
                this.ignoreEvent = false;
                return;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Container container = this.cellEditorComponent.getParent();
                if (container instanceof JVxEditor) {
                    if (!((JVxEditor)container).isBorderVisible()) {
                        this.oldBorder = this.cellEditorComponent.getBorder();
                        this.cellEditorComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
                    } else if (this.oldBorder != null) {
                        this.cellEditorComponent.setBorder(this.oldBorder);
                    }
                }
                this.firstEditingStarted = true;
                this.ignoreEvent = false;
                throw throwable;
            }
        }

        private void styleEditor(ColumnDefinition columnDefinition) throws ModelException {
            Font font;
            Color color;
            Object object;
            CellFormat cellFormat = null;
            if (this.dataRow instanceof IDataBook) {
                object = (IDataBook)this.dataRow;
                if (this.cellEditorListener.getCellFormatter() != null) {
                    try {
                        cellFormat = this.cellEditorListener.getCellFormatter().getCellFormat((IDataBook)object, object.getDataPage(), (IDataRow)object, this.columnName, object.getSelectedRow(), -1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (cellFormat == null) {
                object = null;
                color = null;
                font = null;
            } else {
                object = cellFormat.getBackground();
                color = cellFormat.getForeground();
                font = cellFormat.getFont();
            }
            if (font == null) {
                font = ((Component)((Object)this.cellEditorListener)).getFont();
            }
            if (color == null && ((Component)((Object)this.cellEditorListener)).isForegroundSet()) {
                color = ((Component)((Object)this.cellEditorListener)).getForeground();
            }
            if (object == null && ((Component)((Object)this.cellEditorListener)).isBackgroundSet()) {
                object = ((Component)((Object)this.cellEditorListener)).getBackground();
            }
            this.textComponent.setFont(font);
            if (this.textComponent.isEditable()) {
                if (object == null) {
                    object = columnDefinition.isNullable() ? JVxUtil.getSystemColor("IControl.background") : JVxUtil.getSystemColor("IControl.mandatoryBackground");
                }
            } else {
                object = JVxUtil.getSystemColor("IControl.readOnlyBackground");
            }
            this.textComponent.setBackground((Color)object);
            this.textComponent.setForeground(color);
            if (this.dynamicAlignment != null) {
                int n = this.dynamicAlignment.getHorizontalAlignment();
                if (n == -1) {
                    n = this.cellEditor.getHorizontalAlignment();
                }
                ((JTextField)this.textComponent).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(n));
            }
        }

        @Override
        public void run() {
            try {
                this.saveEditing();
                this.styleEditor(this.dataRow.getRowDefinition().getColumnDefinition(this.columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ignoreEvent = false;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (!this.ignoreEvent && this.cellEditorListener.isSavingImmediate()) {
                    this.ignoreEvent = true;
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (!this.ignoreEvent && this.cellEditorListener.isSavingImmediate()) {
                    this.ignoreEvent = true;
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.textComponent.isEditable() && (this.cellEditor.getContentType() == "text/plain;singleline" || this.cellEditor.getContentType() == "text/plain;password")) {
                this.textComponent.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.fireEditingComplete("FOCUS_LOST");
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        this.fireEditingComplete("ESCAPE_KEY");
                        break;
                    }
                    case 10: {
                        if (keyEvent.getModifiers() == 0 && !this.enterKeyIsUnused) break;
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY");
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY");
                        break;
                    }
                    case 9: {
                        if (keyEvent.getModifiers() == 0 && !this.enterKeyIsUnused) break;
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY");
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY");
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
            }
        }

        protected void fireEditingComplete(String string) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                this.cellEditorListener.editingComplete(string);
            }
        }

        private void replaceAllowed(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            Document document = filterBypass.getDocument();
            int n3 = document.getLength() - n2 + (string != null ? string.length() : 0);
            if (n3 <= this.maxLength) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.textComponent);
            }
        }

        private class TextDocumentFilter
        extends DocumentFilter {
            private TextDocumentFilter() {
            }

            public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                CellEditorHandler.this.replaceAllowed(filterBypass, n, n2, null, null);
            }

            public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                CellEditorHandler.this.replaceAllowed(filterBypass, n, 0, string, attributeSet);
            }

            public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                CellEditorHandler.this.replaceAllowed(filterBypass, n, n2, string, attributeSet);
            }
        }
    }
}

