/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.format.ICellFormatter;
import com.sibvisions.rad.ui.swing.ext.layout.JVxBorderLayout;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.IControl;
import javax.rad.model.ui.IEditorControl;
import javax.rad.ui.IAlignmentConstants;
import javax.rad.util.ExceptionHandler;
import javax.rad.util.TranslationMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxEditor
extends JPanel
implements IEditorControl,
ICellFormatterEditorListener,
FocusListener,
IAlignmentConstants,
Runnable {
    private static final LayoutFocusTraversalPolicy FOCUS_TRAVERSAL_POLICY = new LayoutFocusTraversalPolicy();
    private static ILogger logger = null;
    private IDataRow dataRow = null;
    private String columnName = null;
    private ICellEditor cellEditor = null;
    private ICellFormatter cellFormatter = null;
    private ICellEditorHandler<JComponent> cellEditorHandler = null;
    private Component focusableComponent = null;
    private int horizontalAlignment = -1;
    private int verticalAlignment = -1;
    private TranslationMap translation = null;
    private JTextField dummyEditor = new JTextField(10);
    private boolean savingImmediate = false;
    private boolean firstNotifyRepaintCall = true;
    private boolean isCancelling = false;
    private boolean borderVisible = true;
    private boolean isNotified = false;
    private boolean editingStarted = false;
    private boolean temporaryIsShowingState = false;
    private boolean bTranslationEnabled = true;

    public JVxEditor() {
        super(new JVxBorderLayout());
        this.dummyEditor.setEditable(false);
        this.dummyEditor.setEnabled(false);
        this.add((Component)this.dummyEditor, "Center");
        super.setBackground(null);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.notifyRepaint();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.notifyRepaint();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.notifyRepaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.notifyRepaint();
    }

    @Override
    public boolean isShowing() {
        return this.temporaryIsShowingState || super.isShowing();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.isNotified = true;
        if (this.cellEditorHandler != null) {
            this.focusableComponent = this.getFocusableComponent(this.cellEditorHandler.getCellEditorComponent());
            this.focusableComponent.addFocusListener(this);
            for (MouseListener eventListener : this.getMouseListeners()) {
                this.focusableComponent.addMouseListener(eventListener);
            }
            for (EventListener eventListener : this.getKeyListeners()) {
                this.focusableComponent.addKeyListener((KeyListener)eventListener);
            }
        }
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else {
            this.notifyRepaint();
        }
    }

    @Override
    public void removeNotify() {
        if (this.focusableComponent != null) {
            this.focusableComponent.removeFocusListener(this);
            for (MouseListener eventListener : this.getMouseListeners()) {
                this.focusableComponent.removeMouseListener(eventListener);
            }
            for (EventListener eventListener : this.getKeyListeners()) {
                this.focusableComponent.removeKeyListener((KeyListener)eventListener);
            }
        }
        this.isNotified = false;
        super.removeNotify();
    }

    @Override
    public void requestFocus() {
        if (this.focusableComponent == null) {
            super.requestFocus();
        } else {
            this.focusableComponent.requestFocus();
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this.focusableComponent != null && this.focusableComponent != this) {
            this.focusableComponent.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (this.focusableComponent != null && this.focusableComponent != this) {
            this.focusableComponent.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        if (this.focusableComponent != null && this.focusableComponent != this) {
            this.focusableComponent.addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        super.removeKeyListener(keyListener);
        if (this.focusableComponent != null && this.focusableComponent != this) {
            this.focusableComponent.removeKeyListener(keyListener);
        }
    }

    @Override
    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
        this.notifyRepaint();
    }

    @Override
    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
        this.notifyRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.isCancelling) {
                this.isCancelling = true;
                if (this.isNotified) {
                    this.cancelEditing();
                }
            }
            Object var2_1 = null;
            this.isCancelling = false;
            this.firstNotifyRepaintCall = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isCancelling = false;
            this.firstNotifyRepaintCall = true;
            throw throwable;
        }
    }

    @Override
    public void notifyRepaint() {
        if (this.firstNotifyRepaintCall && !this.editingStarted) {
            this.firstNotifyRepaintCall = false;
            JVxUtil.invokeLater(this);
        }
    }

    @Override
    public void cancelEditing() {
        if (this.editingStarted || this.isCancelling) {
            this.editingStarted = false;
            if (this.cellEditorHandler != null) {
                try {
                    this.cellEditorHandler.cancelEditing();
                }
                catch (ModelException modelException) {
                    if (logger == null) {
                        logger = LoggerFactory.getInstance(this.getClass());
                    }
                    logger.debug(modelException);
                    this.uninstallEditor();
                    this.installEditor();
                }
            }
        }
    }

    @Override
    public void saveEditing() throws ModelException {
        if (this.editingStarted) {
            this.editingStarted = false;
            this.cellEditorHandler.saveEditing();
            this.notifyRepaint();
        }
    }

    @Override
    public ICellFormatter getCellFormatter() {
        return this.cellFormatter;
    }

    @Override
    public void setTranslation(TranslationMap translationMap) {
        if (this.translation != translationMap) {
            this.translation = translationMap;
            try {
                this.saveEditing();
            }
            catch (ModelException modelException) {
                this.cancelEditing();
            }
            this.notifyRepaint();
        }
    }

    @Override
    public TranslationMap getTranslation() {
        return this.translation;
    }

    @Override
    public void setTranslationEnabled(boolean bl) {
        this.bTranslationEnabled = bl;
    }

    @Override
    public boolean isTranslationEnabled() {
        return this.bTranslationEnabled;
    }

    @Override
    public String translate(String string) {
        if (this.bTranslationEnabled && this.translation != null) {
            return this.translation.translate(string);
        }
        return string;
    }

    @Override
    public void editingStarted() {
        try {
            this.editingStarted = true;
            if (this.dataRow instanceof IDataBook) {
                IDataRow iDataRow = this.dataRow.createDataRow(null);
                ((IDataBook)this.dataRow).update();
                if (!iDataRow.equals(this.dataRow, new String[]{this.columnName})) {
                    this.editingStarted = false;
                    this.notifyRepaint();
                }
            }
        }
        catch (ModelException modelException) {
            this.editingStarted = false;
            this.notifyRepaint();
            ExceptionHandler.raise(modelException);
        }
    }

    @Override
    public void editingComplete(String string) {
        if (string == "ESCAPE_KEY") {
            this.cancelEditing();
        } else {
            try {
                this.saveEditing();
            }
            catch (ModelException modelException) {
                this.cancelEditing();
                ExceptionHandler.raise(modelException);
            }
            if (string == "ENTER_KEY") {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            } else if (string == "SHIFT_ENTER_KEY") {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            } else if (string == "TAB_KEY") {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            } else if (string == "SHIFT_TAB_KEY") {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        }
    }

    @Override
    public boolean isSavingImmediate() {
        return this.savingImmediate;
    }

    @Override
    public IControl getControl() {
        return this;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.processFocusEvent(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.processFocusEvent(focusEvent);
    }

    @Override
    public IDataRow getDataRow() {
        return this.dataRow;
    }

    @Override
    public void setDataRow(IDataRow iDataRow) throws ModelException {
        this.uninstallEditor();
        this.dataRow = iDataRow;
        this.installEditor();
    }

    public String getEditorComponentName() {
        return this.dummyEditor.getName();
    }

    public void setEditorComponentName(String string) {
        this.dummyEditor.setName(string);
        if (this.cellEditorHandler != null && this.cellEditorHandler.getCellEditorComponent() instanceof JComboBox) {
            this.cellEditorHandler.getCellEditorComponent().setName(string);
        } else if (this.focusableComponent != null) {
            this.focusableComponent.setName(string);
        }
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public void setColumnName(String string) throws ModelException {
        this.uninstallEditor();
        this.columnName = string;
        this.installEditor();
    }

    public void setSavingImmediate(boolean bl) {
        this.savingImmediate = bl;
    }

    private void uninstallEditor() {
        if (this.cellEditorHandler != null) {
            if (this.focusableComponent != null) {
                this.focusableComponent.removeFocusListener(this);
                for (MouseListener eventListener : this.getMouseListeners()) {
                    this.focusableComponent.removeMouseListener(eventListener);
                }
                for (EventListener eventListener : this.getKeyListeners()) {
                    this.focusableComponent.removeKeyListener((KeyListener)eventListener);
                }
            }
            this.cellEditorHandler.uninstallEditor();
            this.dataRow.removeControl(this);
            this.remove(this.cellEditorHandler.getCellEditorComponent());
            this.cellEditorHandler = null;
        } else {
            this.remove(this.dummyEditor);
        }
    }

    public void setBorderVisible(boolean bl) {
        this.uninstallEditor();
        this.borderVisible = bl;
        this.installEditor();
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    private void installEditor() {
        this.dummyEditor.setBackground(null);
        this.dummyEditor.setEditable(true);
        this.dummyEditor.setEnabled(true);
        this.dummyEditor.setEditable(false);
        this.dummyEditor.setEnabled(false);
        this.focusableComponent = null;
        if (this.dataRow != null && this.columnName != null) {
            try {
                IDataType iDataType = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType();
                ICellEditor iCellEditor = this.cellEditor == null ? iDataType.getCellEditor() : this.cellEditor;
                if (iCellEditor == null) {
                    iCellEditor = JVxUtil.getDefaultCellEditor(iDataType.getTypeClass());
                }
                this.cellEditorHandler = iCellEditor.createCellEditorHandler(this, this.dataRow, this.columnName);
                Component component = this.cellEditorHandler.getCellEditorComponent();
                this.add(component, "Center");
                this.dataRow.addControl(this);
                if (this.isNotified) {
                    this.focusableComponent = this.getFocusableComponent(component);
                    this.focusableComponent.addFocusListener(this);
                    for (MouseListener eventListener : this.getMouseListeners()) {
                        this.focusableComponent.addMouseListener(eventListener);
                    }
                    for (EventListener eventListener : this.getKeyListeners()) {
                        this.focusableComponent.addKeyListener((KeyListener)eventListener);
                    }
                    this.run();
                }
            }
            catch (ModelException modelException) {
                this.dummyEditor.setBackground(JVxUtil.getSystemColor("IControl.invalidEditorBackground"));
            }
        }
        if (this.cellEditorHandler == null) {
            this.add((Component)this.dummyEditor, "Center");
        }
        JVxUtil.revalidateAllDelayed(this);
    }

    protected Component getFocusableComponent(Component component) {
        this.temporaryIsShowingState = true;
        Component component2 = FOCUS_TRAVERSAL_POLICY.getFirstComponent(this);
        this.temporaryIsShowingState = false;
        if (component2 == null || component2 == this) {
            component.setName(this.dummyEditor.getName());
            return component;
        }
        if (component instanceof JComboBox) {
            component.setName(this.dummyEditor.getName());
        } else if (!StringUtil.isEmpty(this.dummyEditor.getName())) {
            component2.setName(this.dummyEditor.getName());
        }
        return component2;
    }

    @Override
    public ICellEditor getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public void setCellEditor(ICellEditor iCellEditor) throws ModelException {
        this.uninstallEditor();
        this.cellEditor = iCellEditor;
        this.installEditor();
    }

    public ICellEditorHandler<JComponent> getCellEditorHandler() {
        return this.cellEditorHandler;
    }

    public void setCellFormatter(ICellFormatter iCellFormatter) {
        this.cellFormatter = iCellFormatter;
    }
}

