/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.event.IMenuActionListener;
import com.sibvisions.util.ArrayUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.rad.util.SilentAbortException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JVxButton
extends JButton
implements MouseListener,
MouseMotionListener {
    private static final String BUTTON_ACCELERATOR = "buttonAccelerator";
    private static final String BORDER_ON_MOUSE_ENTERED = "borderOnMouseEntered";
    private static final AcceleratorAction ACCELERATOR_ACTION_PRESSED = new AcceleratorAction("pressed");
    private static final AcceleratorAction ACCELERATOR_ACTION_RELEASED = new AcceleratorAction("released");
    private static WeakHashMap<AbstractButton, Long> borderRemovedTime = new WeakHashMap();
    private Insets insOrig;
    private Image imgArrow;
    private Image imgSeparator;
    private Rectangle rectCachedBounds;
    private JSeparator separator;
    private JPopupMenu menu;
    private Rectangle rectSplitArea;
    private JMenuItem miDefault;
    private ArrayUtil<ActionListener> auInternalListener;
    private int iSplitWidth = 20;
    private int iArrowWidth = 8;
    private boolean bIsOverSplitArea = false;
    private boolean bDefault = false;

    public JVxButton() {
        super(null, null);
    }

    public JVxButton(Icon icon) {
        super(null, icon);
    }

    public JVxButton(String string) {
        super(string, null);
    }

    public JVxButton(Action action) {
        super(null, null);
        this.setAction(action);
    }

    public JVxButton(String string, Icon icon) {
        super(string, icon);
    }

    public boolean isShowing() {
        if (this.getClientProperty("jvx.isSuperShowing") != null) {
            return super.isShowing();
        }
        if (super.isShowing()) {
            Long l;
            if (!this.isContentAreaFilled() && (l = borderRemovedTime.get(this)) != null) {
                long l2 = System.currentTimeMillis() - l;
                if (l2 < 210L) {
                    return l2 < 70L;
                }
                borderRemovedTime.remove(this);
            }
            return true;
        }
        return false;
    }

    public boolean isDefaultButton() {
        return this.bDefault || super.isDefaultButton();
    }

    public void addNotify() {
        JButton jButton;
        JRootPane jRootPane;
        super.addNotify();
        if (this.bDefault && (jRootPane = SwingUtilities.getRootPane(this)) != null && (jButton = jRootPane.getDefaultButton()) != this) {
            if (jButton instanceof JVxButton) {
                ((JVxButton)jButton).setDefaultButton(false);
            }
            jRootPane.setDefaultButton(this);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        super.removeActionListener(actionListener);
        if (this.auInternalListener != null) {
            this.auInternalListener.remove(actionListener);
        }
    }

    public void setMargin(Insets insets) {
        this.insOrig = insets;
        if (this.menu != null) {
            super.setMargin(new Insets(this.insOrig.top, this.insOrig.left, this.insOrig.bottom, this.insOrig.right + 20));
        } else {
            super.setMargin(insets);
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.menu != null) {
            Graphics graphics2;
            BufferedImage bufferedImage;
            Dimension dimension = this.getSize();
            Rectangle rectangle = this.getBounds();
            if (!rectangle.equals(this.rectCachedBounds)) {
                this.imgSeparator = null;
            }
            this.rectSplitArea = new Rectangle(dimension.width - this.iSplitWidth, 0, this.iSplitWidth, dimension.height);
            if (this.isBorderPainted() && this.isEnabled()) {
                if (this.imgSeparator == null) {
                    bufferedImage = new BufferedImage(4, dimension.width, 2);
                    graphics2 = bufferedImage.getGraphics();
                    if (this.separator == null) {
                        this.separator = new JSeparator(1);
                        this.separator.setEnabled(this.isEnabled());
                    }
                    this.separator.setBounds(4, 4, 4, this.getSize().height - 8);
                    this.separator.paint(graphics2);
                    graphics2.dispose();
                    this.imgSeparator = bufferedImage;
                }
                graphics.drawImage(this.imgSeparator, dimension.width - this.iSplitWidth, 4, this);
            }
            if (this.imgArrow == null) {
                this.rectCachedBounds = rectangle;
                bufferedImage = new BufferedImage(this.iArrowWidth, this.iArrowWidth, 2);
                graphics2 = bufferedImage.getGraphics();
                if (this.isEnabled()) {
                    graphics2.setColor(Color.black);
                } else {
                    graphics2.setColor(new Color(153, 153, 153));
                }
                graphics2.fillPolygon(new int[]{0, this.iArrowWidth, this.iArrowWidth / 2}, new int[]{0, 0, this.iArrowWidth / 2}, 3);
                graphics2.dispose();
                this.imgArrow = bufferedImage;
            }
            graphics.drawImage(this.imgArrow, dimension.width - this.iSplitWidth - 1 + (this.iSplitWidth - this.iArrowWidth) / 2, (dimension.height - this.iArrowWidth / 2) / 2 + 1, this);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            this.imgArrow = null;
        }
        if (this.separator != null) {
            this.separator.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.menu != null) {
            if (this.bIsOverSplitArea) {
                try {
                    this.fireMenuActionPerformed(actionEvent);
                    this.setMenuVisible(true);
                }
                catch (SilentAbortException silentAbortException) {}
            } else {
                ActionListener[] actionListenerArray = this.getActionListeners();
                int n = actionListenerArray.length;
                if (this.auInternalListener != null) {
                    for (int i = 0; i < actionListenerArray.length; ++i) {
                        if (this.auInternalListener.indexOf(actionListenerArray[i]) < 0) continue;
                        --n;
                    }
                }
                if (n == 0) {
                    if (this.miDefault != null) {
                        this.miDefault.doClick(0);
                    } else {
                        try {
                            this.fireMenuActionPerformed(actionEvent);
                            this.setMenuVisible(true);
                        }
                        catch (SilentAbortException silentAbortException) {}
                    }
                } else {
                    super.fireActionPerformed(actionEvent);
                }
            }
        } else {
            super.fireActionPerformed(actionEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.rectSplitArea != null) {
            this.bIsOverSplitArea = false;
            this.repaint(this.rectSplitArea);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.rectSplitArea != null) {
            this.bIsOverSplitArea = this.rectSplitArea.contains(mouseEvent.getPoint());
            this.repaint(this.rectSplitArea);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void setDefaultButton(boolean bl) {
        this.bDefault = bl;
    }

    public KeyStroke getAccelerator() {
        return JVxButton.getAccelerator(this);
    }

    public void setAccelerator(KeyStroke keyStroke) {
        JVxButton.setAccelerator(this, keyStroke);
    }

    public boolean isBorderOnMouseEntered() {
        return JVxButton.isBorderOnMouseEntered(this);
    }

    public void setBorderOnMouseEntered(boolean bl) {
        JVxButton.setBorderOnMouseEntered(this, bl);
    }

    private static KeyStroke getKeyStroke(KeyStroke keyStroke, boolean bl) {
        int n = keyStroke.getKeyCode();
        if (n == 0) {
            n = Character.toUpperCase(keyStroke.getKeyChar());
        }
        return KeyStroke.getKeyStroke(keyStroke.getKeyCode(), keyStroke.getModifiers(), bl);
    }

    public static KeyStroke getAccelerator(AbstractButton abstractButton) {
        return (KeyStroke)abstractButton.getClientProperty(BUTTON_ACCELERATOR);
    }

    public static void setAccelerator(AbstractButton abstractButton, KeyStroke keyStroke) {
        KeyStroke keyStroke2 = JVxButton.getAccelerator(abstractButton);
        if (keyStroke2 != null) {
            abstractButton.getActionMap().remove("pressed");
            abstractButton.getInputMap(2).remove(JVxButton.getKeyStroke(keyStroke2, false));
            abstractButton.getActionMap().remove("released");
            abstractButton.getInputMap(2).remove(JVxButton.getKeyStroke(keyStroke2, true));
        }
        abstractButton.putClientProperty(BUTTON_ACCELERATOR, keyStroke);
        if (keyStroke != null) {
            abstractButton.getActionMap().put("pressed", ACCELERATOR_ACTION_PRESSED);
            abstractButton.getInputMap(2).put(JVxButton.getKeyStroke(keyStroke, false), "pressed");
            abstractButton.getActionMap().put("released", ACCELERATOR_ACTION_RELEASED);
            abstractButton.getInputMap(2).put(JVxButton.getKeyStroke(keyStroke, true), "released");
        }
    }

    public static boolean isBorderOnMouseEntered(AbstractButton abstractButton) {
        return abstractButton.getClientProperty(BORDER_ON_MOUSE_ENTERED) != null;
    }

    public static void setBorderOnMouseEntered(AbstractButton abstractButton, boolean bl) {
        BorderOnMouseEnteredListener borderOnMouseEnteredListener = (BorderOnMouseEnteredListener)abstractButton.getClientProperty(BORDER_ON_MOUSE_ENTERED);
        if (bl) {
            if (borderOnMouseEnteredListener == null) {
                borderOnMouseEnteredListener = new BorderOnMouseEnteredListener(abstractButton);
                abstractButton.putClientProperty(BORDER_ON_MOUSE_ENTERED, borderOnMouseEnteredListener);
                abstractButton.addMouseListener(borderOnMouseEnteredListener);
                abstractButton.addPropertyChangeListener("ancestor", borderOnMouseEnteredListener);
                abstractButton.getModel().addChangeListener(borderOnMouseEnteredListener);
                abstractButton.putClientProperty("jvx.opaque", abstractButton.isOpaque());
                abstractButton.setOpaque(false);
            }
        } else if (borderOnMouseEnteredListener != null) {
            abstractButton.putClientProperty(BORDER_ON_MOUSE_ENTERED, null);
            abstractButton.removeMouseListener(borderOnMouseEnteredListener);
            abstractButton.getModel().removeChangeListener(borderOnMouseEnteredListener);
            Boolean bl2 = (Boolean)abstractButton.getClientProperty("jvx.opaque");
            if (bl2 != null) {
                abstractButton.putClientProperty("jvx.opaque", null);
                abstractButton.setOpaque(bl2);
            }
            borderOnMouseEnteredListener.setBorderVisible(true);
        }
    }

    protected void fireMenuActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent2 = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IMenuActionListener.class) continue;
            if (actionEvent2 == null) {
                String string = actionEvent.getActionCommand();
                if (string == null) {
                    string = this.getActionCommand();
                }
                actionEvent2 = new ActionEvent(this, 1001, string, actionEvent.getWhen(), actionEvent.getModifiers());
            }
            ((IMenuActionListener)objectArray[i + 1]).menuActionPerformed(actionEvent2);
        }
    }

    protected void setMenuVisible(boolean bl) {
        if (this.menu != null) {
            if (bl) {
                this.menu.setPopupSize(null);
                Dimension dimension = this.menu.getPreferredSize();
                int n = this.getWidth();
                if (n < dimension.width) {
                    n = dimension.width;
                }
                this.menu.setPopupSize(n, dimension.height);
                this.menu.show(this, 0, this.getHeight());
            } else {
                this.menu.setVisible(false);
            }
        }
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        if (this.menu == null) {
            this.removeMouseMotionListener(this);
            this.removeMouseListener(this);
            this.rectSplitArea = null;
        } else {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }
        this.setMargin(this.insOrig);
    }

    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    public void setDefaultItem(JMenuItem jMenuItem) {
        this.miDefault = jMenuItem;
    }

    public JMenuItem getDefaultItem() {
        return this.miDefault;
    }

    public void addMenuActionListener(IMenuActionListener iMenuActionListener) {
        this.listenerList.add(IMenuActionListener.class, iMenuActionListener);
    }

    public void removeMenuActionListener(IMenuActionListener iMenuActionListener) {
        this.listenerList.remove(IMenuActionListener.class, iMenuActionListener);
    }

    public void addIgnoreActionListener(ActionListener actionListener) {
        if (this.auInternalListener == null) {
            this.auInternalListener = new ArrayUtil();
        }
        if (this.auInternalListener.indexOf(actionListener) < 0) {
            this.auInternalListener.add(actionListener);
        }
    }

    private static class AcceleratorAction
    extends AbstractAction {
        private static final String PRESSED = "pressed";
        private static final String RELEASED = "released";

        AcceleratorAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            Object object = this.getValue("Name");
            if (object == PRESSED) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus()) {
                    abstractButton.requestFocus();
                }
            } else if (object == RELEASED) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }
    }

    private static class BorderOnMouseEnteredListener
    implements ChangeListener,
    PropertyChangeListener,
    MouseListener {
        private AbstractButton abstractButton;
        private boolean entered = false;

        BorderOnMouseEnteredListener(AbstractButton abstractButton) {
            this.abstractButton = abstractButton;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.entered) {
                this.setBorderVisible(this.abstractButton.getModel().isPressed() || this.abstractButton.getModel().isSelected());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.abstractButton.isEnabled() && (mouseEvent.getModifiers() & 0x1C) == 0) {
                this.entered = true;
                this.setBorderVisible(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.entered) {
                this.entered = false;
                this.setBorderVisible(this.abstractButton.getModel().isPressed() || this.abstractButton.getModel().isSelected());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        protected void setBorderVisible(boolean bl) {
            if (this.abstractButton.isBorderPainted() != bl) {
                boolean bl2 = this.abstractButton.isOpaque();
                if (!bl && this.abstractButton.isShowing()) {
                    try {
                        this.abstractButton.getUI().update(this.abstractButton.getGraphics(), this.abstractButton);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    borderRemovedTime.put(this.abstractButton, System.currentTimeMillis());
                }
                this.abstractButton.setBorderPainted(bl);
                this.abstractButton.setContentAreaFilled(bl);
                if (bl2 != this.abstractButton.isOpaque()) {
                    this.abstractButton.setOpaque(bl2);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.entered && propertyChangeEvent.getNewValue() == null) {
                this.entered = false;
            }
            this.setBorderVisible(this.abstractButton.getModel().isPressed() || this.abstractButton.getModel().isSelected());
        }
    }
}

