/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.protocol;

import com.sibvisions.rad.server.protocol.IProtocolWriter;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ICloseable;
import com.sibvisions.util.log.LoggerFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class Record
implements ICloseable {
    private static final String PREFIX_ID = Long.toString(System.currentTimeMillis(), 36);
    private static AtomicInteger aiSequence = new AtomicInteger(0);
    private IProtocolWriter writer;
    protected String sUUID;
    protected String sCategory;
    protected String sCommand;
    protected Object[] oIdentifier;
    protected Object[] oParameter;
    protected Throwable exception;
    protected long lCreationNano;
    protected long lCreation;
    protected long lDuration = -1L;
    protected long lMemoryInitial;
    protected long lMemoryConsumption = -1L;
    protected int iCount;
    private boolean bClosing;

    public Record(String string, String string2) {
        this(null, string, string2);
    }

    public Record(IProtocolWriter iProtocolWriter, String string, String string2) {
        this.writer = iProtocolWriter;
        this.sCategory = string;
        this.sCommand = string2;
        this.lCreationNano = System.nanoTime();
        this.lCreation = System.currentTimeMillis();
        Runtime runtime = Runtime.getRuntime();
        this.lMemoryInitial = runtime.totalMemory() - runtime.freeMemory();
        this.sUUID = PREFIX_ID + "-" + aiSequence.incrementAndGet();
    }

    public String getUUID() {
        return this.sUUID;
    }

    public String getCategory() {
        return this.sCategory;
    }

    public String getCommand() {
        return this.sCommand;
    }

    public long getCreationTime() {
        return this.lCreation;
    }

    public long getDuration() {
        return this.lDuration;
    }

    public void setParameter(Object ... objectArray) {
        this.oParameter = objectArray;
    }

    public Object[] getParameter() {
        return this.oParameter;
    }

    public void addIdentifier(Object object) {
        this.oIdentifier = ArrayUtil.add(this.oIdentifier, object);
    }

    public void addIdentifier(Object object, int n) {
        this.oIdentifier = ArrayUtil.add(this.oIdentifier, n, object);
    }

    public Object[] getIdentifier() {
        return this.oIdentifier;
    }

    public void setCount(int n) {
        this.iCount = n;
    }

    public int getCount() {
        return this.iCount;
    }

    public long getMemoryInitial() {
        return this.lMemoryInitial;
    }

    public long getMemoryConsumption() {
        return this.lMemoryConsumption;
    }

    public void setException(Throwable throwable) {
        this.exception = throwable;
    }

    public Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.bClosing) {
            this.bClosing = true;
            this.lDuration = System.nanoTime() - this.lCreationNano;
            Runtime runtime = Runtime.getRuntime();
            this.lMemoryConsumption = runtime.totalMemory() - runtime.freeMemory() - this.lMemoryInitial;
            try {
                if (this.writer != null) {
                    this.writer.closeRecord(this);
                } else {
                    ProtocolFactory.getWriter().closeRecord(this);
                }
            }
            catch (Throwable throwable) {
                LoggerFactory.getInstance(Record.class).error(throwable);
            }
            finally {
                this.bClosing = false;
            }
        }
    }
}

