/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpToDateConfigFile
implements Cloneable {
    private File fiConfig;
    private InputStream stream;
    private XmlNode xmnConfig = null;
    private long lLastModified = -1L;
    private boolean bUpdateEnabled = true;
    private boolean bSaveImmediate = true;
    private boolean bChanged = false;
    private boolean bVirtual = false;
    private boolean bStream = false;
    private boolean bCloneNodes = false;
    private boolean bModifiedByInclude = false;

    public UpToDateConfigFile(File file, String string) throws Exception {
        if (file != null && string != null) {
            this.fiConfig = new File(file, string);
        }
        this.update();
    }

    public UpToDateConfigFile(File file) throws Exception {
        this.fiConfig = file;
        this.update();
    }

    UpToDateConfigFile() {
        this.bVirtual = true;
    }

    UpToDateConfigFile(InputStream inputStream) throws Exception {
        this.stream = inputStream;
        this.bVirtual = true;
        this.bStream = true;
        this.update();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            this.update();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        UpToDateConfigFile upToDateConfigFile = (UpToDateConfigFile)super.clone();
        upToDateConfigFile.xmnConfig = (XmlNode)this.xmnConfig.clone();
        return upToDateConfigFile;
    }

    public File getFile() {
        if (this.bVirtual) {
            return null;
        }
        return this.fiConfig;
    }

    public boolean isValid() {
        return this.bVirtual || UpToDateConfigFile.isValid(this.fiConfig);
    }

    static boolean isValid(File file) {
        return file != null && file.exists();
    }

    protected void update() throws Exception {
        if (this.isValid()) {
            if (this.isUpdateEnabled() && (this.lLastModified <= 0L || this.fiConfig != null && this.lLastModified != this.fiConfig.lastModified())) {
                this.reload();
            }
        } else {
            throw new Exception("Invalid configuration file: " + (this.fiConfig != null ? this.fiConfig.getAbsolutePath() : null));
        }
    }

    public synchronized void setProperty(String string, String string2) throws Exception {
        this.update();
        if (string2 == null) {
            this.xmnConfig.removeNode(string);
        } else {
            this.xmnConfig.setNode(string, string2);
        }
        this.bChanged = true;
        if (this.bSaveImmediate) {
            this.save();
        }
    }

    public synchronized void setNode(String string, XmlNode xmlNode) throws Exception {
        this.update();
        if (xmlNode == null) {
            this.xmnConfig.removeNode(string);
        } else {
            this.xmnConfig.setNode(string, xmlNode);
        }
        this.bChanged = true;
        if (this.bSaveImmediate) {
            this.save();
        }
    }

    public synchronized String getProperty(String string) throws Exception {
        return this.getProperty(string, null);
    }

    public synchronized String getProperty(String string, String string2) throws Exception {
        this.update();
        XmlNode xmlNode = this.xmnConfig.getNode(string);
        if (xmlNode != null) {
            return CommonUtil.nvl(xmlNode.getValue(), "");
        }
        return string2;
    }

    public synchronized List<String> getProperties(String string) throws Exception {
        this.update();
        List<XmlNode> list = this.xmnConfig.getNodes(string);
        if (list == null) {
            return null;
        }
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (XmlNode xmlNode : list) {
            arrayUtil.add(CommonUtil.nvl(xmlNode.getValue(), ""));
        }
        return arrayUtil;
    }

    public synchronized List<XmlNode> getNodes(String string) throws Exception {
        this.update();
        List<XmlNode> list = this.xmnConfig.getNodes(string);
        if (this.bCloneNodes && list != null) {
            ArrayUtil<XmlNode> arrayUtil = new ArrayUtil<XmlNode>(list.size());
            for (XmlNode xmlNode : list) {
                arrayUtil.add((XmlNode)xmlNode.clone());
            }
            return arrayUtil;
        }
        return list;
    }

    public synchronized XmlNode getNode(String string) throws Exception {
        this.update();
        XmlNode xmlNode = this.xmnConfig.getNode(string);
        if (xmlNode != null) {
            if (this.bCloneNodes) {
                return (XmlNode)xmlNode.clone();
            }
            return xmlNode;
        }
        return null;
    }

    public void setUpdateEnabled(boolean bl) {
        this.bUpdateEnabled = bl;
    }

    public boolean isUpdateEnabled() {
        return this.bUpdateEnabled;
    }

    public synchronized void setSaveImmediate(boolean bl) {
        this.bSaveImmediate = bl;
    }

    public boolean isSaveImmediate() {
        return this.bSaveImmediate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        if (this.bVirtual) {
            this.bChanged = false;
        } else if (this.bChanged) {
            if (this.bModifiedByInclude) {
                throw new IOException("Couldn't save configuration file! The content was modified by <include> declarations.");
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.fiConfig);
                XmlWorker xmlWorker = this.createXmlWorker();
                xmlWorker.write(fileOutputStream, this.xmnConfig);
                this.lLastModified = this.fiConfig.lastModified();
                this.bChanged = false;
            }
            catch (Throwable throwable) {
                CommonUtil.close(fileOutputStream);
                throw throwable;
            }
            CommonUtil.close(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() throws Exception {
        block9: {
            FileInputStream fileInputStream;
            block6: {
                block8: {
                    block7: {
                        this.bChanged = false;
                        if (!this.bVirtual) break block6;
                        if (this.stream == null) break block7;
                        XmlWorker xmlWorker = this.createXmlWorker();
                        try {
                            XmlNode xmlNode = xmlWorker.read(this.stream);
                            this.prepareIncludeNodes(xmlNode);
                            this.setContent(xmlNode);
                        }
                        catch (Throwable throwable) {
                            CommonUtil.close(this.stream);
                            throw throwable;
                        }
                        CommonUtil.close(this.stream);
                        break block8;
                    }
                    this.setContent(XmlNode.createXmlDeclaration());
                }
                this.lLastModified = System.currentTimeMillis();
                break block9;
            }
            try {
                fileInputStream = new FileInputStream(this.fiConfig);
            }
            catch (IOException iOException) {
                throw new Exception("Invalid configuration file: " + this.fiConfig.getAbsolutePath(), iOException);
            }
            try {
                XmlWorker xmlWorker = this.createXmlWorker();
                XmlNode xmlNode = xmlWorker.read(fileInputStream);
                this.prepareIncludeNodes(xmlNode);
                this.setContent(xmlNode);
                this.lLastModified = this.fiConfig.lastModified();
            }
            catch (Throwable throwable) {
                CommonUtil.close(fileInputStream);
                throw throwable;
            }
            CommonUtil.close(fileInputStream);
        }
    }

    protected XmlWorker createXmlWorker() {
        return new XmlWorker();
    }

    protected void setContent(XmlNode xmlNode) {
        this.xmnConfig = xmlNode;
    }

    public final boolean isFile() {
        return this.fiConfig != null;
    }

    public final boolean isVirtual() {
        return this.bVirtual;
    }

    public final boolean isStream() {
        return this.bStream;
    }

    public void setCloneNodes(boolean bl) {
        this.bCloneNodes = bl;
    }

    public boolean isCloneNodes() {
        return this.bCloneNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareIncludeNodes(XmlNode xmlNode) throws IOException {
        if (xmlNode != null) {
            Object object;
            Object object2 = null;
            List<XmlNode> list = xmlNode.getSubNodes();
            if (list != null) {
                int n = list.size();
                for (int i = 0; i < n && object2 == null; ++i) {
                    object = list.get(i);
                    if (((XmlNode)object).getType() != 1) continue;
                    object2 = object;
                }
            }
            if (object2 != null && (list = ((XmlNode)object2).getNodes("include")) != null) {
                Object object3;
                Object object4;
                Properties properties = new Properties();
                Properties properties2 = System.getProperties();
                object = System.getenv();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    object4 = list.get(i);
                    object3 = this.replacePlaceholder(((XmlNode)object4).getValue(), properties, properties2, (Map<String, String>)object);
                    InputStream inputStream = ResourceUtil.getResourceAsStream((String)object3);
                    if (inputStream == null) {
                        try {
                            InitialContext initialContext = new InitialContext();
                            try {
                                Object object5 = initialContext.lookup((String)object3);
                                if (object5 instanceof String) {
                                    InputStream inputStream2 = ResourceUtil.getResourceAsStream((String)object5);
                                    if (inputStream2 == null) {
                                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object5).getBytes("UTF-8"));
                                        XmlWorker.readNode(byteArrayInputStream);
                                        byteArrayInputStream.reset();
                                        inputStream = byteArrayInputStream;
                                    } else {
                                        inputStream = inputStream2;
                                    }
                                } else if (object5 instanceof InputStream) {
                                    inputStream = (InputStream)object5;
                                }
                            }
                            finally {
                                initialContext.close();
                            }
                        }
                        catch (Exception exception) {
                            LoggerFactory.getInstance(UpToDateConfigFile.class).error(exception);
                            inputStream = null;
                        }
                    }
                    try {
                        if (inputStream != null) {
                            properties.load(inputStream);
                            ((XmlNode)object2).remove((XmlNode)object4);
                            this.bModifiedByInclude = true;
                        }
                    }
                    catch (Throwable throwable) {
                        CommonUtil.close(inputStream);
                        throw throwable;
                    }
                    CommonUtil.close(inputStream);
                }
                this.bModifiedByInclude |= this.replacePlaceholder(xmlNode, properties, properties2, (Map<String, String>)object);
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    object4 = string.replaceAll("\\.", "/");
                    object3 = ((XmlNode)object2).getNode((String)object4);
                    if (object3 != null) {
                        ((XmlNode)object3).setValue(properties.getProperty(string));
                        continue;
                    }
                    ((XmlNode)object2).insertNode((String)object4, properties.getProperty(string));
                }
            }
        }
    }

    protected boolean replacePlaceholder(XmlNode xmlNode, Properties properties, Properties properties2, Map<String, String> map) {
        List<XmlNode> list;
        boolean bl = false;
        if (xmlNode != null && (list = xmlNode.getSubNodes()) != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string;
                XmlNode xmlNode2 = list.get(i);
                if (xmlNode2.getType() == 0) continue;
                String string2 = xmlNode2.getValue();
                if (string2 != null && !(string = this.replacePlaceholder(string2, properties, properties2, map)).equals(string2)) {
                    xmlNode2.setValue(string);
                    bl |= true;
                }
                bl |= this.replacePlaceholder(xmlNode2, properties, properties2, map);
            }
        }
        return bl;
    }

    protected String replacePlaceholder(String string, Properties properties, Properties properties2, Map<String, String> map) {
        if (string != null) {
            int n = string.indexOf("${");
            if (n < 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            int n2 = 0;
            while (n >= 0 && n2 != -1) {
                String string2;
                n2 = stringBuilder.indexOf("}", n + 2);
                if (n2 > n && (string2 = stringBuilder.substring(n + 2, n2)).length() > 0) {
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    int n3 = string2.indexOf(58);
                    if (n3 >= 0) {
                        string3 = string2.substring(0, n3);
                        string4 = string2.substring(n3 + 1);
                    }
                    if ("imp".equalsIgnoreCase(string3)) {
                        if (properties != null) {
                            string5 = properties.getProperty(string4);
                        }
                    } else if ("sys".equalsIgnoreCase(string3)) {
                        if (properties2 != null) {
                            string5 = properties2.getProperty(string4);
                        }
                    } else if ("env".equalsIgnoreCase(string3)) {
                        if (map != null) {
                            string5 = map.get(string4);
                        }
                    } else {
                        if (properties != null) {
                            string5 = properties.getProperty(string2);
                        }
                        if (string5 == null) {
                            if (properties2 != null) {
                                string5 = properties2.getProperty(string2);
                            }
                            if (string5 == null && map != null) {
                                string5 = map.get(string2);
                            }
                        }
                    }
                    if (string5 != null) {
                        stringBuilder = stringBuilder.replace(n, n2 + 1, string5);
                        n2 = n + string5.length() - 1;
                    }
                }
                n = stringBuilder.indexOf("${", n2 + 1);
            }
            return stringBuilder.toString();
        }
        return string;
    }
}

