/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.Monitoring;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.WrappedSession;
import com.sibvisions.util.ArrayUtil;
import javax.rad.server.ICallBackBroker;
import javax.rad.server.ISession;
import javax.rad.server.ResultObject;
import javax.rad.server.SessionContext;

final class SessionCallBackBroker
implements ICallBackBroker {
    private WrappedSession session;
    private WrappedSession master;

    SessionCallBackBroker(SessionContext sessionContext) {
        this.session = (WrappedSession)sessionContext.getSession();
        this.master = (WrappedSession)sessionContext.getMasterSession();
    }

    public ICallBackBroker.PublishState publish(String string, Object object) {
        if (this.master != null && this.session.isValid() && this.master.isValid()) {
            this.master.session.addCallBackResult(new ResultObject(6, object, string + "@" + this.session.getId()));
            return ICallBackBroker.PublishState.Completed;
        }
        return ICallBackBroker.PublishState.Failed;
    }

    public ICallBackBroker.PublishState publishAll(String string, Object object) {
        if (this.master != null) {
            String string2 = this.session.getApplicationName();
            DefaultSessionManager defaultSessionManager = this.master.session.getSessionManager();
            Monitoring monitoring = ((Server)defaultSessionManager.getServer()).getMonitoring();
            ArrayUtil<Object> arrayUtil = monitoring.getMasterSessionIds(string2);
            if (arrayUtil != null) {
                boolean bl = false;
                int n = arrayUtil.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        AbstractSession abstractSession = defaultSessionManager.get(arrayUtil.get(i));
                        ISession iSession = abstractSession;
                        if (abstractSession == this.master.session && this.session.session != this.master.session) {
                            iSession = this.session;
                        }
                        abstractSession.addCallBackResult(new ResultObject(6, object, string + "@" + iSession.getId()));
                        continue;
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                }
                if (bl) {
                    return ICallBackBroker.PublishState.Partial;
                }
                return ICallBackBroker.PublishState.Completed;
            }
        }
        return ICallBackBroker.PublishState.Failed;
    }
}

