/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.sql.Timestamp;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateSerializer
implements ITypeSerializer<Date> {
    private static final int TYPE_TIMESTAMP = 18;
    private static final int TYPE_TIMESTAMP_NONANOS = 19;
    private static Timestamp[] timestampCache = new Timestamp[256];

    @Override
    public Class<Date> getTypeClass() {
        return Date.class;
    }

    @Override
    public int getMinValue() {
        return 18;
    }

    @Override
    public int getMaxValue() {
        return 19;
    }

    @Override
    public Date read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        long l = dataInputStream.readLong();
        int n2 = (int)(l >>> 8);
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        n2 ^= n2 >>> 7 ^ n2 >>> 4;
        Timestamp timestamp = timestampCache[n2 &= 0xFF];
        if (timestamp == null || l != timestamp.getTime()) {
            DateSerializer.timestampCache[n2] = timestamp = new Timestamp(l);
        }
        if (n == 18) {
            dataInputStream.readInt();
        }
        return timestamp;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Date date, TypeCache typeCache) throws Exception {
        dataOutputStream.writeByte(19);
        dataOutputStream.writeLong(date.getTime());
    }
}

