/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.http;

import com.sibvisions.rad.remote.AbstractSerializedConnection;
import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.remote.http.HttpsHostnameVerifier;
import com.sibvisions.rad.remote.http.HttpsTrustManager;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CodecUtil;
import com.sibvisions.util.type.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.rad.io.IDownloadExecutor;
import javax.rad.io.IFileHandle;
import javax.rad.io.IUploadExecutor;
import javax.rad.io.RemoteFileHandle;
import javax.rad.io.TransferContext;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.UnauthorizedException;

public class HttpConnection
extends AbstractSerializedConnection
implements IDownloadExecutor,
IUploadExecutor {
    public static final String PREFIX_HTTP = "client.http.";
    public static final String PROP_SERVICE = "service";
    public static final String PROP_DOWNLOAD = "download";
    public static final String PROP_UPLOAD = "upload";
    private static Provider provider = null;
    private static TrustManager[] tmSsl = null;
    private static HostnameVerifier hvSsl = null;
    private URL urlServlet = null;
    private String sServletURL = null;
    private String sDownloadURL = null;
    private String sUploadURL = null;
    private URLConnection ucServer = null;
    private ILogger log = LoggerFactory.getInstance(this.getClass());
    private int iConTimeout = -1;

    public HttpConnection(Properties properties) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException, ClassNotFoundException {
        this(HttpConnection.createSerializer(properties.getProperty("serializer")), properties.getProperty(PROP_SERVICE));
        this.setDownloadURL(properties.getProperty(PROP_DOWNLOAD));
        this.setUploadURL(properties.getProperty(PROP_UPLOAD));
    }

    public HttpConnection(String string) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException {
        this(null, string);
    }

    public HttpConnection(ISerializer iSerializer, String string) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException {
        super(iSerializer);
        this.sServletURL = string;
        this.urlServlet = new URL(string);
        this.log.info("Server: ", string, ", Serializer: ", iSerializer != null ? iSerializer.getClass() : null);
        this.initSsl();
    }

    private void initSsl() throws NoSuchAlgorithmException, KeyManagementException {
        if ("https".equals(this.urlServlet.getProtocol().toLowerCase())) {
            if (provider == null) {
                try {
                    try {
                        provider = (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance();
                    }
                    catch (Exception exception) {
                        this.log.error(exception);
                        try {
                            provider = (Provider)Class.forName("org.apache.harmony.xnet.provider.jsse.JSSEProvider").newInstance();
                        }
                        catch (Exception exception2) {
                            this.log.error(exception2);
                        }
                    }
                    if (provider != null) {
                        tmSsl = new TrustManager[]{new HttpsTrustManager()};
                        hvSsl = new HttpsHostnameVerifier();
                        Security.addProvider(provider);
                        SSLContext sSLContext = SSLContext.getInstance("SSL");
                        sSLContext.init(null, tmSsl, new SecureRandom());
                        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                        HttpsURLConnection.setDefaultHostnameVerifier(hvSsl);
                    } else {
                        this.log.error("SSL Security provider not found!");
                    }
                }
                catch (SecurityException securityException) {
                    this.log.error(securityException);
                    tmSsl = null;
                    hvSsl = null;
                    provider = null;
                }
            }
            if (tmSsl != null && hvSsl != null) {
                ((HttpsTrustManager)tmSsl[0]).addUrl(this.urlServlet);
                ((HttpsHostnameVerifier)hvSsl).addUrl(this.urlServlet);
            }
        }
    }

    public InputStream readContent(RemoteFileHandle remoteFileHandle) throws IOException {
        if (this.sDownloadURL != null) {
            try {
                return new URL(this.createDownloadURL(remoteFileHandle)).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return null;
    }

    public long getContentLength(RemoteFileHandle remoteFileHandle) throws IOException {
        if (this.sDownloadURL != null) {
            try {
                return new URL(this.createDownloadURL(remoteFileHandle)).openConnection().getContentLength();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return 0L;
    }

    public RemoteFileHandle writeContent(IFileHandle iFileHandle) throws IOException {
        if (this.sUploadURL != null) {
            RemoteFileHandle remoteFileHandle = new RemoteFileHandle(iFileHandle.getFileName(), RemoteFileHandle.createObjectCacheKey());
            URL uRL = new URL(this.createUploadURL(remoteFileHandle));
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            uRLConnection.setRequestProperty("Content-Disposition", "attachment; filename=\"" + iFileHandle.getFileName() + "\"");
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            FileUtil.copy(iFileHandle.getInputStream(), true, uRLConnection.getOutputStream(), true);
            uRLConnection.getInputStream().close();
            return remoteFileHandle;
        }
        return null;
    }

    public OutputStream getOutputStream(ConnectionInfo connectionInfo) throws IOException {
        this.ucServer = this.urlServlet.openConnection();
        this.ucServer.setUseCaches(false);
        this.ucServer.setRequestProperty("Content-Type", "application/octet-stream");
        if (this.iConTimeout >= 0) {
            this.ucServer.setConnectTimeout(this.iConTimeout);
            this.ucServer.setReadTimeout(this.iConTimeout);
        } else {
            this.ucServer.setConnectTimeout(15000);
            this.ucServer.setReadTimeout(15000);
        }
        this.ucServer.setDoInput(true);
        this.ucServer.setDoOutput(true);
        ChangedHashtable<String, Object> changedHashtable = connectionInfo.getProperties();
        for (Map.Entry entry : changedHashtable.entrySet()) {
            Object v;
            String string = (String)entry.getKey();
            if (!string.startsWith(PREFIX_HTTP) || !((v = entry.getValue()) instanceof String)) continue;
            this.ucServer.setRequestProperty(string.substring(PREFIX_HTTP.length()), (String)v);
        }
        return this.ucServer.getOutputStream();
    }

    public InputStream getInputStream(ConnectionInfo connectionInfo) throws IOException {
        if (this.ucServer != null) {
            try {
                return this.ucServer.getInputStream();
            }
            catch (IOException iOException) {
                int n;
                if ((this.ucServer instanceof HttpURLConnection || this.ucServer instanceof HttpsURLConnection) && ((n = ((HttpURLConnection)this.ucServer).getResponseCode()) == 401 || n == 403)) {
                    throw new UnauthorizedException();
                }
                throw iOException;
            }
        }
        throw new IOException("The connection is not open!");
    }

    protected Object initCall(ConnectionInfo connectionInfo) {
        return new TransferContext(connectionInfo, this.sDownloadURL != null ? this : null, this.sUploadURL != null ? this : null);
    }

    protected void releaseCall(ConnectionInfo connectionInfo, Object object) {
        ((TransferContext)object).release();
    }

    protected boolean isReadingMagicByteEnabled() {
        return false;
    }

    protected Throwable prepareException(Throwable throwable) {
        return this.fillInStackTrace(throwable);
    }

    public String getServletURL() {
        return this.sServletURL;
    }

    public void setDownloadURL(String string) throws MalformedURLException {
        this.checkURL(string);
        this.sDownloadURL = string;
    }

    public String getDownloadURL() {
        return this.sDownloadURL;
    }

    public void setUploadURL(String string) throws MalformedURLException {
        this.checkURL(string);
        this.sUploadURL = string;
    }

    public String getUploadURL() {
        return this.sUploadURL;
    }

    public void setConnectionTimeout(int n) {
        this.iConTimeout = n;
    }

    private URL checkURL(String string) throws MalformedURLException {
        if (string != null) {
            new URL(string);
        }
        return null;
    }

    private String createDownloadURL(RemoteFileHandle remoteFileHandle) {
        if (this.sDownloadURL.indexOf("?") > 0) {
            return this.sDownloadURL + "&KEY=" + remoteFileHandle.getObjectCacheKey();
        }
        return this.sDownloadURL + "?KEY=" + remoteFileHandle.getObjectCacheKey();
    }

    private String createUploadURL(RemoteFileHandle remoteFileHandle) {
        StringBuilder stringBuilder = new StringBuilder(this.sUploadURL);
        if (this.sUploadURL.indexOf("?") > 0) {
            stringBuilder.append("&");
        } else {
            stringBuilder.append("?");
        }
        stringBuilder.append("KEY=");
        stringBuilder.append(remoteFileHandle.getObjectCacheKey());
        ConnectionInfo connectionInfo = TransferContext.getCurrentConnectionInfo();
        if (connectionInfo != null) {
            stringBuilder.append("&CONNECTION_ID=");
            try {
                stringBuilder.append(CodecUtil.encodeHex(connectionInfo.getConnectionId().toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileHandle createRemoteFileHandle() {
        TransferContext transferContext = new TransferContext(null, this.sDownloadURL != null ? this : null, this.sUploadURL != null ? this : null);
        try {
            RemoteFileHandle remoteFileHandle = new RemoteFileHandle();
            remoteFileHandle.setObjectCacheKey(RemoteFileHandle.createObjectCacheKey());
            RemoteFileHandle remoteFileHandle2 = remoteFileHandle;
            return remoteFileHandle2;
        }
        finally {
            transferContext.release();
        }
    }
}

