/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.ICondition;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDBAccess
extends DBAccess {
    public static final int TYPE_ENUM = -900;
    public static final int TYPE_SET = -901;

    public MySQLDBAccess() {
        this.setDriver("com.mysql.jdbc.Driver");
        this.setQuoteCharacters("", "");
    }

    @Override
    public void open() throws DataSourceException {
        this.setDBProperty("zeroDateTimeBehavior", "convertToNull");
        this.setDBProperty("useOldAliasMetadataBehavior", "true");
        super.open();
    }

    @Override
    public boolean isAutoQuote(String string) {
        return false;
    }

    @Override
    protected ServerColumnMetaData[] getColumnMetaDataIntern(String string, String[] stringArray, String string2, String string3, String string4) throws DataSourceException {
        ServerColumnMetaData[] serverColumnMetaDataArray = super.getColumnMetaDataIntern(string, stringArray, string2, string3, string4);
        Hashtable<String, ColumnInfo> hashtable = null;
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            ColumnInfo columnInfo;
            int n = serverColumnMetaDataArray[i].getSQLType();
            if (n == -1) {
                columnInfo = null;
                if (hashtable == null) {
                    hashtable = this.getColumnInfo(string);
                }
                if (hashtable != null && (columnInfo = hashtable.get(serverColumnMetaDataArray[i].getColumnName().getRealName())) != null) {
                    serverColumnMetaDataArray[i].setSQLTypeName(columnInfo.type);
                }
                if (columnInfo != null) continue;
                int n2 = serverColumnMetaDataArray[i].getPrecision();
                if (n2 > 0xFFFFFF) {
                    serverColumnMetaDataArray[i].setSQLTypeName("LONGTEXT");
                    continue;
                }
                if (n2 > 65535) {
                    serverColumnMetaDataArray[i].setSQLTypeName("MEDIUMTEXT");
                    continue;
                }
                if (n2 > 255) {
                    serverColumnMetaDataArray[i].setSQLTypeName("TEXT");
                    continue;
                }
                serverColumnMetaDataArray[i].setSQLTypeName("TINYTEXT");
                continue;
            }
            if (n != 1) continue;
            columnInfo = null;
            if (hashtable == null) {
                hashtable = this.getColumnInfo(string);
            }
            if (hashtable == null || (columnInfo = hashtable.get(serverColumnMetaDataArray[i].getColumnName().getRealName())) == null) continue;
            String string5 = columnInfo.type.toLowerCase();
            if (string5.startsWith("enum")) {
                serverColumnMetaDataArray[i].setDetectedType(-900);
                serverColumnMetaDataArray[i].setSQLTypeName(columnInfo.type);
            } else if (string5.startsWith("set")) {
                serverColumnMetaDataArray[i].setDetectedType(-901);
                serverColumnMetaDataArray[i].setSQLTypeName(columnInfo.type);
            }
            if (serverColumnMetaDataArray[i].getDetectedType() != -900 && serverColumnMetaDataArray[i].getDetectedType() != -901) continue;
            serverColumnMetaDataArray[i].setAllowedValues(this.extractValues(serverColumnMetaDataArray[i].getSQLTypeName()));
        }
        return serverColumnMetaDataArray;
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        TableInfo tableInfo = super.getTableInfoIntern(string);
        String string2 = tableInfo.getTable();
        if (string2 != null && string2.contains(".")) {
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
        }
        return new TableInfo(null, tableInfo.getCatalog(), string2);
    }

    @Override
    protected Key getPrimaryKeyIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getPrimaryKeyIntern(string2, null, string3);
    }

    @Override
    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        List<ForeignKey> list = super.getForeignKeysIntern(string2, null, string3);
        for (int i = 0; i < list.size(); ++i) {
            ForeignKey foreignKey = list.get(i);
            foreignKey.setPKSchema(foreignKey.getPKCatalog());
            foreignKey.setPKCatalog(null);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        long l;
        ArrayUtil<Key> arrayUtil;
        ArrayUtil<Key> arrayUtil2;
        ResultSet resultSet;
        block11: {
            resultSet = null;
            arrayUtil2 = new ArrayUtil<Key>();
            arrayUtil = new ArrayUtil<Key>();
            l = System.currentTimeMillis();
            DatabaseMetaData databaseMetaData = this.getConnectionIntern().getMetaData();
            resultSet = databaseMetaData.getIndexInfo(MySQLDBAccess.removeQuotes(string2), null, MySQLDBAccess.removeQuotes(string3), true, false);
            if (resultSet.next()) break block11;
            CommonUtil.close(resultSet);
            ArrayUtil<Key> arrayUtil3 = arrayUtil2;
            CommonUtil.close(resultSet);
            return arrayUtil3;
        }
        try {
            String string4 = null;
            do {
                if (resultSet.getString("COLUMN_NAME") == null) continue;
                if (string4 != null && !resultSet.getString("INDEX_NAME").equals(string4)) {
                    object = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                    arrayUtil2.add((Key)object);
                    arrayUtil.clear();
                }
                string4 = resultSet.getString("INDEX_NAME");
                arrayUtil.add((Key)((Object)new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME")))));
            } while (resultSet.next());
            if (arrayUtil.size() > 0) {
                object = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                arrayUtil2.add((Key)object);
            }
            if (arrayUtil2.size() > 0 && (object = this.getPrimaryKey(string, string2, string3)) != null) {
                for (int i = arrayUtil2.size() - 1; i >= 0; --i) {
                    Name[] nameArray = arrayUtil2.get(i).getColumns();
                    if (!ArrayUtil.containsAll(nameArray, ((Key)object).getColumns()) || nameArray.length != ((Key)object).getColumns().length) continue;
                    arrayUtil2.remove(i);
                }
            }
            if (MySQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                MySQLDBAccess.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil2;
        }
        catch (SQLException sQLException) {
            try {
                MySQLDBAccess.error("Unique Keys couldn't determined from database! - ", string3, sQLException);
                arrayUtil = null;
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet);
                throw throwable;
            }
            CommonUtil.close(resultSet);
            return arrayUtil;
        }
        CommonUtil.close(resultSet);
        return object;
    }

    @Override
    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValuesIntern(string2, null, string3);
    }

    @Override
    public void setUsername(String string) {
        super.setUsername(DBAccess.removeQuotes(string));
    }

    @Override
    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5, int n, int n2, boolean bl) throws DataSourceException {
        long l = System.currentTimeMillis();
        if (this.getMaxTime() > 0 && n > 0 && n2 > 0) {
            n2 = Math.max(n2, n);
        }
        List<Object[]> list = super.fetch(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, string5, n, n2, bl);
        if (n2 > 0 && list.size() == n2 + 1 && list.get(list.size() - 1) == null) {
            long l2;
            long l3;
            list.remove(list.size() - 1);
            if (n2 > 3 && (l3 = Math.max(1L, System.currentTimeMillis() - l)) < (long)this.getMaxTime() && (l2 = (long)list.size() * (((long)this.getMaxTime() - l3) / l3)) > 0L) {
                List<Object[]> list2 = super.fetch(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, string5, n + list.size(), (int)l2, bl);
                if ((long)list2.size() == l2 + 1L && list2.get(list2.size() - 1) == null) {
                    list2.remove(list2.size() - 1);
                }
                list.addAll(list2);
            }
        }
        return list;
    }

    @Override
    public DBAccess.ParameterizedStatement getParameterizedSelectStatement(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5, int n, int n2) throws DataSourceException {
        DBAccess.ParameterizedStatement parameterizedStatement = super.getParameterizedSelectStatement(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, string5, n, n2);
        if (n > 0 || n2 > 0) {
            parameterizedStatement.setStatement(parameterizedStatement.getStatement() + " limit ? offset ?");
            parameterizedStatement.getValues().add(BigDecimal.valueOf(n2 > 0 ? (long)n2 : Integer.MAX_VALUE));
            parameterizedStatement.getValues().add(BigDecimal.valueOf(n > 0 ? (long)n : 0L));
        }
        return parameterizedStatement;
    }

    @Override
    protected int getDiscardRowCount(int n, int n2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable<String, ColumnInfo> getColumnInfo(String string) {
        Hashtable<String, ColumnInfo> hashtable;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.getConnectionIntern().createStatement();
            resultSet = statement.executeQuery("show columns from " + string);
            Hashtable<String, ColumnInfo> hashtable2 = new Hashtable<String, ColumnInfo>();
            while (resultSet.next()) {
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.type = resultSet.getString("Type");
                columnInfo.nullable = resultSet.getString("Null");
                columnInfo.key = resultSet.getString("Key");
                columnInfo.defaultvalue = resultSet.getString("Default");
                hashtable2.put(resultSet.getString("Field"), columnInfo);
            }
            hashtable = hashtable2;
        }
        catch (SQLException sQLException) {
            Hashtable<String, ColumnInfo> hashtable3;
            try {
                MySQLDBAccess.debug(sQLException);
                hashtable3 = new Hashtable<String, ColumnInfo>();
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, statement);
                throw throwable;
            }
            CommonUtil.close(resultSet, statement);
            return hashtable3;
        }
        CommonUtil.close(resultSet, statement);
        return hashtable;
    }

    protected String[] extractValues(String string) {
        int n = string.indexOf(40);
        String string2 = string.substring(n + 1, string.lastIndexOf(41));
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("null")) {
                stringArray[i] = null;
                continue;
            }
            stringArray[i] = StringUtil.removeQuotes(stringArray[i].trim(), "'");
            if (stringArray[i].length() != 0) continue;
            stringArray[i] = null;
        }
        return stringArray;
    }

    private static class ColumnInfo {
        String field;
        String type;
        String nullable;
        String key;
        String defaultvalue;

        private ColumnInfo() {
        }
    }
}

