/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2DBAccess
extends DBAccess {
    private static String sSynonymSelect = "select t.base_tabschema, t.base_tabname FROM syscat.tables t WHERE t.type='A' AND t.tabname = ?";

    public DB2DBAccess() {
        this.setDriver("com.ibm.db2.jcc.DB2Driver");
    }

    @Override
    public void open() throws DataSourceException {
        this.setDBProperty("retrieveMessagesFromServerOnGetMessage", "true");
        super.open();
    }

    @Override
    public void setUsername(String string) {
        super.setUsername(DB2DBAccess.removeQuotes(string));
    }

    @Override
    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValuesIntern(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        TableInfo tableInfo = super.getTableInfoIntern(string);
        String string2 = tableInfo.getTable();
        if (string2 != null && !string2.startsWith("`") && !string2.endsWith("`")) {
            string2 = string2.toUpperCase();
        }
        return new TableInfo(null, tableInfo.getSchema(), string2);
    }

    @Override
    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        List<ForeignKey> list = super.getForeignKeysIntern(string, string2, string3);
        for (int i = 0; i < list.size(); ++i) {
            ForeignKey foreignKey = list.get(i);
            foreignKey.setPKCatalog(null);
        }
        return list;
    }

    @Override
    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        String string2;
        long l;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block7: {
            preparedStatement = null;
            resultSet = null;
            l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sSynonymSelect);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block7;
            CommonUtil.close(resultSet, preparedStatement);
            String string3 = string;
            CommonUtil.close(resultSet, preparedStatement);
            return string3;
        }
        try {
            String string4 = resultSet.getString("BASE_TABSCHEMA");
            String string5 = resultSet.getString("BASE_TABNAME");
            StringBuilder stringBuilder = new StringBuilder();
            if (string4 != null) {
                stringBuilder.append(string4.trim());
                stringBuilder.append('.');
            }
            stringBuilder.append(string5.trim());
            if (DB2DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DB2DBAccess.debug("getTableForSynonym(", string, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string2 = stringBuilder.toString();
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Synonyms couldn't determined from database! - " + string, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string2;
    }

    @Override
    protected void initializeDataType(ResultSetMetaData resultSetMetaData, int n, ColumnMetaData columnMetaData) throws SQLException, DataSourceException {
        if (resultSetMetaData.getColumnType(n) == 1111) {
            columnMetaData.setTypeIdentifier(3);
            columnMetaData.setPrecision(0);
            columnMetaData.setScale(-1);
            columnMetaData.setSigned(resultSetMetaData.isSigned(n));
        } else {
            super.initializeDataType(resultSetMetaData, n, columnMetaData);
        }
    }
}

