/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.remote;

import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.rad.model.mem.MemDataPage;
import com.sibvisions.rad.model.remote.RemoteDataBook;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.util.List;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.reference.ReferenceDefinition;

public class RemoteDataPage
extends MemDataPage {
    private static ILogger logger = LoggerFactory.getInstance(RemoteDataPage.class);
    private int fetchedRows = 0;

    public RemoteDataPage(MemDataBook memDataBook, IDataRow iDataRow) {
        super(memDataBook, iDataRow);
        this.setAllFetched(false);
    }

    public RemoteDataBook getDataBook() {
        return (RemoteDataBook)super.getDataBook();
    }

    protected void addFetchedRow(Object[] objectArray) throws ModelException {
        super.addFetchedRow(objectArray);
        ++this.fetchedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchToRow(int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (n < this.getRowCountInternal() && n >= 0) {
                return;
            }
            if (!this.isAllFetched()) {
                RemoteDataBook remoteDataBook = this.getDataBook();
                try {
                    int n2;
                    String[] stringArray;
                    IDataRow iDataRow;
                    String string = remoteDataBook.getName();
                    int n3 = this.rdRowDefinition.getColumnCount();
                    int[] nArray = remoteDataBook.getFetchColumnIndexes();
                    int[] nArray2 = remoteDataBook.getMasterColumnIndexesForBlock();
                    if (nArray2 != null) {
                        iDataRow = this.getMasterDataRow().createEmptyDataRow(null);
                        stringArray = iDataRow.getRowDefinition().getColumnNames();
                        n2 = remoteDataBook.getFetchedRowsForBlock(this.getMasterDataRow());
                        if (n2 < 0) {
                            this.setAllFetched(true);
                            return;
                        }
                    } else {
                        iDataRow = null;
                        stringArray = null;
                        n2 = this.fetchedRows;
                    }
                    do {
                        long l = System.currentTimeMillis();
                        int n4 = n;
                        if (n >= 0) {
                            n4 = n + remoteDataBook.getReadAhead() - this.fetchedRows + 1;
                        }
                        SortDefinition sortDefinition = remoteDataBook.isMemSort() ? null : remoteDataBook.getSort();
                        ICondition iCondition = this.getCompleteFilter();
                        List list = (List)remoteDataBook.getConnection().call(string, "fetch", iCondition, sortDefinition, n2, n4);
                        logger.debug("acConnection.fetch(", string, ",", iCondition, ",", sortDefinition, ",", n2, ",", n4, ") in ", System.currentTimeMillis() - l, "ms");
                        for (int i = 0; i < list.size(); ++i) {
                            int n5;
                            Object[] objectArray = (Object[])list.get(i);
                            if (objectArray == null) {
                                this.setAllFetched(true);
                                continue;
                            }
                            if (objectArray.length != nArray.length) {
                                throw new ModelException("Remote storage returned " + objectArray.length + " value(s) but " + nArray.length + " were expected (check meta data)!");
                            }
                            Object[] objectArray2 = new Object[n3];
                            for (n5 = 0; n5 < nArray.length; ++n5) {
                                int n6 = nArray[n5];
                                objectArray2[n6] = this.rdRowDefinition.getColumnDefinition(n6).getDataType().convertToTypeClass(objectArray[n5]);
                            }
                            if (nArray2 == null) {
                                this.addFetchedRow(objectArray2);
                                continue;
                            }
                            if (iDataRow == null) {
                                iDataRow = this.getMasterDataRow().createEmptyDataRow(null);
                                stringArray = iDataRow.getRowDefinition().getColumnNames();
                            }
                            for (n5 = 0; n5 < nArray2.length; ++n5) {
                                iDataRow.setValue(stringArray[n5], objectArray2[nArray2[n5]]);
                            }
                            RemoteDataPage remoteDataPage = (RemoteDataPage)remoteDataBook.getDataPage(iDataRow);
                            remoteDataPage.addFetchedRow(objectArray2);
                            ++n2;
                        }
                    } while (nArray2 != null && !this.isAllFetched() && (n < 0 || n >= this.getRowCountInternal()));
                    if (nArray2 != null) {
                        if (this.isAllFetched()) {
                            remoteDataBook.setFetchedRowsForBlock(this.getMasterDataRow(), -1);
                        } else {
                            remoteDataBook.setFetchedRowsForBlock(this.getMasterDataRow(), n2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.setAllFetched(true);
                    throw new ModelException("Fetch to Row failed!", throwable);
                }
            }
        }
    }

    public int getEstimatedRowCount() throws ModelException {
        try {
            long l = System.currentTimeMillis();
            RemoteDataBook remoteDataBook = this.getDataBook();
            Integer n = (Integer)remoteDataBook.getConnection().call(remoteDataBook.getName(), "getEstimatedRowCount", this.getCompleteFilter());
            logger.debug("acConnection.getEstimatedRowCount(", remoteDataBook.getName(), ",", this.getCompleteFilter(), ") in ", System.currentTimeMillis() - l, "ms");
            return n;
        }
        catch (Throwable throwable) {
            throw new ModelException("getEstimatedRowCount failed!", throwable);
        }
    }

    private ICondition getCompleteFilter() throws ModelException {
        ICondition iCondition;
        RemoteDataBook remoteDataBook = this.getDataBook();
        if (remoteDataBook.isMemFilter()) {
            iCondition = null;
        } else {
            iCondition = remoteDataBook.getFilter();
            if (iCondition != null) {
                iCondition = iCondition.clone();
            }
        }
        ReferenceDefinition referenceDefinition = remoteDataBook.getMasterReference();
        if (referenceDefinition != null) {
            String[] stringArray = referenceDefinition.getColumnNames();
            String[] stringArray2 = referenceDefinition.getReferencedColumnNames();
            String[] stringArray3 = remoteDataBook.getBlockFetchColumnNames();
            IDataRow iDataRow = this.getMasterDataRow();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray3 != null && ArrayUtil.indexOf(stringArray3, stringArray[i]) < 0) continue;
                Equals equals = new Equals(stringArray[i], iDataRow.getValue(stringArray2[i]), false);
                iCondition = iCondition == null ? equals : iCondition.and(equals);
            }
        }
        return iCondition;
    }
}

