/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.application;

import com.sibvisions.util.type.StringUtil;
import javax.rad.application.IContent;
import javax.rad.application.IMessageConstants;
import javax.rad.genui.UIColor;
import javax.rad.genui.UIDimension;
import javax.rad.genui.UIFont;
import javax.rad.genui.UIImage;
import javax.rad.genui.component.UIButton;
import javax.rad.genui.component.UIIcon;
import javax.rad.genui.component.UITextArea;
import javax.rad.genui.container.UIDesktopPanel;
import javax.rad.genui.container.UIInternalFrame;
import javax.rad.genui.container.UIPanel;
import javax.rad.genui.layout.UIBorderLayout;
import javax.rad.genui.layout.UIFlowLayout;
import javax.rad.genui.layout.UIFormLayout;
import javax.rad.ui.IComponent;
import javax.rad.ui.event.ActionHandler;
import javax.rad.ui.event.IActionListener;
import javax.rad.ui.event.UIActionEvent;
import javax.rad.ui.event.UIEvent;
import javax.rad.ui.event.UIWindowEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends UIInternalFrame
implements IContent,
IMessageConstants {
    private static ActionHandler eventMessage = new ActionHandler();
    private Object opener;
    private UITextArea taMessage = new UITextArea();
    private UIButton butOK = null;
    private UIButton butCancel = null;
    private String sOkAction;
    private String sCancelAction;
    private int iIconType;
    private int iButtonType;

    public Message(UIDesktopPanel uIDesktopPanel, int n, int n2, String string, String string2, String string3) {
        super(uIDesktopPanel);
        this.iIconType = n;
        this.iButtonType = n2;
        this.sOkAction = string2;
        this.sCancelAction = string3;
        this.taMessage.setText(string);
        this.taMessage.setFont(UIFont.getDefaultFont());
        this.taMessage.setRows(0);
        this.taMessage.setColumns(0);
        this.init();
    }

    protected void init() {
        String string;
        UIPanel uIPanel = new UIPanel();
        UIIcon uIIcon = null;
        UIFlowLayout uIFlowLayout = new UIFlowLayout();
        uIFlowLayout.setMargins(8, 0, 8, 0);
        UIPanel uIPanel2 = new UIPanel(uIFlowLayout);
        UIFormLayout uIFormLayout = new UIFormLayout();
        uIFormLayout.setHorizontalGap(10);
        uIPanel.setLayout(uIFormLayout);
        uIPanel.setBackground(UIColor.white);
        UIImage uIImage = null;
        switch (this.iIconType) {
            case 0: {
                string = "Information";
                uIImage = UIImage.getImage("MESSAGE_INFO_LARGE");
                break;
            }
            case 1: {
                string = "Warning";
                uIImage = UIImage.getImage("MESSAGE_WARNING_LARGE");
                break;
            }
            case 2: {
                string = "Error";
                uIImage = UIImage.getImage("MESSAGE_ERROR_LARGE");
                break;
            }
            case 3: {
                string = "Question";
                uIImage = UIImage.getImage("MESSAGE_QUESTION_LARGE");
                break;
            }
            default: {
                string = "";
            }
        }
        if (uIImage != null) {
            uIIcon = new UIIcon();
            uIIcon.setImage(uIImage);
            uIIcon.setVerticalAlignment(0);
            uIPanel.add(uIIcon);
        }
        this.setTitle(string);
        this.setIconImage(null);
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setResizable(false);
        this.setModal(true);
        this.taMessage.setEditable(false);
        this.taMessage.setBorderVisible(false);
        this.taMessage.setWordWrap(true);
        UIIcon uIIcon2 = new UIIcon();
        uIIcon2.setBackground(UIColor.gray);
        if (StringUtil.countCharacter(this.taMessage.getText(), '\n') < 3) {
            uIPanel.add((IComponent)this.taMessage, uIFormLayout.getVCenterConstraints(1, 0, -1, -1));
        } else {
            uIPanel.add((IComponent)this.taMessage, uIFormLayout.getConstraints(1, 0, -1, -1));
        }
        uIPanel.add((IComponent)uIIcon2, uIFormLayout.getConstraints(uIFormLayout.createAnchor(uIFormLayout.getBottomAnchor(), -1), uIFormLayout.getLeftAnchor(), uIFormLayout.getBottomAnchor(), uIFormLayout.getRightAnchor()));
        switch (this.iButtonType) {
            case 6: {
                this.butOK = this.createButton("OK", "doOk");
                this.butOK.setDefaultButton(true);
                break;
            }
            case 4: {
                this.butOK = this.createButton("OK", "doOk");
                this.butCancel = this.createButton("Cancel", "doCancel");
                this.butCancel.setDefaultButton(true);
                break;
            }
            case 5: {
                this.butOK = this.createButton("Yes", "doOk");
                this.butCancel = this.createButton("No", "doCancel");
                this.butCancel.setDefaultButton(true);
                break;
            }
        }
        if (this.butOK != null) {
            uIPanel2.add(this.butOK);
        }
        if (this.butCancel != null) {
            uIPanel2.add(this.butCancel);
        }
        UIBorderLayout uIBorderLayout = new UIBorderLayout();
        uIBorderLayout.setVerticalGap(1);
        this.setLayout(uIBorderLayout);
        this.add((IComponent)uIPanel, "Center");
        this.add((IComponent)uIPanel2, "South");
        this.eventWindowClosing().addListener(this, "doClose");
        uIPanel.setMinimumSize(250, 50);
        uIPanel.setMaximumSize(800, 600);
    }

    @Override
    public void notifyDestroy() {
    }

    @Override
    public void notifyVisible() {
    }

    @Override
    public <OP> void setOpener(OP OP) {
        this.opener = OP;
    }

    @Override
    public <OP> OP getOpener() {
        return (OP)this.opener;
    }

    protected UIButton createButton(String string, String string2) {
        UIButton uIButton = new UIButton();
        uIButton.setText(string);
        uIButton.eventAction().addListener(this, string2);
        uIButton.setPreferredSize(new UIDimension(80, 25));
        return uIButton;
    }

    private void callAction(UIEvent uIEvent, String string) throws Throwable {
        if (string != null && this.opener != null) {
            IActionListener iActionListener = (IActionListener)eventMessage.createListener(this.opener, string);
            iActionListener.action(new UIActionEvent(this, 1001, uIEvent.getWhen(), uIEvent.getModifiers(), null));
        }
    }

    public void doOk(UIActionEvent uIActionEvent) throws Throwable {
        this.dispose();
        this.callAction(uIActionEvent, this.sOkAction);
    }

    public void doCancel(UIActionEvent uIActionEvent) throws Throwable {
        this.dispose();
        this.callAction(uIActionEvent, this.sCancelAction);
    }

    public void doClose(UIWindowEvent uIWindowEvent) throws Throwable {
        this.dispose();
        this.callAction(uIWindowEvent, this.sCancelAction);
    }
}

