/*
 * Copyright 2012 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 20.07.2012 - [JR] - creation
 */
package com.sibvisions.rad.persist.jdbc.param;

/**
 * The <code>InOutParam</code> defines an input and output parameter for JDBC calls.
 * 
 * @author Ren Jahn
 */
public class InOutParam extends AbstractParam
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>InOutParam</code> for the given sql type.
	 * 
	 * @param pSqlType the sql type. All {@link java.sql.Types} are supported.
	 */
	public InOutParam(int pSqlType)
	{
		super(ParameterType.InOut, pSqlType, null);
	}

	/**
	 * Creates a new instance of <code>InOutParam</code> for the given value and sql type.
	 * 
	 * @param pValue the input value
	 * @param pSqlType the sql type. All {@link java.sql.Types} are supported.
	 */
	public InOutParam(int pSqlType, Object pValue)
	{
		super(ParameterType.InOut, pSqlType, pValue);
	}
	
	/**
	 * Creates a new instance of <code>InOutParam</code> for the given array type.
	 * 
	 * @param pArrayType the array type. 
	 */
	public InOutParam(String pArrayType)
	{
		super(ParameterType.InOut, pArrayType, null);
	}

	/**
	 * Creates a new instance of <code>InOutParam</code> for the given value and array type.
	 * 
	 * @param pValue the input value
	 * @param pArrayType the array type.
	 */
	public InOutParam(String pArrayType, Object pValue)
	{
		super(ParameterType.InOut, pArrayType, pValue);
	}
	
}	// InOutParam
