/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import com.sibvisions.util.Internalize;
import com.sibvisions.util.type.NumberUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;
import javax.rad.model.ui.ICellEditor;

public class BigDecimalDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = 3;
    private int iScale = -1;
    private int iPrecision = 0;
    private boolean bSigned = true;
    private NumberUtil numberUtil = new NumberUtil();

    public BigDecimalDataType() {
    }

    public BigDecimalDataType(int n, int n2) {
        this.setPrecision(n);
        this.setScale(n2);
    }

    public BigDecimalDataType(ICellEditor iCellEditor) {
        this.setCellEditor(iCellEditor);
    }

    public BigDecimalDataType(int n, int n2, ICellEditor iCellEditor) {
        this.setPrecision(n);
        this.setScale(n2);
        this.setCellEditor(iCellEditor);
    }

    public int getTypeIdentifier() {
        return 3;
    }

    public Class getTypeClass() {
        return BigDecimal.class;
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.numberUtil.format((Number)object);
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    public static final BigDecimal trimScale(BigDecimal bigDecimal) {
        return BigDecimalDataType.removeExponent(bigDecimal.stripTrailingZeros());
    }

    public static final BigDecimal removeExponent(BigDecimal bigDecimal) {
        if (bigDecimal.scale() < 0) {
            return bigDecimal.setScale(0);
        }
        return bigDecimal;
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return BigDecimalDataType.removeExponent((BigDecimal)object);
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return BigDecimalDataType.removeExponent(BigDecimal.valueOf(((Number)object).longValue()));
        }
        if (object instanceof BigInteger) {
            return BigDecimalDataType.removeExponent(new BigDecimal((BigInteger)object));
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d != d) {
                return null;
            }
            return BigDecimalDataType.removeExponent(BigDecimal.valueOf(((Number)object).doubleValue()));
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return BigDecimalDataType.removeExponent(BigDecimal.valueOf(date.getTime()));
        }
        if (object instanceof CharSequence) {
            String string = object.toString().trim();
            if (string.length() == 0) {
                return null;
            }
            try {
                return BigDecimalDataType.removeExponent(new BigDecimal(string));
            }
            catch (Exception exception) {
                try {
                    return BigDecimalDataType.removeExponent((BigDecimal)this.numberUtil.parse(string));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        throw new ModelException("Conversion failed! Type not supported ! from " + object.getClass().getName() + " to " + this.getTypeClass().getName());
    }

    public BigDecimal convertAndCheckToTypeClass(Object object) throws ModelException {
        BigDecimal bigDecimal = (BigDecimal)this.convertToTypeClass(object);
        if (bigDecimal == null) {
            return null;
        }
        if (bigDecimal.signum() < 0 && !this.isSigned()) {
            throw new ModelException("BigDecimal needs to be positive! - " + bigDecimal);
        }
        int n = bigDecimal.scale();
        int n2 = bigDecimal.precision();
        if (!(this.getPrecision() > 0 && n2 - n > this.getPrecision() - Math.max(n, this.getScale()) || this.getScale() >= 0 && n > this.getScale())) {
            return Internalize.intern(BigDecimalDataType.trimScale(bigDecimal));
        }
        throw new ModelException("BigDecimal too large! - (precision/scale) from (" + n2 + "/" + n + ") to (" + this.getPrecision() + "/" + this.getScale() + ")");
    }

    public int getSize() {
        if (this.getPrecision() == 0 && this.getScale() == -1) {
            return 38;
        }
        int n = this.getPrecision();
        if (this.getScale() != 0) {
            ++n;
        }
        if (this.getScale() > 0 && this.getPrecision() == this.getScale()) {
            ++n;
        }
        if (this.isSigned()) {
            ++n;
        }
        return n;
    }

    public BigDecimalDataType clone() {
        return (BigDecimalDataType)super.clone();
    }

    public int getPrecision() {
        return this.iPrecision;
    }

    public void setPrecision(int n) {
        if (n <= 0) {
            n = 0;
        }
        this.iPrecision = n;
    }

    public int getScale() {
        return this.iScale;
    }

    public void setScale(int n) {
        if (n < -1) {
            n = -1;
        }
        this.iScale = n;
    }

    public boolean isSigned() {
        return this.bSigned;
    }

    public void setSigned(boolean bl) {
        this.bSigned = bl;
    }

    public String getNumberFormat() {
        return this.numberUtil.getNumberPattern();
    }

    public void setNumberFormat(String string) {
        this.numberUtil.setNumberPattern(string);
    }
}

