/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model;

import java.util.Arrays;

public class TreePath {
    public static final TreePath EMPTY = new TreePath(new int[0]);
    private int[] array;

    public TreePath(int ... nArray) {
        this.array = nArray;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.array.length; ++i) {
            n = 31 * n + this.array[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null && this.array.length == 0) {
            return true;
        }
        if (object instanceof TreePath) {
            TreePath treePath = (TreePath)object;
            if (this.array.length == treePath.array.length) {
                for (int i = 0; i < this.array.length; ++i) {
                    if (this.array[i] == treePath.array[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    public int length() {
        return this.array.length;
    }

    public int get(int n) {
        return this.array[n];
    }

    public int getLast() {
        if (this.array.length == 0) {
            return -1;
        }
        return this.array[this.array.length - 1];
    }

    public TreePath getSubPath(int n) {
        if (n <= 0) {
            return this;
        }
        if (this.array.length <= n) {
            return EMPTY;
        }
        int[] nArray = new int[this.array.length - n];
        System.arraycopy(this.array, n, nArray, 0, this.array.length - n);
        return new TreePath(nArray);
    }

    public TreePath set(int n, int n2) {
        int[] nArray = (int[])this.array.clone();
        nArray[n] = n2;
        return new TreePath(nArray);
    }

    public TreePath getChildPath(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return this;
        }
        int[] nArray2 = new int[this.array.length + nArray.length];
        System.arraycopy(this.array, 0, nArray2, 0, this.array.length);
        System.arraycopy(nArray, 0, nArray2, this.array.length, nArray.length);
        return new TreePath(nArray2);
    }

    public TreePath getParentPath() {
        if (this.array.length == 0) {
            return this;
        }
        if (this.array.length == 0) {
            return EMPTY;
        }
        int[] nArray = new int[this.array.length - 1];
        System.arraycopy(this.array, 0, nArray, 0, nArray.length);
        return new TreePath(nArray);
    }

    public boolean containsAsParent(TreePath treePath) {
        if (treePath == null) {
            return true;
        }
        if (this.array.length >= treePath.array.length) {
            for (int i = 0; i < treePath.array.length; ++i) {
                if (this.array[i] == treePath.array[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] toArray() {
        return (int[])this.array.clone();
    }
}

