/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model;

import com.sibvisions.util.type.StringUtil;
import java.io.Serializable;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.ui.IControl;
import javax.rad.persist.ColumnMetaData;

public class ColumnDefinition
implements Serializable,
Cloneable {
    private transient IRowDefinition rdRowDefinition;
    private String sName;
    private IDataType ctDataType;
    private String sLabel;
    private boolean bNullable = true;
    private String sComment;
    private Object oDefault;
    private Object[] oAllowedValues;
    private boolean bReadonly;
    private boolean bWriteable = false;
    private boolean bFilterable = true;
    private int iWidth;
    private boolean bMoveable = true;
    private boolean bResizeable = true;

    public ColumnDefinition() {
        this(null, new StringDataType());
    }

    public ColumnDefinition(String string) {
        this(string, new StringDataType());
    }

    public ColumnDefinition(String string, IDataType iDataType) {
        this.sName = string;
        this.ctDataType = iDataType;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColumnDefinition ::[");
        stringBuilder.append(this.sName);
        stringBuilder.append("]");
        stringBuilder.append(",Type=");
        stringBuilder.append(this.ctDataType);
        stringBuilder.append(",Label=");
        stringBuilder.append(this.sLabel);
        stringBuilder.append(",Nullable=");
        stringBuilder.append(this.bNullable);
        stringBuilder.append(",Readonly=");
        stringBuilder.append(this.bReadonly);
        stringBuilder.append(",Writeable=");
        stringBuilder.append(this.bWriteable);
        stringBuilder.append(",Filterable=");
        stringBuilder.append(this.bFilterable);
        stringBuilder.append(",Width=");
        stringBuilder.append(this.iWidth);
        stringBuilder.append(",Moveable=");
        stringBuilder.append(this.bMoveable);
        stringBuilder.append(",Resizeable=");
        stringBuilder.append(this.bResizeable);
        stringBuilder.append(",Default=");
        stringBuilder.append(this.oDefault);
        stringBuilder.append(",Allowed=");
        stringBuilder.append(StringUtil.toString(this.oAllowedValues));
        return stringBuilder.toString();
    }

    public ColumnDefinition clone() {
        try {
            ColumnDefinition columnDefinition = (ColumnDefinition)super.clone();
            columnDefinition.rdRowDefinition = null;
            columnDefinition.ctDataType = this.ctDataType.clone();
            if (this.oAllowedValues != null) {
                columnDefinition.oAllowedValues = (Object[])this.oAllowedValues.clone();
            }
            return columnDefinition;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setRowDefinition(IRowDefinition iRowDefinition) throws ModelException {
        if (this.rdRowDefinition != null && iRowDefinition != null) {
            throw new ModelException("ColumnDefinition already added to an RowDefinition! - " + this.rdRowDefinition.toString());
        }
        this.rdRowDefinition = iRowDefinition;
    }

    public IRowDefinition getRowDefinition() {
        return this.rdRowDefinition;
    }

    public void setName(String string) throws ModelException {
        if (this.rdRowDefinition != null) {
            throw new ModelException("ColumnDefinition already added to an RowDefinition! - " + this.rdRowDefinition.toString());
        }
        if (string == null) {
            throw new ModelException("Column name have to be != null!");
        }
        this.sName = string;
    }

    public String getName() {
        return this.sName;
    }

    public void setDataType(IDataType iDataType) throws ModelException {
        if (this.rdRowDefinition != null) {
            throw new ModelException("ColumnDefinition already added to an RowDefinition! - " + this.rdRowDefinition.toString());
        }
        this.ctDataType = iDataType;
    }

    public IDataType getDataType() {
        return this.ctDataType;
    }

    public void setNullable(boolean bl) {
        this.bNullable = bl;
        this.invokeRepaintListeners();
    }

    public boolean isNullable() {
        return this.bNullable;
    }

    public void setWritable(boolean bl) {
        this.bWriteable = bl;
        this.invokeRepaintListeners();
    }

    public boolean isWritable() {
        return this.bWriteable;
    }

    public void setFilterable(boolean bl) {
        this.bFilterable = bl;
        this.invokeRepaintListeners();
    }

    public boolean isFilterable() {
        return this.bFilterable;
    }

    public void setLabel(String string) {
        this.sLabel = string;
        this.invokeRepaintListeners();
    }

    public String getLabel() {
        if (this.sLabel == null) {
            return this.getDefaultLabel();
        }
        return this.sLabel;
    }

    public void setComment(String string) {
        this.sComment = string;
    }

    public String getComment() {
        return this.sComment;
    }

    public int getWidth() {
        return this.iWidth;
    }

    public void setWidth(int n) {
        this.iWidth = n;
    }

    public void setMovable(boolean bl) {
        this.bMoveable = bl;
        this.invokeRepaintListeners();
    }

    public boolean isMovable() {
        return this.bMoveable;
    }

    public void setResizable(boolean bl) {
        this.bResizeable = bl;
        this.invokeRepaintListeners();
    }

    public boolean isResizable() {
        return this.bResizeable;
    }

    public void setReadOnly(boolean bl) {
        this.bReadonly = bl;
        this.invokeRepaintListeners();
    }

    public boolean isReadOnly() {
        return this.bReadonly;
    }

    public String getDefaultLabel() {
        return ColumnMetaData.getDefaultLabel(this.sName);
    }

    public void setDefaultValue(Object object) {
        this.oDefault = object;
    }

    public Object getDefaultValue() {
        return this.oDefault;
    }

    public void setAllowedValues(Object[] objectArray) {
        this.oAllowedValues = objectArray;
    }

    public Object[] getAllowedValues() {
        return this.oAllowedValues;
    }

    protected void invokeRepaintListeners() {
        if (this.rdRowDefinition != null) {
            IControl[] iControlArray = this.rdRowDefinition.getControls();
            for (int i = 0; i < iControlArray.length; ++i) {
                iControlArray[i].notifyRepaint();
            }
        }
    }
}

