/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.application.genui;

import com.sibvisions.util.Reflective;
import javax.rad.application.IApplication;
import javax.rad.application.IContent;
import javax.rad.application.genui.ControllerContent;
import javax.rad.application.genui.IApplicationSetup;
import javax.rad.application.genui.UILauncher;
import javax.rad.ui.IContainer;
import javax.rad.ui.ICursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Application
extends ControllerContent
implements IApplication {
    public static final String PARAM_SETUP_CLASS = "Application.setup.classname";
    private UILauncher launcher;
    private IApplicationSetup setup;

    public Application(UILauncher uILauncher) {
        this.setLauncher(uILauncher);
        try {
            String string = uILauncher.getParameter(PARAM_SETUP_CLASS);
            if (string != null) {
                this.setup = (IApplicationSetup)Reflective.construct(string, new Object[0]);
                this.setup.apply(this);
                this.debug("Apply setup: ", string);
            }
        }
        catch (Throwable throwable) {
            this.debug(throwable);
        }
    }

    @Override
    public UILauncher getLauncher() {
        return this.launcher;
    }

    @Override
    public <OP> IContent showMessage(OP OP, int n, int n2, String string, String string2, String string3) throws Throwable {
        this.getLauncher().handleException(new Exception(string));
        return null;
    }

    @Override
    public IContainer getApplicationPane() {
        return this;
    }

    @Override
    public IContainer getContentPane() {
        return this.getApplicationPane();
    }

    @Override
    public void setCursor(ICursor iCursor) {
        this.launcher.setCursor(iCursor);
    }

    @Override
    public ICursor getCursor() {
        return this.launcher.getCursor();
    }

    @Override
    public void notifyDestroy() {
        this.launcher.cancelPendingThreads();
    }

    @Override
    public Object getControllerProperty(String string) {
        Object object = super.getControllerProperty(string);
        if (object == null) {
            return this.launcher.getParameter("Controller." + string);
        }
        return object;
    }

    public <OP> IContent showInformation(OP OP, String string) throws Throwable {
        return this.showMessage(OP, 0, 6, string, null, null);
    }

    public <OP> IContent showInformation(OP OP, String string, String string2) throws Throwable {
        return this.showMessage(OP, 0, 6, string, string2, null);
    }

    public <OP> IContent showError(OP OP, String string) throws Throwable {
        return this.showMessage(OP, 2, 6, string, null, null);
    }

    public <OP> IContent showError(OP OP, String string, String string2) throws Throwable {
        return this.showMessage(OP, 2, 6, string, string2, null);
    }

    public <OP> IContent showQuestion(OP OP, String string, String string2) throws Throwable {
        return this.showMessage(OP, 3, 5, string, string2, null);
    }

    public <OP> IContent showQuestion(OP OP, String string, String string2, String string3) throws Throwable {
        return this.showMessage(OP, 3, 5, string, string2, string3);
    }

    public <OP> IContent showWarning(OP OP, String string) throws Throwable {
        return this.showMessage(OP, 1, 6, string, null, null);
    }

    public <OP> IContent showWarning(OP OP, String string, String string2) throws Throwable {
        return this.showMessage(OP, 1, 6, string, string2, null);
    }

    protected final void setLauncher(UILauncher uILauncher) {
        this.launcher = uILauncher;
    }

    protected IApplicationSetup getSetup() {
        return this.setup;
    }
}

