/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.type.CommonUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil<E>
extends AbstractList<E>
implements RandomAccess,
Cloneable,
Serializable {
    private static final int MIN_SIZE = 16;
    private E[] array;
    private int offset;
    private int size;

    public ArrayUtil() {
        this(0);
    }

    public ArrayUtil(int n) {
        this.array = null;
        this.offset = n - n / 2;
        this.size = 0;
    }

    public ArrayUtil(E ... EArray) {
        this(EArray, 0, -1);
    }

    public ArrayUtil(E[] EArray, int n) {
        this(EArray, 0, n);
    }

    public ArrayUtil(E[] EArray, int n, int n2) {
        int n3;
        this.array = EArray;
        int n4 = n3 = this.array == null ? 0 : this.array.length;
        if (n2 < 0) {
            this.size = n3;
        } else {
            if (n2 > n3) {
                throw new IndexOutOfBoundsException("The size is " + n2 + " and should be smaller or equal than length " + n3 + "!");
            }
            this.size = n2;
        }
        if (n < 0 || n + n2 > n3) {
            throw new IndexOutOfBoundsException("The offset is " + n + " and should be between 0 and length " + n3 + " - size " + this.size + "!");
        }
        this.offset = n;
    }

    public ArrayUtil(Collection<? extends E> collection) {
        int n = this.size = collection != null ? collection.size() : 0;
        if (this.size == 0) {
            this.array = null;
            this.offset = 0;
        } else if (collection instanceof ArrayUtil) {
            this.array = (Object[])((ArrayUtil)collection).array.clone();
            this.offset = ((ArrayUtil)collection).offset;
        } else {
            this.array = collection.toArray();
            this.offset = 0;
        }
    }

    private void ensureCapacity(int n, int n2) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("The index is " + n + " and should be between 0 and size " + this.size + "!");
        }
        if (n < this.size / 2) {
            if (n2 <= this.offset) {
                if (n > 0) {
                    System.arraycopy(this.array, this.offset, this.array, this.offset - n2, n);
                }
                this.offset -= n2;
            } else {
                int n3;
                int n4 = this.array.length - this.offset + n2;
                int n5 = n3 = this.array.length < 16 ? 16 : this.array.length;
                while (n3 < n4) {
                    n3 += n3 / 2;
                }
                Object[] objectArray = new Object[n3];
                int n6 = n3 - n4;
                if (n < this.size) {
                    System.arraycopy(this.array, this.offset + n, objectArray, n6 + n + n2, this.size - n);
                }
                if (n > 0) {
                    System.arraycopy(this.array, this.offset, objectArray, n6, n);
                }
                this.array = objectArray;
                this.offset = n6;
            }
        } else {
            int n7 = this.offset + this.size + n2;
            if (this.array != null && n7 <= this.array.length) {
                if (n < this.size) {
                    System.arraycopy(this.array, this.offset + n, this.array, this.offset + n + n2, this.size - n);
                }
            } else {
                int n8;
                int n9 = this.array == null ? (this.offset > 0 ? this.offset * 2 : 16) : (n8 = this.array.length < 16 ? 16 : this.array.length);
                while (n8 < n7) {
                    n8 += n8 / 2;
                }
                Object[] objectArray = new Object[n8];
                if (this.array != null) {
                    if (n > 0) {
                        System.arraycopy(this.array, this.offset, objectArray, this.offset, n);
                    }
                    if (n < this.size) {
                        System.arraycopy(this.array, this.offset + n, objectArray, this.offset + n + n2, this.size - n);
                    }
                }
                this.array = objectArray;
            }
        }
        ++this.modCount;
        this.size += n2;
    }

    @Override
    public boolean add(E e) {
        this.add(this.size, e);
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.ensureCapacity(n, 1);
        this.array[this.offset + n] = e;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection instanceof ArrayUtil) {
            return this.addAll(n, ((ArrayUtil)collection).array, ((ArrayUtil)collection).offset, ((ArrayUtil)collection).size);
        }
        return this.addAll(n, collection.toArray(), 0, -1);
    }

    public boolean addAll(E[] EArray) {
        return this.addAll(this.size, EArray, 0, -1);
    }

    public boolean addAll(int n, E[] EArray) {
        return this.addAll(n, EArray, 0, -1);
    }

    public boolean addAll(int n, E[] EArray, int n2, int n3) {
        if (n3 == 0 || EArray == null) {
            return false;
        }
        if (n3 < 0) {
            n3 = EArray.length;
        }
        this.ensureCapacity(n, n3);
        System.arraycopy(EArray, n2, this.array, this.offset + n, n3);
        return true;
    }

    public void merge(E[] EArray) {
        Object[] objectArray;
        Object[] objectArray2;
        if (EArray != null) {
            objectArray2 = new Object[Math.max(this.size + EArray.length, 16)];
            objectArray = new Object[]{this.array, EArray};
        } else {
            objectArray2 = new Object[this.array.length];
            objectArray = new Object[]{this.array};
        }
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray3 = (Object[])objectArray[i];
            if (objectArray3 == null) continue;
            for (int j = 0; j < objectArray3.length; ++j) {
                if (ArrayUtil.indexOf(objectArray2, objectArray3[j]) >= 0) continue;
                objectArray2[n++] = objectArray3[j];
            }
        }
        ++this.modCount;
        this.offset = 0;
        this.size = n;
        this.array = objectArray2;
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(this.size, n - this.size);
        } else if (n < this.size) {
            this.removeRange(n, this.size);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.array = null;
        this.offset = 0;
        this.size = 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public E get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("The index is " + n + " and should be between 0 and size " + (this.size - 1) + "!");
        }
        return this.array[this.offset + n];
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int n) {
        if (n >= 0) {
            int n2 = this.offset + this.size;
            Object object2 = object instanceof WeakReference ? ((WeakReference)object).get() : object;
            for (int i = this.offset + n; i < n2; ++i) {
                Object object3 = this.array[i];
                if (object3 instanceof WeakReference) {
                    object3 = ((WeakReference)object3).get();
                }
                if (object2 != object3 && (object3 == null || !object3.equals(object2)) && (object2 == null || !object2.equals(object3))) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    public boolean containsReference(Object object) {
        return this.indexOfReference(object) >= 0;
    }

    public int indexOfReference(Object object) {
        return this.indexOfReference(object, 0);
    }

    public int indexOfReference(Object object, int n) {
        if (n >= 0) {
            int n2 = this.offset + this.size;
            Object object2 = object instanceof WeakReference ? ((WeakReference)object).get() : object;
            for (int i = this.offset + n; i < n2; ++i) {
                Object object3 = this.array[i];
                if (object3 instanceof WeakReference) {
                    object3 = ((WeakReference)object3).get();
                }
                if (object2 != object3) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, -1);
    }

    public int lastIndexOf(Object object, int n) {
        if (n < this.size) {
            if (n < 0) {
                n = this.size - 1;
            }
            Object object2 = object instanceof WeakReference ? ((WeakReference)object).get() : object;
            for (int i = this.offset + n; i >= this.offset; --i) {
                Object object3 = this.array[i];
                if (object3 instanceof WeakReference) {
                    object3 = ((WeakReference)object3).get();
                }
                if (object2 != object3 && (object2 == null || !object2.equals(object3)) && (object3 == null || !object3.equals(object2))) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    public int lastIndexOfReference(Object object) {
        return this.lastIndexOfReference(object, -1);
    }

    public int lastIndexOfReference(Object object, int n) {
        if (n < this.size) {
            if (n < 0) {
                n = this.size - 1;
            }
            Object object2 = object instanceof WeakReference ? ((WeakReference)object).get() : object;
            for (int i = this.offset + n; i >= this.offset; --i) {
                Object object3 = this.array[i];
                if (object3 instanceof WeakReference) {
                    object3 = ((WeakReference)object3).get();
                }
                if (object2 != object3) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    @Override
    public void removeRange(int n, int n2) {
        if (n < 0) {
            n = this.size - 1;
        } else if (n > this.size) {
            throw new IndexOutOfBoundsException("The fromIndex is " + n + " and should be smaller or equal than size " + this.size + "!");
        }
        if (n2 < 0) {
            n2 = this.size;
        } else if (n2 > this.size) {
            throw new IndexOutOfBoundsException("The toIndex is " + n2 + " and should be smaller or equal than size " + this.size + "!");
        }
        if (n < n2) {
            int n3;
            ++this.modCount;
            int n4 = n2 - n;
            int n5 = this.size - n4;
            for (n3 = this.array.length; n5 < n3 - n3 / 3 && n3 > 16; n3 -= n3 / 3) {
            }
            if (n3 == this.array.length) {
                if (n < n5 - n) {
                    if (n > 0) {
                        System.arraycopy(this.array, this.offset, this.array, this.offset + n4, n);
                    }
                    for (int i = this.offset + n4 - 1; i >= this.offset; --i) {
                        this.array[i] = null;
                    }
                    this.offset += n4;
                } else {
                    if (n < n5) {
                        System.arraycopy(this.array, this.offset + n2, this.array, this.offset + n, n5 - n);
                    }
                    for (int i = this.offset + this.size - 1; i >= this.offset + n5; --i) {
                        this.array[i] = null;
                    }
                }
            } else {
                int n6 = (n3 - n5) / 2;
                Object[] objectArray = new Object[n3];
                if (n > 0) {
                    System.arraycopy(this.array, this.offset, objectArray, n6, n);
                }
                if (n < n5) {
                    System.arraycopy(this.array, this.offset + n2, objectArray, n6 + n, n5 - n);
                }
                this.array = objectArray;
                this.offset = n6;
            }
            this.size = n5;
        }
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeRange(n, n + 1);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int n) {
        E e = this.get(n);
        this.removeRange(n, n + 1);
        return e;
    }

    @Override
    public void removeLast() {
        this.removeRange(-1, -1);
    }

    public boolean removeAll(E[] EArray) {
        if (EArray == null) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (ArrayUtil.indexOf(EArray, iterator.next()) < 0) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public void truncate(int n) {
        this.removeRange(n, -1);
    }

    @Override
    public E set(int n, E e) {
        E e2 = this.get(n);
        this.array[this.offset + n] = e;
        return e2;
    }

    @Override
    public int size() {
        return this.size;
    }

    public Enumeration<E> enumeration() {
        return Collections.enumeration(this);
    }

    public ArrayUtil<E> clone() {
        try {
            ArrayUtil arrayUtil = (ArrayUtil)super.clone();
            if (this.array != null) {
                arrayUtil.array = (Object[])this.array.clone();
            }
            return arrayUtil;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        if (this.array != null) {
            System.arraycopy(this.array, this.offset, objectArray, 0, this.size);
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        if (this.array != null) {
            System.arraycopy(this.array, this.offset, objectArray, 0, this.size);
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ArrayUtil) {
            ArrayUtil arrayUtil = (ArrayUtil)object;
            if (this.size != arrayUtil.size) {
                return false;
            }
            if (this.size == 0) {
                return true;
            }
            int n = this.offset + this.size;
            int n2 = arrayUtil.offset;
            int n3 = this.offset;
            while (n3 < n) {
                E e;
                E e2;
                if (!CommonUtil.equals(e2 = this.array[n3++], e = arrayUtil.array[n2++])) {
                    return false;
                }
                ++n3;
                ++n2;
            }
            return true;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (this.size != collection.size()) {
                return false;
            }
            if (this.size == 0) {
                return true;
            }
            Iterator iterator = collection.iterator();
            int n = this.offset + this.size;
            for (int i = this.offset; i < n; ++i) {
                E e = this.array[i];
                Object e3 = iterator.next();
                if (CommonUtil.equals(e, e3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        int n2 = this.offset + this.size;
        if (this.size < 16) {
            for (int i = this.offset; i < n2; ++i) {
                n *= 37;
                E e = this.array[i];
                if (e == null) continue;
                n += e.hashCode();
            }
        } else {
            int n3 = this.size / 16;
            for (int i = this.offset; i < n2; i += n3) {
                n *= 41;
                E e = this.array[i];
                if (e == null) continue;
                n += e.hashCode();
            }
        }
        return n;
    }

    public static <T> T[] add(T[] TArray, int n, T t) {
        int n2;
        int n3 = n2 = TArray == null ? 0 : TArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        Object[] objectArray = TArray == null ? new Object[n2 + 1] : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2 + 1);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        if (n < n2) {
            System.arraycopy(TArray, n, objectArray, n + 1, n2 - n);
        }
        objectArray[n] = t;
        return objectArray;
    }

    public static <T> T[] add(T[] TArray, T t) {
        return ArrayUtil.add(TArray, -1, t);
    }

    public static <T> T[] addAll(T[] TArray, int n, T[] TArray2) {
        int n2;
        int n3 = n2 = TArray == null ? 0 : TArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        if (TArray2 == null || TArray2.length == 0) {
            return TArray;
        }
        Object[] objectArray = TArray == null ? (Object[])Array.newInstance(TArray2.getClass().getComponentType(), n2 + TArray2.length) : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2 + TArray2.length);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        if (n < n2) {
            System.arraycopy(TArray, n, objectArray, n + TArray2.length, n2 - n);
        }
        System.arraycopy(TArray2, 0, objectArray, n, TArray2.length);
        return objectArray;
    }

    public static <T> T[] addAll(T[] TArray, T[] TArray2) {
        return ArrayUtil.addAll(TArray, -1, TArray2);
    }

    public static boolean[] merge(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null && blArray2 == null) {
            return null;
        }
        boolean[] blArray3 = new boolean[2];
        Object[] objectArray = new Object[]{blArray, blArray2};
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < objectArray.length && n < 2; ++i) {
            boolean[] blArray4 = (boolean[])objectArray[i];
            if (blArray4 == null) continue;
            for (int j = 0; j < blArray4.length && n < 2; ++j) {
                if (blArray4[j]) {
                    if (bl) continue;
                    bl = true;
                    blArray3[n++] = true;
                    continue;
                }
                if (bl2) continue;
                bl2 = true;
                blArray3[n++] = false;
            }
        }
        if (n == 2) {
            return blArray3;
        }
        boolean[] blArray5 = new boolean[n];
        System.arraycopy(blArray3, 0, blArray5, 0, n);
        return blArray5;
    }

    public static float[] merge(float[] fArray, float[] fArray2) {
        if (fArray == null && fArray2 == null) {
            return null;
        }
        float[] fArray3 = new float[(fArray != null ? fArray.length : 0) + (fArray2 != null ? fArray2.length : 0)];
        Object[] objectArray = new Object[]{fArray, fArray2};
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            float[] fArray4 = (float[])objectArray[i];
            if (fArray4 == null) continue;
            for (int j = 0; j < fArray4.length; ++j) {
                if (ArrayUtil.indexOf(fArray3, fArray4[j]) >= 0) continue;
                fArray3[n++] = fArray4[j];
            }
        }
        float[] fArray5 = new float[n];
        System.arraycopy(fArray3, 0, fArray5, 0, n);
        return fArray5;
    }

    public static double[] merge(double[] dArray, double[] dArray2) {
        if (dArray == null && dArray2 == null) {
            return null;
        }
        double[] dArray3 = new double[(dArray != null ? dArray.length : 0) + (dArray2 != null ? dArray2.length : 0)];
        Object[] objectArray = new Object[]{dArray, dArray2};
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            double[] dArray4 = (double[])objectArray[i];
            if (dArray4 == null) continue;
            for (int j = 0; j < dArray4.length; ++j) {
                if (ArrayUtil.indexOf(dArray3, dArray4[j]) >= 0) continue;
                dArray3[n++] = dArray4[j];
            }
        }
        double[] dArray5 = new double[n];
        System.arraycopy(dArray3, 0, dArray5, 0, n);
        return dArray5;
    }

    public static int[] merge(int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 == null) {
            return null;
        }
        int[] nArray3 = new int[(nArray != null ? nArray.length : 0) + (nArray2 != null ? nArray2.length : 0)];
        Object[] objectArray = new Object[]{nArray, nArray2};
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            int[] nArray4 = (int[])objectArray[i];
            if (nArray4 == null) continue;
            for (int j = 0; j < nArray4.length; ++j) {
                if (ArrayUtil.indexOf(nArray3, nArray4[j]) >= 0) continue;
                nArray3[n++] = nArray4[j];
            }
        }
        int[] nArray5 = new int[n];
        System.arraycopy(nArray3, 0, nArray5, 0, n);
        return nArray5;
    }

    public static long[] merge(long[] lArray, long[] lArray2) {
        if (lArray == null && lArray2 == null) {
            return null;
        }
        long[] lArray3 = new long[(lArray != null ? lArray.length : 0) + (lArray2 != null ? lArray2.length : 0)];
        Object[] objectArray = new Object[]{lArray, lArray2};
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            long[] lArray4 = (long[])objectArray[i];
            if (lArray4 == null) continue;
            for (int j = 0; j < lArray4.length; ++j) {
                if (ArrayUtil.indexOf(lArray3, lArray4[j]) >= 0) continue;
                lArray3[n++] = lArray4[j];
            }
        }
        long[] lArray5 = new long[n];
        System.arraycopy(lArray3, 0, lArray5, 0, n);
        return lArray5;
    }

    public static char[] merge(char[] cArray, char[] cArray2) {
        if (cArray == null && cArray2 == null) {
            return null;
        }
        char[] cArray3 = new char[(cArray != null ? cArray.length : 0) + (cArray2 != null ? cArray2.length : 0)];
        Object[] objectArray = new Object[]{cArray, cArray2};
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            char[] cArray4 = (char[])objectArray[i];
            if (cArray4 == null) continue;
            for (int j = 0; j < cArray4.length; ++j) {
                if (ArrayUtil.indexOf(cArray3, cArray4[j]) >= 0) continue;
                cArray3[n++] = cArray4[j];
            }
        }
        char[] cArray5 = new char[n];
        System.arraycopy(cArray3, 0, cArray5, 0, n);
        return cArray5;
    }

    public static <T> T[] merge(T[] TArray, T[] TArray2) {
        if (TArray == null && TArray2 == null) {
            return null;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray != null ? TArray.getClass().getComponentType() : TArray2.getClass().getComponentType(), (TArray != null ? TArray.length : 0) + (TArray2 != null ? TArray2.length : 0));
        Object[] objectArray2 = new Object[]{TArray, TArray2};
        int n = 0;
        for (int i = 0; i < objectArray2.length; ++i) {
            Object[] objectArray3 = (Object[])objectArray2[i];
            if (objectArray3 == null) continue;
            for (int j = 0; j < objectArray3.length; ++j) {
                if (ArrayUtil.indexOf(objectArray, objectArray3[j]) >= 0) continue;
                objectArray[n++] = objectArray3[j];
            }
        }
        Object[] objectArray4 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        System.arraycopy(objectArray, 0, objectArray4, 0, n);
        return objectArray4;
    }

    public static <T> T[] removeRange(T[] TArray, int n, int n2) {
        int n3;
        int n4 = n3 = TArray == null ? 0 : TArray.length;
        if (n < 0) {
            n = n3 - 1;
        } else if (n > n3) {
            throw new IndexOutOfBoundsException("The fromIndex is " + n + " and should be smaller or equal than " + n3 + "!");
        }
        if (n2 < 0) {
            n2 = n3;
        } else if (n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException("The toIndex is " + n2 + " and should be between fromIndex + " + n + " and length " + n3 + "!");
        }
        if (n == n2) {
            return TArray;
        }
        int n5 = n2 - n;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n3 - n5);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        if (n2 < n3) {
            System.arraycopy(TArray, n2, objectArray, n, n3 - n2);
        }
        return objectArray;
    }

    public static <T> T[] remove(T[] TArray, int n) {
        return ArrayUtil.removeRange(TArray, n, n + 1);
    }

    public static <T> T[] removeLast(T[] TArray) {
        return ArrayUtil.removeRange(TArray, -1, -1);
    }

    public static <T> T[] remove(T[] TArray, T t) {
        int n = ArrayUtil.indexOf(TArray, t);
        if (n < 0) {
            return TArray;
        }
        return ArrayUtil.removeRange(TArray, n, n + 1);
    }

    public static <T> T[] removeReference(T[] TArray, T t) {
        int n = ArrayUtil.indexOfReference(TArray, t);
        if (n < 0) {
            return TArray;
        }
        return ArrayUtil.removeRange(TArray, n, n + 1);
    }

    public static <T> T[] removeAll(T[] TArray, T[] TArray2) {
        if (TArray == null) {
            return null;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length);
        if (TArray2 == null) {
            System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
            return objectArray;
        }
        int n = 0;
        for (T t : TArray) {
            if (ArrayUtil.indexOf(TArray2, t) >= 0) continue;
            objectArray[n++] = t;
        }
        if (n < TArray.length) {
            Object[] objectArray2 = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            return objectArray2;
        }
        return objectArray;
    }

    public static <T> T[] intersect(T[] TArray, T[] TArray2) {
        if (TArray == null) {
            return null;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length);
        if (TArray2 == null) {
            System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
            return objectArray;
        }
        int n = 0;
        for (T t : TArray) {
            if (ArrayUtil.indexOf(TArray2, t) < 0 || ArrayUtil.indexOf(objectArray, t, 0, n) >= 0) continue;
            objectArray[n++] = t;
        }
        if (n < TArray.length) {
            Object[] objectArray2 = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            return objectArray2;
        }
        return objectArray;
    }

    public static <T> T[] truncate(T[] TArray, int n) {
        return ArrayUtil.removeRange(TArray, n, -1);
    }

    public static <T> T[] clear(T[] TArray) {
        return ArrayUtil.removeRange(TArray, 0, -1);
    }

    public static <T> boolean contains(T[] TArray, T t) {
        return ArrayUtil.indexOf(TArray, t, 0) >= 0;
    }

    public static <T> int indexOf(T[] TArray, T t) {
        return ArrayUtil.indexOf(TArray, t, 0, TArray == null ? 0 : TArray.length);
    }

    public static <T> int indexOf(T[] TArray, T t, int n) {
        return ArrayUtil.indexOf(TArray, t, n, TArray == null ? 0 : TArray.length);
    }

    public static <T> int indexOf(T[] TArray, T t, int n, int n2) {
        if (n >= 0) {
            for (int i = n; i < n2; ++i) {
                if (!CommonUtil.equals(t, TArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean containsReference(T[] TArray, T t) {
        return ArrayUtil.indexOfReference(TArray, t, 0) >= 0;
    }

    public static <T> int indexOfReference(T[] TArray, T t) {
        return ArrayUtil.indexOfReference(TArray, t, 0);
    }

    public static <T> int indexOfReference(T[] TArray, T t, int n) {
        if (n >= 0) {
            int n2 = TArray == null ? 0 : TArray.length;
            T t2 = t instanceof WeakReference ? ((WeakReference)t).get() : t;
            for (int i = n; i < n2; ++i) {
                T t3 = TArray[i];
                if (t3 instanceof WeakReference) {
                    t3 = ((WeakReference)t3).get();
                }
                if (t2 != t3) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] TArray, T t) {
        return ArrayUtil.lastIndexOf(TArray, t, -1);
    }

    public static <T> int lastIndexOf(T[] TArray, T t, int n) {
        int n2;
        int n3 = n2 = TArray == null ? 0 : TArray.length;
        if (n < n2) {
            if (n < 0) {
                n = n2 - 1;
            }
            T t2 = t instanceof WeakReference ? ((WeakReference)t).get() : t;
            for (int i = n; i >= 0; --i) {
                T t3 = TArray[i];
                if (t3 instanceof WeakReference) {
                    t3 = ((WeakReference)t3).get();
                }
                if (t2 != t3 && (t2 == null || !t2.equals(t3)) && (t3 == null || !t3.equals(t2))) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int indexOfReference(List<T> list, T t) {
        return ArrayUtil.indexOfReference(list, t, 0);
    }

    public static <T> int indexOfReference(List<T> list, T t, int n) {
        if (n >= 0) {
            int n2 = list == null ? 0 : list.size();
            T t2 = t instanceof WeakReference ? ((WeakReference)t).get() : t;
            for (int i = n; i < n2; ++i) {
                T t3 = list.get(i);
                if (t3 instanceof WeakReference) {
                    t3 = ((WeakReference)t3).get();
                }
                if (t2 != t3) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(List<T> list, T t) {
        return ArrayUtil.lastIndexOf(list, t, -1);
    }

    public static <T> int lastIndexOf(List<T> list, T t, int n) {
        int n2;
        int n3 = n2 = list == null ? 0 : list.size();
        if (n < n2) {
            if (n < 0) {
                n = n2 - 1;
            }
            T t2 = t instanceof WeakReference ? ((WeakReference)t).get() : t;
            for (int i = n; i >= 0; --i) {
                T t3 = list.get(i);
                if (t3 instanceof WeakReference) {
                    t3 = ((WeakReference)t3).get();
                }
                if (t2 != t3 && (t2 == null || !t2.equals(t3)) && (t3 == null || !t3.equals(t2))) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOfReference(T[] TArray, T t) {
        return ArrayUtil.lastIndexOfReference(TArray, t, -1);
    }

    public static <T> int lastIndexOfReference(T[] TArray, T t, int n) {
        int n2;
        int n3 = n2 = TArray == null ? 0 : TArray.length;
        if (n < n2) {
            if (n < 0) {
                n = n2 - 1;
            }
            T t2 = t instanceof WeakReference ? ((WeakReference)t).get() : t;
            for (int i = n; i >= 0; --i) {
                T t3 = TArray[i];
                if (t3 instanceof WeakReference) {
                    t3 = ((WeakReference)t3).get();
                }
                if (t2 != t3) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean[] add(boolean[] blArray, int n, boolean bl) {
        int n2;
        int n3 = n2 = blArray == null ? 0 : blArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        boolean[] blArray2 = new boolean[n2 + 1];
        if (n > 0) {
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        if (n < n2) {
            System.arraycopy(blArray, n, blArray2, n + 1, n2 - n);
        }
        blArray2[n] = bl;
        return blArray2;
    }

    public static boolean[] add(boolean[] blArray, boolean bl) {
        return ArrayUtil.add(blArray, -1, bl);
    }

    public static boolean[] addAll(boolean[] blArray, int n, boolean[] blArray2) {
        int n2;
        int n3 = n2 = blArray == null ? 0 : blArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        if (blArray2 == null || blArray2.length == 0) {
            return blArray;
        }
        boolean[] blArray3 = new boolean[n2 + blArray2.length];
        if (n > 0) {
            System.arraycopy(blArray, 0, blArray3, 0, n);
        }
        if (n < n2) {
            System.arraycopy(blArray, n, blArray3, n + blArray2.length, n2 - n);
        }
        System.arraycopy(blArray2, 0, blArray3, n, blArray2.length);
        return blArray3;
    }

    public static boolean[] addAll(boolean[] blArray, boolean[] blArray2) {
        return ArrayUtil.addAll(blArray, -1, blArray2);
    }

    public static boolean[] removeRange(boolean[] blArray, int n, int n2) {
        int n3;
        int n4 = n3 = blArray == null ? 0 : blArray.length;
        if (n < 0) {
            n = n3 - 1;
        } else if (n > n3) {
            throw new IndexOutOfBoundsException("The fromIndex is " + n + " and should be smaller or equal than " + n3 + "!");
        }
        if (n2 < 0) {
            n2 = n3;
        } else if (n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException("The toIndex is " + n2 + " and should be between fromIndex + " + n + " and length " + n3 + "!");
        }
        if (n == n2) {
            return blArray;
        }
        int n5 = n2 - n;
        boolean[] blArray2 = new boolean[n3 - n5];
        if (n > 0) {
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        if (n2 < n3) {
            System.arraycopy(blArray, n2, blArray2, n, n3 - n2);
        }
        return blArray2;
    }

    public static boolean[] remove(boolean[] blArray, int n) {
        return ArrayUtil.removeRange(blArray, n, n + 1);
    }

    public static boolean[] removeLast(boolean[] blArray) {
        return ArrayUtil.removeRange(blArray, -1, -1);
    }

    public static boolean[] truncate(boolean[] blArray, int n) {
        return ArrayUtil.removeRange(blArray, n, -1);
    }

    public static boolean[] clear(boolean[] blArray) {
        return ArrayUtil.removeRange(blArray, 0, -1);
    }

    public static boolean contains(boolean[] blArray, boolean bl) {
        return ArrayUtil.indexOf(blArray, bl, 0) >= 0;
    }

    public static int indexOf(boolean[] blArray, boolean bl) {
        return ArrayUtil.indexOf(blArray, bl, 0);
    }

    public static int indexOf(boolean[] blArray, boolean bl, int n) {
        if (n >= 0) {
            int n2 = blArray == null ? 0 : blArray.length;
            for (int i = n; i < n2; ++i) {
                if (bl != blArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] blArray, boolean bl) {
        return ArrayUtil.lastIndexOf(blArray, bl, -1);
    }

    public static int lastIndexOf(boolean[] blArray, boolean bl, int n) {
        int n2;
        int n3 = n2 = blArray == null ? 0 : blArray.length;
        if (n < n2) {
            if (n < 0) {
                n = n2 - 1;
            }
            for (int i = n; i >= 0; --i) {
                if (bl != blArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static char[] add(char[] cArray, int n, char c) {
        int n2;
        int n3 = n2 = cArray == null ? 0 : cArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        char[] cArray2 = new char[n2 + 1];
        if (n > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n);
        }
        if (n < n2) {
            System.arraycopy(cArray, n, cArray2, n + 1, n2 - n);
        }
        cArray2[n] = c;
        return cArray2;
    }

    public static char[] add(char[] cArray, char c) {
        return ArrayUtil.add(cArray, -1, c);
    }

    public static char[] addAll(char[] cArray, int n, char[] cArray2) {
        int n2;
        int n3 = n2 = cArray == null ? 0 : cArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        if (cArray2 == null || cArray2.length == 0) {
            return cArray;
        }
        char[] cArray3 = new char[n2 + cArray2.length];
        if (n > 0) {
            System.arraycopy(cArray, 0, cArray3, 0, n);
        }
        if (n < n2) {
            System.arraycopy(cArray, n, cArray3, n + cArray2.length, n2 - n);
        }
        System.arraycopy(cArray2, 0, cArray3, n, cArray2.length);
        return cArray3;
    }

    public static char[] addAll(char[] cArray, char[] cArray2) {
        return ArrayUtil.addAll(cArray, -1, cArray2);
    }

    public static char[] removeRange(char[] cArray, int n, int n2) {
        int n3;
        int n4 = n3 = cArray == null ? 0 : cArray.length;
        if (n < 0) {
            n = n3 - 1;
        } else if (n > n3) {
            throw new IndexOutOfBoundsException("The fromIndex is " + n + " and should be smaller or equal than " + n3 + "!");
        }
        if (n2 < 0) {
            n2 = n3;
        } else if (n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException("The toIndex is " + n2 + " and should be between fromIndex + " + n + " and length " + n3 + "!");
        }
        if (n == n2) {
            return cArray;
        }
        int n5 = n2 - n;
        char[] cArray2 = new char[n3 - n5];
        if (n > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n);
        }
        if (n2 < n3) {
            System.arraycopy(cArray, n2, cArray2, n, n3 - n2);
        }
        return cArray2;
    }

    public static char[] remove(char[] cArray, int n) {
        return ArrayUtil.removeRange(cArray, n, n + 1);
    }

    public static char[] removeLast(char[] cArray) {
        return ArrayUtil.removeRange(cArray, -1, -1);
    }

    public static char[] truncate(char[] cArray, int n) {
        return ArrayUtil.removeRange(cArray, n, -1);
    }

    public static char[] clear(char[] cArray) {
        return ArrayUtil.removeRange(cArray, 0, -1);
    }

    public static boolean contains(char[] cArray, char c) {
        return ArrayUtil.indexOf(cArray, c, 0) >= 0;
    }

    public static int indexOf(char[] cArray, char c) {
        return ArrayUtil.indexOf(cArray, c, 0);
    }

    public static int indexOf(char[] cArray, char c, int n) {
        if (n >= 0) {
            int n2 = cArray == null ? 0 : cArray.length;
            for (int i = n; i < n2; ++i) {
                if (c != cArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] cArray, char c) {
        return ArrayUtil.lastIndexOf(cArray, c, -1);
    }

    public static int lastIndexOf(char[] cArray, char c, int n) {
        int n2;
        int n3 = n2 = cArray == null ? 0 : cArray.length;
        if (n < n2) {
            if (n < 0) {
                n = n2 - 1;
            }
            for (int i = n; i >= 0; --i) {
                if (c != cArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int[] add(int[] nArray, int n, int n2) {
        int n3;
        int n4 = n3 = nArray == null ? 0 : nArray.length;
        if (n < 0) {
            n = n3;
        } else if (n > n3) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n3 + "!");
        }
        int[] nArray2 = new int[n3 + 1];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n < n3) {
            System.arraycopy(nArray, n, nArray2, n + 1, n3 - n);
        }
        nArray2[n] = n2;
        return nArray2;
    }

    public static int[] add(int[] nArray, int n) {
        return ArrayUtil.add(nArray, -1, n);
    }

    public static int[] addAll(int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3 = n2 = nArray == null ? 0 : nArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        if (nArray2 == null || nArray2.length == 0) {
            return nArray;
        }
        int[] nArray3 = new int[n2 + nArray2.length];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray3, 0, n);
        }
        if (n < n2) {
            System.arraycopy(nArray, n, nArray3, n + nArray2.length, n2 - n);
        }
        System.arraycopy(nArray2, 0, nArray3, n, nArray2.length);
        return nArray3;
    }

    public static int[] addAll(int[] nArray, int[] nArray2) {
        return ArrayUtil.addAll(nArray, -1, nArray2);
    }

    public static int[] removeRange(int[] nArray, int n, int n2) {
        int n3;
        int n4 = n3 = nArray == null ? 0 : nArray.length;
        if (n < 0) {
            n = n3 - 1;
        } else if (n > n3) {
            throw new IndexOutOfBoundsException("The fromIndex is " + n + " and should be smaller or equal than " + n3 + "!");
        }
        if (n2 < 0) {
            n2 = n3;
        } else if (n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException("The toIndex is " + n2 + " and should be between fromIndex + " + n + " and length " + n3 + "!");
        }
        if (n == n2) {
            return nArray;
        }
        int n5 = n2 - n;
        int[] nArray2 = new int[n3 - n5];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n2 < n3) {
            System.arraycopy(nArray, n2, nArray2, n, n3 - n2);
        }
        return nArray2;
    }

    public static int[] remove(int[] nArray, int n) {
        return ArrayUtil.removeRange(nArray, n, n + 1);
    }

    public static int[] removeLast(int[] nArray) {
        return ArrayUtil.removeRange(nArray, -1, -1);
    }

    public static int[] truncate(int[] nArray, int n) {
        return ArrayUtil.removeRange(nArray, n, -1);
    }

    public static int[] clear(int[] nArray) {
        return ArrayUtil.removeRange(nArray, 0, -1);
    }

    public static boolean contains(int[] nArray, int n) {
        return ArrayUtil.indexOf(nArray, n, 0) >= 0;
    }

    public static int indexOf(int[] nArray, int n) {
        return ArrayUtil.indexOf(nArray, n, 0);
    }

    public static int indexOf(int[] nArray, int n, int n2) {
        if (n2 >= 0) {
            int n3 = nArray == null ? 0 : nArray.length;
            for (int i = n2; i < n3; ++i) {
                if (n != nArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(int[] nArray, int n) {
        return ArrayUtil.lastIndexOf(nArray, n, -1);
    }

    public static int lastIndexOf(int[] nArray, int n, int n2) {
        int n3;
        int n4 = n3 = nArray == null ? 0 : nArray.length;
        if (n2 < n3) {
            if (n2 < 0) {
                n2 = n3 - 1;
            }
            for (int i = n2; i >= 0; --i) {
                if (n != nArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static long[] add(long[] lArray, int n, long l) {
        int n2;
        int n3 = n2 = lArray == null ? 0 : lArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        long[] lArray2 = new long[n2 + 1];
        if (n > 0) {
            System.arraycopy(lArray, 0, lArray2, 0, n);
        }
        if (n < n2) {
            System.arraycopy(lArray, n, lArray2, n + 1, n2 - n);
        }
        lArray2[n] = l;
        return lArray2;
    }

    public static long[] add(long[] lArray, long l) {
        return ArrayUtil.add(lArray, -1, l);
    }

    public static long[] addAll(long[] lArray, int n, long[] lArray2) {
        int n2;
        int n3 = n2 = lArray == null ? 0 : lArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        if (lArray2 == null || lArray2.length == 0) {
            return lArray;
        }
        long[] lArray3 = new long[n2 + lArray2.length];
        if (n > 0) {
            System.arraycopy(lArray, 0, lArray3, 0, n);
        }
        if (n < n2) {
            System.arraycopy(lArray, n, lArray3, n + lArray2.length, n2 - n);
        }
        System.arraycopy(lArray2, 0, lArray3, n, lArray2.length);
        return lArray3;
    }

    public static long[] addAll(long[] lArray, long[] lArray2) {
        return ArrayUtil.addAll(lArray, -1, lArray2);
    }

    public static long[] removeRange(long[] lArray, int n, int n2) {
        int n3;
        int n4 = n3 = lArray == null ? 0 : lArray.length;
        if (n < 0) {
            n = n3 - 1;
        } else if (n > n3) {
            throw new IndexOutOfBoundsException("The fromIndex is " + n + " and should be smaller or equal than " + n3 + "!");
        }
        if (n2 < 0) {
            n2 = n3;
        } else if (n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException("The toIndex is " + n2 + " and should be between fromIndex + " + n + " and length " + n3 + "!");
        }
        if (n == n2) {
            return lArray;
        }
        int n5 = n2 - n;
        long[] lArray2 = new long[n3 - n5];
        if (n > 0) {
            System.arraycopy(lArray, 0, lArray2, 0, n);
        }
        if (n2 < n3) {
            System.arraycopy(lArray, n2, lArray2, n, n3 - n2);
        }
        return lArray2;
    }

    public static long[] remove(long[] lArray, int n) {
        return ArrayUtil.removeRange(lArray, n, n + 1);
    }

    public static long[] removeLast(long[] lArray) {
        return ArrayUtil.removeRange(lArray, -1, -1);
    }

    public static long[] truncate(long[] lArray, int n) {
        return ArrayUtil.removeRange(lArray, n, -1);
    }

    public static long[] clear(long[] lArray) {
        return ArrayUtil.removeRange(lArray, 0, -1);
    }

    public static boolean contains(long[] lArray, long l) {
        return ArrayUtil.indexOf(lArray, l, 0) >= 0;
    }

    public static int indexOf(long[] lArray, long l) {
        return ArrayUtil.indexOf(lArray, l, 0);
    }

    public static int indexOf(long[] lArray, long l, int n) {
        if (n >= 0) {
            int n2 = lArray == null ? 0 : lArray.length;
            for (int i = n; i < n2; ++i) {
                if (l != lArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(long[] lArray, long l) {
        return ArrayUtil.lastIndexOf(lArray, l, -1);
    }

    public static int lastIndexOf(long[] lArray, long l, int n) {
        int n2;
        int n3 = n2 = lArray == null ? 0 : lArray.length;
        if (n < n2) {
            if (n < 0) {
                n = n2 - 1;
            }
            for (int i = n; i >= 0; --i) {
                if (l != lArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static float[] add(float[] fArray, int n, float f) {
        int n2;
        int n3 = n2 = fArray == null ? 0 : fArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        float[] fArray2 = new float[n2 + 1];
        if (n > 0) {
            System.arraycopy(fArray, 0, fArray2, 0, n);
        }
        if (n < n2) {
            System.arraycopy(fArray, n, fArray2, n + 1, n2 - n);
        }
        fArray2[n] = f;
        return fArray2;
    }

    public static float[] add(float[] fArray, float f) {
        return ArrayUtil.add(fArray, -1, f);
    }

    public static float[] addAll(float[] fArray, int n, float[] fArray2) {
        int n2;
        int n3 = n2 = fArray == null ? 0 : fArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        if (fArray2 == null || fArray2.length == 0) {
            return fArray;
        }
        float[] fArray3 = new float[n2 + fArray2.length];
        if (n > 0) {
            System.arraycopy(fArray, 0, fArray3, 0, n);
        }
        if (n < n2) {
            System.arraycopy(fArray, n, fArray3, n + fArray2.length, n2 - n);
        }
        System.arraycopy(fArray2, 0, fArray3, n, fArray2.length);
        return fArray3;
    }

    public static float[] addAll(float[] fArray, float[] fArray2) {
        return ArrayUtil.addAll(fArray, -1, fArray2);
    }

    public static float[] removeRange(float[] fArray, int n, int n2) {
        int n3;
        int n4 = n3 = fArray == null ? 0 : fArray.length;
        if (n < 0) {
            n = n3 - 1;
        } else if (n > n3) {
            throw new IndexOutOfBoundsException("The fromIndex is " + n + " and should be smaller or equal than " + n3 + "!");
        }
        if (n2 < 0) {
            n2 = n3;
        } else if (n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException("The toIndex is " + n2 + " and should be between fromIndex + " + n + " and length " + n3 + "!");
        }
        if (n == n2) {
            return fArray;
        }
        int n5 = n2 - n;
        float[] fArray2 = new float[n3 - n5];
        if (n > 0) {
            System.arraycopy(fArray, 0, fArray2, 0, n);
        }
        if (n2 < n3) {
            System.arraycopy(fArray, n2, fArray2, n, n3 - n2);
        }
        return fArray2;
    }

    public static float[] remove(float[] fArray, int n) {
        return ArrayUtil.removeRange(fArray, n, n + 1);
    }

    public static float[] removeLast(float[] fArray) {
        return ArrayUtil.removeRange(fArray, -1, -1);
    }

    public static float[] truncate(float[] fArray, int n) {
        return ArrayUtil.removeRange(fArray, n, -1);
    }

    public static float[] clear(float[] fArray) {
        return ArrayUtil.removeRange(fArray, 0, -1);
    }

    public static boolean contains(float[] fArray, float f) {
        return ArrayUtil.indexOf(fArray, f, 0) >= 0;
    }

    public static int indexOf(float[] fArray, float f) {
        return ArrayUtil.indexOf(fArray, f, 0);
    }

    public static int indexOf(float[] fArray, float f, int n) {
        if (n >= 0) {
            int n2 = fArray == null ? 0 : fArray.length;
            for (int i = n; i < n2; ++i) {
                if (f != fArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(float[] fArray, float f) {
        return ArrayUtil.lastIndexOf(fArray, f, -1);
    }

    public static int lastIndexOf(float[] fArray, float f, int n) {
        int n2;
        int n3 = n2 = fArray == null ? 0 : fArray.length;
        if (n < n2) {
            if (n < 0) {
                n = n2 - 1;
            }
            for (int i = n; i >= 0; --i) {
                if (f != fArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static double[] add(double[] dArray, int n, double d) {
        int n2;
        int n3 = n2 = dArray == null ? 0 : dArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        double[] dArray2 = new double[n2 + 1];
        if (n > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, n);
        }
        if (n < n2) {
            System.arraycopy(dArray, n, dArray2, n + 1, n2 - n);
        }
        dArray2[n] = d;
        return dArray2;
    }

    public static double[] add(double[] dArray, double d) {
        return ArrayUtil.add(dArray, -1, d);
    }

    public static double[] addAll(double[] dArray, int n, double[] dArray2) {
        int n2;
        int n3 = n2 = dArray == null ? 0 : dArray.length;
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            throw new IndexOutOfBoundsException("The index is " + n + ", should be smaller or equal to length " + n2 + "!");
        }
        if (dArray2 == null || dArray2.length == 0) {
            return dArray;
        }
        double[] dArray3 = new double[n2 + dArray2.length];
        if (n > 0) {
            System.arraycopy(dArray, 0, dArray3, 0, n);
        }
        if (n < n2) {
            System.arraycopy(dArray, n, dArray3, n + dArray2.length, n2 - n);
        }
        System.arraycopy(dArray2, 0, dArray3, n, dArray2.length);
        return dArray3;
    }

    public static double[] addAll(double[] dArray, double[] dArray2) {
        return ArrayUtil.addAll(dArray, -1, dArray2);
    }

    public static double[] removeRange(double[] dArray, int n, int n2) {
        int n3;
        int n4 = n3 = dArray == null ? 0 : dArray.length;
        if (n < 0) {
            n = n3 - 1;
        } else if (n > n3) {
            throw new IndexOutOfBoundsException("The fromIndex is " + n + " and should be smaller or equal than " + n3 + "!");
        }
        if (n2 < 0) {
            n2 = n3;
        } else if (n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException("The toIndex is " + n2 + " and should be between fromIndex + " + n + " and length " + n3 + "!");
        }
        if (n == n2) {
            return dArray;
        }
        int n5 = n2 - n;
        double[] dArray2 = new double[n3 - n5];
        if (n > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, n);
        }
        if (n2 < n3) {
            System.arraycopy(dArray, n2, dArray2, n, n3 - n2);
        }
        return dArray2;
    }

    public static double[] remove(double[] dArray, int n) {
        return ArrayUtil.removeRange(dArray, n, n + 1);
    }

    public static double[] removeLast(double[] dArray) {
        return ArrayUtil.removeRange(dArray, -1, -1);
    }

    public static double[] truncate(double[] dArray, int n) {
        return ArrayUtil.removeRange(dArray, n, -1);
    }

    public static double[] clear(double[] dArray) {
        return ArrayUtil.removeRange(dArray, 0, -1);
    }

    public static boolean contains(double[] dArray, double d) {
        return ArrayUtil.indexOf(dArray, d, 0) >= 0;
    }

    public static int indexOf(double[] dArray, double d) {
        return ArrayUtil.indexOf(dArray, d, 0);
    }

    public static int indexOf(double[] dArray, double d, int n) {
        if (n >= 0) {
            int n2 = dArray == null ? 0 : dArray.length;
            for (int i = n; i < n2; ++i) {
                if (d != dArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(double[] dArray, double d) {
        return ArrayUtil.lastIndexOf(dArray, d, -1);
    }

    public static int lastIndexOf(double[] dArray, double d, int n) {
        int n2;
        int n3 = n2 = dArray == null ? 0 : dArray.length;
        if (n < n2) {
            if (n < 0) {
                n = n2 - 1;
            }
            for (int i = n; i >= 0; --i) {
                if (d != dArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean containsAll(T[] TArray, T[] TArray2) {
        if (TArray == null) {
            return false;
        }
        if (TArray2 == null) {
            return true;
        }
        for (T t : TArray2) {
            if (ArrayUtil.indexOf(TArray, t) >= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsOne(T[] TArray, T[] TArray2) {
        if (TArray2 == null) {
            return false;
        }
        for (T t : TArray2) {
            if (ArrayUtil.indexOf(TArray, t) < 0) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(E[] EArray) {
        if (EArray == null) {
            return true;
        }
        for (E e : EArray) {
            if (this.indexOf(e) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsOne(E[] EArray) {
        if (EArray == null) {
            return false;
        }
        for (E e : EArray) {
            if (this.indexOf(e) < 0) continue;
            return true;
        }
        return true;
    }

    public E[] toArray(int n, int n2) {
        if (this.size < n + n2) {
            throw new IllegalArgumentException("Source array has " + this.size + " element(s). Start index " + n + " and length " + n2 + " are not possible!");
        }
        Object[] objectArray = (Object[])Array.newInstance(this.array.getClass().getComponentType(), n2);
        System.arraycopy(this.array, this.offset + n, objectArray, 0, n2);
        return objectArray;
    }

    public E first() {
        return this.array[this.offset];
    }

    public E last() {
        return this.array[this.offset + this.size - 1];
    }
}

