/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl;

import com.sibvisions.rad.ui.awt.impl.AwtResource;
import com.sibvisions.util.type.ImageUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.rad.ui.IImage;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingImage
extends AwtResource<ImageIcon>
implements IImage {
    private String imageName;

    public SwingImage(ImageIcon imageIcon) {
        this(null, imageIcon);
    }

    public SwingImage(String string, ImageIcon imageIcon) {
        super(imageIcon);
        this.imageName = string;
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public int getWidth() {
        return ((ImageIcon)this.resource).getIconWidth();
    }

    @Override
    public int getHeight() {
        return ((ImageIcon)this.resource).getIconHeight();
    }

    @Override
    public void saveAs(OutputStream outputStream, IImage.ImageType imageType) throws IOException {
        ImageUtil.ImageFormat imageFormat;
        if (imageType == null) {
            imageFormat = ImageUtil.ImageFormat.PNG;
        } else {
            switch (imageType) {
                case JPG: {
                    imageFormat = ImageUtil.ImageFormat.JPG;
                    break;
                }
                case GIF: {
                    imageFormat = ImageUtil.ImageFormat.GIF;
                    break;
                }
                case BMP: {
                    imageFormat = ImageUtil.ImageFormat.BMP;
                    break;
                }
                default: {
                    imageFormat = ImageUtil.ImageFormat.PNG;
                }
            }
        }
        ImageUtil.save(((ImageIcon)this.resource).getImage(), imageFormat, outputStream);
    }
}

