/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.type.ExceptionUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.rad.application.IApplication;
import javax.rad.application.ILauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationUtil {
    private static boolean bIsMacOS;
    private static boolean bIsWindows;
    private static boolean bIsLinux;

    private ApplicationUtil() {
    }

    public static IApplication createApplication(ILauncher iLauncher, String string) throws Throwable {
        return (IApplication)Reflective.construct(string, iLauncher);
    }

    public static IApplication createApplication(ILauncher iLauncher, ClassLoader classLoader, String string) throws Throwable {
        return (IApplication)Reflective.construct(classLoader, string, iLauncher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlNode getConfig(ILauncher iLauncher, String string) throws Exception {
        InputStream inputStream = ResourceUtil.getResourceAsStream(string);
        if (inputStream != null) {
            XmlNode xmlNode;
            block7: {
                try {
                    XmlWorker xmlWorker = new XmlWorker();
                    xmlNode = xmlWorker.read(inputStream);
                    Object var6_5 = null;
                    if (inputStream == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return xmlNode;
        }
        return null;
    }

    public static String replaceParameter(String string, ILauncher iLauncher) {
        if (string != null) {
            int n = 0;
            int n2 = string.indexOf("[", n);
            while (n2 >= 0 && n != -1) {
                String string2;
                String string3;
                n = string.indexOf(93, n2);
                if (n > n2 && (string3 = iLauncher.getParameter(string2 = string.substring(n2 + 1, n))) != null) {
                    string = string.replace("[" + string2 + "]", string3);
                    n = n2 + string3.length();
                }
                n2 = string.indexOf("[", n);
            }
            return string;
        }
        return null;
    }

    public static void setRegistryKey(String string, String string2, String string3) {
        if (bIsMacOS) {
            try {
                XmlNode xmlNode;
                File file = ApplicationUtil.getRegistryFile();
                XmlWorker xmlWorker = new XmlWorker();
                if (file.exists()) {
                    xmlNode = xmlWorker.read(file);
                } else {
                    new File(FileUtil.getDirectory(file.getAbsolutePath())).mkdirs();
                    xmlNode = XmlNode.createXmlDeclaration();
                }
                String string4 = "/registry/" + string + "/" + string2;
                if (string3 == null) {
                    xmlNode.removeNode(string4);
                } else {
                    xmlNode.setNode(string4, string3);
                }
                xmlWorker.write(file, xmlNode);
            }
            catch (Exception exception) {
                throw new SecurityException(exception);
            }
        }
        Preferences preferences = Preferences.userRoot().node(string);
        try {
            if (string3 == null) {
                preferences.remove(string2);
            } else {
                preferences.put(string2, string3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return;
        }
        try {
            preferences.flush();
            preferences.sync();
        }
        catch (BackingStoreException backingStoreException) {
            throw new RuntimeException("Error saving registry key: " + string + " " + string2, backingStoreException);
        }
    }

    private static File getRegistryFile() {
        if (bIsMacOS) {
            return new File(System.getProperty("user.home"), "/Library/Preferences/com.sibvisions.rad.Registry.xml");
        }
        if (bIsLinux) {
            return new File(System.getProperty("user.home"), "/Java/registry.xml");
        }
        if (bIsWindows) {
            return new File(System.getenv("APPDATA"), "/.java/preferences/registry.xml");
        }
        return null;
    }

    public static String getRegistryKey(String string, String string2) {
        if (bIsMacOS) {
            try {
                File file = ApplicationUtil.getRegistryFile();
                if (file.exists()) {
                    XmlWorker xmlWorker = new XmlWorker();
                    XmlNode xmlNode = xmlWorker.read(file);
                    return xmlNode.getNodeValue("/registry/" + string + "/" + string2);
                }
                return null;
            }
            catch (Exception exception) {
                throw new SecurityException(exception);
            }
        }
        Preferences preferences = Preferences.userRoot();
        try {
            if (string != null && preferences.nodeExists(string)) {
                return preferences.node(string).get(string2, null);
            }
            return null;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    public static String getRegistryApplicationName(ILauncher iLauncher) {
        String string = iLauncher.getParameter("Launcher.codebase");
        if (string == null) {
            string = iLauncher.getParameter("Application.serverbase");
        }
        if (string != null) {
            if ((string = string.replace("://", "/").replace(":", "/")).endsWith("/")) {
                return string + iLauncher.getParameter("Application.name");
            }
            return string + "/" + iLauncher.getParameter("Application.name");
        }
        return iLauncher.getParameter("Application.name");
    }

    public static boolean configureFrameBounds(Frame frame) {
        try {
            String string = System.getProperty("framebounds");
            if (string != null) {
                try {
                    String[] stringArray = string.split(",");
                    frame.setBounds(Integer.parseInt(stringArray[0].trim()), Integer.parseInt(stringArray[1].trim()), Integer.parseInt(stringArray[2].trim()), Integer.parseInt(stringArray[3].trim()));
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Can't set frame bounds\n" + ExceptionUtil.dump(exception, true));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isMacOS() {
        return bIsMacOS;
    }

    public static boolean isLinux() {
        return bIsLinux;
    }

    public static boolean isWindows() {
        return bIsWindows;
    }

    public static HashMap<String, String> splitImageProperties(String string) {
        ArrayUtil<String> arrayUtil = StringUtil.separateList(string, ";", true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!arrayUtil.isEmpty()) {
            hashMap.put("name", (String)arrayUtil.get(0));
            int n = arrayUtil.size();
            for (int i = 1; i < n; ++i) {
                String[] stringArray;
                String string2;
                String string3 = (String)arrayUtil.get(i);
                if (StringUtil.isEmpty(string3) || "name".equals(string2 = (stringArray = string3.split("="))[0].toLowerCase())) continue;
                hashMap.put(string2, stringArray[1]);
            }
        }
        return hashMap;
    }

    static {
        try {
            String string = System.getProperty("os.name").toLowerCase();
            bIsMacOS = string.indexOf("mac") >= 0;
            bIsWindows = string.indexOf("windows") >= 0;
            bIsLinux = string.indexOf("linux") >= 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

