/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.persist.jdbc.DBCredentials;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import javax.rad.server.IConfiguration;

public final class DataSourceHandler {
    private DataSourceHandler() {
    }

    public static DBCredentials createDBCredentials(ApplicationZone applicationZone, String string) {
        return DataSourceHandler.createDBCredentials(applicationZone, string, null);
    }

    public static DBCredentials createDBCredentials(ApplicationZone applicationZone, String string, String string2) {
        if (applicationZone != null && string != null) {
            return DataSourceHandler.createDBCredentials(applicationZone.getConfig(), string, string2);
        }
        return null;
    }

    public static DBCredentials createDBCredentials(IConfiguration iConfiguration, String string) {
        return DataSourceHandler.createDBCredentials(iConfiguration, string, null);
    }

    public static DBCredentials createDBCredentials(IConfiguration iConfiguration, String string, String string2) {
        int n;
        XmlNode xmlNode;
        if (iConfiguration != null && string != null && (xmlNode = iConfiguration.getNode("/application/datasource")) != null && (n = xmlNode.indexOf("/db/name", string)) >= 0) {
            return DataSourceHandler.createDBCredentials(xmlNode.getNode("/db(" + n + ")"), string2);
        }
        return null;
    }

    public static DBCredentials createDBCredentials(XmlNode xmlNode) {
        return DataSourceHandler.createDBCredentials(xmlNode, null);
    }

    public static DBCredentials createDBCredentials(XmlNode xmlNode, String string) {
        if (xmlNode != null) {
            boolean bl;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            XmlNode xmlNode2 = null;
            boolean bl2 = bl = !StringUtil.isEmpty(string);
            if (bl) {
                xmlNode2 = xmlNode.getNode("/url_" + string);
            }
            if (xmlNode2 == null) {
                xmlNode2 = xmlNode.getNode("/url");
            }
            if (xmlNode2 != null) {
                if (bl) {
                    string2 = DataSourceHandler.getValue(xmlNode.getNode("/driver_" + string));
                    string3 = DataSourceHandler.getValue(xmlNode.getNode("/username_" + string));
                    string4 = DataSourceHandler.getValue(xmlNode.getNode("/password_" + string));
                }
                if (string2 == null) {
                    string2 = DataSourceHandler.getValue(xmlNode.getNode("/driver"));
                }
                if (string3 == null) {
                    string3 = DataSourceHandler.getValue(xmlNode.getNode("/username"));
                }
                if (string4 == null) {
                    string4 = DataSourceHandler.getValue(xmlNode.getNode("/password"));
                }
                return new DBCredentials(StringUtil.replacePlaceholder(string2), StringUtil.replacePlaceholder(DataSourceHandler.getValue(xmlNode2)), StringUtil.replacePlaceholder(string3), StringUtil.replacePlaceholder(string4));
            }
        }
        return null;
    }

    private static String getValue(XmlNode xmlNode) {
        if (xmlNode != null) {
            return CommonUtil.nvl(xmlNode.getValue(), "");
        }
        return null;
    }
}

