/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.util.log.LoggerFactory;
import javax.rad.remote.event.CallBackEvent;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.server.ResultObject;

final class Call {
    private ICallBackListener listener;
    private Object oCallBackId;
    private String sObjectName;
    private String sMethodName;
    private Object[] oParams;
    private long lCreation = System.currentTimeMillis();
    private boolean bForceCallBack = false;

    Call(ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) {
        this.listener = iCallBackListener;
        this.sObjectName = string;
        this.sMethodName = string2;
        this.oParams = objectArray;
    }

    Call(Object object, String string, String string2, Object ... objectArray) {
        this.oCallBackId = object;
        this.sObjectName = string;
        this.sMethodName = string2;
        this.oParams = objectArray;
    }

    public String getObjectName() {
        return this.sObjectName;
    }

    public String getMethodName() {
        return this.sMethodName;
    }

    public Object[] getParameters() {
        return this.oParams;
    }

    public boolean isCallBack() {
        return this.listener != null || this.oCallBackId != null || this.bForceCallBack;
    }

    public String formatMethod() {
        if (this.sObjectName == null) {
            return this.sMethodName;
        }
        return this.sObjectName + "." + this.sMethodName;
    }

    void success(AbstractSession abstractSession, Object object) {
        this.sendResult(abstractSession, (byte)1, object);
    }

    void error(AbstractSession abstractSession, Throwable throwable) {
        this.sendResult(abstractSession, (byte)2, throwable);
    }

    private void sendResult(AbstractSession abstractSession, byte by, Object object) {
        if (this.oCallBackId != null) {
            abstractSession.addCallBackResult(new ResultObject(by, object, this.oCallBackId));
        } else if (this.listener != null) {
            try {
                this.listener.callBack(new CallBackEvent(abstractSession.getSessionManager().getServer(), this.sObjectName, this.sMethodName, 1 == by ? object : null, (Throwable)(2 == by ? object : null), this.lCreation, System.currentTimeMillis()));
            }
            catch (Throwable throwable) {
                LoggerFactory.getInstance(Call.class).error(throwable);
            }
        } else if (!this.bForceCallBack) {
            throw new RuntimeException("Callback not possible without callback id or callback listener!");
        }
    }

    void setForceCallBack(boolean bl) {
        this.bForceCallBack = bl;
    }

    boolean isForceCallBack() {
        return this.bForceCallBack;
    }
}

