/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.remote;

import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.rad.model.mem.MemDataPage;
import com.sibvisions.rad.model.remote.RemoteDataPage;
import com.sibvisions.rad.model.remote.RemoteDataSource;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.celleditor.UILinkedCellEditor;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.IDataSource;
import javax.rad.model.MetaDataCacheOption;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.reference.StorageReferenceDefinition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.MetaData;
import javax.rad.remote.AbstractConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDataBook
extends MemDataBook {
    private static ILogger logger = LoggerFactory.getInstance(RemoteDataBook.class);
    private static Hashtable<String, Boolean> htCachingStorage = new Hashtable();
    private String[] saMetaDataColumnNames;
    private String[] saBlockFetchColumnNames;
    private String[] saBlockFetchReferencedColumnNames;
    private Hashtable<Object, Integer> htFetchedRowsForBlock = null;
    private MetaData mdMetaData;
    private int[] iaFetchColumnIndexes;
    private int[] iaMasterColumnIndexes;
    private boolean bCachingStorage = true;
    private boolean bMetaDataCacheEnabled = true;

    public RemoteDataBook() {
        this.setMemSort(false);
        this.setMemFilter(false);
        this.setDeleteCascade(false);
        this.setWritebackEnabled(true);
    }

    @Override
    protected boolean isDataPageRefetchPossible() {
        return this.saBlockFetchColumnNames == null;
    }

    @Override
    protected MemDataPage createDataPage(IDataRow iDataRow) {
        return new RemoteDataPage(this, iDataRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataSource(IDataSource iDataSource) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!(iDataSource instanceof RemoteDataSource)) {
                throw new ModelException("It's not an RemoteDataSource! -> it have to be one!");
            }
            super.setDataSource(iDataSource);
        }
    }

    @Override
    public RemoteDataSource getDataSource() {
        return (RemoteDataSource)super.getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.isOpen()) {
                int n;
                Object object;
                Object[] objectArray;
                block35: {
                    if (this.getConnection() == null) {
                        throw new ModelException("The remote connection to the server IStorage is null!");
                    }
                    if (this.getName() == null) {
                        throw new ModelException("DataBook Name is null!");
                    }
                    try {
                        this.initServerMetaData();
                    }
                    catch (DataSourceException dataSourceException) {
                        if (this.rdRowDefinition != null && this.rdRowDefinition.getColumnCount() != 0) break block35;
                        throw new ModelException("RowDefintion can't init with meta data from storage!", dataSourceException);
                    }
                }
                if (this.mdMetaData != null) {
                    int n2;
                    if (!this.mdMetaData.isSupported(MetaData.Feature.Filter)) {
                        this.setMemFilter(true);
                    }
                    if (!this.mdMetaData.isSupported(MetaData.Feature.Sort)) {
                        this.setMemSort(true);
                    }
                    if (!this.mdMetaData.isSupported(MetaData.Feature.WriteBack)) {
                        this.setWritebackEnabled(false);
                    }
                    objectArray = this.mdMetaData.getColumnMetaData();
                    this.saMetaDataColumnNames = new String[objectArray.length];
                    if (this.rdRowDefinition == null) {
                        this.rdRowDefinition = new RowDefinition();
                    }
                    object = new HashMap();
                    n = RemoteDataSource.getMetaDataCacheRole() != RemoteDataSource.MetaDataCacheRole.Off && this.getDataSource().getMetaDataCacheOption() != MetaDataCacheOption.Off ? 1 : 0;
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        if (this.rdRowDefinition.getColumnDefinitionIndex(((ColumnMetaData)objectArray[n2]).getName()) < 0) {
                            StorageReferenceDefinition storageReferenceDefinition;
                            ColumnDefinition columnDefinition = ((ColumnMetaData)objectArray[n2]).createColumnDefinition();
                            columnDefinition.setWritable(true);
                            columnDefinition.setFilterable(!((ColumnMetaData)objectArray[n2]).isCalculated());
                            this.rdRowDefinition.addColumnDefinition(columnDefinition);
                            if (UIFactoryManager.getFactory() != null && (storageReferenceDefinition = ((ColumnMetaData)objectArray[n2]).getLinkReference()) != null && !(columnDefinition.getDataType() instanceof BinaryDataType)) {
                                Object object2;
                                RemoteDataBook remoteDataBook = this.getDataBookForLinkedCellEditor(storageReferenceDefinition, (HashMap<String, RemoteDataBook>)object, n != 0);
                                ColumnView columnView = new ColumnView(new String[0]);
                                int n3 = storageReferenceDefinition.getReferencedColumnNames().length;
                                for (int i = 0; i < n3; ++i) {
                                    object2 = storageReferenceDefinition.getReferencedColumnNames()[i];
                                    if (columnView.getColumnNameIndex((String)object2) >= 0 || RowDefinition.isColumnIgnored((String)object2) || remoteDataBook.getRowDefinition().getColumnDefinition((String)object2).getDataType().getTypeIdentifier() == -2) continue;
                                    columnView.addColumnNames(new String[]{object2});
                                }
                                if (columnView.getColumnCount() == 0) {
                                    String[] stringArray = remoteDataBook.mdMetaData.getRepresentationColumnNames();
                                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                                        object2 = stringArray[n3];
                                        if (columnView.getColumnNameIndex((String)object2) >= 0 || RowDefinition.isColumnIgnored((String)object2) || remoteDataBook.getRowDefinition().getColumnDefinition((String)object2).getDataType().getTypeIdentifier() == -2) continue;
                                        columnView.addColumnNames(stringArray[n3]);
                                    }
                                }
                                ReferenceDefinition referenceDefinition = new ReferenceDefinition();
                                referenceDefinition.setReferencedDataBook(remoteDataBook);
                                referenceDefinition.setReferencedColumnNames(storageReferenceDefinition.getReferencedColumnNames());
                                referenceDefinition.setColumnNames(storageReferenceDefinition.getColumnNames());
                                UILinkedCellEditor uILinkedCellEditor = new UILinkedCellEditor();
                                uILinkedCellEditor.setLinkReference(referenceDefinition);
                                uILinkedCellEditor.setColumnView(columnView);
                                uILinkedCellEditor.setValidationEnabled(!(columnDefinition.getDataType() instanceof StringDataType) || ArrayUtil.contains(remoteDataBook.getRowDefinition().getPrimaryKeyColumnNames(), referenceDefinition.getReferencedColumnName(columnDefinition.getName())) || !((ColumnMetaData)objectArray[n2]).isWritable());
                                object2 = new ArrayUtil();
                                ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
                                String[] stringArray = referenceDefinition.getColumnNames();
                                int n4 = objectArray.length;
                                for (int i = 0; i < n4; ++i) {
                                    String[] stringArray2;
                                    StorageReferenceDefinition storageReferenceDefinition2 = ((ColumnMetaData)objectArray[i]).getLinkReference();
                                    if (storageReferenceDefinition2 == null || (stringArray2 = storageReferenceDefinition2.getColumnNames()).length >= stringArray.length || !ArrayUtil.containsAll(stringArray, stringArray2)) continue;
                                    for (int j = 0; j < stringArray2.length; ++j) {
                                        if (((ArrayUtil)object2).contains(stringArray2[j])) continue;
                                        ((ArrayUtil)object2).add(stringArray2[j]);
                                        arrayUtil.add(referenceDefinition.getReferencedColumnName(stringArray2[j]));
                                    }
                                }
                                if (((ArrayUtil)object2).size() > 0) {
                                    uILinkedCellEditor.setSearchColumnMapping(new ColumnMapping(((ArrayUtil)object2).toArray(new String[((ArrayUtil)object2).size()]), arrayUtil.toArray(new String[arrayUtil.size()])));
                                }
                                if (columnDefinition.getDataType() instanceof BigDecimalDataType) {
                                    uILinkedCellEditor.setHorizontalAlignment(2);
                                }
                                columnDefinition.getDataType().setDefaultCellEditor(uILinkedCellEditor);
                            }
                        } else {
                            this.rdRowDefinition.getColumnDefinition(((ColumnMetaData)objectArray[n2]).getName()).setWritable(true);
                            this.rdRowDefinition.getColumnDefinition(((ColumnMetaData)objectArray[n2]).getName()).setFilterable(!((ColumnMetaData)objectArray[n2]).isCalculated());
                        }
                        this.saMetaDataColumnNames[n2] = ((ColumnMetaData)objectArray[n2]).getName();
                    }
                    this.iaFetchColumnIndexes = new int[objectArray.length];
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        this.iaFetchColumnIndexes[n2] = this.rdRowDefinition.getColumnDefinitionIndex(((ColumnMetaData)objectArray[n2]).getName());
                    }
                    if (this.rdRowDefinition.getPrimaryKeyColumnNames() == null) {
                        String[] stringArray = this.mdMetaData.getPrimaryKeyColumnNames();
                        if (stringArray == null) {
                            this.setWritebackEnabled(false);
                        } else {
                            this.rdRowDefinition.setPrimaryKeyColumnNames(stringArray);
                        }
                    }
                }
                if (this.saBlockFetchColumnNames == null) {
                    this.iaMasterColumnIndexes = null;
                    this.saBlockFetchReferencedColumnNames = null;
                } else {
                    if (this.getMasterReference() == null) {
                        throw new ModelException("Block fetch is only allowed if a master reference is set!");
                    }
                    if (ArrayUtil.containsAll(this.getMasterReference().getColumnNames(), this.saBlockFetchColumnNames)) {
                        objectArray = this.getMasterReference().getColumnNames();
                        object = this.getMasterReference().getReferencedColumnNames();
                        this.iaMasterColumnIndexes = new int[objectArray.length];
                        for (n = 0; n < this.iaMasterColumnIndexes.length; n += 1) {
                            this.iaMasterColumnIndexes[n] = this.rdRowDefinition.getColumnDefinitionIndex((String)objectArray[n]);
                        }
                        this.saBlockFetchReferencedColumnNames = new String[this.saBlockFetchColumnNames.length];
                        for (n = 0; n < this.saBlockFetchColumnNames.length; n += 1) {
                            this.saBlockFetchReferencedColumnNames[n] = object[ArrayUtil.indexOf(objectArray, this.saBlockFetchColumnNames[n])];
                        }
                    } else {
                        throw new ModelException("Block fetch have to be a subset of the master reference columns!");
                    }
                }
                super.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.isOpen()) {
                super.close();
                this.htFetchedRowsForBlock = null;
            }
        }
    }

    @Override
    protected IDataRow executeLockAndRefetch(IChangeableDataRow iChangeableDataRow) throws ModelException {
        try {
            Object[] objectArray;
            long l = System.currentTimeMillis();
            String[] stringArray = this.mdMetaData.getPrimaryKeyColumnNames();
            if (stringArray == null) {
                objectArray = iChangeableDataRow.getValues(this.saMetaDataColumnNames);
            } else {
                objectArray = new Object[this.mdMetaData.getColumnMetaDataCount()];
                for (String string : stringArray) {
                    objectArray[this.mdMetaData.getColumnMetaDataIndex((String)string)] = iChangeableDataRow.getValue(string);
                }
            }
            Object[] objectArray2 = (Object[])this.getConnection().call(this.getName(), "refetchRow", objectArray);
            if (logger.isEnabled(ILogger.LogLevel.DEBUG)) {
                logger.debug("acConnection.refetchRow(", this.getName(), ",", objectArray, ") in ", System.currentTimeMillis() - l, "ms");
            }
            if (objectArray2 != null) {
                IDataRow iDataRow = iChangeableDataRow.createDataRow(null);
                iDataRow.setValues(this.saMetaDataColumnNames, objectArray2);
                return iDataRow;
            }
            return null;
        }
        catch (Throwable throwable) {
            throw new ModelException("Execute Lock and Refetch failed!", throwable);
        }
    }

    @Override
    protected IDataRow executeInsert(IChangeableDataRow iChangeableDataRow) throws ModelException {
        try {
            long l = System.currentTimeMillis();
            Object[] objectArray = (Object[])this.getConnection().call(this.getName(), "insert", iChangeableDataRow.getValues(this.saMetaDataColumnNames));
            if (logger.isEnabled(ILogger.LogLevel.DEBUG)) {
                logger.debug("acConnection.insert(", this.getName(), ",", iChangeableDataRow.getValues(this.saMetaDataColumnNames), ") in ", System.currentTimeMillis() - l, "ms");
            }
            if (objectArray != null) {
                IDataRow iDataRow = iChangeableDataRow.createDataRow(null);
                iDataRow.setValues(this.saMetaDataColumnNames, objectArray);
                return iDataRow;
            }
            return null;
        }
        catch (Throwable throwable) {
            throw new ModelException("Execute Insert failed!", throwable);
        }
    }

    @Override
    protected IDataRow executeUpdate(IChangeableDataRow iChangeableDataRow) throws ModelException {
        try {
            long l = System.currentTimeMillis();
            Object[] objectArray = (Object[])this.getConnection().call(this.getName(), "update", iChangeableDataRow.getOriginalDataRow().getValues(this.saMetaDataColumnNames), iChangeableDataRow.getValues(this.saMetaDataColumnNames));
            if (logger.isEnabled(ILogger.LogLevel.DEBUG)) {
                logger.debug("acConnection.update(", this.getName(), ",", iChangeableDataRow.getOriginalDataRow().getValues(this.saMetaDataColumnNames), ",", iChangeableDataRow.getValues(this.saMetaDataColumnNames), ") in ", System.currentTimeMillis() - l, "ms");
            }
            if (objectArray != null) {
                IDataRow iDataRow = iChangeableDataRow.createDataRow(null);
                iDataRow.setValues(this.saMetaDataColumnNames, objectArray);
                return iDataRow;
            }
            return null;
        }
        catch (Throwable throwable) {
            throw new ModelException("Execute Update failed!", throwable);
        }
    }

    @Override
    protected void executeDelete(IChangeableDataRow iChangeableDataRow) throws ModelException {
        try {
            long l = System.currentTimeMillis();
            this.getConnection().call(this.getName(), "delete", iChangeableDataRow.getOriginalDataRow().getValues(this.saMetaDataColumnNames));
            if (logger.isEnabled(ILogger.LogLevel.DEBUG)) {
                logger.debug("acConnection.delete(", this.getName(), ",", iChangeableDataRow.getOriginalDataRow().getValues(this.saMetaDataColumnNames), ") in ", System.currentTimeMillis() - l, "ms");
            }
        }
        catch (Throwable throwable) {
            throw new ModelException("Execute Delete failed!", throwable);
        }
    }

    @Override
    protected void executeRefresh() throws ModelException {
        super.clear();
        this.htFetchedRowsForBlock = null;
    }

    @Override
    protected void executeRefreshDataPage() throws ModelException {
        this.clearCurrentDataPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMemSort(boolean bl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.Sort)) {
                return;
            }
            super.setMemSort(bl);
        }
    }

    @Override
    public boolean isMemSort() {
        return super.isMemSort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMemFilter(boolean bl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.Filter)) {
                return;
            }
            super.setMemFilter(bl);
        }
    }

    @Override
    public boolean isMemFilter() {
        return super.isMemFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWritebackEnabled(boolean bl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.isOpen() && !this.mdMetaData.isSupported(MetaData.Feature.WriteBack)) {
                return;
            }
            super.setWritebackEnabled(bl);
        }
    }

    @Override
    public boolean isWritebackEnabled() {
        return super.isWritebackEnabled();
    }

    private RemoteDataBook getDataBookForLinkedCellEditor(StorageReferenceDefinition storageReferenceDefinition, HashMap<String, RemoteDataBook> hashMap, boolean bl) throws ModelException {
        String string = storageReferenceDefinition.getReferencedStorage();
        String string2 = string.startsWith(".") ? this.getName() + string : string;
        IDataBook[] iDataBookArray = this.getDataSource().getDataBooks();
        RemoteDataBook remoteDataBook = hashMap.get(string);
        if (remoteDataBook == null) {
            if (bl) {
                for (int i = 0; remoteDataBook == null && i < iDataBookArray.length; ++i) {
                    IDataBook iDataBook = iDataBookArray[i];
                    if (!(iDataBook instanceof RemoteDataBook) || !iDataBook.getName().equals(string2)) continue;
                    remoteDataBook = (RemoteDataBook)iDataBook;
                }
            }
            if (remoteDataBook == null) {
                remoteDataBook = new RemoteDataBook();
                remoteDataBook.setDataSource(this.getDataSource());
                remoteDataBook.setName(string2);
                remoteDataBook.setSelectionMode(IDataBook.SelectionMode.DESELECTED);
                remoteDataBook.open();
            }
            hashMap.put(string, remoteDataBook);
        }
        return remoteDataBook;
    }

    public String[] getBlockFetchColumnNames() {
        return this.saBlockFetchColumnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockFetchColumnNames(String[] stringArray) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.isOpen()) {
                throw new ModelException("It's not allowed on open DataBooks!");
            }
            this.saBlockFetchColumnNames = stringArray;
        }
    }

    public void setMetaDataCacheEnabled(boolean bl) {
        this.bMetaDataCacheEnabled = bl;
    }

    public boolean isMetaDataCacheEnabled() {
        return this.bMetaDataCacheEnabled;
    }

    private void initServerMetaData() throws DataSourceException {
        block10: {
            try {
                RemoteDataSource remoteDataSource = this.getDataSource();
                String string = remoteDataSource.getConnection().getLifeCycleName();
                String string2 = this.getName();
                String string3 = string + "." + string2;
                this.mdMetaData = this.bMetaDataCacheEnabled ? remoteDataSource.getMetaData(string3) : null;
                if (this.mdMetaData == null) {
                    Boolean bl = htCachingStorage.get(string3);
                    this.bCachingStorage = bl != null ? bl : true;
                    long l = System.currentTimeMillis();
                    if (this.bCachingStorage) {
                        try {
                            Hashtable hashtable;
                            Object[] objectArray = this.getConnection().call(new String[]{string2, string2}, new String[]{"getMetaData", "getMetaDataFromCache"}, new Object[][]{{string, string2}, {string}});
                            this.mdMetaData = (MetaData)objectArray[0];
                            if (this.bMetaDataCacheEnabled && (hashtable = (Hashtable)objectArray[1]) != null) {
                                for (Map.Entry entry : hashtable.entrySet()) {
                                    remoteDataSource.putMetaData((String)entry.getKey(), (MetaData)entry.getValue());
                                }
                            }
                            logger.debug("getMetaDataFromCache(", string, ", ", string2, ") in ", System.currentTimeMillis() - l, "ms");
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            this.bCachingStorage = false;
                        }
                    }
                    if (!this.bCachingStorage) {
                        this.mdMetaData = (MetaData)this.getConnection().call(string2, "getMetaData");
                        if (this.bMetaDataCacheEnabled) {
                            remoteDataSource.putMetaData(string3, this.mdMetaData);
                        }
                        logger.debug("getMetaData(", string2, ") in ", System.currentTimeMillis() - l, "ms");
                    }
                    htCachingStorage.put(string3, this.bCachingStorage);
                    break block10;
                }
                logger.debug("use cached metadata: ", string2);
            }
            catch (Throwable throwable) {
                throw new DataSourceException("Init ServerMetaData failed!", throwable);
            }
        }
    }

    protected String[] getMetaDataColumnNames() {
        return this.saMetaDataColumnNames;
    }

    protected int[] getFetchColumnIndexes() {
        return this.iaFetchColumnIndexes;
    }

    protected int[] getMasterColumnIndexesForBlock() {
        return this.iaMasterColumnIndexes;
    }

    protected int getFetchedRowsForBlock(IDataRow iDataRow) throws ModelException {
        if (this.htFetchedRowsForBlock == null) {
            return 0;
        }
        Integer n = this.htFetchedRowsForBlock.get(iDataRow.createDataRow(this.saBlockFetchReferencedColumnNames));
        if (n == null) {
            return 0;
        }
        return n;
    }

    protected void setFetchedRowsForBlock(IDataRow iDataRow, int n) throws ModelException {
        if (this.htFetchedRowsForBlock == null) {
            this.htFetchedRowsForBlock = new Hashtable();
        }
        this.htFetchedRowsForBlock.put(iDataRow.createDataRow(this.saBlockFetchReferencedColumnNames), n);
    }

    protected AbstractConnection getConnection() {
        RemoteDataSource remoteDataSource = this.getDataSource();
        if (remoteDataSource == null) {
            return null;
        }
        return remoteDataSource.getConnection();
    }

    protected boolean isCachingStorage() {
        return this.bCachingStorage;
    }
}

