/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.rad.model.mem.ChangeableDataRow;
import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.ExceptionUtil;
import com.sibvisions.util.type.StringUtil;
import java.util.Arrays;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.DataType;
import javax.rad.model.datatype.IDataType;

public class MemDataPage
implements IDataPage {
    private static final int INIT_STORAGE_SIZE = 16;
    static final int[] EMPTY_INT_ARRAY = new int[0];
    private MemDataBook dbDataBook;
    protected IDataBook rootDataBook;
    protected IRowDefinition rdRowDefinition;
    protected IDataRow drMasterDataRow;
    private ArrayUtil<Object[]> alStorage;
    private int[] iaChangedRows = null;
    private int iChangedRowCount = 0;
    private boolean bAllFetched = true;
    private int[] iaUsedRows = null;
    private int iUsedRowCount = 0;

    public MemDataPage(MemDataBook memDataBook, IDataRow iDataRow) {
        this.dbDataBook = memDataBook;
        this.rdRowDefinition = memDataBook.getRowDefinition();
        this.rootDataBook = this.dbDataBook.getRootDataBook();
        this.drMasterDataRow = iDataRow;
        this.alStorage = new ArrayUtil(16);
    }

    public IDataBook getDataBook() {
        return this.dbDataBook;
    }

    public IDataRow getMasterDataRow() {
        return this.drMasterDataRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChangeableDataRow getDataRow(int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.initFilterSort();
            if (!this.bAllFetched && n >= this.alStorage.size()) {
                this.fetchToRow(n);
            }
            if (n >= 0 && n < this.getRowCountInternal()) {
                return new ChangeableDataRow(this.rdRowDefinition, (Object[])this.alStorage.get(this.getInternalRowIndex(n)).clone(), this, n);
            }
            return null;
        }
    }

    public void fetchAll() throws ModelException {
        if (!this.bAllFetched) {
            this.fetchToRow(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllFetched() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.drMasterDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)this.drMasterDataRow).getUID() != null) {
                return true;
            }
            return this.bAllFetched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.initFilterSort();
            return this.getRowCountInternal();
        }
    }

    @Deprecated
    public int[] getChangedDataRows() {
        return this.getChangedRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getChangedRows() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.iChangedRowCount == 0) {
                return EMPTY_INT_ARRAY;
            }
            if (this.iaUsedRows == null) {
                int[] nArray = new int[this.iChangedRowCount];
                System.arraycopy(this.iaChangedRows, 0, nArray, 0, this.iChangedRowCount);
                return nArray;
            }
            int[] nArray = new int[Math.min(this.iChangedRowCount, this.iUsedRowCount)];
            int n = 0;
            for (int i = 0; i < this.iUsedRowCount && n < this.iChangedRowCount; ++i) {
                if (Arrays.binarySearch(this.iaChangedRows, 0, this.iChangedRowCount, this.iaUsedRows[i]) < 0) continue;
                nArray[n] = i;
                ++n;
            }
            return ArrayUtil.truncate(nArray, n);
        }
    }

    public int searchNext(ICondition iCondition) throws ModelException {
        return this.searchNext(iCondition, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int searchNext(ICondition iCondition, int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (iCondition != null && n >= 0) {
                this.initFilterSort();
                if (!this.bAllFetched && n >= this.alStorage.size()) {
                    this.fetchToRow(n);
                }
                int n2 = this.getRowCountInternal();
                while (n < n2) {
                    this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(this.getInternalRowIndex(n));
                    if (iCondition.isFulfilled(this.dbDataBook.rowInstance1)) {
                        return n;
                    }
                    if (this.bAllFetched || ++n < this.alStorage.size()) continue;
                    this.fetchToRow(n);
                    n2 = this.getRowCountInternal();
                }
            }
            return -1;
        }
    }

    public int searchPrevious(ICondition iCondition) throws ModelException {
        return this.searchPrevious(iCondition, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int searchPrevious(ICondition iCondition, int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (iCondition != null && n != 0) {
                this.initFilterSort();
                if (!this.bAllFetched) {
                    if (n >= this.alStorage.size()) {
                        this.fetchToRow(n);
                    } else if (n < 0) {
                        this.fetchAll();
                    }
                }
                int n2 = this.getRowCountInternal();
                n = n < 0 || n > n2 ? n2 - 1 : --n;
                while (n >= 0) {
                    this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(this.getInternalRowIndex(n));
                    if (iCondition.isFulfilled(this.dbDataBook.rowInstance1)) {
                        return n;
                    }
                    --n;
                }
            }
            return -1;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public boolean hasChanges() {
        return this.iChangedRowCount > 0;
    }

    protected void setAllFetched(boolean bl) {
        this.bAllFetched = bl;
        this.clear();
    }

    protected void addFetchedRow(Object[] objectArray) throws ModelException {
        this.alStorage.add(objectArray);
    }

    void insert(int n, ChangeableDataRow changeableDataRow) throws ModelException {
        if (n > this.getRowCount()) {
            throw new ModelException("DataRow index out of bounds");
        }
        if (this.iaUsedRows == null) {
            this.alStorage.add(n, changeableDataRow.oaStorage);
            this.addChange(n, true);
            if (!(changeableDataRow.isDeleting() || changeableDataRow.isInserting() || changeableDataRow.isUpdating() || changeableDataRow.isDetailChanged())) {
                this.removeChange(n, false);
            }
        } else {
            int n2 = this.alStorage.size();
            this.alStorage.add(n2, changeableDataRow.oaStorage);
            if (this.iUsedRowCount == this.iaUsedRows.length) {
                int[] nArray = new int[Math.max(16, this.iUsedRowCount * 2)];
                System.arraycopy(this.iaUsedRows, 0, nArray, 0, n);
                if (n < this.iUsedRowCount) {
                    System.arraycopy(this.iaUsedRows, n, nArray, n + 1, this.iUsedRowCount - n);
                }
                this.iaUsedRows = nArray;
            } else if (n < this.iUsedRowCount) {
                System.arraycopy(this.iaUsedRows, n, this.iaUsedRows, n + 1, this.iUsedRowCount - n);
            }
            this.iaUsedRows[n] = n2;
            ++this.iUsedRowCount;
            this.addChange(n2, true);
            if (!(changeableDataRow.isDeleting() || changeableDataRow.isInserting() || changeableDataRow.isUpdating() || changeableDataRow.isDetailChanged())) {
                this.removeChange(n2, false);
            }
        }
    }

    void delete(int n) throws ModelException {
        if (n >= this.getRowCount()) {
            throw new ModelException("Row index out of bounds");
        }
        int n2 = this.getInternalRowIndex(n);
        this.alStorage.remove(n2);
        if (this.iaUsedRows != null) {
            --this.iUsedRowCount;
            if (n < this.iUsedRowCount) {
                System.arraycopy(this.iaUsedRows, n + 1, this.iaUsedRows, n, this.iUsedRowCount - n);
            }
            this.shiftIndicies(n2, -1);
        }
        this.removeChange(n2, true);
    }

    protected Object[] getDataRowStorage(int n) throws ModelException {
        this.initFilterSort();
        if (!this.bAllFetched && n >= this.alStorage.size()) {
            this.fetchToRow(n);
        }
        if (n >= 0 && n < this.getRowCountInternal()) {
            return this.alStorage.get(this.getInternalRowIndex(n));
        }
        return null;
    }

    protected void setMasterDataRow(IDataRow iDataRow) throws ModelException {
        int n;
        this.drMasterDataRow = iDataRow;
        String[] stringArray = this.dbDataBook.getMasterReference().getColumnNames();
        int[] nArray = new int[stringArray.length];
        IDataType[] iDataTypeArray = new IDataType[stringArray.length];
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            nArray[n] = n2 = this.rdRowDefinition.getColumnDefinitionIndex(stringArray[n]);
            iDataTypeArray[n] = this.rdRowDefinition.getColumnDefinition(n2).getDataType();
        }
        for (n = 0; n < this.alStorage.size(); ++n) {
            Object[] objectArray = this.alStorage.get(n);
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[nArray[i]] = iDataTypeArray[i].convertAndCheckToTypeClass(this.drMasterDataRow.getValue(i));
            }
        }
    }

    public int getEstimatedRowCount() throws ModelException {
        return this.getRowCount();
    }

    public void fetchToRow(int n) throws ModelException {
    }

    protected int getRowCountInternal() {
        if (this.iaUsedRows == null) {
            return this.alStorage.size();
        }
        return this.iUsedRowCount;
    }

    private int getInternalRowIndex(int n) {
        if (this.iaUsedRows == null) {
            return n;
        }
        if (n >= this.iUsedRowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.iaUsedRows[n];
    }

    protected void setDataRow(int n, ChangeableDataRow changeableDataRow) throws ModelException {
        int n2 = this.getInternalRowIndex(n);
        this.alStorage.set(n2, changeableDataRow.oaStorage);
        if (changeableDataRow.isDeleting() || changeableDataRow.isInserting() || changeableDataRow.isUpdating() || changeableDataRow.isDetailChanged()) {
            this.addChange(n2, false);
        } else {
            this.removeChange(n2, false);
        }
    }

    private void shiftIndicies(int n, int n2) {
        for (int i = 0; i < this.iUsedRowCount; ++i) {
            int n3 = this.iaUsedRows[i];
            if (n3 < n) continue;
            this.iaUsedRows[i] = n3 += n2;
        }
    }

    private void addChange(int n, boolean bl) {
        if (this.iaChangedRows == null) {
            this.iaChangedRows = new int[16];
        }
        int n2 = Arrays.binarySearch(this.iaChangedRows, 0, this.iChangedRowCount, n);
        if (bl) {
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            int n3 = n2;
            while (n3 < this.iChangedRowCount) {
                int n4 = n3++;
                this.iaChangedRows[n4] = this.iaChangedRows[n4] + 1;
            }
        } else {
            n2 = -n2 - 1;
        }
        if (n2 >= 0) {
            if (this.iChangedRowCount == this.iaChangedRows.length) {
                int[] nArray = new int[this.iChangedRowCount * 2];
                System.arraycopy(this.iaChangedRows, 0, nArray, 0, n2);
                if (n2 < this.iChangedRowCount) {
                    System.arraycopy(this.iaChangedRows, n2, nArray, n2 + 1, this.iChangedRowCount - n2);
                }
                this.iaChangedRows = nArray;
            } else if (n2 < this.iChangedRowCount) {
                System.arraycopy(this.iaChangedRows, n2, this.iaChangedRows, n2 + 1, this.iChangedRowCount - n2);
            }
            this.iaChangedRows[n2] = n;
            ++this.iChangedRowCount;
        }
    }

    private void removeChange(int n, boolean bl) throws ModelException {
        int n2 = Arrays.binarySearch(this.iaChangedRows, 0, this.iChangedRowCount, n);
        if (n2 >= 0) {
            --this.iChangedRowCount;
            if (this.iChangedRowCount > 16 && this.iChangedRowCount == this.iaChangedRows.length / 2) {
                int[] nArray = new int[this.iChangedRowCount];
                System.arraycopy(this.iaChangedRows, 0, nArray, 0, n2);
                if (n2 < this.iChangedRowCount) {
                    System.arraycopy(this.iaChangedRows, n2 + 1, nArray, n2, this.iChangedRowCount - n2);
                }
                this.iaChangedRows = nArray;
            } else if (n2 < this.iChangedRowCount) {
                System.arraycopy(this.iaChangedRows, n2 + 1, this.iaChangedRows, n2, this.iChangedRowCount - n2);
            }
        } else {
            n2 = -n2 - 1;
        }
        if (bl) {
            int n3 = n2;
            while (n3 < this.iChangedRowCount) {
                int n4 = n3++;
                this.iaChangedRows[n4] = this.iaChangedRows[n4] - 1;
            }
        }
    }

    private void initFilterSort() throws ModelException {
        if (this.iaUsedRows == null && this.dbDataBook != null) {
            if (this.dbDataBook.bMemFilter) {
                this.filter();
            }
            if (this.dbDataBook.bMemSort) {
                this.sort();
            }
        }
    }

    protected void clear() {
        this.iaUsedRows = null;
    }

    private void filter() throws ModelException {
        ICondition iCondition = this.dbDataBook.getFilter();
        if (iCondition != null) {
            this.fetchAll();
            int n = this.getRowCountInternal();
            int[] nArray = new int[16];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(i);
                if (!iCondition.isFulfilled(this.dbDataBook.rowInstance1)) continue;
                if (n2 == nArray.length) {
                    int[] nArray2 = new int[n2 * 2];
                    System.arraycopy(nArray, 0, nArray2, 0, n2);
                    nArray = nArray2;
                }
                nArray[n2] = i;
                ++n2;
            }
            this.iaUsedRows = nArray;
            this.iUsedRowCount = n2;
        }
    }

    private void sort() throws ModelException {
        SortDefinition sortDefinition = this.dbDataBook.getSort();
        if (sortDefinition != null) {
            this.fetchAll();
            if (this.iaUsedRows == null) {
                this.iaUsedRows = this.createArrayWithAscendingIndexes(this.getRowCountInternal());
                this.iUsedRowCount = this.iaUsedRows.length;
            }
            this.quickSort(this.iaUsedRows, 0, this.iUsedRowCount - 1, sortDefinition);
            this.insertionSort(this.iaUsedRows, 0, this.iUsedRowCount - 1, sortDefinition);
        }
    }

    private int[] createArrayWithAscendingIndexes(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private void quickSort(int[] nArray, int n, int n2, SortDefinition sortDefinition) {
        if (n2 - n > 4) {
            int n3 = (n2 + n) / 2;
            this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[n]);
            this.dbDataBook.rowInstance2.oaStorage = this.alStorage.get(nArray[n3]);
            if (this.dbDataBook.rowInstance1.compareTo(this.dbDataBook.rowInstance2, sortDefinition) > 0) {
                this.swap(nArray, n, n3);
            }
            this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[n]);
            this.dbDataBook.rowInstance2.oaStorage = this.alStorage.get(nArray[n2]);
            if (this.dbDataBook.rowInstance1.compareTo(this.dbDataBook.rowInstance2, sortDefinition) > 0) {
                this.swap(nArray, n, n2);
            }
            this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[n3]);
            this.dbDataBook.rowInstance2.oaStorage = this.alStorage.get(nArray[n2]);
            if (this.dbDataBook.rowInstance1.compareTo(this.dbDataBook.rowInstance2, sortDefinition) > 0) {
                this.swap(nArray, n3, n2);
            }
            int n4 = n2 - 1;
            this.swap(nArray, n3, n4);
            n3 = n;
            this.dbDataBook.rowInstance2.oaStorage = this.alStorage.get(nArray[n4]);
            while (true) {
                this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[++n3]);
                while (this.dbDataBook.rowInstance1.compareTo(this.dbDataBook.rowInstance2, sortDefinition) < 0) {
                    this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[++n3]);
                }
                this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[--n4]);
                while (this.dbDataBook.rowInstance1.compareTo(this.dbDataBook.rowInstance2, sortDefinition) > 0) {
                    this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[--n4]);
                }
                if (n4 < n3) break;
                this.swap(nArray, n3, n4);
            }
            this.swap(nArray, n3, n2 - 1);
            this.quickSort(nArray, n, n4, sortDefinition);
            this.quickSort(nArray, n3 + 1, n2, sortDefinition);
        }
    }

    private void insertionSort(int[] nArray, int n, int n2, SortDefinition sortDefinition) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3 = nArray[i];
            this.dbDataBook.rowInstance2.oaStorage = this.alStorage.get(n3);
            int n4 = i;
            if (n4 > n) {
                this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[n4 - 1]);
                while (n4 > n && this.dbDataBook.rowInstance1.compareTo(this.dbDataBook.rowInstance2, sortDefinition) > 0) {
                    nArray[n4] = nArray[n4 - 1];
                    if (--n4 <= n) continue;
                    this.dbDataBook.rowInstance1.oaStorage = this.alStorage.get(nArray[n4 - 1]);
                }
            }
            nArray[n4] = n3;
        }
    }

    String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.dbDataBook != null) {
            stringBuilder.append(string);
            stringBuilder.append("DataBook = ");
            stringBuilder.append(this.dbDataBook.getName());
            stringBuilder.append("\n");
        }
        try {
            if (this.rdRowDefinition != null) {
                Object[] objectArray;
                int n;
                stringBuilder.append(string);
                stringBuilder.append("Changes  = [");
                for (int i = 0; i < this.iChangedRowCount; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(this.iaChangedRows[i]);
                }
                stringBuilder.append("]");
                String[] stringArray = (String[])this.rdRowDefinition.getColumnNames().clone();
                int[] nArray = new int[stringArray.length];
                int[] nArray2 = new int[stringArray.length];
                int n2 = 0;
                stringBuilder.append("\n\n");
                stringBuilder.append(string);
                stringBuilder.append("[    #][       UID][CHANGES] |");
                int n3 = stringArray.length;
                for (n = 0; n < n3; ++n) {
                    IDataType iDataType = this.rdRowDefinition.getColumnDefinition(stringArray[n]).getDataType();
                    if (iDataType instanceof DataType) {
                        nArray[n] = ((DataType)iDataType).getSize();
                        if (nArray[n] > 50) {
                            switch (iDataType.getTypeIdentifier()) {
                                case 3: {
                                    nArray[n] = 15;
                                    break;
                                }
                                case 93: {
                                    nArray[n] = 20;
                                    break;
                                }
                                default: {
                                    nArray[n] = 50;
                                }
                            }
                        }
                    }
                    nArray2[n] = 0;
                    if (iDataType instanceof BigDecimalDataType) {
                        nArray2[n] = 1;
                    }
                    if (stringArray[n] != null && stringArray[n].length() > nArray[n]) {
                        stringArray[n] = stringArray[n].substring(0, nArray[n]);
                    }
                    objectArray = StringUtil.rpad(stringArray[n], nArray[n]);
                    n2 += objectArray.length();
                    stringBuilder.append((String)objectArray);
                    if (n + 1 >= n3) continue;
                    stringBuilder.append("|");
                    ++n2;
                }
                stringBuilder.append("\n");
                stringBuilder.append(string);
                stringBuilder.append("-------------------------------");
                for (n = 0; n < n2; ++n) {
                    stringBuilder.append('-');
                }
                n3 = this.getRowCountInternal();
                for (n = 0; n < n3; ++n) {
                    stringBuilder.append("\n");
                    stringBuilder.append(string);
                    stringBuilder.append("[");
                    stringBuilder.append(StringUtil.lpad(Integer.toString(n), 5));
                    stringBuilder.append("]");
                    int n4 = this.getInternalRowIndex(n);
                    objectArray = this.alStorage.get(n4);
                    ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.rdRowDefinition, objectArray, this, n);
                    stringBuilder.append("[");
                    stringBuilder.append(StringUtil.lpad(changeableDataRow.getUID() != null ? "" + changeableDataRow.getUID() : "", 10));
                    stringBuilder.append("]");
                    stringBuilder.append("[");
                    if (changeableDataRow.isInserting()) {
                        stringBuilder.append("I");
                    }
                    if (changeableDataRow.isUpdating()) {
                        stringBuilder.append("U");
                    }
                    if (changeableDataRow.isDeleting()) {
                        stringBuilder.append("D");
                    }
                    if (!(changeableDataRow.isInserting() || changeableDataRow.isUpdating() || changeableDataRow.isDeleting())) {
                        stringBuilder.append(" ");
                    }
                    if (changeableDataRow.isDetailChanged()) {
                        stringBuilder.append("DC");
                    } else {
                        stringBuilder.append("  ");
                    }
                    stringBuilder.append("    ] |");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object object = objectArray[i];
                        if (object == null) {
                            object = "null";
                        } else if (((String)(object = StringUtil.toString(object).replace("\n", "\\n"))).length() > nArray[i]) {
                            object = ((String)object).substring(0, nArray[i]);
                        }
                        if (nArray2[i] == 0) {
                            stringBuilder.append(StringUtil.rpad(StringUtil.toString(object), nArray[i]));
                        } else {
                            stringBuilder.append(StringUtil.lpad(StringUtil.toString(object), nArray[i]));
                        }
                        if (i + 1 >= stringArray.length) continue;
                        stringBuilder.append("|");
                    }
                }
            }
        }
        catch (ModelException modelException) {
            stringBuilder.append("\n");
            stringBuilder.append(ExceptionUtil.dump(modelException, true));
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }
}

