/*
 * Copyright 2016 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 08.06.2016 - [JR] - creation
 */
package javax.rad.server;

/**
 * The <code>ICallBackBroker</code> enables publishing of objects from the server to the client.
 * 
 * @author Ren Jahn
 */
public interface ICallBackBroker
{
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Constants
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /** The publish state. */
    public enum PublishState
    {
        /** Published to all relevant sessions. */
        Completed,
        /** Published to some sessions, not all. */
        Partial,
        /** Not published. */
        Failed;
    }
    
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Method definitions
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    /**
     * Publishs an object to the client for the current session.
     * 
     * @param pInstruction the instruction identifier
     * @param pObject the object to publich
     * @return the publish state
     */
    public PublishState publish(String pInstruction, Object pObject);
    
    /**
     * Publishs an object to all client for the current session and all other master sessions
     * for the same application as the current one.
     * 
     * @param pInstruction the instruction identifier
     * @param pObject the object to publich
     * @return the publish state
     */
    public PublishState publishAll(String pInstruction, Object pObject);
    
}   // ICallBackBroker
