/*
 * Copyright 2015 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 06.11.2015 - [RZ] - creation
 */
package com.sibvisions.rad.ui;

import java.util.HashMap;
import java.util.Map;

import javax.rad.ui.IFactory;

/**
 * The {@link AbstractFactory} is an abstract implementation of {@link IFactory}
 * , which provides common functionality.
 * 
 * @author Robert Zenz
 */
public abstract class AbstractFactory implements IFactory
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/** The {@link Map} which holds the properties. */
	protected Map<String, Object> properties = new HashMap<String, Object>();
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	public Object getProperty(String pName)
	{
		return properties.get(pName);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setProperty(String pName, Object pValue)
	{
		properties.put(pName, pValue);
	}
	
}	// AbstractFactory
