/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.util;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.rad.util.ITranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationMap
implements ITranslator {
    private ILogger log = LoggerFactory.getInstance(this.getClass());
    private TranslationMap parent = null;
    private Hashtable<String, String> simpleTranslations = new Hashtable();
    private Hashtable<String, List<WildCardEntry>> wildcardTranslations = new Hashtable();
    private String sLangCode = null;
    private String sResource;
    private long lLastModified = -1L;

    public TranslationMap getParent() {
        return this.parent;
    }

    public void setParent(TranslationMap translationMap) {
        if (translationMap == this) {
            throw new IllegalArgumentException("Can't set this translation as parent!");
        }
        this.parent = translationMap;
    }

    @Override
    public String translate(String string) {
        if (string == null) {
            return "";
        }
        String string2 = this.simpleTranslations.get(string);
        if (string2 == null) {
            int n = string.length();
            if (n >= 2) {
                int n2 = this.getKeyLength(n);
                string2 = this.translate(string.substring(0, n2), string);
                while (string2 == null && n2 > 0) {
                    string2 = this.translate(string.substring(0, n2 /= 2), string);
                }
            }
            if (string2 == null) {
                string2 = string;
                this.simpleTranslations.put(string2, string2);
                this.log.debug("<entry key=\"", this.prepareCharacters(string), "\">Translation</entry>");
            }
        }
        if (this.parent != null && string2 == this.simpleTranslations.get(string2)) {
            return this.parent.translate(string);
        }
        return string2;
    }

    private String prepareCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private int getKeyLength(int n) {
        int n2;
        for (n2 = 8; n2 > n; n2 /= 2) {
        }
        return n2;
    }

    private String translate(String string, String string2) {
        List<WildCardEntry> list = this.wildcardTranslations.get(string);
        if (list == null) {
            return null;
        }
        String string3 = null;
        for (int i = list.size() - 1; i >= 0 && string3 == null; --i) {
            string3 = this.translateWildCard(list.get(i), string2);
        }
        return string3;
    }

    private String translateWildCard(WildCardEntry wildCardEntry, String string) {
        String string2 = wildCardEntry.wildCardParts[0];
        if (string.startsWith(string2)) {
            int n = wildCardEntry.wildCardParts.length - 1;
            String string3 = wildCardEntry.wildCardParts[n];
            if (string.endsWith(string3)) {
                int n2;
                int n3 = string.length();
                int n4 = string2.length();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 1; i < n; ++i) {
                    string2 = wildCardEntry.wildCardParts[i];
                    n2 = string.indexOf(string2, n4);
                    if (n2 < 0) {
                        return null;
                    }
                    arrayList.add(string.substring(n4, n2));
                    n4 = n2 + string2.length();
                }
                arrayList.add(string.substring(n4, n3 - string3.length()));
                StringBuilder stringBuilder = new StringBuilder(n3 * 2);
                stringBuilder.append(wildCardEntry.translationParts[0]);
                n2 = wildCardEntry.translationParts.length;
                for (int i = 1; i < n2; ++i) {
                    int n5 = wildCardEntry.dynamicPartOrder[i - 1];
                    if (n5 < n) {
                        if (wildCardEntry.noSubTranslation[i - 1]) {
                            stringBuilder.append((String)arrayList.get(n5));
                        } else {
                            stringBuilder.append(this.translate((String)arrayList.get(n5)));
                        }
                    }
                    stringBuilder.append(wildCardEntry.translationParts[i]);
                }
                return stringBuilder.toString();
            }
            return null;
        }
        return null;
    }

    private String[] tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(42);
        while (n2 >= 0) {
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(42, n);
        }
        arrayList.add(string.substring(n));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String put(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Null Text can not be translated!");
        }
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException("Empty Text can not be translated!");
        }
        if (string.equals(string2)) {
            string2 = string;
        }
        String string3 = this.simpleTranslations.put(string, string2);
        Object[] objectArray = this.tokenize(string);
        String[] stringArray = this.tokenize(string2);
        if (objectArray.length > 1) {
            Object object;
            int n2;
            String string4 = objectArray[0];
            String string5 = string4.substring(0, this.getKeyLength(string4.length()));
            List<WildCardEntry> list = this.wildcardTranslations.get(string5);
            if (list == null) {
                list = new ArrayList<WildCardEntry>();
                this.wildcardTranslations.put(string5, list);
            } else if (string3 != null) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    if (!Arrays.equals(list.get(i).wildCardParts, objectArray)) continue;
                    list.remove(i);
                }
            }
            Object object2 = stringArray[0];
            int[] nArray = new int[stringArray.length - 1];
            boolean[] blArray = new boolean[stringArray.length - 1];
            for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
                char c;
                nArray[n2] = n2;
                object = stringArray[n2 + 1];
                if (((String)object2).length() > 0 && ((String)object2).charAt(((String)object2).length() - 1) == '~') {
                    blArray[n2] = true;
                    stringArray[n2] = ((String)object2).substring(0, ((String)object2).length() - 1);
                }
                if (((String)object).length() > 0 && (c = ((String)object).charAt(0)) >= '0' && c <= '9') {
                    nArray[n2] = c - 48;
                    stringArray[n2 + 1] = object = ((String)object).substring(1);
                }
                object2 = object;
            }
            object = new WildCardEntry((String[])objectArray, stringArray, nArray, blArray);
            for (n2 = list.size(); n2 > 0 && list.get(n2 - 1).wildCardParts.length < ((WildCardEntry)object).wildCardParts.length; --n2) {
            }
            list.add(n2, new WildCardEntry((String[])objectArray, stringArray, nArray, blArray));
        }
        this.lLastModified = System.currentTimeMillis();
        return string3;
    }

    public Enumeration<String> keys() {
        return this.simpleTranslations.keys();
    }

    public String get(String string) {
        return this.simpleTranslations.get(string);
    }

    public int size() {
        return this.simpleTranslations.size();
    }

    public void clear() {
        this.simpleTranslations.clear();
        this.wildcardTranslations.clear();
        this.lLastModified = System.currentTimeMillis();
    }

    public List<String> getUntranslated() {
        ArrayList<String> arrayList = new ArrayList<String>(this.simpleTranslations.size());
        Enumeration<String> enumeration = this.simpleTranslations.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (string != this.simpleTranslations.get(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Properties getAsProperties() {
        Properties properties = new Properties();
        Enumeration<String> enumeration = this.simpleTranslations.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.setProperty(string, this.simpleTranslations.get(string));
        }
        return properties;
    }

    public void setAsProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof String)) continue;
            this.put((String)obj, properties.getProperty((String)obj));
        }
    }

    public void setLanguage(String string) {
        this.sLangCode = string;
    }

    public String getLanguage() {
        return this.sLangCode;
    }

    public void setResourcePath(String string) {
        this.sResource = string;
    }

    public String getResourcePath() {
        return this.sResource;
    }

    public long lastModified() {
        return this.lLastModified;
    }

    private static final class WildCardEntry {
        private String[] wildCardParts;
        private String[] translationParts;
        private int[] dynamicPartOrder;
        private boolean[] noSubTranslation;

        private WildCardEntry(String[] stringArray, String[] stringArray2, int[] nArray, boolean[] blArray) {
            this.wildCardParts = stringArray;
            this.translationParts = stringArray2;
            this.dynamicPartOrder = nArray;
            this.noSubTranslation = blArray;
        }
    }
}

