/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.remote;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.List;
import javax.rad.remote.AbstractConnection;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.SessionExpiredException;
import javax.rad.remote.SubConnection;
import javax.rad.remote.event.CallErrorEvent;
import javax.rad.remote.event.CallEvent;
import javax.rad.remote.event.ConnectionEvent;
import javax.rad.remote.event.IConnectionListener;
import javax.rad.remote.event.PropertyEvent;
import javax.rad.util.UIInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterConnection
extends AbstractConnection {
    private static final long ALIVECHECK_DELAY = 30000L;
    private UIInvoker uiInvoker = new UIInvoker();
    private SubConnectionListener sclSubCon = null;
    private ArrayUtil<WeakReference<SubConnection>> auSubConnections = null;
    private Thread thAliveCheck = null;
    private Object oSyncSubConnections = new Object();
    private long lAliveInterval = 30000L;
    private boolean bAliveCheckIsActive = false;

    public MasterConnection(IConnection iConnection) {
        super(iConnection);
    }

    @Override
    public void openConnection() throws Throwable {
        this.connection.open(this.coninf);
        this.startAliveCheck();
    }

    @Override
    protected UIInvoker getUIInvoker() {
        return this.uiInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Throwable {
        Object object;
        Object object2 = this.oSyncSubConnections;
        synchronized (object2) {
            object = this.auSubConnections != null ? this.auSubConnections.clone() : null;
            this.auSubConnections = null;
        }
        this.stopAliveCheck();
        if (object != null) {
            int n = ((ArrayUtil)object).size();
            for (int i = 0; i < n; ++i) {
                object2 = (SubConnection)((WeakReference)((ArrayUtil)object).get(i)).get();
                if (object2 == null) continue;
                ((AbstractConnection)object2).removeConnectionListener(this.sclSubCon);
                ((SubConnection)object2).close(false);
            }
        }
        super.close();
    }

    @Override
    public void reopen() throws Throwable {
        this.reopen(false);
    }

    @Override
    protected ChangedHashtable<String, Object> createConnectionProperties() {
        ChangedHashtable<String, Object> changedHashtable = super.createConnectionProperties();
        changedHashtable.put("client.alive.interval", 30000L);
        return changedHashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopen(boolean bl) throws Throwable {
        block7: {
            Object object;
            block6: {
                int n;
                int n2;
                this.stopAliveCheck();
                List<SubConnection> list = this.getSubConnections();
                if (list != null) {
                    n2 = list.size();
                    for (n = 0; n < n2; ++n) {
                        object = list.get(n);
                        ((AbstractConnection)object).removeConnectionListener(this.sclSubCon);
                        if (!bl) continue;
                        ((SubConnection)object).close(false);
                    }
                }
                super.reopen();
                this.startAliveCheck();
                if (bl) break block6;
                if (list == null) break block7;
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    object = list.get(n);
                    ((SubConnection)object).reopen();
                }
                break block7;
            }
            object = this.oSyncSubConnections;
            synchronized (object) {
                this.auSubConnections = null;
            }
        }
    }

    public SubConnection createSubConnection(String string) throws Throwable {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection is not open!");
        }
        try {
            SubConnection subConnection = new SubConnection(this);
            subConnection.setLifeCycleName(string);
            this.startAliveCheck();
            return subConnection;
        }
        catch (Throwable throwable) {
            throw this.handleCallError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubConnection(SubConnection subConnection) {
        Object object = this.oSyncSubConnections;
        synchronized (object) {
            if (subConnection != null) {
                if (this.auSubConnections == null) {
                    this.auSubConnections = new ArrayUtil();
                    this.auSubConnections.add(new WeakReference<SubConnection>(subConnection));
                } else if (this.auSubConnections.indexOf(subConnection) < 0) {
                    this.auSubConnections.add(new WeakReference<SubConnection>(subConnection));
                }
            }
        }
        if (subConnection != null) {
            if (this.sclSubCon == null) {
                this.sclSubCon = new SubConnectionListener();
            }
            subConnection.addConnectionListener(this.sclSubCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubConnection(SubConnection subConnection) {
        Object object = this.oSyncSubConnections;
        synchronized (object) {
            if (this.auSubConnections != null && subConnection != null) {
                subConnection.removeConnectionListener(this.sclSubCon);
                this.auSubConnections.remove(subConnection);
                if (this.auSubConnections.size() == 0) {
                    this.auSubConnections = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubConnection> getSubConnections() {
        Object object = this.oSyncSubConnections;
        synchronized (object) {
            if (this.auSubConnections != null) {
                ArrayUtil<SubConnection> arrayUtil = null;
                int n = 0;
                int n2 = this.auSubConnections.size();
                while (n < n2) {
                    WeakReference<SubConnection> weakReference = this.auSubConnections.get(n);
                    SubConnection subConnection = (SubConnection)weakReference.get();
                    if (subConnection == null) {
                        this.auSubConnections.remove(n);
                        --n2;
                        continue;
                    }
                    if (arrayUtil == null) {
                        arrayUtil = new ArrayUtil<SubConnection>();
                    }
                    arrayUtil.add(subConnection);
                    ++n;
                }
                if (this.auSubConnections.size() == 0) {
                    this.auSubConnections = null;
                }
                return arrayUtil;
            }
            return null;
        }
    }

    private void startAliveCheck() {
        if (this.lAliveInterval >= 0L && ThreadHandler.isStopped(this.thAliveCheck) && this.isOpen()) {
            this.thAliveCheck = ThreadHandler.start(new Alive());
        }
    }

    private void stopAliveCheck() {
        this.thAliveCheck = ThreadHandler.stop(this.thAliveCheck);
    }

    public void setAliveInterval(long l) {
        if (l >= 0L && l <= 1000L) {
            this.lAliveInterval = 30000L;
            this.startAliveCheck();
        } else {
            this.lAliveInterval = l;
            if (this.lAliveInterval < 0L) {
                this.stopAliveCheck();
            } else {
                this.startAliveCheck();
            }
        }
        this.coninf.getProperties().put("client.alive.interval", this.lAliveInterval);
    }

    public long getAliveInterval() {
        Long l = (Long)this.coninf.getProperties().get("client.alive.interval");
        if (l != null) {
            return l;
        }
        return this.lAliveInterval;
    }

    public void setNewPassword(String string, String string2) throws Throwable {
        this.coninf.getProperties().put("client.oldpassword", string);
        this.coninf.getProperties().put("client.newpassword", string2);
        if (this.isOpen()) {
            long l = System.currentTimeMillis();
            try {
                this.connection.setNewPassword(this.coninf, string, string2);
                this.logCommunication(l, "setNewPassword", null, new Object[0]);
            }
            catch (Throwable throwable) {
                this.logCommunication(l, "setNewPassword", throwable, new Object[0]);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAndCheckAlive() throws Throwable {
        try {
            SubConnection subConnection;
            int n;
            int n2;
            Object object;
            this.bAliveCheckIsActive = true;
            ConnectionInfo[] connectionInfoArray = null;
            Hashtable<Object, SubConnection> hashtable = new Hashtable<Object, SubConnection>();
            List<SubConnection> list = this.getSubConnections();
            if (list != null) {
                object = new ArrayUtil<ConnectionInfo>();
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    subConnection = list.get(n);
                    if (!subConnection.isOpen()) continue;
                    ((ArrayUtil)object).add(subConnection.coninf);
                    hashtable.put(subConnection.coninf.getConnectionId(), subConnection);
                }
                if (((ArrayUtil)object).size() > 0) {
                    connectionInfoArray = new ConnectionInfo[((ArrayUtil)object).size()];
                    ((ArrayUtil)object).toArray(connectionInfoArray);
                }
            }
            if ((connectionInfoArray = this.getConnection().setAndCheckAlive(this.coninf, connectionInfoArray)) != null) {
                n2 = connectionInfoArray.length;
                for (n = 0; n < n2; ++n) {
                    object = connectionInfoArray[n].getConnectionId();
                    subConnection = (SubConnection)hashtable.get(object);
                    Object object2 = this.oSyncSubConnections;
                    synchronized (object2) {
                        if (this.auSubConnections != null && this.auSubConnections.contains(subConnection)) {
                            final SubConnection subConnection2 = subConnection;
                            final Object object3 = object;
                            this.getUIInvoker().invokeLater(new Runnable(){

                                public void run() {
                                    subConnection2.fireCallError(MasterConnection.this.setConnection(new SessionExpiredException("" + object3)));
                                }
                            });
                        }
                        continue;
                    }
                }
            }
            connectionInfoArray = null;
            hashtable = null;
            subConnection = null;
        }
        finally {
            this.bAliveCheckIsActive = false;
        }
    }

    private final class SubConnectionListener
    implements IConnectionListener {
        private SubConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callError(CallErrorEvent callErrorEvent) {
            if (!MasterConnection.this.bAliveCheckIsActive) {
                MasterConnection.this.bAliveCheckIsActive = true;
                try {
                    if (callErrorEvent.getCause() instanceof SessionExpiredException) {
                        try {
                            MasterConnection.this.getConnection().setAndCheckAlive(MasterConnection.this.coninf, null);
                        }
                        catch (Throwable throwable) {
                            MasterConnection.this.fireCallError(MasterConnection.this.setConnection(throwable));
                        }
                    }
                }
                finally {
                    MasterConnection.this.bAliveCheckIsActive = false;
                }
            }
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionReOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
        }

        public void actionCalled(CallEvent callEvent) {
        }

        public void objectCalled(CallEvent callEvent) {
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
        }
    }

    private final class Alive
    extends Thread {
        private Alive() {
        }

        public void run() {
            ILogger iLogger = null;
            try {
                while (MasterConnection.this.lAliveInterval >= 0L && !ThreadHandler.isStopped()) {
                    long l = MasterConnection.this.coninf.getLastCallTime();
                    if (l > 0L) {
                        long l2;
                        if (l < System.currentTimeMillis() - MasterConnection.this.lAliveInterval && !MasterConnection.this.connection.isCalling()) {
                            MasterConnection.this.setAndCheckAlive();
                        }
                        if ((l2 = System.currentTimeMillis() - MasterConnection.this.coninf.getLastCallTime()) >= 0L && l2 < MasterConnection.this.lAliveInterval) {
                            Thread.sleep(MasterConnection.this.lAliveInterval - l2 + 500L);
                            continue;
                        }
                        Thread.sleep(500L);
                        continue;
                    }
                    Thread.sleep(MasterConnection.this.lAliveInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                if (iLogger == null) {
                    iLogger = LoggerFactory.getInstance(this.getClass());
                }
                iLogger.debug(interruptedException);
            }
            catch (Throwable throwable) {
                if (iLogger == null) {
                    iLogger = LoggerFactory.getInstance(this.getClass());
                }
                iLogger.debug(throwable);
                MasterConnection.this.getUIInvoker().invokeLater(new Runnable(){

                    public void run() {
                        MasterConnection.this.fireCallError(MasterConnection.this.setConnection(throwable));
                    }
                });
            }
        }
    }
}

