/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.io;

import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.rad.io.IFileHandle;
import javax.rad.io.IUploadExecutor;
import javax.rad.io.TransferContext;

public class FileHandle
implements IFileHandle,
Serializable {
    private String fileName;
    private transient File fiTempOut;
    private transient FileOutputStream fosTempOut;
    private transient byte[] byContent;
    private transient IFileHandle fileHandle;
    private transient File file;

    public FileHandle() {
        this.fileName = null;
        this.file = null;
    }

    public FileHandle(String string) {
        this.setContent(new File(string));
    }

    public FileHandle(String string, byte[] byArray) throws IOException {
        this.fileName = FileUtil.getName(string);
        this.setContent(byArray);
    }

    public FileHandle(String string, InputStream inputStream) throws IOException {
        this.fileName = FileUtil.getName(string);
        this.setContent(inputStream);
    }

    public FileHandle(File file) throws IOException {
        this.setContent(file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        if (this.fiTempOut != null) {
            return new FileInputStream(this.fiTempOut);
        }
        if (this.fileHandle != null) {
            return this.fileHandle.getInputStream();
        }
        if (this.byContent != null) {
            return new ByteArrayInputStream(this.byContent);
        }
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return null;
    }

    public long getLength() throws IOException {
        if (this.fiTempOut != null) {
            return this.fiTempOut.length();
        }
        if (this.fileHandle != null) {
            return this.fileHandle.getLength();
        }
        if (this.byContent != null) {
            return this.byContent.length;
        }
        if (this.file != null) {
            return this.file.length();
        }
        return -1L;
    }

    protected void finalize() throws Throwable {
        if (this.fiTempOut != null) {
            CommonUtil.close(this.fosTempOut);
            try {
                this.fiTempOut.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public void setFileName(String string) {
        this.fileName = FileUtil.getName(string);
    }

    public File getFile() {
        return this.file;
    }

    public Object getContentDefinition() throws IOException {
        if (this.fileHandle != null) {
            return this.fileHandle;
        }
        IUploadExecutor iUploadExecutor = TransferContext.getCurrentUploadExecutor();
        if (iUploadExecutor != null) {
            return iUploadExecutor.writeContent(this);
        }
        return this.getGZIPContent();
    }

    public void setContentDefinition(Object object) throws IOException {
        if (object instanceof IFileHandle) {
            this.fileHandle = (IFileHandle)object;
        } else if (object instanceof byte[]) {
            this.setGZIPContent((byte[])object);
        }
    }

    private byte[] getGZIPContent() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.file != null || this.fiTempOut != null) {
            FileInputStream fileInputStream = this.fiTempOut != null ? new FileInputStream(this.fiTempOut) : new FileInputStream(this.file);
            FileUtil.copy(fileInputStream, true, new GZIPOutputStream(byteArrayOutputStream), true);
            return byteArrayOutputStream.toByteArray();
        }
        if (this.byContent != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.byContent);
            FileUtil.copy(byteArrayInputStream, true, new GZIPOutputStream(byteArrayOutputStream), true);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    private void setGZIPContent(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        FileUtil.copy(gZIPInputStream, true, this.getOutputStream(), true);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.file == null) {
            CommonUtil.close(this.fosTempOut);
            this.fiTempOut = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
            this.fiTempOut.deleteOnExit();
            this.fosTempOut = new FileOutputStream(this.fiTempOut);
            return this.fosTempOut;
        }
        return new FileOutputStream(this.file);
    }

    public void setContent(byte[] byArray) throws IOException {
        this.byContent = byArray;
    }

    public void setContent(InputStream inputStream) throws IOException {
        FileUtil.copy(inputStream, true, this.getOutputStream(), true);
    }

    public void setContent(File file) {
        if (file != null && this.fileName == null) {
            this.fileName = file.getName();
        }
        this.file = file;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        byte[] byArray = this.getGZIPContent();
        if (byArray == null) {
            objectOutputStream.writeInt(-1);
        } else {
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.file = null;
        int n = objectInputStream.readInt();
        if (n >= 0) {
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            this.setGZIPContent(byArray);
        }
    }
}

