/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import java.util.ArrayList;
import java.util.List;
import javax.rad.genui.UIComponent;
import javax.rad.genui.UILayout;
import javax.rad.genui.UIResource;
import javax.rad.genui.container.UITabsetPanel;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.IImage;
import javax.rad.ui.ILayout;
import javax.rad.ui.container.IToolBar;
import javax.rad.ui.menu.IMenuBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIContainer<C extends IContainer>
extends UIComponent<C>
implements IContainer {
    private ILayout uiLayout = null;
    protected List<UIComponent<?>> components = new ArrayList(4);
    protected List<UIComponent<?>> allComponents = new ArrayList(4);
    private boolean bAddNotify = false;

    protected UIContainer(C c) {
        super(c);
    }

    @Override
    public ILayout getLayout() {
        return this.uiLayout;
    }

    @Override
    public void setLayout(ILayout iLayout) {
        if (iLayout instanceof UILayout) {
            ((IContainer)this.uiResource).setLayout((ILayout)((UILayout)iLayout).uiResource);
        } else {
            ((IContainer)this.uiResource).setLayout(iLayout);
        }
        this.uiLayout = iLayout;
    }

    @Override
    public void add(IComponent iComponent) {
        this.add(iComponent, null, -1);
    }

    @Override
    public void add(IComponent iComponent, Object object) {
        this.add(iComponent, object, -1);
    }

    @Override
    public void add(IComponent iComponent, int n) {
        this.add(iComponent, null, n);
    }

    @Override
    public void add(IComponent iComponent, Object object, int n) {
        this.checkAdd(iComponent, object, n);
        this.addInternal((IContainer)this.uiResource, n, (UIComponent)iComponent, object, n);
    }

    @Override
    public void remove(int n) {
        this.removeInternal(this.components.get(n));
    }

    @Override
    public void remove(IComponent iComponent) {
        int n = this.components.indexOf(iComponent);
        if (n >= 0) {
            this.remove(n);
        }
    }

    @Override
    public void removeAll() {
        while (this.components.size() > 0) {
            this.remove(this.components.size() - 1);
        }
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public UIComponent<?> getComponent(int n) {
        return this.components.get(n);
    }

    @Override
    public int indexOf(IComponent iComponent) {
        return this.components.indexOf(iComponent);
    }

    @Override
    public void updateTranslation() {
        super.updateTranslation();
        if (this.bAddNotify) {
            return;
        }
        for (UIComponent<?> uIComponent : this.allComponents) {
            uIComponent.updateTranslation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeAddNotify(IComponent iComponent) {
        if (this.bAddNotify) {
            return;
        }
        this.bAddNotify = true;
        try {
            super.beforeAddNotify(iComponent);
            UIComponent<?> uIComponent = null;
            this.bAddNotify = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.bAddNotify = false;
            throw throwable;
        }
        for (UIComponent<?> uIComponent : this.allComponents) {
            if (uIComponent.isBeforeNotified()) continue;
            uIComponent.beforeAddNotify(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        if (this.bAddNotify) {
            return;
        }
        this.bAddNotify = true;
        try {
            super.addNotify();
            UIComponent<?> uIComponent = null;
            this.bAddNotify = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.bAddNotify = false;
            throw throwable;
        }
        for (UIComponent<?> uIComponent : this.allComponents) {
            if (uIComponent.isNotified()) continue;
            uIComponent.addNotify();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        for (UIComponent<?> uIComponent : this.allComponents) {
            if (!uIComponent.isNotified()) continue;
            uIComponent.removeNotify();
        }
    }

    protected UIContainer<C> getUIResourceContainer() {
        return (UIContainer)((IContainer)this.uiResource).getEventSource();
    }

    protected void setUIResourceContainer(UIContainer<C> uIContainer) {
        IContainer iContainer;
        for (iContainer = uIContainer; iContainer != null && iContainer != this; iContainer = iContainer.getParent()) {
        }
        if (iContainer == null) {
            throw new IllegalArgumentException("The ui resource container has to be a child!");
        }
        this.components.clear();
        this.uiResource = uIContainer.getUIResource();
        ILayout iLayout = uIContainer.getLayout();
        this.setLayout(iLayout);
        while (uIContainer.getComponentCount() > 0) {
            IComponent iComponent = uIContainer.getComponent(0);
            this.add(iComponent, iLayout.getConstraints(iComponent));
        }
    }

    protected boolean contains(UIComponent<?> uIComponent) {
        return this.allComponents.contains(uIComponent);
    }

    protected void checkAdd(IComponent iComponent, Object object, int n) {
        if (!(iComponent instanceof UIComponent)) {
            throw new IllegalArgumentException("Only UIComponents may be added to UIContainer!");
        }
        if (!(this instanceof IToolBar) && iComponent instanceof IToolBar) {
            throw new IllegalArgumentException("It's not supported to 'add' an IToolBar. Use 'addToolBar'!");
        }
        if (iComponent instanceof IMenuBar) {
            throw new IllegalArgumentException("It's not supported to 'add' an IMenuBar. Use 'setMenuBar'!");
        }
    }

    protected void addInternal(IContainer iContainer, int n, UIComponent uIComponent, Object object, int n2) {
        if (uIComponent.getParent() != null) {
            uIComponent.getParent().remove(uIComponent);
        }
        IComponent iComponent = uIComponent.getComponentUIResource();
        Object object2 = object instanceof UIResource ? ((UIResource)object).getUIResource() : object;
        if (this.isNotified() && !uIComponent.isBeforeNotified()) {
            uIComponent.beforeAddNotify(this);
            if (uIComponent.getUIComponent() != uIComponent) {
                uIComponent.getUIComponent().beforeAddNotify(this);
            }
        }
        this.allComponents.add(uIComponent);
        uIComponent.setParent(this);
        if (iContainer != null) {
            if (n2 < 0) {
                this.components.add(uIComponent);
            } else {
                this.components.add(n2, uIComponent);
            }
            try {
                iContainer.add(iComponent, object2, n);
            }
            catch (RuntimeException runtimeException) {
                this.allComponents.remove(uIComponent);
                this.components.remove(uIComponent);
                uIComponent.setParent(null);
                throw runtimeException;
            }
            catch (Error error) {
                this.allComponents.remove(uIComponent);
                this.components.remove(uIComponent);
                uIComponent.setParent(null);
                throw error;
            }
        }
        if (uIComponent.getUIComponent() != uIComponent) {
            this.allComponents.add(uIComponent.getUIComponent());
            uIComponent.getUIComponent().setParent(this);
        }
        if (this.isNotified() && !uIComponent.isNotified()) {
            uIComponent.addNotify();
            if (uIComponent.getUIComponent() != uIComponent) {
                uIComponent.getUIComponent().addNotify();
            }
        }
    }

    protected void removeInternal(UIComponent uIComponent) {
        if (uIComponent.getParent() == this) {
            int n = this.components.indexOf(uIComponent);
            if (n >= 0) {
                IComponent iComponent = uIComponent.getComponentUIResource();
                ((IContainer)this.uiResource).remove(iComponent);
                this.components.remove(n);
            }
            if (uIComponent.isNotified()) {
                uIComponent.removeNotify();
                if (uIComponent.getUIComponent() != uIComponent) {
                    uIComponent.getUIComponent().removeNotify();
                }
            }
            this.allComponents.remove(uIComponent);
            uIComponent.setParent(null);
            if (uIComponent.getUIComponent() != uIComponent) {
                this.allComponents.remove(uIComponent.getUIComponent());
                uIComponent.getUIComponent().setParent(null);
            }
        }
    }

    public void setZOrder(UIComponent uIComponent, int n) {
        int n2 = this.indexOf(uIComponent);
        if (n2 >= 0) {
            String string = null;
            IImage iImage = null;
            if (this.getLayout() != null) {
                string = (String)this.getLayout().getConstraints(uIComponent);
            } else if (this instanceof UITabsetPanel) {
                string = ((UITabsetPanel)this).getTextAt(n2);
                iImage = ((UITabsetPanel)this).getIconAt(n2);
            }
            ((IContainer)this.uiResource).remove(uIComponent.getComponentUIResource());
            this.components.remove(n2);
            if (n > this.components.size()) {
                n = this.components.size();
            }
            this.components.add(n, uIComponent);
            ((IContainer)this.uiResource).add(uIComponent.getComponentUIResource(), string, n);
            if (iImage != null) {
                ((UITabsetPanel)this).setIconAt(n2, iImage);
            }
        }
    }
}

