/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.celleditor.AbstractNumberCellEditor;
import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxEditor;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.ext.text.NumberFormatter;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.model.ui.IEditorControl;
import javax.rad.ui.IAlignmentConstants;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxNumberCellEditor
extends AbstractNumberCellEditor
implements ICellRenderer<Component> {
    private JLabel cellRenderer = null;
    private NumberFormatter numberFormatter = new NumberFormatter();

    public JVxNumberCellEditor() {
        this(null);
    }

    public JVxNumberCellEditor(String string) {
        this.setNumberFormat(string);
        this.setHorizontalAlignment(2);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, (ICellFormatterEditorListener)iCellEditorListener, iDataRow, string);
    }

    @Override
    public void setNumberFormat(String string) {
        super.setNumberFormat(string);
        this.numberFormatter.setNumberPattern(string);
    }

    @Override
    public Component getCellRendererComponent(Component component, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new DefaultTableCellRenderer();
        }
        this.cellRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.cellRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        try {
            this.cellRenderer.setText(this.numberFormatter.valueToString(iDataRow.getValue(string)));
        }
        catch (Exception exception) {
            this.cellRenderer.setText(null);
        }
        return this.cellRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellEditorHandler
    implements ICellEditorHandler<JComponent>,
    DocumentListener,
    FocusListener,
    KeyListener,
    Runnable {
        private JVxNumberCellEditor cellEditor;
        private ICellFormatterEditorListener cellEditorListener;
        private IAlignmentConstants dynamicAlignment = null;
        private IDataRow dataRow;
        private Border oldBorder;
        private String columnName;
        private JFormattedTextField cellEditorComponent;
        private boolean ignoreEvent;
        private boolean firstEditingStarted = true;

        public CellEditorHandler(JVxNumberCellEditor jVxNumberCellEditor, ICellFormatterEditorListener iCellFormatterEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxNumberCellEditor;
            this.cellEditorListener = iCellFormatterEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            NumberFormatter numberFormatter = new NumberFormatter();
            numberFormatter.setNumberPattern(this.cellEditor.getNumberFormat());
            try {
                numberFormatter.setDataType(this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            this.cellEditorComponent = new JFormattedTextField(numberFormatter);
            this.cellEditorComponent.setColumns(5);
            if (this.cellEditorListener.getControl() instanceof IAlignmentConstants && this.cellEditorListener.getControl() instanceof IEditorControl) {
                this.dynamicAlignment = (IAlignmentConstants)((Object)this.cellEditorListener.getControl());
            } else {
                this.cellEditorComponent.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
            }
            this.cellEditorComponent.getDocument().addDocumentListener(this);
            this.cellEditorComponent.setFocusTraversalKeysEnabled(false);
            this.cellEditorComponent.addFocusListener(this);
            this.cellEditorComponent.addKeyListener(this);
            JVxUtil.installActions(this.cellEditorComponent);
        }

        @Override
        public void uninstallEditor() {
            this.cellEditorComponent.getDocument().removeDocumentListener(this);
            this.cellEditorComponent.removeFocusListener(this);
            this.cellEditorComponent.removeKeyListener(this);
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        @Override
        public void saveEditing() throws ModelException {
            try {
                this.cellEditorComponent.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            IDataType iDataType = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType();
            Object object = this.dataRow.getValue(this.columnName);
            Object object2 = iDataType.convertToTypeClass(this.cellEditorComponent.getValue());
            if (!this.cellEditorListener.isSavingImmediate() || iDataType.compareTo(object, object2) != 0) {
                this.dataRow.setValue(this.columnName, object2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void cancelEditing() throws ModelException {
            if (this.ignoreEvent) return;
            this.ignoreEvent = true;
            try {
                block19: {
                    try {
                        boolean bl;
                        ColumnDefinition columnDefinition = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName);
                        this.cellEditorComponent.setValue(this.dataRow.getValue(this.columnName));
                        Container container = this.cellEditorComponent.getParent();
                        boolean bl2 = bl = container == null || container.isEnabled();
                        if (this.dataRow instanceof IDataBook) {
                            IDataBook iDataBook = (IDataBook)this.dataRow;
                            this.cellEditorComponent.setEditable(bl && iDataBook.isUpdateAllowed() && !columnDefinition.isReadOnly() && iDataBook.getSelectedRow() >= 0);
                        } else {
                            this.cellEditorComponent.setEditable(bl && !columnDefinition.isReadOnly());
                        }
                        this.styleEditor(columnDefinition);
                        if (this.cellEditorComponent.isEditable()) {
                            if (this.cellEditorComponent.hasFocus()) {
                                this.cellEditorComponent.selectAll();
                            } else {
                                this.cellEditorComponent.select(0, 0);
                            }
                        } else {
                            this.cellEditorComponent.select(0, 0);
                        }
                        if (!(container instanceof JComponent)) break block19;
                        this.cellEditorComponent.putClientProperty("tabIndex", ((JComponent)container).getClientProperty("tabIndex"));
                    }
                    catch (Exception exception) {
                        this.cellEditorComponent.setValue(null);
                        this.cellEditorComponent.setEditable(false);
                        this.cellEditorComponent.setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
                        throw new ModelException("Editor cannot be restored!", exception);
                    }
                }
                Object var6_6 = null;
                Container container = this.cellEditorComponent.getParent();
                if (container instanceof JVxEditor) {
                    if (!((JVxEditor)container).isBorderVisible()) {
                        this.oldBorder = this.cellEditorComponent.getBorder();
                        this.cellEditorComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
                    } else if (this.oldBorder != null) {
                        this.cellEditorComponent.setBorder(this.oldBorder);
                    }
                }
                this.firstEditingStarted = true;
                this.ignoreEvent = false;
                return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Container container = this.cellEditorComponent.getParent();
                if (container instanceof JVxEditor) {
                    if (!((JVxEditor)container).isBorderVisible()) {
                        this.oldBorder = this.cellEditorComponent.getBorder();
                        this.cellEditorComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
                    } else if (this.oldBorder != null) {
                        this.cellEditorComponent.setBorder(this.oldBorder);
                    }
                }
                this.firstEditingStarted = true;
                this.ignoreEvent = false;
                throw throwable;
            }
        }

        private void styleEditor(ColumnDefinition columnDefinition) throws ModelException {
            Font font;
            Color color;
            Object object;
            CellFormat cellFormat = null;
            if (this.dataRow instanceof IDataBook) {
                object = (IDataBook)this.dataRow;
                if (this.cellEditorListener.getCellFormatter() != null) {
                    try {
                        cellFormat = this.cellEditorListener.getCellFormatter().getCellFormat((IDataBook)object, object.getDataPage(), (IDataRow)object, this.columnName, object.getSelectedRow(), -1);
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                }
            }
            if (cellFormat == null) {
                object = null;
                color = null;
                font = null;
            } else {
                object = cellFormat.getBackground();
                color = cellFormat.getForeground();
                font = cellFormat.getFont();
            }
            if (font == null) {
                font = ((Component)((Object)this.cellEditorListener)).getFont();
            }
            if (color == null && ((Component)((Object)this.cellEditorListener)).isForegroundSet()) {
                color = ((Component)((Object)this.cellEditorListener)).getForeground();
            }
            if (object == null && ((Component)((Object)this.cellEditorListener)).isBackgroundSet()) {
                object = ((Component)((Object)this.cellEditorListener)).getBackground();
            }
            this.cellEditorComponent.setFont(font);
            if (this.cellEditorComponent.isEditable()) {
                if (object == null) {
                    object = columnDefinition.isNullable() ? JVxUtil.getSystemColor("IControl.background") : JVxUtil.getSystemColor("IControl.mandatoryBackground");
                }
            } else {
                object = JVxUtil.getSystemColor("IControl.readOnlyBackground");
            }
            this.cellEditorComponent.setBackground((Color)object);
            this.cellEditorComponent.setForeground(color);
            if (this.dynamicAlignment != null) {
                int n = this.dynamicAlignment.getHorizontalAlignment();
                if (n == -1) {
                    n = this.cellEditor.getHorizontalAlignment();
                }
                this.cellEditorComponent.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(n));
            }
        }

        @Override
        public void run() {
            try {
                this.saveEditing();
                this.styleEditor(this.dataRow.getRowDefinition().getColumnDefinition(this.columnName));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ignoreEvent = false;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (!this.ignoreEvent && this.cellEditorListener.isSavingImmediate()) {
                    this.ignoreEvent = true;
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (!this.ignoreEvent && this.cellEditorListener.isSavingImmediate()) {
                    this.ignoreEvent = true;
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.cellEditorComponent.isEditable()) {
                this.cellEditorComponent.setText(this.cellEditorComponent.getText());
                this.cellEditorComponent.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.fireEditingComplete("FOCUS_LOST");
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        this.fireEditingComplete("ESCAPE_KEY");
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY");
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY");
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY");
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY");
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
            }
        }

        protected void fireEditingComplete(String string) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                this.cellEditorListener.editingComplete(string);
            }
        }
    }
}

