/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JVxSplitPane
extends JSplitPane {
    public static final int DIVIDER_TOP_LEFT = 0;
    public static final int DIVIDER_BOTTOM_RIGHT = 1;
    public static final int DIVIDER_RELATIVE = 2;
    private static final Dimension NO_MINIMUM_SIZE = new Dimension(0, 0);
    private int dividerAlignment = 2;
    private boolean bUpdateUI = false;

    public JVxSplitPane() {
    }

    public JVxSplitPane(int n) {
        super(n);
    }

    public JVxSplitPane(int n, boolean bl) {
        super(n, bl);
    }

    public JVxSplitPane(int n, Component component, Component component2) {
        super(n, component, component2);
    }

    public JVxSplitPane(int n, boolean bl, Component component, Component component2) {
        super(n, bl, component, component2);
    }

    public void setBorder(Border border) {
        if (this.bUpdateUI) {
            return;
        }
        super.setBorder(border);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        super.addNotify();
        if (this.bUpdateUI) {
            return;
        }
        this.bUpdateUI = true;
        try {
            this.updateUI();
            Object var2_1 = null;
            this.bUpdateUI = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.bUpdateUI = false;
            throw throwable;
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.getBorder() == null) {
            ((BasicSplitPaneUI)this.ui).getDivider().setBorder(BorderFactory.createEmptyBorder());
            ((BasicSplitPaneUI)this.ui).getDivider().setBackground(this.getBackground());
        } else {
            ((BasicSplitPaneUI)this.ui).getDivider().setBackground(this.getBackground());
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.ui instanceof BasicSplitPaneUI && ((BasicSplitPaneUI)this.ui).getDivider() != null) {
            ((BasicSplitPaneUI)this.ui).getDivider().setBackground(color);
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof CoveragePanel)) continue;
            component.setBackground(color);
        }
    }

    public void doLayout() {
        int n;
        int n2;
        Insets insets;
        Serializable serializable;
        if (this.getDividerLocation() < 0) {
            int n3;
            serializable = this.getBounds();
            insets = this.getInsets();
            if (this.getOrientation() == 0) {
                n2 = ((Rectangle)serializable).height;
                if (this.getTopComponent() == null || this.getBottomComponent() == null) {
                    n = 25;
                    n3 = 25;
                } else {
                    n = JVxUtil.getPreferredSize((Component)((Container)this.getTopComponent()).getComponent((int)0)).height;
                    n3 = JVxUtil.getPreferredSize((Component)((Container)this.getBottomComponent()).getComponent((int)0)).height;
                }
            } else {
                n2 = ((Rectangle)serializable).width;
                if (this.getTopComponent() == null || this.getBottomComponent() == null) {
                    n = 25;
                    n3 = 25;
                } else {
                    n = JVxUtil.getPreferredSize((Component)((Container)this.getLeftComponent()).getComponent((int)0)).width;
                    n3 = JVxUtil.getPreferredSize((Component)((Container)this.getRightComponent()).getComponent((int)0)).width;
                }
            }
            if (this.dividerAlignment == 0) {
                this.setDividerLocation(Math.min(n + insets.left + this.getDividerSize(), n2 * 9 / 10));
            } else if (this.dividerAlignment == 1) {
                this.setDividerLocation(Math.max(n2 - n3 - this.getDividerSize() - insets.right, n2 * 1 / 10));
            } else {
                if (n <= 0) {
                    n = 1;
                }
                if (n3 <= 0) {
                    n3 = 1;
                }
                this.setDividerLocation(Math.round((float)n2 * (float)n / (float)(n + n3)) - this.getDividerSize() / 2);
            }
        }
        if (this.getLeftComponent() != null) {
            serializable = ((Container)this.getLeftComponent()).getComponent(0);
            if (((Component)serializable).isMinimumSizeSet()) {
                this.getLeftComponent().setMinimumSize(((Component)serializable).getMinimumSize());
            } else {
                this.getLeftComponent().setMinimumSize(NO_MINIMUM_SIZE);
            }
        }
        if (this.getRightComponent() != null) {
            serializable = ((Container)this.getRightComponent()).getComponent(0);
            if (((Component)serializable).isMinimumSizeSet()) {
                this.getRightComponent().setMinimumSize(((Component)serializable).getMinimumSize());
            } else {
                this.getRightComponent().setMinimumSize(NO_MINIMUM_SIZE);
            }
        }
        super.doLayout();
        insets = this.getInsets();
        n2 = this.getDividerLocation();
        if (this.dividerAlignment == 0 && this.getLeftComponent() != null) {
            Component component = ((Container)this.getLeftComponent()).getComponent(0);
            if (component.isMinimumSizeSet()) {
                int n4;
                Dimension dimension = component.getMinimumSize();
                if (this.getOrientation() == 1) {
                    n = this.getSize().width - this.getDividerSize() - insets.left;
                    n4 = dimension.width + insets.left;
                } else {
                    n = this.getSize().height - this.getDividerSize() - insets.top;
                    n4 = dimension.height + insets.top;
                }
                if (n2 > insets.left && n < n4 && n2 < n) {
                    this.setDividerLocation(n);
                    this.validate();
                }
            }
        } else if (this.dividerAlignment == 1 && this.getRightComponent() != null) {
            Component component = ((Container)this.getRightComponent()).getComponent(0);
            Dimension dimension = component.getMaximumSize();
            if (component.isMaximumSizeSet()) {
                int n5;
                if (this.getOrientation() == 1) {
                    n = this.getSize().width - this.getDividerSize() - insets.right;
                    n5 = n - dimension.width;
                } else {
                    n = this.getSize().height - this.getDividerSize() - insets.bottom;
                    n5 = n - dimension.height;
                }
                if (n2 < n && n5 < insets.left && n2 > insets.left) {
                    this.setDividerLocation(insets.left);
                    this.validate();
                }
            }
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if ("divider".equals(object)) {
            super.addImpl(component, object, n);
        } else {
            CoveragePanel coveragePanel;
            if (component.getParent() instanceof CoveragePanel) {
                coveragePanel = (CoveragePanel)component.getParent();
            } else {
                coveragePanel = new CoveragePanel();
                coveragePanel.add(component, "Center");
            }
            if (this.isBackgroundSet()) {
                coveragePanel.setBackground(this.getBackground());
            }
            super.addImpl(coveragePanel, object, n);
        }
    }

    public void remove(Component component) {
        if (component.getParent() instanceof CoveragePanel && component.getParent().getParent() == this) {
            super.remove(component.getParent());
        } else {
            super.remove(component);
        }
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        if (component instanceof CoveragePanel) {
            ((CoveragePanel)component).removeAll();
        }
    }

    public void setDividerLocation(int n) {
        Component component;
        Insets insets = this.getInsets();
        boolean bl = false;
        if (this.dividerAlignment == 0 && this.getLeftComponent() != null) {
            Component component2 = ((Container)this.getLeftComponent()).getComponent(0);
            if (component2.isMaximumSizeSet()) {
                Dimension dimension = component2.getMaximumSize();
                int n2 = this.getOrientation() == 1 ? dimension.width + insets.left : dimension.height + insets.top;
                if (n > n2) {
                    n = n2;
                    bl = true;
                }
            }
        } else if (this.dividerAlignment == 1 && this.getRightComponent() != null && (component = ((Container)this.getRightComponent()).getComponent(0)).isMaximumSizeSet()) {
            Dimension dimension = component.getMaximumSize();
            int n3 = this.getOrientation() == 1 ? this.getSize().width - dimension.width - insets.right - this.getDividerSize() : this.getSize().height - dimension.height - insets.bottom - this.getDividerSize();
            if (n < n3) {
                n = n3;
                bl = true;
            }
        }
        super.setDividerLocation(n);
        if (bl) {
            this.validate();
        }
    }

    public void setDividerSize(int n) {
        super.setDividerSize(n);
        if (n <= 1) {
            this.setOneTouchExpandable(false);
        } else {
            this.setOneTouchExpandable(true);
        }
    }

    public int getDividerAlignment() {
        return this.dividerAlignment;
    }

    public void setDividerAlignment(int n) {
        this.dividerAlignment = n;
        switch (this.dividerAlignment) {
            case 0: {
                this.setResizeWeight(0.0);
                break;
            }
            case 1: {
                this.setResizeWeight(1.0);
                break;
            }
            default: {
                this.setResizeWeight(0.5);
            }
        }
    }

    public static class CoveragePanel
    extends JPanel {
        public CoveragePanel() {
            super(new BorderLayout());
        }

        public void remove(Component component) {
            super.remove(component);
            this.removeFromParent();
        }

        public void remove(int n) {
            super.remove(n);
            this.removeFromParent();
        }

        public void removeAll() {
            super.removeAll();
            this.removeFromParent();
        }

        private void removeFromParent() {
            Container container = this.getParent();
            if (container != null) {
                container.remove(this);
            }
        }
    }
}

