/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.celleditor;

import com.sibvisions.rad.ui.celleditor.AbstractComboCellEditor;
import com.sibvisions.util.type.CommonUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.rad.model.ColumnView;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.condition.ICondition;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.ui.IDimension;
import javax.rad.ui.celleditor.ILinkedCellEditor;

public abstract class AbstractLinkedCellEditor
extends AbstractComboCellEditor
implements ILinkedCellEditor {
    protected boolean autoTableHeaderVisibility = true;
    protected ICondition additionalCondition;
    protected ColumnView columnView;
    protected String displayReferencedColumnName = null;
    protected ReferenceDefinition linkReference;
    protected IDimension popupSize;
    protected ColumnMapping searchColumnMapping;
    protected boolean searchTextAnywhere = true;
    protected boolean sortByColumnName;
    protected boolean tableHeaderVisible = false;
    protected boolean tableReadOnly = true;
    protected boolean validationEnabled = true;
    private Map<String, Integer> displayValueCache = new HashMap<String, Integer>();
    private String lastColumnForSearch = null;
    private String lastDisplayColumn = null;
    private WeakReference<IDataPage> lastPageForSearch = null;
    private int lastSearchRow = 0;

    protected AbstractLinkedCellEditor() {
    }

    public ICondition getAdditionalCondition() {
        return this.additionalCondition;
    }

    public ColumnView getColumnView() {
        return this.columnView;
    }

    public String getDisplayReferencedColumnName() {
        return this.displayReferencedColumnName;
    }

    public ReferenceDefinition getLinkReference() {
        return this.linkReference;
    }

    public IDimension getPopupSize() {
        return this.popupSize;
    }

    public ColumnMapping getSearchColumnMapping() {
        return this.searchColumnMapping;
    }

    public boolean isSearchTextAnywhere() {
        return this.searchTextAnywhere;
    }

    public boolean isSortByColumnName() {
        return this.sortByColumnName;
    }

    public boolean isTableHeaderVisible() {
        return this.tableHeaderVisible;
    }

    public boolean isTableReadonly() {
        return this.tableReadOnly;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setAdditionalCondition(ICondition iCondition) {
        this.additionalCondition = iCondition;
    }

    public void setColumnView(ColumnView columnView) {
        this.columnView = columnView;
    }

    public void setDisplayReferencedColumnName(String string) {
        this.displayReferencedColumnName = string;
    }

    public void setLinkReference(ReferenceDefinition referenceDefinition) {
        this.linkReference = referenceDefinition;
    }

    public void setPopupSize(IDimension iDimension) {
        this.popupSize = iDimension;
    }

    public void setSearchColumnMapping(ColumnMapping columnMapping) {
        this.searchColumnMapping = columnMapping;
    }

    public void setSearchTextAnywhere(boolean bl) {
        this.searchTextAnywhere = bl;
    }

    public void setSortByColumnName(boolean bl) {
        this.sortByColumnName = bl;
    }

    public void setTableHeaderVisible(boolean bl) {
        this.autoTableHeaderVisibility = false;
        this.tableHeaderVisible = bl;
    }

    public void setTableReadonly(boolean bl) {
        this.tableReadOnly = bl;
    }

    public void setValidationEnabled(boolean bl) {
        this.validationEnabled = bl;
    }

    public boolean isDirectCellEditor() {
        return false;
    }

    protected String getDisplayValue(IDataRow iDataRow, String string) throws ModelException {
        return this.getDisplayValue(iDataRow.getValueAsString(string), string);
    }

    protected String getDisplayValue(String string, String string2) throws ModelException {
        if (this.displayReferencedColumnName != null && this.linkReference != null) {
            String string3;
            Integer n = this.displayValueCache.get(string);
            IDataBook iDataBook = this.linkReference.getReferencedDataBook();
            IDataPage iDataPage = iDataBook.getDataPage();
            IChangeableDataRow iChangeableDataRow = null;
            if (n != null) {
                iChangeableDataRow = iDataBook.getDataRow(n);
            }
            String string4 = this.linkReference.getReferencedColumnName(string2);
            if (iDataBook.getFilter() != null) {
                iDataBook.setFilter(null);
            }
            if (this.lastPageForSearch != null && this.lastPageForSearch.get() != iDataPage || !CommonUtil.equals(string4, this.lastColumnForSearch) || !CommonUtil.equals(this.displayReferencedColumnName, this.lastDisplayColumn) || iChangeableDataRow != null && !CommonUtil.equals(iChangeableDataRow.getValue(string4), string)) {
                this.displayValueCache.clear();
                this.lastPageForSearch = new WeakReference<IDataPage>(iDataPage);
                this.lastColumnForSearch = string4;
                this.lastDisplayColumn = this.displayReferencedColumnName;
                this.lastSearchRow = 0;
                n = null;
            }
            if (n == null) {
                IChangeableDataRow iChangeableDataRow2 = iDataBook.getDataRow(this.lastSearchRow);
                while (iChangeableDataRow2 != null) {
                    String string5 = iChangeableDataRow2.getValueAsString(string4);
                    String string6 = iChangeableDataRow2.getValueAsString(this.displayReferencedColumnName);
                    this.displayValueCache.put(string5, this.lastSearchRow);
                    if ((string == string5 || string != null && string.equals(string5)) && string6 != null) {
                        return string6;
                    }
                    ++this.lastSearchRow;
                    iChangeableDataRow2 = iDataBook.getDataRow(this.lastSearchRow);
                }
            } else if (iChangeableDataRow != null && (string3 = iChangeableDataRow.getValueAsString(this.displayReferencedColumnName)) != null) {
                return string3;
            }
        }
        return string;
    }
}

