/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.GenericBean;
import com.sibvisions.rad.server.ILifeCycleObject;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.SessionContextImpl;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.annotation.Accessible;
import com.sibvisions.rad.server.annotation.NotAccessible;
import com.sibvisions.rad.server.annotation.Replacement;
import com.sibvisions.rad.server.annotation.StrictIsolation;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.security.IObjectAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.InjectObject;
import javax.rad.server.SessionContext;
import javax.rad.server.UnknownObjectException;
import javax.rad.server.event.ISessionListener;
import javax.rad.type.bean.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectProvider
extends AbstractObjectProvider
implements ISessionListener {
    private ILogger log = LoggerFactory.getInstance(this.getClass());
    private Hashtable<String, Map> htApplicationObjects = null;
    private Hashtable<Object, Map> htSessionObjects = null;
    private IObjectAccessController oaController = null;
    private WeakHashMap<Class<?>, WeakReference<Method>> whmpConstruct;
    private WeakHashMap<Class<?>, List<WeakReference<Method>>> whmpDestroy;

    protected DefaultObjectProvider(Server server) {
        super(server);
        server.getSessionManager().addSessionListener(this);
        try {
            String string = Configuration.getServerZone().getProperty("/server/objectprovider/accesscontroller");
            if (!StringUtil.isEmpty(string)) {
                this.oaController = (IObjectAccessController)Reflective.construct(string, new Object[0]);
                this.log.debug("Use ", string, " as ObjectAccessController");
            }
        }
        catch (Throwable throwable) {
            this.log.debug("Can't use configured ObjectAccessController!", throwable);
            this.oaController = null;
        }
    }

    @Override
    public void sessionCreated(ISession iSession) {
    }

    @Override
    public void sessionDestroyed(ISession iSession) {
        this.destroySession(iSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(ISession iSession, String string) throws Throwable {
        ISession iSession2 = iSession;
        synchronized (iSession2) {
            Map map = this.getSessionObject(iSession);
            if (map instanceof ImplicitLifeCycleObject) {
                throw new ClassNotFoundException("Missing instance name");
            }
            if (string == null || string.trim().length() == 0) {
                if (map == null) {
                    throw new UnknownObjectException(iSession.getLifeCycleName());
                }
                return map;
            }
            ArrayUtil<String> arrayUtil = StringUtil.separateList(string, ".", true);
            Object object = map;
            StringBuilder stringBuilder = new StringBuilder();
            SessionContextImpl sessionContextImpl = (SessionContextImpl)SessionContext.getCurrentInstance();
            String string2 = sessionContextImpl.getMethodName();
            sessionContextImpl.setMethodName(null);
            IObjectAccessController iObjectAccessController = this.getObjectAccessController();
            int n = arrayUtil.size();
            for (int i = 0; i < n; ++i) {
                String string3;
                block16: {
                    string3 = arrayUtil.get(i);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(".");
                    }
                    stringBuilder.append(string3);
                    sessionContextImpl.setObjectName(stringBuilder.toString());
                    if (i == n - 1) {
                        sessionContextImpl.setMethodName(string2);
                    }
                    if (object == null) {
                        throw new UnknownObjectException(stringBuilder.toString());
                    }
                    try {
                        String string4 = StringUtil.formatMethodName("get", string3);
                        Method method = Reflective.getMethod(object.getClass(), string4, new Class[0]);
                        object = i > 0 ? this.invokeSubMethod(method, object, stringBuilder) : this.invokeMethod(method, object, stringBuilder);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Method[] methodArray;
                        boolean bl = false;
                        if (i == 0 && (methodArray = object.getClass().getMethods()) != null) {
                            for (int j = 0; j < methodArray.length && !bl; ++j) {
                                Replacement replacement;
                                if (methodArray[j].getParameterTypes().length != 0 || methodArray[j].getReturnType() == Void.TYPE || (replacement = methodArray[j].getAnnotation(Replacement.class)) == null || !string3.equals(replacement.name())) continue;
                                object = i > 0 ? this.invokeSubMethod(methodArray[j], object, stringBuilder) : this.invokeMethod(methodArray[j], object, stringBuilder);
                                bl = true;
                            }
                        }
                        if (bl) break block16;
                        if (object instanceof Map) {
                            Object v = object.get(string3);
                            if (v == null && !((Map)object).containsKey(string3)) {
                                throw new UnknownObjectException(string3);
                            }
                            object = v;
                        }
                        throw new UnknownObjectException(string3, noSuchMethodException);
                    }
                }
                if (iObjectAccessController == null || iObjectAccessController.isObjectAccessAllowed(this, iSession, map, stringBuilder.toString(), object)) continue;
                throw new SecurityException("Access to '" + string3 + "' is denied!");
            }
            return object;
        }
    }

    @Override
    public Object putObject(ISession iSession, String string, Object object) throws Throwable {
        if (string == null) {
            return null;
        }
        ISession iSession2 = iSession;
        synchronized (iSession2) {
            String string2;
            Object object2;
            int n = string.lastIndexOf(".");
            if (n > 0) {
                SessionContextImpl sessionContextImpl = (SessionContextImpl)SessionContext.getCurrentInstance();
                String string3 = sessionContextImpl.getMethodName();
                sessionContextImpl.setMethodName(null);
                object2 = this.getObject(iSession, string.substring(0, n));
                sessionContextImpl.setMethodName(string3);
                string2 = string.substring(n + 1);
            } else {
                object2 = this.getSessionObject(iSession);
                string2 = string;
            }
            try {
                return Reflective.call(object2, StringUtil.formatMethodName("set", string2), object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (object2 instanceof Map) {
                    return object2.put(string2, object);
                }
                throw new RuntimeException("Can't set object '" + string + "'", noSuchMethodException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(ISession iSession, String string, String string2, Object ... objectArray) throws Throwable {
        Object object = this.getObject(iSession, string);
        try {
            block9: {
                Object object2;
                if (object == null) {
                    throw new RuntimeException("The Object '" + string + "' is known but 'null' was returned!");
                }
                IObjectAccessController iObjectAccessController = this.getObjectAccessController();
                if (iObjectAccessController != null && !iObjectAccessController.isMethodInvocationAllowed(this, iSession, string, object, string2, objectArray)) {
                    throw new SecurityException("Invocation of '" + string2 + "' is not allowed!");
                }
                try {
                    if (!(object instanceof GenericBean)) break block9;
                    object2 = ((GenericBean)object).invoke(string2, objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method[] methodArray = object.getClass().getDeclaredMethods();
                    if (methodArray == null) throw noSuchMethodException;
                    int n = 0;
                    while (n < methodArray.length) {
                        Replacement replacement = methodArray[n].getAnnotation(Replacement.class);
                        if (replacement != null && string2.equals(replacement.name())) {
                            Object object3 = Reflective.call(object, true, methodArray[n].getName(), objectArray);
                            Object var13_12 = null;
                            if (this.getServer().getSessionManager().isAvailable(iSession)) return object3;
                            this.destroySession(iSession);
                            return object3;
                        }
                        ++n;
                    }
                    throw noSuchMethodException;
                }
                Object var13_10 = null;
                if (this.getServer().getSessionManager().isAvailable(iSession)) return object2;
                this.destroySession(iSession);
                return object2;
            }
            Object object4 = Reflective.call(object, string2, objectArray);
            Object var13_11 = null;
            if (this.getServer().getSessionManager().isAvailable(iSession)) return object4;
            this.destroySession(iSession);
            return object4;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (this.getServer().getSessionManager().isAvailable(iSession)) throw throwable;
            this.destroySession(iSession);
            throw throwable;
        }
    }

    @Override
    public Server getServer() {
        return (Server)super.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getSessionObject(ISession iSession) throws Exception {
        ISession iSession2 = iSession;
        synchronized (iSession2) {
            Map map = null;
            AbstractSession abstractSession = (AbstractSession)iSession;
            if (this.htSessionObjects != null) {
                map = this.htSessionObjects.get(abstractSession.getId());
            }
            if (map == null) {
                map = this.initSessionObject(abstractSession, true);
            } else {
                this.updateSessionObject(abstractSession, map);
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map initSessionObject(AbstractSession abstractSession, boolean bl) throws Exception {
        AbstractSession abstractSession2 = abstractSession;
        synchronized (abstractSession2) {
            if (abstractSession instanceof SubSession) {
                Map map = this.createInstance(abstractSession, abstractSession.getLifeCycleName());
                if (!this.isIsolated(map)) {
                    MasterSession masterSession = ((SubSession)abstractSession).getMasterSession();
                    Map map2 = null;
                    MasterSession masterSession2 = masterSession;
                    synchronized (masterSession2) {
                        if (this.htSessionObjects != null) {
                            map2 = this.htSessionObjects.get(masterSession.getId());
                        }
                        if (map2 == null) {
                            SessionContext sessionContext = masterSession.createSessionContext(null, null);
                            try {
                                map2 = this.initSessionObject(masterSession, false);
                                Object var10_11 = null;
                                sessionContext.release();
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                sessionContext.release();
                                throw throwable;
                            }
                        }
                    }
                    this.setParent(abstractSession, map, map2);
                }
                if (bl) {
                    abstractSession.getCallHandler().postObjectCreation();
                }
                if (this.htSessionObjects == null) {
                    this.htSessionObjects = new Hashtable();
                }
                this.htSessionObjects.put(abstractSession.getId(), map);
                this.injectObjects(abstractSession, map);
                return map;
            }
            String string = abstractSession.getLifeCycleName();
            Map<String, Object> map = !StringUtil.isEmpty(string) ? this.createInstance(abstractSession, string) : new ImplicitLifeCycleObject();
            if (!this.isIsolated(map)) {
                this.setParent(abstractSession, map, this.getApplicationObject(abstractSession));
            }
            if (this.htSessionObjects == null) {
                this.htSessionObjects = new Hashtable();
            }
            this.htSessionObjects.put(abstractSession.getId(), map);
            if (bl) {
                abstractSession.getCallHandler().postObjectCreation();
            }
            this.injectObjects(abstractSession, map);
            return map;
        }
    }

    private void updateSessionObject(AbstractSession abstractSession, Map map) throws Exception {
        List<Map.Entry<String, InjectObject>> list = abstractSession.getChangedInjectObjects();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Map.Entry<String, InjectObject> entry = list.get(i);
                InjectObject injectObject = entry.getValue();
                if (injectObject == null) {
                    map.remove(entry.getKey());
                    continue;
                }
                map.put(injectObject.getName(), injectObject.getObject());
            }
        }
    }

    protected synchronized Map getApplicationObject(AbstractSession abstractSession) throws Exception {
        Map map = null;
        String string = abstractSession.getApplicationName();
        if (this.htApplicationObjects != null) {
            map = this.htApplicationObjects.get(string);
        }
        if (map == null) {
            map = this.initApplicationObject(abstractSession);
        }
        return map;
    }

    private Map initApplicationObject(AbstractSession abstractSession) throws Exception {
        String string = abstractSession.getApplicationZone().getProperty("/application/lifecycle/application");
        if (!StringUtil.isEmpty(string)) {
            try {
                Map map = this.createInstance(abstractSession, string);
                if (this.htApplicationObjects == null) {
                    this.htApplicationObjects = new Hashtable();
                }
                this.htApplicationObjects.put(abstractSession.getApplicationName(), map);
                return map;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error("Application object '" + string + "' was not found!", classNotFoundException);
                return null;
            }
        }
        return null;
    }

    protected Map createInstance(AbstractSession abstractSession, String string) throws Exception {
        if (string != null) {
            WeakReference<Method> weakReference;
            Object obj;
            Class<?> clazz;
            ClassLoader classLoader = this.getClassLoader(abstractSession);
            if (classLoader == null) {
                clazz = Class.forName(string);
                obj = clazz.newInstance();
            } else {
                clazz = Class.forName(string, true, classLoader);
                obj = clazz.newInstance();
            }
            if (!(obj instanceof Map)) {
                throw new RuntimeException("The lifecycle object '" + string + "' has to be a Map!");
            }
            Method method = null;
            boolean bl = false;
            if (this.whmpConstruct != null) {
                weakReference = this.whmpConstruct.get(clazz);
                if (weakReference == null) {
                    bl = this.whmpConstruct.containsKey(clazz);
                } else {
                    method = (Method)weakReference.get();
                }
            }
            if (!bl) {
                if (method == null) {
                    weakReference = new ArrayUtil();
                    for (Method method2 : clazz.getDeclaredMethods()) {
                        if (method2.getParameterTypes().length != 0 || !method2.getReturnType().equals(Void.TYPE) || Modifier.isStatic(method2.getModifiers())) continue;
                        if (method2.isAnnotationPresent(PostConstruct.class)) {
                            if (method != null) {
                                throw new IllegalStateException("It's not allowed to define @PostConstrut on more than one method!");
                            }
                            method = method2;
                        }
                        if (!method2.isAnnotationPresent(PreDestroy.class)) continue;
                        weakReference.add(new WeakReference<Method>(method2));
                    }
                    if (this.whmpConstruct == null) {
                        this.whmpConstruct = new WeakHashMap();
                    }
                    if (method == null) {
                        this.whmpConstruct.put(clazz, null);
                    } else {
                        this.whmpConstruct.put(clazz, new WeakReference<Method>(method));
                    }
                    if (this.whmpDestroy == null) {
                        this.whmpDestroy = new WeakHashMap();
                    }
                    if (weakReference.isEmpty()) {
                        this.whmpDestroy.put(clazz, null);
                    } else {
                        this.whmpDestroy.put(clazz, (List<WeakReference<Method>>)((Object)weakReference));
                    }
                }
                if (method != null) {
                    try {
                        Reflective.invoke(obj, method, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof Exception) {
                            throw (Exception)throwable;
                        }
                        throw new RuntimeException(throwable);
                    }
                }
            }
            return (Map)obj;
        }
        throw new ClassNotFoundException("Missing instance name");
    }

    protected ClassLoader getClassLoader(AbstractSession abstractSession) {
        return null;
    }

    protected boolean isIsolated(Object object) {
        return object != null && this.isIsolated(object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIsolated(AbstractSession abstractSession) {
        AbstractObjectProvider abstractObjectProvider = abstractSession.getObjectProvider();
        if (abstractObjectProvider instanceof DefaultObjectProvider) {
            DefaultObjectProvider defaultObjectProvider = (DefaultObjectProvider)abstractObjectProvider;
            AbstractSession abstractSession2 = abstractSession;
            synchronized (abstractSession2) {
                Object object;
                if (defaultObjectProvider.htSessionObjects != null && (object = defaultObjectProvider.htSessionObjects.get(abstractSession.getId())) != null) {
                    return defaultObjectProvider.isIsolated(object);
                }
                object = abstractSession.getLifeCycleName();
                if (object != null) {
                    Class<?> clazz;
                    try {
                        ClassLoader classLoader = defaultObjectProvider.getClassLoader(abstractSession);
                        clazz = classLoader == null ? Class.forName((String)object) : Class.forName((String)object, true, classLoader);
                    }
                    catch (Exception exception) {
                        defaultObjectProvider.log.equals(exception);
                        return false;
                    }
                    return defaultObjectProvider.isIsolated(clazz);
                }
            }
        }
        return false;
    }

    private boolean isIsolated(Class<?> clazz) {
        return clazz != null && clazz.getAnnotation(StrictIsolation.class) != null;
    }

    protected void setParent(ISession iSession, Map map, Map map2) {
        if (map2 != null) {
            if (map instanceof GenericBean && map2 instanceof Bean) {
                ((GenericBean)map).setParent((Bean)map2);
            } else {
                this.log.info("Can't set parent for: ", iSession.getLifeCycleName(), " because the life-cycle object is not instance of GenericBean");
            }
        }
    }

    private void injectObjects(AbstractSession abstractSession, Map map) throws Exception {
        Enumeration<InjectObject> enumeration = abstractSession.getInjectObjects();
        while (enumeration.hasMoreElements()) {
            InjectObject injectObject = enumeration.nextElement();
            String string = injectObject.getName();
            map.put(string, injectObject.getObject());
        }
    }

    private void removeInjectedObjects(AbstractSession abstractSession, Map map) throws Exception {
        Enumeration<InjectObject> enumeration = abstractSession.getInjectObjects();
        while (enumeration.hasMoreElements()) {
            InjectObject injectObject = enumeration.nextElement();
            if (!injectObject.isExternal()) continue;
            String string = injectObject.getName();
            map.remove(string);
        }
    }

    public void setObjectAccessController(IObjectAccessController iObjectAccessController) {
        this.oaController = iObjectAccessController;
    }

    public IObjectAccessController getObjectAccessController() {
        return this.oaController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void destroySession(ISession iSession) {
        Object object;
        Map map;
        if (this.htSessionObjects == null || (map = this.htSessionObjects.remove(iSession.getId())) == null) return;
        if (this.whmpDestroy != null && (object = this.whmpDestroy.get(map.getClass())) != null) {
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                Method method = (Method)((WeakReference)object.get(i)).get();
                if (method == null) continue;
                try {
                    Reflective.invoke(map, method, new Object[0]);
                    continue;
                }
                catch (Throwable throwable) {
                    this.log.debug(throwable);
                }
            }
        }
        if (map instanceof ILifeCycleObject) {
            boolean bl;
            object = SessionContext.getCurrentInstance();
            if (object == null) {
                object = ((AbstractSession)iSession).createSessionContext(null, "destroy");
                bl = true;
            } else {
                bl = false;
            }
            try {
                try {
                    this.removeInjectedObjects((AbstractSession)iSession, map);
                    ((ILifeCycleObject)((Object)map)).destroy();
                }
                catch (Throwable throwable) {
                    this.log.debug(throwable);
                    Object var9_11 = null;
                    if (!bl) return;
                    ((SessionContext)object).release();
                    return;
                }
                Object var9_10 = null;
                if (!bl) return;
                ((SessionContext)object).release();
                return;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (!bl) throw throwable;
                ((SessionContext)object).release();
                throw throwable;
            }
        } else {
            if (map.isEmpty()) return;
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                CommonUtil.close(((Map.Entry)object.next()).getValue());
            }
        }
    }

    private Object invokeMethod(Method method, Object object, StringBuilder stringBuilder) throws Exception {
        if (method.isAnnotationPresent(NotAccessible.class)) {
            throw new SecurityException("Access to " + stringBuilder + " denied!");
        }
        return method.invoke(object, new Object[0]);
    }

    private Object invokeSubMethod(Method method, Object object, StringBuilder stringBuilder) throws Exception {
        if (!method.isAnnotationPresent(Accessible.class)) {
            throw new SecurityException("Access to " + stringBuilder + " denied!");
        }
        return method.invoke(object, new Object[0]);
    }

    public static final class ImplicitLifeCycleObject
    extends GenericBean {
    }
}

