/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleSerializer
implements ITypeSerializer<Double> {
    private static final int TYPE_DOUBLE = 7;
    private static final int TYPE_DOUBLE_0 = 8;
    private static final Double DOUBLE_0 = 0.0;

    @Override
    public Class<Double> getTypeClass() {
        return Double.class;
    }

    @Override
    public int getMinValue() {
        return 7;
    }

    @Override
    public int getMaxValue() {
        return 8;
    }

    @Override
    public Double read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        if (n == 7) {
            return dataInputStream.readDouble();
        }
        return DOUBLE_0;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Double d, TypeCache typeCache) throws Exception {
        double d2 = d;
        if (d2 == 0.0) {
            dataOutputStream.writeByte(8);
        } else {
            dataOutputStream.writeByte(7);
            dataOutputStream.writeDouble(d2);
        }
    }
}

