/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.rad.persist.jdbc.param.AbstractParam;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.model.condition.ICondition;
import javax.rad.persist.DataSourceException;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.BeanType;
import javax.rad.type.bean.IBean;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDBAccess
extends DBAccess {
    private static String sUKSelect = "SELECT c.constraint_name FROM all_constraints c WHERE c.constraint_type = 'U' AND c.table_name = ? AND c.owner = ?";
    private static String sConstraintColumnsSelect = "SELECT c.column_name ,c.table_name FROM all_cons_columns c WHERE c.owner = ? AND c.constraint_name = ? ORDER BY POSITION";
    private static String sPKSelect = "SELECT c.constraint_name FROM all_constraints c WHERE c.constraint_type = 'P' AND c.table_name = ? AND c.owner = ?";
    private static String sFKSelect = "SELECT c.constraint_name fk_name ,c.r_owner pktable_schem ,c.r_constraint_name pk_name FROM all_constraints c WHERE c.constraint_type = 'R' AND c.table_name = ? AND c.owner = ?";
    private static String sCheckSelect = "select c.search_condition from all_constraints c where c.constraint_type = 'C' and c.generated = 'USER NAME' and c.table_name = ? and c.owner = ?";
    private static String sDefaultValueSelect = "select c.column_name, c.data_type, c.data_default from all_tab_columns c where c.data_default is not null and c.table_name = ? and c.owner = ?";
    private static String sSynonymSelect = "select s.table_owner, s.table_name, s.db_link FROM user_synonyms s WHERE s.synonym_name = ?";

    public OracleDBAccess() {
        this.setDriver("oracle.jdbc.OracleDriver");
        this.configureTnsAdmin();
    }

    @Override
    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return super.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition) + " NOWAIT";
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertOracle(string, string2, serverMetaData, objectArray, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object executeFunction(String string, int n, Object ... objectArray) throws SQLException {
        int n2;
        AbstractParam.ParameterType parameterType;
        AbstractParam abstractParam;
        Record record = ProtocolFactory.openRecord("DB", "EXECUTE_FUNCTION", new Object[0]);
        if (record != null) {
            if (objectArray != null && objectArray.length > 0) {
                record.setParameter(string, objectArray);
            } else {
                record.setParameter(string);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder("begin ? := ");
        StringBuilder stringBuilder3 = new StringBuilder();
        if (n == 16) {
            stringBuilder2.append("sys.diutil.bool_to_int(");
        }
        stringBuilder2.append(string);
        int[] nArray = new int[]{};
        if (objectArray != null && objectArray.length > 0) {
            stringBuilder2.append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder2.append(", ");
                }
                if (objectArray[i] instanceof AbstractParam) {
                    abstractParam = (AbstractParam)objectArray[i];
                    parameterType = abstractParam.getType();
                    if ((parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) && abstractParam.getSqlType() == 16) {
                        if (stringBuilder.length() == 0) {
                            stringBuilder.append("declare ");
                        }
                        String string2 = "bool" + nArray.length;
                        stringBuilder2.append(string2);
                        stringBuilder.append(string2).append(" boolean := sys.diutil.int_to_bool(?); ");
                        stringBuilder3.append("? := sys.diutil.bool_to_int(").append(string2).append(");");
                        nArray = ArrayUtil.add(nArray, i);
                        continue;
                    }
                    if (abstractParam.getSqlType() == 16 || abstractParam.getValue() instanceof Boolean) {
                        stringBuilder2.append("sys.diutil.int_to_bool(?)");
                        continue;
                    }
                    stringBuilder2.append("?");
                    continue;
                }
                if (objectArray[i] instanceof Boolean) {
                    stringBuilder2.append("sys.diutil.int_to_bool(?)");
                    continue;
                }
                stringBuilder2.append("?");
            }
            stringBuilder2.append(")");
        }
        if (n == 16) {
            stringBuilder2.append(")");
        }
        stringBuilder2.append("; ");
        stringBuilder2.insert(0, stringBuilder);
        stringBuilder2.append((CharSequence)stringBuilder3);
        stringBuilder2.append(" end;");
        CallableStatement callableStatement = null;
        OracleDBAccess.debug("executeFunction -> ", stringBuilder2);
        callableStatement = this.getConnection().prepareCall(this.translateQuotes(stringBuilder2.toString()));
        if (n == 16) {
            callableStatement.registerOutParameter(nArray.length + 1, 4);
        } else {
            callableStatement.registerOutParameter(nArray.length + 1, n);
        }
        int n3 = 0;
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            int n4;
            Object object;
            n2 = i + nArray.length - n3 + 2;
            if (nArray.length > 0 && nArray[n3] == i) {
                callableStatement.registerOutParameter(objectArray.length + n3 + 2, 4);
                object = ((AbstractParam)objectArray[i]).getValue();
                if (object == null) {
                    callableStatement.setNull(n3 + 1, 4);
                } else {
                    n4 = 0;
                    if (object instanceof Boolean && (Boolean)object != false || object instanceof Number && ((Number)object).intValue() != 0 || object instanceof String && Boolean.valueOf((String)object).booleanValue()) {
                        n4 = 1;
                    }
                    callableStatement.setObject(n3 + 1, (Object)n4);
                }
                ++n3;
                continue;
            }
            if (objectArray[i] == null) {
                callableStatement.setNull(n2, 12);
                continue;
            }
            if (objectArray[i] instanceof AbstractParam) {
                abstractParam = (AbstractParam)objectArray[i];
                parameterType = abstractParam.getType();
                if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                    if (abstractParam.getArrayType() != null) {
                        callableStatement.registerOutParameter(n2, abstractParam.getSqlType(), abstractParam.getArrayType());
                    } else {
                        callableStatement.registerOutParameter(n2, abstractParam.getSqlType());
                    }
                }
                if (abstractParam.getValue() == null) {
                    if (abstractParam.getArrayType() != null) {
                        callableStatement.setNull(n2, abstractParam.getSqlType(), abstractParam.getArrayType());
                        continue;
                    }
                    if (abstractParam.getSqlType() == 16) {
                        callableStatement.setNull(n2, 4);
                        continue;
                    }
                    callableStatement.setNull(n2, abstractParam.getSqlType());
                    continue;
                }
                if (abstractParam.getSqlType() == 16 || abstractParam.getValue() instanceof Boolean) {
                    object = abstractParam.getValue();
                    n4 = 0;
                    if (object instanceof Boolean && (Boolean)object != false || object instanceof Number && ((Number)object).intValue() != 0 || object instanceof String && Boolean.valueOf((String)object).booleanValue()) {
                        n4 = 1;
                    }
                    callableStatement.setObject(n2, (Object)n4, 4);
                    continue;
                }
                callableStatement.setObject(n2, this.convertValueToDatabaseSpecificObject(this.convertToArray(abstractParam)), abstractParam.getSqlType());
                continue;
            }
            if (objectArray[i] instanceof Boolean) {
                callableStatement.setObject(n2, (Object)((Boolean)objectArray[i] != false ? Integer.valueOf(1) : Integer.valueOf(0)));
                continue;
            }
            callableStatement.setObject(n2, this.convertValueToDatabaseSpecificObject(objectArray[i]));
        }
        if (callableStatement.execute()) {
            CommonUtil.close(callableStatement.getResultSet());
        }
        Object object = callableStatement.getObject(nArray.length + 1);
        if (n == 16 && object != null) {
            object = ((Number)object).intValue() != 0;
        }
        n3 = 0;
        for (n2 = 0; objectArray != null && n2 < objectArray.length; ++n2) {
            int n5 = n2 + nArray.length - n3 + 2;
            if (nArray.length > 0 && nArray[n3] == n2) {
                abstractParam = (AbstractParam)objectArray[n2];
                Object object2 = callableStatement.getObject(objectArray.length + n3 + 2);
                if (object2 instanceof Number) {
                    abstractParam.setValue(((Number)object2).intValue() != 0);
                } else {
                    abstractParam.setValue(null);
                }
                ++n3;
                continue;
            }
            if (!(objectArray[n2] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[n2]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
            abstractParam.setValue(this.convertArrayToList(callableStatement.getObject(n5)));
        }
        Object object3 = object;
        CommonUtil.close(callableStatement);
        CommonUtil.close(record);
        return object3;
        {
            catch (Throwable throwable) {
                try {
                    CommonUtil.close(callableStatement);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CommonUtil.close(record);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcedure(String string, Object ... objectArray) throws SQLException {
        Record record = ProtocolFactory.openRecord("DB", "EXECUTE_PROCEDURE", new Object[0]);
        try {
            AbstractParam.ParameterType parameterType;
            AbstractParam abstractParam;
            if (record != null) {
                if (objectArray != null && objectArray.length > 0) {
                    record.setParameter(string, objectArray);
                } else {
                    record.setParameter(string);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder("begin ");
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder2.append(string);
            int[] nArray = new int[]{};
            if (objectArray != null && objectArray.length > 0) {
                stringBuilder2.append("(");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder2.append(", ");
                    }
                    if (objectArray[i] instanceof AbstractParam) {
                        abstractParam = (AbstractParam)objectArray[i];
                        parameterType = abstractParam.getType();
                        if ((parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) && abstractParam.getSqlType() == 16) {
                            if (stringBuilder.length() == 0) {
                                stringBuilder.append("declare ");
                            }
                            String string2 = "bool" + nArray.length;
                            stringBuilder2.append(string2);
                            stringBuilder.append(string2).append(" boolean := sys.diutil.int_to_bool(?); ");
                            stringBuilder3.append("? := sys.diutil.bool_to_int(").append(string2).append(");");
                            nArray = ArrayUtil.add(nArray, i);
                            continue;
                        }
                        if (abstractParam.getSqlType() == 16 || abstractParam.getValue() instanceof Boolean) {
                            stringBuilder2.append("sys.diutil.int_to_bool(?)");
                            continue;
                        }
                        stringBuilder2.append("?");
                        continue;
                    }
                    if (objectArray[i] instanceof Boolean) {
                        stringBuilder2.append("sys.diutil.int_to_bool(?)");
                        continue;
                    }
                    stringBuilder2.append("?");
                }
                stringBuilder2.append(")");
            }
            stringBuilder2.append("; ");
            stringBuilder2.insert(0, stringBuilder);
            stringBuilder2.append((CharSequence)stringBuilder3);
            stringBuilder2.append(" end;");
            CallableStatement callableStatement = null;
            try {
                Object object;
                int n;
                int n2;
                OracleDBAccess.debug("executeProcedure -> ", stringBuilder2);
                callableStatement = this.getConnection().prepareCall(this.translateQuotes(stringBuilder2.toString()));
                int n3 = 0;
                for (n2 = 0; objectArray != null && n2 < objectArray.length; ++n2) {
                    int n4;
                    n = n2 + nArray.length - n3 + 1;
                    if (nArray.length > 0 && nArray[n3] == n2) {
                        callableStatement.registerOutParameter(objectArray.length + n3 + 1, 4);
                        object = ((AbstractParam)objectArray[n2]).getValue();
                        if (object == null) {
                            callableStatement.setNull(n3 + 1, 4);
                        } else {
                            n4 = 0;
                            if (object instanceof Boolean && (Boolean)object != false || object instanceof Number && ((Number)object).intValue() != 0 || object instanceof String && Boolean.valueOf((String)object).booleanValue()) {
                                n4 = 1;
                            }
                            callableStatement.setObject(n3 + 1, (Object)n4);
                        }
                        ++n3;
                        continue;
                    }
                    if (objectArray[n2] == null) {
                        callableStatement.setNull(n, 12);
                        continue;
                    }
                    if (objectArray[n2] instanceof AbstractParam) {
                        abstractParam = (AbstractParam)objectArray[n2];
                        parameterType = abstractParam.getType();
                        if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                            if (abstractParam.getArrayType() != null) {
                                callableStatement.registerOutParameter(n, abstractParam.getSqlType(), abstractParam.getArrayType());
                            } else {
                                callableStatement.registerOutParameter(n, abstractParam.getSqlType());
                            }
                        }
                        if (abstractParam.getValue() == null) {
                            if (abstractParam.getArrayType() != null) {
                                callableStatement.setNull(n, abstractParam.getSqlType(), abstractParam.getArrayType());
                                continue;
                            }
                            if (abstractParam.getSqlType() == 16) {
                                callableStatement.setNull(n, 4);
                                continue;
                            }
                            callableStatement.setNull(n, abstractParam.getSqlType());
                            continue;
                        }
                        if (abstractParam.getSqlType() == 16 || abstractParam.getValue() instanceof Boolean) {
                            object = abstractParam.getValue();
                            n4 = 0;
                            if (object instanceof Boolean && (Boolean)object != false || object instanceof Number && ((Number)object).intValue() != 0 || object instanceof String && Boolean.valueOf((String)object).booleanValue()) {
                                n4 = 1;
                            }
                            callableStatement.setObject(n, (Object)n4, 4);
                            continue;
                        }
                        callableStatement.setObject(n, this.convertValueToDatabaseSpecificObject(this.convertToArray(abstractParam)), abstractParam.getSqlType());
                        continue;
                    }
                    if (objectArray[n2] instanceof Boolean) {
                        callableStatement.setObject(n, (Object)((Boolean)objectArray[n2] != false ? Integer.valueOf(1) : Integer.valueOf(0)));
                        continue;
                    }
                    callableStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[n2]));
                }
                callableStatement.execute();
                n3 = 0;
                for (n2 = 0; objectArray != null && n2 < objectArray.length; ++n2) {
                    n = n2 + nArray.length - n3 + 1;
                    if (nArray.length > 0 && nArray[n3] == n2) {
                        abstractParam = (AbstractParam)objectArray[n2];
                        object = callableStatement.getObject(objectArray.length + n3 + 1);
                        if (object instanceof Number) {
                            abstractParam.setValue(((Number)object).intValue() != 0);
                        } else {
                            abstractParam.setValue(null);
                        }
                        ++n3;
                        continue;
                    }
                    if (!(objectArray[n2] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[n2]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
                    abstractParam.setValue(this.convertArrayToList(callableStatement.getObject(n)));
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(callableStatement);
                throw throwable;
            }
            CommonUtil.close(callableStatement);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    protected Object convertArrayToList(Object object) throws SQLException {
        if (object instanceof ARRAY) {
            ARRAY aRRAY = (ARRAY)object;
            BeanType beanType = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray = (Object[])aRRAY.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 instanceof STRUCT) {
                    int n;
                    String[] stringArray;
                    Object object3;
                    STRUCT sTRUCT = (STRUCT)object2;
                    if (beanType == null) {
                        object3 = sTRUCT.getDescriptor().getMetaData();
                        stringArray = new String[object3.getColumnCount()];
                        for (n = 0; n < stringArray.length; ++n) {
                            stringArray[n] = object3.getColumnName(n + 1);
                        }
                        beanType = new BeanType(stringArray);
                    }
                    object3 = sTRUCT.getAttributes();
                    stringArray = new Bean(beanType);
                    for (n = 0; n < ((Object)object3).length; ++n) {
                        stringArray.put(n, object3[n]);
                    }
                    arrayList.add(stringArray);
                    continue;
                }
                arrayList.add(object2);
            }
            return arrayList;
        }
        return object;
    }

    protected Object convertToArray(AbstractParam abstractParam) throws SQLException {
        Object object = abstractParam.getValue();
        if (abstractParam.getSqlType() == 2003 && object != null) {
            Object[] objectArray;
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)abstractParam.getArrayType(), (Connection)this.getConnection());
            if (object instanceof List) {
                objectArray = ((List)object).toArray();
            } else if (object instanceof Object[]) {
                objectArray = (Object[])((Object[])object).clone();
            } else {
                throw new SQLException("Unsopported array value,only List and Object[] are supported!");
            }
            if (arrayDescriptor.getBaseType() == 2002) {
                int n;
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)arrayDescriptor.getBaseName(), (Connection)this.getConnection());
                ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
                String[] stringArray = new String[resultSetMetaData.getColumnCount()];
                String[] stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = resultSetMetaData.getColumnName(n + 1);
                    stringArray2[n] = StringUtil.convertToMemberName(stringArray[n]);
                }
                for (n = 0; n < objectArray.length; ++n) {
                    String[] stringArray3;
                    IBean iBean;
                    Object object2 = objectArray[n];
                    if (object2 instanceof Object[]) continue;
                    Object[] objectArray2 = new Object[stringArray.length];
                    if (object2 instanceof IBean) {
                        iBean = (IBean)object2;
                        stringArray3 = stringArray;
                    } else {
                        iBean = new Bean(object2);
                        stringArray3 = stringArray2;
                    }
                    for (int i = 0; i < stringArray3.length; ++i) {
                        objectArray2[i] = iBean.get(stringArray3[i]);
                    }
                    objectArray[n] = objectArray2;
                }
            }
            return ((OracleConnection)this.getConnection()).createARRAY(abstractParam.getArrayType(), (Object)objectArray);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void open() throws DataSourceException {
        super.open();
        Statement statement = null;
        try {
            statement = this.getConnectionIntern().createStatement();
            statement.executeUpdate("ALTER SESSION SET NLS_COMP='BINARY'");
            statement.executeUpdate("ALTER SESSION SET NLS_SORT='BINARY'");
        }
        catch (SQLException sQLException) {
            CommonUtil.close(statement);
            catch (Throwable throwable) {
                CommonUtil.close(statement);
                throw throwable;
            }
        }
        CommonUtil.close(statement);
    }

    @Override
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement2 = null;
        try {
            ArrayUtil<Key> arrayUtil = new ArrayUtil<Key>();
            ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sUKSelect);
            preparedStatement2 = this.getPreparedStatement(sConstraintColumnsSelect);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, OracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("CONSTRAINT_NAME");
                preparedStatement2.setString(1, OracleDBAccess.removeQuotes(string2));
                preparedStatement2.setString(2, (String)object);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    arrayUtil2.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                Key key = new Key((String)object, arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                arrayUtil.add(key);
                arrayUtil2.clear();
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Unique Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
        return object;
    }

    @Override
    protected Key getPrimaryKeyIntern(String string, String string2, String string3) throws DataSourceException {
        String string4;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            Key key = null;
            ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sPKSelect);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, OracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string4 = resultSet.getString("CONSTRAINT_NAME");
                CommonUtil.close(resultSet, preparedStatement);
                preparedStatement = this.getPreparedStatement(sConstraintColumnsSelect);
                preparedStatement.setString(1, OracleDBAccess.removeQuotes(string2));
                preparedStatement.setString(2, string4);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    do {
                        arrayUtil.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
                    } while (resultSet.next());
                    if (arrayUtil.size() > 0) {
                        key = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                    }
                }
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getPK(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string4 = key;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Primary Key couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string4;
    }

    @Override
    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement2 = null;
        try {
            ArrayUtil<ForeignKey> arrayUtil = new ArrayUtil<ForeignKey>();
            long l = System.currentTimeMillis();
            String string4 = this.getConnectionIntern().getCatalog();
            preparedStatement = this.getPreparedStatement(sFKSelect);
            preparedStatement2 = this.getPreparedStatement(sConstraintColumnsSelect);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, OracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("FK_NAME");
                String string5 = resultSet.getString("PK_NAME");
                String string6 = resultSet.getString("PKTABLE_SCHEM");
                String string7 = null;
                ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
                ArrayUtil<Name> arrayUtil3 = new ArrayUtil<Name>();
                preparedStatement2.setString(1, OracleDBAccess.removeQuotes(string2));
                preparedStatement2.setString(2, (String)object);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    arrayUtil3.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                preparedStatement2.setString(1, string6);
                preparedStatement2.setString(2, string5);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    if (string7 == null) {
                        string7 = resultSet2.getString("TABLE_NAME");
                    }
                    arrayUtil2.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                if (string7 != null) {
                    ForeignKey foreignKey = new ForeignKey(new Name(string7, this.quote(string7)), new Name(string4, this.quote(string4)), new Name(string6, this.quote(string6)));
                    foreignKey.setFKName((String)object);
                    foreignKey.setFKColumns(arrayUtil3.toArray(new Name[arrayUtil3.size()]));
                    foreignKey.setPKColumns(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                    arrayUtil.add(foreignKey);
                }
                arrayUtil2.clear();
                arrayUtil3.clear();
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
        return object;
    }

    @Override
    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        String string2;
        long l;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            preparedStatement = null;
            resultSet = null;
            l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sSynonymSelect);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block8;
            String string3 = string;
            CommonUtil.close(resultSet, preparedStatement);
            return string3;
        }
        try {
            String string4 = resultSet.getString("TABLE_OWNER");
            String string5 = resultSet.getString("TABLE_NAME");
            String string6 = resultSet.getString("DB_LINK");
            StringBuilder stringBuilder = new StringBuilder();
            if (string4 != null) {
                stringBuilder.append(string4);
                stringBuilder.append('.');
            }
            stringBuilder.append(string5);
            if (string6 != null) {
                stringBuilder.append('@');
                stringBuilder.append(string6);
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getTableForSynonym(", string, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string2 = stringBuilder.toString();
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Synonyms couldn't determined from database! - " + string, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string2;
    }

    @Override
    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<Object, Object> hashtable = null;
        try {
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sDefaultValueSelect);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, OracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Object>();
                }
                object = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                int n = 12;
                if (string4.contains("DATE") || string4.contains("TIME") || string4.contains("INTERVAL")) {
                    n = 91;
                } else if (string4.contains("NUMBER") || string4.contains("FLOAT") || string4.contains("INTEGER")) {
                    n = 3;
                }
                String string5 = resultSet.getString(3);
                try {
                    Object object2 = this.translateDefaultValue((String)object, n, string5.trim());
                    if (object2 == null) continue;
                    hashtable.put(object, object2);
                }
                catch (Exception exception) {
                    OracleDBAccess.debug(string5, exception);
                }
            }
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getDefaultValuesIntern(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = hashtable;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return object;
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    protected Map<String, Object[]> getAllowedValuesIntern(String string, String string2, String string3) throws DataSourceException {
        Hashtable<String, Object[]> hashtable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, Object[]> hashtable2 = null;
        Hashtable<String, List<String>> hashtable3 = null;
        try {
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sCheckSelect);
            preparedStatement.setString(1, OracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, OracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashtable3 = CheckConstraintSupport.parseCondition(resultSet.getString(1), hashtable3, true);
            }
            hashtable2 = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable3);
            if (OracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                OracleDBAccess.debug("getAllowedValuesIntern(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            hashtable = hashtable2;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return hashtable;
    }

    @Override
    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) throws SQLException {
        if (object instanceof TIMESTAMPLTZ) {
            return ((TIMESTAMPLTZ)object).timestampValue(this.getConnectionIntern());
        }
        if (object instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)object).timestampValue(this.getConnectionIntern());
        }
        if (object instanceof Datum) {
            return ((Datum)object).timestampValue();
        }
        return object;
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        String string2;
        TableInfo tableInfo = super.getTableInfoIntern(string);
        String string3 = tableInfo.getSchema();
        if (string3 == null) {
            string3 = this.getUsername().toUpperCase();
        }
        if ((string2 = tableInfo.getTable()) != null && !string2.startsWith("`") && !string2.endsWith("`")) {
            string2 = string2.toUpperCase();
        }
        return new TableInfo(tableInfo.getCatalog(), string3, string2);
    }

    @Override
    protected boolean detectModified() {
        try {
            return this.executeSql("select dbms_transaction.local_transaction_id from dual", new Object[0]).get(0) != null;
        }
        catch (SQLException sQLException) {
            return super.detectModified();
        }
    }

    private void configureTnsAdmin() {
        try {
            if (System.getProperty("oracle.net.tns_admin") == null) {
                String string = System.getenv("TNS_ADMIN");
                if (string == null) {
                    String string2 = System.getenv("ORACLE_HOME");
                    if (string2 != null) {
                        string = string2 + "/network/admin";
                    } else {
                        String string3 = System.getenv("PATH");
                        if (string3 != null) {
                            String[] stringArray = string3.split(File.pathSeparator);
                            for (int i = 0; string == null && i < stringArray.length; ++i) {
                                String string4 = stringArray[i].toLowerCase().replace('\\', '/');
                                if (!string4.contains("oracle") || !string4.endsWith("/bin") || !new File(string4 = stringArray[i].substring(0, string4.length() - 4) + "/network/admin").exists()) continue;
                                string = string4;
                            }
                        }
                    }
                }
                if (string != null) {
                    System.setProperty("oracle.net.tns_admin", string);
                }
            }
        }
        catch (Exception exception) {
            OracleDBAccess.debug("Configure tns admin failed!" + exception);
        }
    }

    private Object[] insertOracle(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        CallableStatement callableStatement;
        block20: {
            int n;
            boolean bl;
            int[] nArray = serverMetaData.getPrimaryKeyColumnIndices();
            if (nArray == null || nArray.length == 0) {
                bl = false;
            } else {
                bl = true;
                for (int i = 0; bl && nArray != null && i < nArray.length; ++i) {
                    if (objectArray[nArray[i]] == null) continue;
                    bl = false;
                }
            }
            if (bl) {
                int n2;
                StringBuffer stringBuffer = new StringBuffer("BEGIN " + string2);
                stringBuffer.append(" RETURNING ");
                for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(serverMetaData.getServerColumnMetaData(nArray[n2]).getColumnName().getQuotedName());
                }
                stringBuffer.append(" INTO ");
                for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("?");
                }
                stringBuffer.append("; END;");
                string2 = stringBuffer.toString();
            }
            callableStatement = null;
            String string4 = this.translateQuotes(string2);
            OracleDBAccess.debug("executeSQL->", string4);
            callableStatement = this.getConnectionIntern().prepareCall(string4);
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray2 = serverMetaData.getWritableColumnIndices();
            int n3 = 0;
            if (string3 == null) {
                n3 = this.setColumnsToStore(callableStatement, serverColumnMetaDataArray, nArray2, objectArray, null);
            } else {
                for (n = 0; n < serverColumnMetaDataArray.length; ++n) {
                    if (!serverColumnMetaDataArray[n].getColumnName().getQuotedName().equals(string3)) continue;
                    callableStatement.setObject(1, null, serverColumnMetaDataArray[n].getSQLType());
                    break;
                }
                n3 = 1;
            }
            if (bl) {
                for (n = 0; nArray != null && n < nArray.length; ++n) {
                    int n4 = serverColumnMetaDataArray[nArray[n]].getColumnMetaData().getTypeIdentifier();
                    callableStatement.registerOutParameter(n3 + n + 1, n4);
                }
            }
            if (callableStatement.executeUpdate() != 1) break block20;
            if (bl) {
                for (n = 0; nArray != null && n < nArray.length; ++n) {
                    objectArray[nArray[n]] = callableStatement.getObject(n3 + n + 1);
                }
            }
            Object[] objectArray2 = objectArray;
            CommonUtil.close(callableStatement);
            return objectArray2;
        }
        try {
            try {
                throw new DataSourceException("Insert failed ! - Result row count != 1 ! - " + string2);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Insert failed! - " + string2, this.formatSQLException(sQLException));
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(callableStatement);
            throw throwable;
        }
    }
}

