/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist;

import com.sibvisions.rad.model.DataBookCSVExporter;
import com.sibvisions.rad.persist.bean.BeanConverter;
import com.sibvisions.rad.persist.bean.IAllFetched;
import com.sibvisions.rad.persist.event.StorageEvent;
import com.sibvisions.rad.persist.event.StorageHandler;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ICloseable;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.LocaleUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.rad.io.IFileHandle;
import javax.rad.io.RemoteFileHandle;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.ICondition;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.IStorage;
import javax.rad.persist.MetaData;
import javax.rad.server.ISession;
import javax.rad.server.SessionContext;
import javax.rad.type.bean.BeanType;
import javax.rad.type.bean.IBean;
import javax.rad.type.bean.IBeanType;
import javax.rad.util.EventHandler;
import javax.rad.util.INamedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStorage
implements IStorage,
INamedObject,
ICloseable {
    private static final StringBuilder UNDEFINED_VALUE = new StringBuilder();
    private static ILogger logger = null;
    private StorageHandler eventCalculateRow;
    private StorageHandler eventInsteadOfInsert;
    private StorageHandler eventBeforeInsert;
    private StorageHandler eventAfterInsert;
    private StorageHandler eventInsteadOfUpdate;
    private StorageHandler eventBeforeUpdate;
    private StorageHandler eventAfterUpdate;
    private StorageHandler eventInsteadOfDelete;
    private StorageHandler eventBeforeDelete;
    private StorageHandler eventAfterDelete;
    private boolean bRefetch = true;
    private BeanConverter beanConverter = new BeanConverter();
    private String sName;

    @Override
    public final List<Object[]> fetch(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.fetch(false, iCondition, sortDefinition, n, n2);
    }

    @Override
    public final Object[] refetchRow(Object[] objectArray) throws DataSourceException {
        return this.refetchRow(false, objectArray);
    }

    @Override
    public final Object[] insert(Object[] objectArray) throws DataSourceException {
        Object[] objectArray2 = objectArray;
        this.dispatchEvent(this.eventBeforeInsert, StorageEvent.ChangedType.BEFORE_INSERT, null, objectArray2);
        if (EventHandler.isDispatchable(this.eventInsteadOfInsert)) {
            if (this.isRefetch()) {
                objectArray2 = (Object[])objectArray2.clone();
            }
            this.dispatchEvent(this.eventInsteadOfInsert, StorageEvent.ChangedType.INSTEADOF_INSERT, null, objectArray2);
        } else if (this.isRefetch()) {
            objectArray2 = this.executeInsert((Object[])objectArray2.clone());
        } else {
            this.executeInsert(objectArray2);
        }
        this.dispatchEvent(this.eventAfterInsert, StorageEvent.ChangedType.AFTER_INSERT, null, objectArray2);
        this.dispatchEvent(this.eventCalculateRow, StorageEvent.ChangedType.CALCULATE_ROW, null, objectArray2);
        return this.trimArray(objectArray2, objectArray);
    }

    @Override
    public final Object[] update(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        Object[] objectArray3 = objectArray;
        Object[] objectArray4 = objectArray2;
        this.dispatchEvent(this.eventBeforeUpdate, StorageEvent.ChangedType.BEFORE_UPDATE, objectArray3, objectArray4);
        if (EventHandler.isDispatchable(this.eventInsteadOfUpdate)) {
            if (this.isRefetch()) {
                objectArray4 = (Object[])objectArray4.clone();
            }
            this.dispatchEvent(this.eventInsteadOfUpdate, StorageEvent.ChangedType.INSTEADOF_UPDATE, objectArray3, objectArray4);
        } else if (this.isRefetch()) {
            objectArray4 = this.executeUpdate(objectArray3, (Object[])objectArray4.clone());
        } else {
            this.executeUpdate(objectArray3, objectArray4);
        }
        this.dispatchEvent(this.eventAfterUpdate, StorageEvent.ChangedType.AFTER_UPDATE, objectArray3, objectArray4);
        this.dispatchEvent(this.eventCalculateRow, StorageEvent.ChangedType.CALCULATE_ROW, objectArray3, objectArray4);
        return this.trimArray(objectArray4, objectArray2);
    }

    @Override
    public final void delete(Object[] objectArray) throws DataSourceException {
        this.dispatchEvent(this.eventBeforeDelete, StorageEvent.ChangedType.BEFORE_DELETE, objectArray, null);
        if (EventHandler.isDispatchable(this.eventInsteadOfDelete)) {
            this.dispatchEvent(this.eventInsteadOfDelete, StorageEvent.ChangedType.INSTEADOF_DELETE, objectArray, null);
        } else {
            this.executeDelete(objectArray);
        }
        this.dispatchEvent(this.eventAfterDelete, StorageEvent.ChangedType.AFTER_DELETE, objectArray, null);
    }

    public abstract void writeCSV(OutputStream var1, String[] var2, String[] var3, ICondition var4, SortDefinition var5, String var6) throws Exception;

    protected abstract Object[] executeRefetchRow(Object[] var1) throws DataSourceException;

    protected abstract List<Object[]> executeFetch(ICondition var1, SortDefinition var2, int var3, int var4) throws DataSourceException;

    protected abstract Object[] executeInsert(Object[] var1) throws DataSourceException;

    protected abstract Object[] executeUpdate(Object[] var1, Object[] var2) throws DataSourceException;

    protected abstract void executeDelete(Object[] var1) throws DataSourceException;

    public BeanConverter getBeanConverter() throws DataSourceException {
        if (!this.beanConverter.isInitialized()) {
            this.beanConverter.setBeanType(this.createBeanType(this.getMetaData().getColumnNames()));
        }
        return this.beanConverter;
    }

    private List<Object[]> fetch(boolean bl, ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        List<Object[]> list = bl ? this.executeFetchAsBean(iCondition, sortDefinition, n, n2) : this.executeFetch(iCondition, sortDefinition, n, n2);
        if (this.eventCalculateRow != null) {
            for (int i = 0; i < list.size() && list.get(i) != null; ++i) {
                this.dispatchEvent(this.eventCalculateRow, StorageEvent.ChangedType.CALCULATE_ROW, null, list.get(i));
            }
        }
        return list;
    }

    private Object[] refetchRow(boolean bl, Object[] objectArray) throws DataSourceException {
        Object[] objectArray2 = bl ? this.executeRefetchRowAsBean(objectArray) : this.executeRefetchRow(objectArray);
        this.dispatchEvent(this.eventCalculateRow, StorageEvent.ChangedType.CALCULATE_ROW, null, objectArray2);
        return this.trimArray(objectArray2, objectArray);
    }

    @Override
    public void setName(String string) {
        this.sName = string;
    }

    @Override
    public String getName() {
        return this.sName;
    }

    public boolean isRefetch() {
        return this.bRefetch;
    }

    public void setRefetch(boolean bl) {
        this.bRefetch = bl;
    }

    protected boolean isLogEnabled(ILogger.LogLevel logLevel) {
        if (logger == null) {
            return LoggerFactory.getInstance(AbstractStorage.class).isEnabled(logLevel);
        }
        return logger.isEnabled(logLevel);
    }

    protected void debug(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(AbstractStorage.class);
        }
        logger.debug(objectArray);
    }

    protected void info(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(AbstractStorage.class);
        }
        logger.info(objectArray);
    }

    protected void error(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(AbstractStorage.class);
        }
        logger.error(objectArray);
    }

    public IFileHandle createCSV(String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition) throws Exception {
        SessionContext sessionContext = SessionContext.getCurrentInstance();
        String string = null;
        if (sessionContext != null) {
            string = sessionContext.getObjectName();
        }
        return this.createCSV(string, stringArray, stringArray2, iCondition, sortDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileHandle createCSV(String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws Exception {
        try {
            LocaleUtil.setThreadDefault(LocaleUtil.forLanguageTag(string));
            IFileHandle iFileHandle = this.createCSV(stringArray, stringArray2, iCondition, sortDefinition);
            return iFileHandle;
        }
        finally {
            LocaleUtil.setThreadDefault(null);
        }
    }

    public IFileHandle createCSV(String string, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition) throws Exception {
        String string2;
        Object object;
        RemoteFileHandle remoteFileHandle = new RemoteFileHandle(DataBookCSVExporter.formatCSVFileName(string));
        ISession iSession = SessionContext.getCurrentSession();
        if (iSession != null) {
            object = (String)iSession.getProperty("client.locale.language");
            String string3 = (String)iSession.getProperty("client.locale.country");
            String string4 = (String)iSession.getProperty("client.locale.variant");
            string2 = object != null ? LocaleUtil.getListSeparator(new Locale((String)object, string3, string4)) : LocaleUtil.getListSeparator();
        } else {
            string2 = LocaleUtil.getListSeparator();
        }
        object = remoteFileHandle.getOutputStream();
        this.writeCSV((OutputStream)object, stringArray, stringArray2, iCondition, sortDefinition, string2);
        ((OutputStream)object).close();
        return remoteFileHandle;
    }

    public StorageHandler eventCalculateRow() {
        if (this.eventCalculateRow == null) {
            this.eventCalculateRow = new StorageHandler();
        }
        return this.eventCalculateRow;
    }

    public StorageHandler eventInsteadOfInsert() {
        if (this.eventInsteadOfInsert == null) {
            this.eventInsteadOfInsert = new StorageHandler();
        }
        return this.eventInsteadOfInsert;
    }

    public StorageHandler eventBeforeInsert() {
        if (this.eventBeforeInsert == null) {
            this.eventBeforeInsert = new StorageHandler();
        }
        return this.eventBeforeInsert;
    }

    public StorageHandler eventAfterInsert() {
        if (this.eventAfterInsert == null) {
            this.eventAfterInsert = new StorageHandler();
        }
        return this.eventAfterInsert;
    }

    public StorageHandler eventInsteadOfUpdate() {
        if (this.eventInsteadOfUpdate == null) {
            this.eventInsteadOfUpdate = new StorageHandler();
        }
        return this.eventInsteadOfUpdate;
    }

    public StorageHandler eventBeforeUpdate() {
        if (this.eventBeforeUpdate == null) {
            this.eventBeforeUpdate = new StorageHandler();
        }
        return this.eventBeforeUpdate;
    }

    public StorageHandler eventAfterUpdate() {
        if (this.eventAfterUpdate == null) {
            this.eventAfterUpdate = new StorageHandler();
        }
        return this.eventAfterUpdate;
    }

    public StorageHandler eventInsteadOfDelete() {
        if (this.eventInsteadOfDelete == null) {
            this.eventInsteadOfDelete = new StorageHandler();
        }
        return this.eventInsteadOfDelete;
    }

    public StorageHandler eventBeforeDelete() {
        if (this.eventBeforeDelete == null) {
            this.eventBeforeDelete = new StorageHandler();
        }
        return this.eventBeforeDelete;
    }

    public StorageHandler eventAfterDelete() {
        if (this.eventAfterDelete == null) {
            this.eventAfterDelete = new StorageHandler();
        }
        return this.eventAfterDelete;
    }

    protected IBeanType getAndInitBeanType() throws DataSourceException {
        return this.getBeanConverter().getBeanType();
    }

    protected BeanType createBeanType(String[] stringArray) {
        return new BeanType(stringArray);
    }

    public IBean createEmptyBean() throws DataSourceException {
        return this.getBeanConverter().createEmptyBean();
    }

    protected IBean createBean(Object[] objectArray) throws DataSourceException {
        return this.getBeanConverter().createBean(objectArray);
    }

    private void dispatchEvent(StorageHandler storageHandler, StorageEvent.ChangedType changedType, IBean iBean, IBean iBean2) throws DataSourceException {
        if (EventHandler.isDispatchable(storageHandler)) {
            StorageEvent storageEvent = new StorageEvent((IStorage)this, this.getBeanConverter(), changedType, iBean, iBean2);
            storageHandler.dispatchEvent(storageEvent);
            storageEvent.getOld();
            storageEvent.getNew();
        }
    }

    private void dispatchEvent(StorageHandler storageHandler, StorageEvent.ChangedType changedType, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        if (EventHandler.isDispatchable(storageHandler)) {
            StorageEvent storageEvent = new StorageEvent((IStorage)this, this.getBeanConverter(), changedType, objectArray, objectArray2);
            storageHandler.dispatchEvent(storageEvent);
            storageEvent.getOldAsArray();
            storageEvent.getNewAsArray();
        }
    }

    private <T> void dispatchEvent(StorageHandler storageHandler, StorageEvent.ChangedType changedType, T t, T t2) throws DataSourceException {
        if (EventHandler.isDispatchable(storageHandler)) {
            StorageEvent storageEvent = new StorageEvent((IStorage)this, this.getBeanConverter(), changedType, t, t2);
            storageHandler.dispatchEvent(storageEvent);
            if (t != null) {
                storageEvent.getOld(t.getClass());
            }
            if (t2 != null) {
                storageEvent.getNew(t2.getClass());
            }
        }
    }

    private Object[] trimArray(Object[] objectArray, Object[] objectArray2) {
        if (objectArray2 == null || objectArray == null || objectArray.length == objectArray2.length) {
            return objectArray;
        }
        Object[] objectArray3 = new Object[objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, Math.min(objectArray3.length, objectArray.length));
        return objectArray3;
    }

    protected <T> T createPOJO(Class<T> clazz, Object[] objectArray) throws DataSourceException {
        return this.getBeanConverter().createPOJO(clazz, objectArray);
    }

    public <T> T createPOJO(Class<T> clazz, IBean iBean) throws DataSourceException {
        return this.getBeanConverter().createPOJO(clazz, iBean);
    }

    public void updateBean(IBean iBean, Object object) throws DataSourceException {
        this.getBeanConverter().updateBean(iBean, object);
    }

    public void setPropertyNameForColumn(String string, String string2) {
        if (string2 == null) {
            this.beanConverter.removePropertyNameForColumn(string);
        } else {
            this.beanConverter.setPropertyNameForColumn(string, string2);
        }
        if (this.beanConverter.isInitialized()) {
            int n;
            MetaData metaData;
            try {
                metaData = this.getMetaData();
            }
            catch (DataSourceException dataSourceException) {
                throw new RuntimeException(dataSourceException);
            }
            if (metaData != null && (n = metaData.getColumnMetaDataIndex(string)) >= 0) {
                if (string2 == null) {
                    this.beanConverter.setPojoPropertyName(n, StringUtil.convertToMemberName(string));
                } else {
                    this.beanConverter.setPojoPropertyName(n, string2);
                }
            }
        }
    }

    public String getPropertyNameForColumn(String string) {
        String string2 = this.beanConverter.getPropertyNameForColumn(string);
        if (string2 == null) {
            if (this.beanConverter.isInitialized()) {
                int n;
                MetaData metaData;
                try {
                    metaData = this.getMetaData();
                }
                catch (DataSourceException dataSourceException) {
                    throw new RuntimeException(dataSourceException);
                }
                if (metaData != null && (n = metaData.getColumnMetaDataIndex(string)) >= 0) {
                    return this.beanConverter.getPojoPropertyName(n);
                }
            } else {
                return StringUtil.convertToMemberName(string);
            }
        }
        return string2;
    }

    public IBean fetchBean(ICondition iCondition) throws DataSourceException {
        return this.fetch(IBean.class, iCondition);
    }

    public <T> T fetch(Class<T> clazz, ICondition iCondition) throws DataSourceException {
        List<Object[]> list = this.fetch(true, iCondition, null, 0, 2);
        int n = list.size();
        if (n < 2) {
            return null;
        }
        if (n == 2 && list.get(1) == null) {
            if (IBean.class.isAssignableFrom(clazz)) {
                return (T)this.getBeanConverter().createBean(list.get(0));
            }
            return this.getBeanConverter().createPOJO(clazz, list.get(0));
        }
        throw new DataSourceException("More than one bean available!");
    }

    public List<IBean> fetchBean(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.fetch(IBean.class, iCondition, sortDefinition, n, n2);
    }

    public <T> List<T> fetch(Class<T> clazz, ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        List<Object[]> list = this.fetch(true, iCondition, sortDefinition, n, n2);
        ArrayUtil arrayUtil = list.get(list.size() - 1) == null ? new AllFetchedList(list.size()) : new ArrayUtil(list.size());
        BeanConverter beanConverter = this.getBeanConverter();
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            Object[] objectArray = list.get(i);
            if (objectArray == null) continue;
            if (IBean.class.isAssignableFrom(clazz)) {
                arrayUtil.add(beanConverter.createBean(objectArray));
                continue;
            }
            arrayUtil.add(beanConverter.createPOJO(clazz, objectArray));
        }
        return arrayUtil;
    }

    public <T> T refetch(T t) throws DataSourceException {
        BeanConverter beanConverter = this.getBeanConverter();
        if (t instanceof IBean) {
            return (T)beanConverter.createBean(this.refetchRow(true, beanConverter.createArray(t)));
        }
        return (T)beanConverter.createPOJO(t.getClass(), this.refetchRow(true, beanConverter.createArray(t)));
    }

    public <T> T insert(T t) throws DataSourceException {
        if (t instanceof IBean) {
            IBean iBean = (IBean)t;
            this.dispatchEvent(this.eventBeforeInsert, StorageEvent.ChangedType.BEFORE_INSERT, null, iBean);
            if (EventHandler.isDispatchable(this.eventInsteadOfInsert)) {
                if (this.isRefetch()) {
                    iBean = (IBean)iBean.clone();
                }
                this.dispatchEvent(this.eventInsteadOfInsert, StorageEvent.ChangedType.INSTEADOF_INSERT, null, iBean);
            } else {
                BeanConverter beanConverter = this.getBeanConverter();
                Object[] objectArray = beanConverter.createArray(iBean);
                if (this.isRefetch()) {
                    objectArray = this.executeInsertAsBean(objectArray);
                    iBean = (IBean)iBean.clone();
                } else {
                    this.executeInsertAsBean(objectArray);
                }
                beanConverter.updateBean(iBean, objectArray);
            }
            this.dispatchEvent(this.eventAfterInsert, StorageEvent.ChangedType.AFTER_INSERT, null, iBean);
            this.dispatchEvent(this.eventCalculateRow, StorageEvent.ChangedType.CALCULATE_ROW, null, iBean);
            return (T)iBean;
        }
        Object object = t;
        this.dispatchEvent(this.eventBeforeInsert, StorageEvent.ChangedType.BEFORE_INSERT, null, object);
        if (EventHandler.isDispatchable(this.eventInsteadOfInsert)) {
            if (this.isRefetch()) {
                object = BeanType.getBeanType(object).clone(object);
            }
            this.dispatchEvent(this.eventInsteadOfInsert, StorageEvent.ChangedType.INSTEADOF_INSERT, null, object);
        } else {
            BeanConverter beanConverter = this.getBeanConverter();
            Object[] objectArray = beanConverter.createArray(object);
            if (this.isRefetch()) {
                objectArray = this.executeInsert(objectArray);
                object = BeanType.getBeanType(object).clone(object);
            } else {
                this.executeInsert(objectArray);
            }
            beanConverter.updatePOJO(object, objectArray);
        }
        this.dispatchEvent(this.eventAfterInsert, StorageEvent.ChangedType.AFTER_INSERT, null, object);
        this.dispatchEvent(this.eventCalculateRow, StorageEvent.ChangedType.CALCULATE_ROW, null, object);
        return object;
    }

    public <T> T update(T t) throws DataSourceException {
        return this.update(null, t);
    }

    public <T> T update(T t, T t2) throws DataSourceException {
        Object object;
        Object[] objectArray;
        MetaData metaData = this.getMetaData();
        BeanConverter beanConverter = this.getBeanConverter();
        Object[] objectArray2 = beanConverter.createArray(t2);
        if (t != null) {
            objectArray = beanConverter.createArray(t);
        } else {
            int n;
            int n2;
            if (t2 instanceof IBean) {
                objectArray = (Object[])objectArray2.clone();
                object = ((IBean)t2).getBeanType().getPropertyNames();
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    n = metaData.getColumnMetaDataIndex(object[n2]);
                    if (n < 0) continue;
                    objectArray[n] = UNDEFINED_VALUE;
                }
            } else {
                objectArray = new Object[objectArray2.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = UNDEFINED_VALUE;
                }
            }
            if ((object = metaData.getPrimaryKeyColumnNames()) != null) {
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    n = metaData.getColumnMetaDataIndex(object[n2]);
                    objectArray[n] = objectArray2[n];
                }
            }
        }
        this.dispatchEvent(this.eventBeforeUpdate, StorageEvent.ChangedType.BEFORE_UPDATE, objectArray, objectArray2);
        if (t2 instanceof IBean) {
            object = (IBean)t2;
            if (EventHandler.isDispatchable(this.eventInsteadOfUpdate)) {
                this.dispatchEvent(this.eventInsteadOfUpdate, StorageEvent.ChangedType.INSTEADOF_UPDATE, objectArray, objectArray2);
                if (this.isRefetch()) {
                    object = (IBean)object.clone();
                }
            } else if (this.isRefetch()) {
                objectArray2 = this.executeUpdateAsBean(objectArray, objectArray2);
                object = (IBean)object.clone();
            } else {
                this.executeUpdateAsBean(objectArray, objectArray2);
            }
            this.dispatchEvent(this.eventAfterUpdate, StorageEvent.ChangedType.AFTER_UPDATE, objectArray, objectArray2);
            this.dispatchEvent(this.eventCalculateRow, StorageEvent.ChangedType.CALCULATE_ROW, null, objectArray2);
            beanConverter.updateBean((IBean)object, objectArray2);
            return (T)object;
        }
        object = t2;
        if (EventHandler.isDispatchable(this.eventInsteadOfUpdate)) {
            this.dispatchEvent(this.eventInsteadOfUpdate, StorageEvent.ChangedType.INSTEADOF_UPDATE, objectArray, objectArray2);
            if (this.isRefetch()) {
                object = BeanType.getBeanType(t2).clone(t2);
            }
        } else if (this.isRefetch()) {
            objectArray2 = this.executeUpdate(objectArray, objectArray2);
            object = BeanType.getBeanType(t2).clone(t2);
        } else {
            this.executeUpdate(objectArray, objectArray2);
        }
        this.dispatchEvent(this.eventAfterUpdate, StorageEvent.ChangedType.AFTER_UPDATE, objectArray, objectArray2);
        this.dispatchEvent(this.eventCalculateRow, StorageEvent.ChangedType.CALCULATE_ROW, null, objectArray2);
        beanConverter.updatePOJO(object, objectArray2);
        return (T)object;
    }

    public <T> void delete(T t) throws DataSourceException {
        if (t instanceof IBean) {
            IBean iBean = (IBean)t;
            this.dispatchEvent(this.eventBeforeDelete, StorageEvent.ChangedType.BEFORE_DELETE, iBean, null);
            if (EventHandler.isDispatchable(this.eventInsteadOfDelete)) {
                this.dispatchEvent(this.eventInsteadOfDelete, StorageEvent.ChangedType.INSTEADOF_DELETE, iBean, null);
            } else {
                this.executeDeleteAsBean(this.getBeanConverter().createArray(iBean));
            }
            this.dispatchEvent(this.eventAfterDelete, StorageEvent.ChangedType.AFTER_DELETE, iBean, null);
        } else {
            this.dispatchEvent(this.eventBeforeDelete, StorageEvent.ChangedType.BEFORE_DELETE, t, null);
            if (EventHandler.isDispatchable(this.eventInsteadOfDelete)) {
                this.dispatchEvent(this.eventInsteadOfDelete, StorageEvent.ChangedType.INSTEADOF_DELETE, t, null);
            } else {
                this.executeDelete(this.getBeanConverter().createArray(t));
            }
            this.dispatchEvent(this.eventAfterDelete, StorageEvent.ChangedType.AFTER_DELETE, t, null);
        }
    }

    protected Object[] executeRefetchRowAsBean(Object[] objectArray) throws DataSourceException {
        return this.executeRefetchRow(objectArray);
    }

    protected List<Object[]> executeFetchAsBean(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.executeFetch(iCondition, sortDefinition, n, n2);
    }

    protected Object[] executeInsertAsBean(Object[] objectArray) throws DataSourceException {
        return this.executeInsert(objectArray);
    }

    protected Object[] executeUpdateAsBean(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        return this.executeUpdate(objectArray, objectArray2);
    }

    protected void executeDeleteAsBean(Object[] objectArray) throws DataSourceException {
        this.executeDelete(objectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AllFetchedList<E>
    extends ArrayUtil<E>
    implements IAllFetched {
        public AllFetchedList() {
        }

        public AllFetchedList(int n) {
            super(n);
        }

        public AllFetchedList(E ... EArray) {
            super(EArray);
        }

        public AllFetchedList(E[] EArray, int n) {
            super(EArray, n);
        }

        public AllFetchedList(E[] EArray, int n, int n2) {
            super(EArray, n, n2);
        }

        public AllFetchedList(Collection<? extends E> collection) {
            super(collection);
        }
    }
}

