/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.rad.genui.celleditor.UIEnumCellEditor;
import com.sibvisions.rad.model.Filter;
import com.sibvisions.rad.model.mem.ChangeableDataRow;
import com.sibvisions.rad.model.mem.DataRow;
import com.sibvisions.rad.model.mem.MemDataPage;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.ExceptionUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.celleditor.UICellEditor;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IDataSource;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.TreePath;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.event.DataBookEvent;
import javax.rad.model.event.DataBookHandler;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.IControl;
import javax.rad.ui.IFactory;
import javax.rad.util.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemDataBook
extends ChangeableDataRow
implements IDataBook {
    private static int iUID = 0;
    private TreePath treePath = TreePath.EMPTY;
    private IDataBook.SelectionMode iSelectionMode = IDataBook.SelectionMode.CURRENT_ROW;
    private ICondition cFilter;
    private SortDefinition sSort;
    private ReferenceDefinition rdMasterReference;
    private ReferenceDefinition rdTreeRootReference;
    private String[] saTreeRootMasterColumnNames;
    private IDataBook.WriteBackIsolationLevel iWritebackIsolationLevel;
    private ArrayUtil<WeakReference<IDataBook>> auDetailDataBooks;
    private IDataSource dsDataSource;
    private ArrayUtil<IDataRow> auStoredSelection = new ArrayUtil();
    private MemDataPage dpCurrentDataPage;
    private MemDataPage dpEmptyDataPage;
    private ChangeableDataRow additionalDataRow;
    private IRowDefinition additionalRowDefinition;
    private boolean additionalDataRowVisible = false;
    private Hashtable<Object, MemDataPage> htDataPagesCache = new Hashtable();
    private MemDataPage temporaryMasterDataPage = null;
    private DataBookHandler eventBeforeRowSelected;
    private DataBookHandler eventAfterRowSelected;
    private DataBookHandler eventBeforeInserting;
    private DataBookHandler eventAfterInserting;
    private DataBookHandler eventBeforeInserted;
    private DataBookHandler eventAfterInserted;
    private DataBookHandler eventBeforeUpdating;
    private DataBookHandler eventAfterUpdating;
    private DataBookHandler eventBeforeUpdated;
    private DataBookHandler eventAfterUpdated;
    private DataBookHandler eventBeforeDeleting;
    private DataBookHandler eventAfterDeleting;
    private DataBookHandler eventBeforeDeleted;
    private DataBookHandler eventAfterDeleted;
    private DataBookHandler eventBeforeRestore;
    private DataBookHandler eventAfterRestore;
    private DataBookHandler eventBeforeReload;
    private DataBookHandler eventAfterReload;
    private DataBookHandler eventBeforeFilterChanged;
    private DataBookHandler eventAfterFilterChanged;
    private DataBookHandler eventBeforeSortChanged;
    private DataBookHandler eventAfterSortChanged;
    private DataBookHandler eventBeforeColumnSelected;
    private DataBookHandler eventAfterColumnSelected;
    private String sName;
    private String sSelectedColumn = null;
    private int iReadAheadRowCount = 35;
    private int iSelectedRowIndex = -1;
    private int iOldSelectedRowSaveAllRows;
    private IDataPage dpOldCurrentDataPageSaveAllRows;
    private boolean bMasterChanged = false;
    private boolean bInsertEnabled = true;
    private boolean bUpdateEnabled = true;
    private boolean bDeleteEnabled = true;
    private boolean bLockAndRefetchEnabled = false;
    private boolean bReadOnly = false;
    private boolean bDeleteCascade = true;
    protected boolean bMemSort = true;
    protected boolean bMemFilter = true;
    private boolean bWritebackEnabled = false;
    private boolean bIsOpen = false;
    private boolean bSaveAllRows = false;
    private boolean bRestoreAllRows = false;
    private boolean ignoreReload = false;
    private IFactory factory = null;
    private boolean invokeRepaintListeners = true;
    private boolean invokeLaterRepaintListenersCalled = false;
    private boolean invokeSaveEditingControls = true;
    private boolean invokeCancelEditingControls = true;
    protected DataRow rowInstance1 = null;
    protected DataRow rowInstance2 = null;
    protected IDataBook rootDataBook = this;

    public MemDataBook() {
    }

    public MemDataBook(RowDefinition rowDefinition) {
        super(rowDefinition);
    }

    @Override
    public IDataBook getDataBook() {
        return this;
    }

    @Override
    public String getName() {
        return this.sName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String string) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen) {
                throw new ModelException("It's not allowed on open DataBooks! - " + this.getName());
            }
            this.sName = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWritebackIsolationLevel(IDataBook.WriteBackIsolationLevel writeBackIsolationLevel) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.iWritebackIsolationLevel = writeBackIsolationLevel;
        }
    }

    @Override
    public IDataBook.WriteBackIsolationLevel getWritebackIsolationLevel() {
        if (this.iWritebackIsolationLevel == null) {
            IDataSource iDataSource = this.getDataSource();
            if (iDataSource != null) {
                return iDataSource.getWritebackIsolationLevel();
            }
            return IDataBook.WriteBackIsolationLevel.DATA_ROW;
        }
        return this.iWritebackIsolationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowDefinition(IRowDefinition iRowDefinition) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            int n;
            if (this.bIsOpen) {
                throw new ModelException("It's not allowed on open DataBooks!");
            }
            IControl[] iControlArray = null;
            if (this.rdRowDefinition != null) {
                iControlArray = this.getControls();
                for (n = 0; n < iControlArray.length; ++n) {
                    this.rdRowDefinition.removeControl(iControlArray[n]);
                }
            }
            this.rdRowDefinition = iRowDefinition;
            if (this.rdRowDefinition == null) {
                this.rdRowDefinition = new RowDefinition();
            }
            if (this.rdRowDefinition != null) {
                if (iControlArray == null) {
                    iControlArray = this.getControls();
                }
                for (n = 0; n < iControlArray.length; ++n) {
                    this.rdRowDefinition.addControl(iControlArray[n]);
                }
            }
        }
    }

    @Override
    public IDataSource getDataSource() {
        return this.dsDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataSource(IDataSource iDataSource) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen) {
                throw new ModelException("It's not allowed on open DataBooks!");
            }
            this.dsDataSource = iDataSource;
        }
    }

    @Override
    public ReferenceDefinition getMasterReference() {
        return this.rdMasterReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMasterReference(ReferenceDefinition referenceDefinition) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen) {
                throw new ModelException("It's not allowed on open DataBooks!");
            }
            this.rdMasterReference = referenceDefinition;
        }
    }

    @Override
    public boolean isSelfJoined() {
        return this.rdMasterReference != null && this.rdMasterReference.getReferencedDataBook() == this;
    }

    @Override
    public IDataPage getDataPage(TreePath treePath) throws ModelException {
        if (this.rdTreeRootReference == null) {
            return this.getDataPage(null, treePath);
        }
        return this.getDataPage(this.rdTreeRootReference.getReferencedDataBook(), treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataPage getDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            IDataPage iDataPage = this.getDataPageWithRootRow(iDataRow);
            if (treePath != null) {
                for (int i = 0; i < treePath.length(); ++i) {
                    IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(treePath.get(i));
                    if (iChangeableDataRow == null) {
                        return null;
                    }
                    iDataPage = this.getDataPageIntern(iChangeableDataRow);
                }
            }
            return iDataPage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataPage getDataPageWithRootRow(IDataRow iDataRow) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.rdMasterReference == null) {
                this.sync();
                return this.dpCurrentDataPage;
            }
            return this.getDataPageIntern(this.getMasterDataRowFromRootDataRow(iDataRow));
        }
    }

    @Override
    public ReferenceDefinition getRootReference() {
        return this.rdTreeRootReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRootReference(ReferenceDefinition referenceDefinition) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen) {
                throw new ModelException("It's not allowed on open DataBooks!");
            }
            this.rdTreeRootReference = referenceDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreePath getTreePath() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            try {
                this.sync();
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            return this.treePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTreePath(TreePath treePath) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.treePath.equals(treePath) || this.bMasterChanged) {
                this.invokeTreeSaveEditingControls();
                this.sync();
                boolean bl = EventHandler.isDispatchable(this.eventBeforeRowSelected);
                boolean bl2 = EventHandler.isDispatchable(this.eventAfterRowSelected);
                IDataRow iDataRow = bl || bl2 ? this.createDataRow(null) : null;
                this.saveDataRowLevel(null);
                if (bl) {
                    this.eventBeforeRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_ROW_SELECTED, iDataRow));
                }
                this.treePath = treePath == null ? TreePath.EMPTY : treePath;
                this.dpCurrentDataPage = (MemDataPage)this.getDataPage(this.treePath);
                if (this.dpCurrentDataPage == null) {
                    this.bMasterChanged = true;
                    this.sync();
                }
                if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED_SETFILTER) {
                    this.setSelectedRowInternal(-1);
                } else {
                    this.setSelectedRowInternal(0);
                }
                if (bl2) {
                    this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iDataRow));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMasterChanged() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            try {
                MemDataPage memDataPage;
                if (this.rdMasterReference != null && !this.rdMasterReference.getReferencedDataBook().isOutOfSync() && this.rdMasterReference.getReferencedDataBook().getUID() != null && !this.rdMasterReference.getReferencedDataBook().isInserting()) {
                    if (this.dpCurrentDataPage != null && this.rdMasterReference.getReferencedDataBook().getUID() != null && (memDataPage = this.htDataPagesCache.remove(this.rdMasterReference.getReferencedDataBook().getUID())) != null) {
                        if (!this.isDataPageRefetchPossible() || memDataPage.getChangedDataRows().length > 0) {
                            IDataRow iDataRow = this.getMasterDataRow(this.rdMasterReference.getReferencedDataBook());
                            memDataPage.setMasterDataRow(iDataRow);
                            this.htDataPagesCache.put(iDataRow, memDataPage);
                        } else if (memDataPage == this.dpCurrentDataPage) {
                            this.handleStoreSelection(this.iSelectionMode);
                            this.dpCurrentDataPage = null;
                        }
                    }
                } else if (this.isSelfJoined() && this.rdTreeRootReference != null && !this.rdTreeRootReference.getReferencedDataBook().isOutOfSync() && this.rdTreeRootReference.getReferencedDataBook().getUID() != null && !this.rdTreeRootReference.getReferencedDataBook().isInserting() && (memDataPage = this.htDataPagesCache.remove(this.rdTreeRootReference.getReferencedDataBook().getUID())) != null) {
                    if (!this.isDataPageRefetchPossible() || memDataPage.getChangedDataRows().length > 0) {
                        IDataRow iDataRow = this.getMasterDataRowFromRootDataRow(this.rdTreeRootReference.getReferencedDataBook()).createDataRow(null);
                        memDataPage.setMasterDataRow(iDataRow);
                        this.htDataPagesCache.put(iDataRow, memDataPage);
                    } else if (memDataPage == this.dpCurrentDataPage) {
                        this.handleStoreSelection(this.iSelectionMode);
                        this.dpCurrentDataPage = null;
                    }
                }
            }
            catch (ModelException modelException) {
                throw new RuntimeException(modelException);
            }
            if (!this.bMasterChanged) {
                try {
                    this.bMasterChanged = true;
                    if (EventHandler.isDispatchable(this.eventAfterReload)) {
                        this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
                    }
                    this.invokeMasterChangedDetailsListeners();
                }
                catch (ModelException modelException) {
                    throw new RuntimeException(modelException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            int n;
            int n2;
            IDataRow iDataRow2 = null;
            MemDataPage memDataPage = null;
            if (this.isSelfJoined()) {
                if (treePath == null) {
                    treePath = TreePath.EMPTY;
                }
                IDataBook iDataBook2 = null;
                if (this.rdTreeRootReference != null) {
                    iDataBook2 = this.rdTreeRootReference.getReferencedDataBook();
                }
                if (!this.hasDataPage(iDataBook2, treePath)) return;
                memDataPage = (MemDataPage)this.getDataPage(iDataBook2, treePath);
                iDataRow2 = memDataPage.getMasterDataRow();
                n2 = 0;
                int n3 = memDataPage.getRowCountInternal();
                while (n2 < n3) {
                    this.removeDataPage(null, treePath.getChildPath(n2++));
                }
            } else {
                if (!this.hasDataPage(iDataRow)) return;
                memDataPage = (MemDataPage)this.getDataPage(iDataRow);
                iDataRow2 = memDataPage.getMasterDataRow();
            }
            n2 = memDataPage.getRowCountInternal();
            for (n = 0; n < n2; ++n) {
                IChangeableDataRow iChangeableDataRow = memDataPage.getDataRow(n);
                if (this.auDetailDataBooks == null) continue;
                int n4 = this.auDetailDataBooks.size();
                for (int i = 0; i < n4; ++i) {
                    IDataBook iDataBook3 = (IDataBook)this.auDetailDataBooks.get(i).get();
                    if (iDataBook3 == null) continue;
                    iDataBook3.removeDataPage(iChangeableDataRow, null);
                }
            }
            if (iDataRow2 instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow2).getUID() != null) {
                this.htDataPagesCache.remove(((IChangeableDataRow)iDataRow2).getUID());
            } else {
                this.htDataPagesCache.remove(iDataRow2);
            }
            if (this.isSelfJoined() && this.treePath != null && this.treePath.length() > 0 && this.treePath.length() >= treePath.length()) {
                n = 1;
                for (n2 = 0; n != 0 && n2 < this.treePath.length() && n2 < treePath.length(); ++n2) {
                    if (this.treePath.get(n2) == treePath.get(n2)) continue;
                    n = 0;
                }
                if (n != 0) {
                    this.setTreePath(TreePath.EMPTY);
                }
            }
            if (memDataPage != this.dpCurrentDataPage) return;
            this.dpCurrentDataPage = null;
            this.bMasterChanged = true;
            this.notifyRepaintControls();
            return;
        }
    }

    @Override
    public IDataBook.SelectionMode getSelectionMode() {
        return this.iSelectionMode;
    }

    @Override
    public void setSelectionMode(IDataBook.SelectionMode selectionMode) {
        this.iSelectionMode = selectionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInsertAllowed() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            return this.bInsertEnabled && !this.isReadOnly() && this.dpCurrentDataPage != this.dpEmptyDataPage;
        }
    }

    @Override
    public boolean isInsertEnabled() {
        return this.bInsertEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInsertEnabled(boolean bl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.bInsertEnabled = bl;
            this.notifyRepaintControls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpdateAllowed() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            return this.bUpdateEnabled && !this.isReadOnly() && this.getSelectedRow() >= 0 && !this.isDeleting();
        }
    }

    @Override
    public boolean isUpdateEnabled() throws ModelException {
        return this.bUpdateEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUpdateEnabled(boolean bl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.bUpdateEnabled = bl;
            this.notifyRepaintControls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeleteAllowed() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            return this.bDeleteEnabled && !this.isReadOnly() && this.getSelectedRow() >= (this.additionalDataRowVisible ? 1 : 0);
        }
    }

    @Override
    public boolean isDeleteEnabled() throws ModelException {
        return this.bDeleteEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleteEnabled(boolean bl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.bDeleteEnabled = bl;
            this.notifyRepaintControls();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.bReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean bl) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen && !this.bReadOnly && bl) {
                if (!this.isMemFilter() || this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                    this.saveAllRows();
                } else {
                    this.invokeTreeSaveEditingControls();
                }
            }
            this.setReadOnlyWithoutSave(bl);
        }
    }

    @Override
    public boolean isOpen() {
        return this.bIsOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                Object object;
                if (this.getName() == null) {
                    throw new ModelException("DataBook Name is null!");
                }
                if (this.rdRowDefinition.getColumnCount() == 0) {
                    throw new ModelException("RowDefintion in DataBook contains no columns!");
                }
                this.factory = UIFactoryManager.getFactory();
                if (this.factory != null) {
                    int n = this.rdRowDefinition.getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        object = this.rdRowDefinition.getColumnDefinition(i);
                        Object[] objectArray = ((ColumnDefinition)object).getAllowedValues();
                        IDataType iDataType = ((ColumnDefinition)object).getDataType();
                        if (iDataType == null || iDataType.getCellEditor() != null || objectArray == null || objectArray.length <= 0) continue;
                        ICellEditor iCellEditor = null;
                        if (((ColumnDefinition)object).isNullable()) {
                            iCellEditor = UICellEditor.getDefaultCellEditor(ArrayUtil.add(objectArray, null));
                        }
                        if (iCellEditor == null) {
                            iCellEditor = UICellEditor.getDefaultCellEditor(objectArray);
                        }
                        if (iCellEditor != null) {
                            iDataType.setDefaultCellEditor(iCellEditor);
                            continue;
                        }
                        iDataType.setDefaultCellEditor(new UIEnumCellEditor(objectArray));
                    }
                }
                object = this.rdRowDefinition.getPrimaryKeyColumnNames();
                for (int i = 0; object != null && i < ((String[])object).length; ++i) {
                    if (this.rdRowDefinition.getColumnDefinitionIndex((String)object[i]) >= 0) continue;
                    throw new ModelException("Primary key column '" + (String)object[i] + "' doesn't exist in RowDefinition of this DataBook!");
                }
                ReferenceDefinition referenceDefinition = this.getMasterReference();
                if (referenceDefinition != null) {
                    IDataBook iDataBook2 = referenceDefinition.getReferencedDataBook();
                    if (!this.isSelfJoined() && !iDataBook2.isOpen()) {
                        throw new ModelException("The master DataBook has to be opened first! - " + iDataBook2.getName());
                    }
                    String[] stringArray = referenceDefinition.getColumnNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (this.rdRowDefinition.getColumnDefinitionIndex(stringArray[i]) >= 0) continue;
                        throw new ModelException("Column '" + stringArray[i] + "' doesn't exist in detail DataBook '" + this.getName() + "' !");
                    }
                    String[] stringArray2 = referenceDefinition.getReferencedColumnNames();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (iDataBook2.getRowDefinition().getColumnDefinitionIndex(stringArray2[i]) >= 0) continue;
                        throw new ModelException("Column '" + stringArray2[i] + "' doesn't exist in master DataBook '" + iDataBook2.getName() + "' !");
                    }
                    if (this.isSelfJoined()) {
                        if (this.getRootReference() != null) {
                            if (this.getRootReference().getReferencedDataBook() == iDataBook2) {
                                throw new ModelException("The RootReference DataBook '" + this.getRootReference().getReferencedDataBook().getName() + "' must be != MasterReference DataBook '" + iDataBook2.getName() + "' !");
                            }
                            String[] stringArray3 = this.getRootReference().getColumnNames();
                            this.saTreeRootMasterColumnNames = new String[stringArray3.length];
                            for (int i = 0; i < stringArray3.length; ++i) {
                                int n = ArrayUtil.indexOf(this.getMasterReference().getColumnNames(), stringArray3[i]);
                                if (n < 0) {
                                    throw new ModelException("Column name " + stringArray3[i] + " of root reference is not in master reference!");
                                }
                                this.saTreeRootMasterColumnNames[i] = this.getMasterReference().getReferencedColumnNames()[n];
                            }
                            this.getRootReference().getReferencedDataBook().addDetailDataBook(this);
                        } else {
                            this.saTreeRootMasterColumnNames = null;
                        }
                    } else {
                        referenceDefinition.getReferencedDataBook().addDetailDataBook(this);
                        referenceDefinition.setConnected();
                    }
                }
                if (this.getDataSource() != null) {
                    if (!this.getDataSource().isOpen()) {
                        throw new ModelException("DataSource is not open!");
                    }
                    this.getDataSource().addDataBook(this);
                }
                this.rdRowDefinition.addDataBook(this);
                this.iSelectedRowIndex = this.additionalDataRowVisible ? -2 : -1;
                this.rowInstance1 = new DataRow(this.rdRowDefinition);
                this.rowInstance2 = new DataRow(this.rdRowDefinition);
                this.rootDataBook = this.getRootDataBookIntern();
                this.bMasterChanged = true;
                this.bIsOpen = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen) {
                this.rootDataBook = this;
                this.bIsOpen = false;
                this.dpCurrentDataPage = null;
                this.temporaryMasterDataPage = null;
                this.bMasterChanged = false;
                this.htDataPagesCache.clear();
                this.iSelectedRowIndex = this.additionalDataRowVisible ? -2 : -1;
                this.additionalDataRow = null;
                this.additionalRowDefinition = null;
                this.oaStorage = null;
                if (this.rdMasterReference != null) {
                    if (this.isSelfJoined()) {
                        if (this.getRootReference() != null) {
                            this.getRootReference().getReferencedDataBook().removeDetailDataBook(this);
                            this.getRootReference().getReferencedDataBook().notifyDetailChanged();
                        }
                    } else {
                        this.rdMasterReference.getReferencedDataBook().removeDetailDataBook(this);
                        this.rdMasterReference.getReferencedDataBook().notifyDetailChanged();
                    }
                }
                if (this.dsDataSource != null) {
                    this.dsDataSource.removeDataBook(this);
                }
                if (this.rdRowDefinition != null) {
                    this.rdRowDefinition.removeDataBook(this);
                }
                this.rowInstance1 = null;
                this.rowInstance2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen) {
                this.sync();
                if (this.additionalDataRowVisible) {
                    return this.dpCurrentDataPage.getRowCount() + 1;
                }
                return this.dpCurrentDataPage.getRowCount();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSelectedRow() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.additionalDataRowVisible) {
                return this.getSelectedDataPageRow() + 1;
            }
            return this.getSelectedDataPageRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedRow(int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (this.getSelectedRow() != n) {
                this.invokeTreeSaveEditingControls();
                this.sync();
                boolean bl = EventHandler.isDispatchable(this.eventBeforeRowSelected);
                boolean bl2 = EventHandler.isDispatchable(this.eventAfterRowSelected);
                IDataRow iDataRow = bl || bl2 ? this.createDataRow(null) : null;
                if (this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                    this.saveDataRowLevelDetails(null);
                }
                if (bl) {
                    this.eventBeforeRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_ROW_SELECTED, iDataRow));
                }
                this.setSelectedRowInternal(n);
                if (bl2) {
                    this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iDataRow));
                }
            }
        }
    }

    @Override
    public String getSelectedColumn() throws ModelException {
        return this.sSelectedColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedColumn(String string) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (string != null) {
                this.rdRowDefinition.getColumnDefinition(string);
            }
            if (this.sSelectedColumn == null && string != null || this.sSelectedColumn != null && !this.sSelectedColumn.equals(string)) {
                if (EventHandler.isDispatchable(this.eventBeforeColumnSelected)) {
                    this.eventBeforeColumnSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_COLUMN_SELECTED, null));
                }
                this.sSelectedColumn = string;
                this.notifyRepaintControls();
                if (EventHandler.isDispatchable(this.eventAfterColumnSelected)) {
                    this.eventAfterColumnSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_COLUMN_SELECTED, null));
                }
            }
        }
    }

    @Override
    public boolean isDeleteCascade() {
        return this.bDeleteCascade;
    }

    @Override
    public void setDeleteCascade(boolean bl) {
        this.bDeleteCascade = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(boolean bl) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            boolean bl2;
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (this.dpCurrentDataPage == this.dpEmptyDataPage) {
                throw new ModelException("Master DataBook has no selected row! - " + this.rdMasterReference.getReferencedDataBook().getName());
            }
            if (!this.isInsertAllowed()) {
                throw new ModelException("Insert isn't allowed!");
            }
            this.invokeTreeSaveEditingControls();
            this.saveDataRowLevel(null);
            this.sync();
            if (!this.dpCurrentDataPage.isAllFetched() && this.dpCurrentDataPage.getRowCount() == 0) {
                this.getDataRow(0);
            }
            IDataRow iDataRow = (bl2 = EventHandler.isDispatchable(this.eventAfterRowSelected)) ? this.createDataRow(null) : null;
            if (EventHandler.isDispatchable(this.eventBeforeInserting)) {
                this.eventBeforeInserting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_INSERTING, null));
            }
            this.insertInternal(bl);
            this.copyMasterColumnsToCurrentDetail(false);
            if (EventHandler.isDispatchable(this.eventAfterInserting)) {
                this.eventAfterInserting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_INSERTING, null));
            }
            if (bl2) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iDataRow));
            }
            return this.iSelectedRowIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!(this.isUpdating() || this.isInserting() || this.isDeleting())) {
                if (!this.bIsOpen) {
                    throw new ModelException("DataBook isn't open! - " + this.sName);
                }
                this.sync();
                if (this.additionalDataRowVisible && this.getSelectedRow() == 0) {
                    return;
                }
                if (!this.isUpdateAllowed()) {
                    throw new ModelException("Update isn't allowed!");
                }
                this.saveDataRowLevel(this);
                boolean bl = EventHandler.isDispatchable(this.eventBeforeUpdating);
                boolean bl2 = EventHandler.isDispatchable(this.eventAfterUpdating);
                IDataRow iDataRow = bl || bl2 ? this.createDataRow(null) : null;
                if (bl) {
                    this.eventBeforeUpdating.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_UPDATING, iDataRow));
                }
                if (this.isWritebackEnabled() && this.isLockAndRefetchEnabled()) {
                    this.lockAndRefetchIntern();
                }
                this.setUpdating();
                this.dpCurrentDataPage.setDataRow(this.iSelectedRowIndex, this);
                this.setDetailsChangedInMasterBook();
                if (bl2) {
                    this.eventAfterUpdating.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_UPDATING, iDataRow));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (this.iSelectedRowIndex < 0) {
                return;
            }
            if (!this.isDeleteAllowed()) {
                throw new ModelException("Delete isn't allowed!");
            }
            if (!this.isDeleting()) {
                boolean bl;
                boolean bl2;
                boolean bl3 = EventHandler.isDispatchable(this.eventBeforeDeleting);
                boolean bl4 = EventHandler.isDispatchable(this.eventAfterDeleting);
                boolean bl5 = EventHandler.isDispatchable(this.eventBeforeRestore);
                boolean bl6 = EventHandler.isDispatchable(this.eventAfterRestore);
                boolean bl7 = EventHandler.isDispatchable(this.eventAfterRowSelected);
                IDataRow iDataRow = bl3 || bl4 || bl5 || bl6 || bl7 ? this.createDataRow(null) : null;
                if (bl3) {
                    this.eventBeforeDeleting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_DELETING, iDataRow));
                }
                if (bl2 = this.isInserting()) {
                    if (bl4) {
                        this.eventAfterDeleting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_DELETING, iDataRow));
                    }
                    if (bl5) {
                        this.eventBeforeRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RESTORE, iDataRow));
                    }
                }
                this.restoreSaveAllDetails();
                if (!this.isInserting()) {
                    this.restoreSelectedRow();
                } else {
                    this.invokeTreeCancelEditingControls();
                }
                if (!this.isInserting() && this.isWritebackEnabled() && this.isLockAndRefetchEnabled()) {
                    this.lockAndRefetchIntern();
                }
                if (bl = this.deleteInternal()) {
                    this.correctSelectedRowAfterDelete();
                    if (bl6) {
                        this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iDataRow));
                    }
                    if (bl7) {
                        this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iDataRow));
                    }
                }
                if (!bl2 && bl4) {
                    this.eventAfterDeleting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_DELETING, iDataRow));
                }
                if (!bl && IDataBook.WriteBackIsolationLevel.DATA_ROW.equals((Object)this.getWritebackIsolationLevel())) {
                    try {
                        this.saveSelectedRow();
                    }
                    catch (ModelException modelException) {
                        if (this.isDeleting()) {
                            this.restoreRow();
                        }
                        throw modelException;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllDataRows() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            this.fetchAll();
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                this.setSelectedRow(i);
                this.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDetailChanged() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            try {
                if (this.iSelectedRowIndex >= 0 && this.iSelectedRowIndex < this.dpCurrentDataPage.getRowCount()) {
                    boolean bl = false;
                    for (int i = this.auDetailDataBooks.size() - 1; !bl && i >= 0; --i) {
                        IDataPage iDataPage;
                        int[] nArray;
                        IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                        if (iDataBook2 == null || (nArray = (iDataPage = iDataBook2.isSelfJoined() ? iDataBook2.getDataPage(TreePath.EMPTY) : iDataBook2).getChangedDataRows()).length <= 0) continue;
                        bl = true;
                    }
                    if (bl != this.isDetailChanged()) {
                        this.setDetailChanged(bl);
                        this.dpCurrentDataPage.setDataRow(this.iSelectedRowIndex, this);
                    }
                }
                this.setDetailsChangedInMasterBook();
            }
            catch (ModelException modelException) {
                throw new RuntimeException(modelException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChangeableDataRow getDataRow(int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            if (n < 0) {
                return null;
            }
            this.sync();
            if (this.additionalDataRowVisible) {
                if (n == 0) {
                    return this.getAdditionalDataRow();
                }
                return this.getDataRowInternal(n - 1);
            }
            return this.getDataRowInternal(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeableDataRow getAdditionalDataRow() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            if (this.additionalDataRow == null) {
                this.additionalRowDefinition = this.rdRowDefinition.createRowDefinition(this.rdRowDefinition.getColumnNames());
                Class<? extends IControl>[] classArray = this.rdRowDefinition.getColumnViewClasses();
                this.additionalRowDefinition.setPrimaryKeyColumnNames(this.rdRowDefinition.getPrimaryKeyColumnNames());
                for (int i = 0; i < classArray.length; ++i) {
                    this.additionalRowDefinition.setColumnView(classArray[i], this.rdRowDefinition.getColumnView(classArray[i]));
                }
                IDataBook[] iDataBookArray = this.rdRowDefinition.getDataBooks();
                for (int i = 0; i < iDataBookArray.length; ++i) {
                    this.additionalRowDefinition.addDataBook(iDataBookArray[i]);
                }
                this.additionalDataRow = new ChangeableDataRow(this.additionalRowDefinition);
            }
            return this.additionalDataRow;
        }
    }

    @Override
    public boolean isAdditionalDataRowVisible() {
        return this.additionalDataRowVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdditionalDataRowVisible(boolean bl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (bl != this.additionalDataRowVisible) {
                this.additionalDataRowVisible = bl;
                this.notifyRepaintControls();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSelectedDataPageRow() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return -1;
            }
            this.sync();
            return this.iSelectedRowIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedDataPageRow(int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.additionalDataRowVisible) {
                this.setSelectedRow(n + 1);
            } else {
                this.setSelectedRow(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataRow getOriginalRow() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return null;
            }
            this.sync();
            return super.getOriginalRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWritableColumnChanged() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return false;
            }
            if (this.getSelectedDataPageRow() < 0) {
                return false;
            }
            return super.isWritableColumnChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeleting() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return false;
            }
            if (this.getSelectedDataPageRow() < 0) {
                return false;
            }
            return super.isDeleting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpdating() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return false;
            }
            if (this.getSelectedDataPageRow() < 0) {
                return false;
            }
            return super.isUpdating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInserting() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return false;
            }
            if (this.getSelectedDataPageRow() < 0) {
                return false;
            }
            return super.isInserting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDetailChanged() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return false;
            }
            if (this.getSelectedDataPageRow() < 0) {
                return false;
            }
            return super.isDetailChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUID() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return null;
            }
            if (this.getSelectedDataPageRow() < 0) {
                return null;
            }
            return super.getUID();
        }
    }

    @Override
    public ICondition getFilter() {
        return this.cFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFilter(ICondition iCondition) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (EventHandler.isDispatchable(this.eventBeforeFilterChanged)) {
                this.eventBeforeFilterChanged.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_FILTER_CHANGED, null));
            }
            if (this.bIsOpen && !this.ignoreReload) {
                if (!this.isMemFilter() || this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                    this.saveAllRows();
                } else {
                    this.invokeTreeSaveEditingControls();
                }
                if (EventHandler.isDispatchable(this.eventBeforeReload)) {
                    this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
                }
                if (this.iSelectionMode == IDataBook.SelectionMode.CURRENT_ROW_SETFILTER || this.iSelectionMode == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED_SETFILTER) {
                    this.handleStoreSelection(this.iSelectionMode);
                } else if (this.iSelectionMode == IDataBook.SelectionMode.DESELECTED || this.iSelectionMode == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED) {
                    this.handleStoreSelection(IDataBook.SelectionMode.DESELECTED);
                } else {
                    this.handleStoreSelection(IDataBook.SelectionMode.FIRST_ROW);
                }
                if (!this.isMemFilter()) {
                    this.restoreAllRows();
                }
            }
            this.cFilter = iCondition != null ? iCondition.clone() : null;
            if (EventHandler.isDispatchable(this.eventAfterFilterChanged)) {
                this.eventAfterFilterChanged.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_FILTER_CHANGED, null));
            }
            if (this.bIsOpen && !this.ignoreReload) {
                if (this.isMemFilter()) {
                    this.clearFilterSortInMemDataPages();
                    this.notifyRepaintControls();
                    if (EventHandler.isDispatchable(this.eventAfterReload)) {
                        this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
                    }
                } else {
                    this.reloadIntern();
                }
            }
        }
    }

    @Override
    public SortDefinition getSort() {
        return this.sSort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSort(SortDefinition sortDefinition) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (EventHandler.isDispatchable(this.eventBeforeSortChanged)) {
                this.eventBeforeSortChanged.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_SORT_CHANGED, null));
            }
            if (this.bIsOpen && !this.ignoreReload) {
                if (!this.isMemSort() || this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                    this.saveAllRows();
                } else {
                    this.invokeTreeSaveEditingControls();
                }
                if (EventHandler.isDispatchable(this.eventBeforeReload)) {
                    this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
                }
                this.handleStoreSelection(this.iSelectionMode);
                if (!this.isMemSort()) {
                    this.restoreAllRows();
                }
            }
            this.sSort = sortDefinition != null ? sortDefinition.clone() : null;
            if (EventHandler.isDispatchable(this.eventAfterSortChanged)) {
                this.eventAfterSortChanged.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_SORT_CHANGED, null));
            }
            if (this.bIsOpen && !this.ignoreReload) {
                if (this.isMemSort()) {
                    this.clearFilterSortInMemDataPages();
                    this.notifyRepaintControls();
                    if (EventHandler.isDispatchable(this.eventAfterReload)) {
                        this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
                    }
                } else {
                    this.reloadIntern();
                }
            }
        }
    }

    @Override
    public void reload() throws ModelException {
        this.reload(this.getSelectionMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(IDataBook.SelectionMode selectionMode) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen && !this.ignoreReload) {
                if (EventHandler.isDispatchable(this.eventBeforeReload)) {
                    this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
                }
                this.handleStoreSelection(selectionMode);
                this.restoreAllRows();
                this.reloadIntern();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreSelectedRow() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (this.iSelectedRowIndex < 0) {
                return;
            }
            this.invokeTreeCancelEditingControls();
            if (this.isInserting() || this.isUpdating() || this.isDeleting()) {
                this.restoreRow();
            }
            this.notifyRepaintControls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void restoreAllRows() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            ArrayUtil<TreePath> arrayUtil;
            int n;
            block17: {
                if (!this.bIsOpen) {
                    throw new ModelException("DataBook isn't open! - " + this.sName);
                }
                if (!this.hasChanges()) {
                    return;
                }
                this.sync();
                this.invokeTreeCancelEditingControls();
                if (this.getSelectedRow() >= 0 && (this.isInserting() || this.isUpdating() || this.isDeleting())) {
                    this.restoreRow();
                }
                n = this.getSelectedRow();
                arrayUtil = this.getAllDetailsTreePath();
                ICondition iCondition = null;
                try {
                    if (this.isMemFilter() && this.getWritebackIsolationLevel() != IDataBook.WriteBackIsolationLevel.DATA_ROW && this.getFilter() != null) {
                        iCondition = this.getFilter();
                        this.setFilter(null);
                        this.sync();
                    }
                    this.restoreDataPageIntern();
                    if (!this.bRestoreAllRows && this.rdMasterReference != null) {
                        Enumeration<MemDataPage> enumeration = this.htDataPagesCache.elements();
                        boolean bl = false;
                        while (enumeration.hasMoreElements() && !bl) {
                            MemDataPage memDataPage = enumeration.nextElement();
                            if (memDataPage.getChangedDataRows().length <= 0) continue;
                            bl = true;
                        }
                        if (bl) {
                            ReferenceDefinition referenceDefinition;
                            IDataBook iDataBook2 = this;
                            ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
                            while (referenceDefinition != null) {
                                iDataBook2 = referenceDefinition.getReferencedDataBook();
                                referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
                            }
                            TreePath treePath = null;
                            if (iDataBook2.isSelfJoined()) {
                                treePath = iDataBook2.getTreePath();
                                iDataBook2.setTreePath(null);
                            }
                            this.bRestoreAllRows = true;
                            try {
                                this.restoreTopDownAllRows(iDataBook2, this);
                                Object var12_11 = null;
                                this.bRestoreAllRows = false;
                            }
                            catch (Throwable throwable) {
                                Object var12_12 = null;
                                this.bRestoreAllRows = false;
                                throw throwable;
                            }
                            if (iDataBook2.isSelfJoined() && treePath != null) {
                                iDataBook2.setTreePath(treePath);
                            }
                        }
                    }
                    Object var14_14 = null;
                    if (iCondition == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    if (iCondition == null) throw throwable;
                    this.setFilter(iCondition);
                    throw throwable;
                }
                this.setFilter(iCondition);
            }
            if (this.getSelectedRow() != n) {
                this.setSelectedRow(n);
            }
            this.setAllDetailsTreePath(arrayUtil);
            this.notifyRepaintControls();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSelectedRow() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            if (this.getSelectedRow() < 0) {
                return;
            }
            this.invokeTreeSaveEditingControls();
            this.sync();
            if (this.isDeleting() || this.isUpdating() || this.isInserting()) {
                ArrayUtil<TreePath> arrayUtil = this.getAllDetailsTreePath();
                this.saveSelectedRowInternIncludeDetails();
                this.setAllDetailsTreePath(arrayUtil);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDataPage() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            int n = this.iSelectedRowIndex;
            ArrayUtil<TreePath> arrayUtil = this.getAllDetailsTreePath();
            this.saveDataPageIntern();
            if (n >= this.getRowCount()) {
                this.iSelectedRowIndex = n;
                this.correctSelectedRowAfterDelete();
            } else {
                if (this.iSelectedRowIndex != n) {
                    this.setSelectedRow(n);
                }
                this.setAllDetailsTreePath(arrayUtil);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveAllRows() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.invokeTreeSaveEditingControls();
            if (!this.hasChanges()) {
                return;
            }
            this.sync();
            if (this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                this.saveSelectedRow();
            } else {
                ArrayUtil<TreePath> arrayUtil;
                block24: {
                    this.iOldSelectedRowSaveAllRows = this.iSelectedRowIndex;
                    this.dpOldCurrentDataPageSaveAllRows = this.dpCurrentDataPage;
                    arrayUtil = this.getAllDetailsTreePath();
                    ICondition iCondition = null;
                    try {
                        int n;
                        Object object;
                        if (this.isMemFilter() && this.getWritebackIsolationLevel() != IDataBook.WriteBackIsolationLevel.DATA_ROW && this.getFilter() != null) {
                            iCondition = this.getFilter();
                            this.setFilter(null);
                            this.sync();
                        }
                        this.saveDataPageIntern();
                        if (this.isSelfJoined()) {
                            object = this.getTreePath();
                            if (object != null && ((TreePath)object).length() > 0) {
                                this.setTreePathInternal(null);
                            }
                            n = this.getRowCount();
                            for (int i = 0; i < n; ++i) {
                                this.setSelectedRow(i);
                                this.saveSelfJoinedDetailRows();
                            }
                            if (object != null && ((TreePath)object).length() > 0) {
                                this.setTreePathInternal((TreePath)object);
                            }
                        }
                        if (!this.bSaveAllRows && this.rdMasterReference != null) {
                            object = this.htDataPagesCache.elements();
                            n = 0;
                            while (object.hasMoreElements() && n == 0) {
                                MemDataPage memDataPage = (MemDataPage)object.nextElement();
                                if (memDataPage.getChangedDataRows().length <= 0) continue;
                                n = 1;
                            }
                            if (n != 0) {
                                ReferenceDefinition referenceDefinition;
                                IDataBook iDataBook2 = this;
                                ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
                                while (referenceDefinition != null) {
                                    iDataBook2 = referenceDefinition.getReferencedDataBook();
                                    referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
                                }
                                TreePath treePath = null;
                                if (iDataBook2.isSelfJoined()) {
                                    treePath = iDataBook2.getTreePath();
                                    iDataBook2.setTreePath(null);
                                }
                                this.bSaveAllRows = true;
                                try {
                                    this.saveTopDownAllRows(iDataBook2, this);
                                    Object var11_11 = null;
                                    this.bSaveAllRows = false;
                                }
                                catch (Throwable throwable) {
                                    Object var11_12 = null;
                                    this.bSaveAllRows = false;
                                    throw throwable;
                                }
                                if (iDataBook2.isSelfJoined() && treePath != null) {
                                    iDataBook2.setTreePath(treePath);
                                }
                            }
                        }
                        Object var13_14 = null;
                        if (iCondition == null) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        if (iCondition == null) throw throwable;
                        this.setFilter(iCondition);
                        throw throwable;
                    }
                    this.setFilter(iCondition);
                }
                if (this.iOldSelectedRowSaveAllRows >= this.getRowCount()) {
                    this.iSelectedRowIndex = this.iOldSelectedRowSaveAllRows;
                    this.correctSelectedRowAfterDelete();
                } else {
                    if (this.iSelectedRowIndex != this.iOldSelectedRowSaveAllRows) {
                        this.setSelectedRow(this.iOldSelectedRowSaveAllRows);
                    }
                    this.setAllDetailsTreePath(arrayUtil);
                }
            }
            return;
        }
    }

    @Override
    public boolean isOutOfSync() {
        return this.dpCurrentDataPage == null || this.rdMasterReference != null && this.bMasterChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAllFetched() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            return this.dpCurrentDataPage.isAllFetched();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAll() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (this.dpCurrentDataPage == this.dpEmptyDataPage) {
                return;
            }
            this.dpCurrentDataPage.fetchAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataRow getMasterDataRow() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return null;
            }
            this.sync();
            return this.dpCurrentDataPage.getMasterDataRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDetailDataBook(IDataBook iDataBook) {
        IDataBook iDataBook2 = this.rootDataBook;
        synchronized (iDataBook2) {
            if (this.auDetailDataBooks == null) {
                this.auDetailDataBooks = new ArrayUtil();
            } else {
                for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                    if (this.auDetailDataBooks.get(i).get() != null) continue;
                    this.auDetailDataBooks.remove(i);
                }
            }
            this.auDetailDataBooks.add(new WeakReference<IDataBook>(iDataBook));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDetailDataBook(IDataBook iDataBook) {
        IDataBook iDataBook2 = this.rootDataBook;
        synchronized (iDataBook2) {
            if (this.auDetailDataBooks != null) {
                for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                    IDataBook iDataBook3 = (IDataBook)this.auDetailDataBooks.get(i).get();
                    if (iDataBook3 != null && iDataBook3 != iDataBook) continue;
                    this.auDetailDataBooks.remove(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataBook[] getDetailDataBooks() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            ArrayUtil<IDataBook> arrayUtil = new ArrayUtil<IDataBook>();
            if (this.auDetailDataBooks != null) {
                for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                    IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                    if (iDataBook2 == null) {
                        this.auDetailDataBooks.remove(i);
                        continue;
                    }
                    arrayUtil.add(0, iDataBook2);
                }
            }
            return arrayUtil.toArray(new IDataBook[arrayUtil.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getChangedDataRows() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            IDataBook iDataBook2;
            IDataRow iDataRow;
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            if (this.dpCurrentDataPage == null) {
                return MemDataPage.EMPTY_INT_ARRAY;
            }
            if (this.rdMasterReference != null && !this.isSelfJoined() && this.htDataPagesCache.get(iDataRow = this.getMasterDataRow(iDataBook2 = this.rdMasterReference.getReferencedDataBook())) == null) {
                if (iDataBook2.getUID() != null) {
                    if (this.htDataPagesCache.get(iDataBook2.getUID()) == null) {
                        return MemDataPage.EMPTY_INT_ARRAY;
                    }
                } else {
                    return MemDataPage.EMPTY_INT_ARRAY;
                }
            }
            this.sync();
            return this.dpCurrentDataPage.getChangedDataRows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataPage getDataPage(IDataRow iDataRow) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.rdMasterReference == null) {
                this.sync();
                return this.dpCurrentDataPage;
            }
            return this.getDataPageIntern(iDataRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDataPage(IDataRow iDataRow) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.rdMasterReference == null) {
                return iDataRow == null;
                {
                }
            }
            IDataRow iDataRow2 = this.getMasterDataRow(iDataRow);
            MemDataPage memDataPage = this.htDataPagesCache.get(iDataRow2);
            if (memDataPage == null && iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
                memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow).getUID());
            }
            return memDataPage != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int searchNext(ICondition iCondition) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.sync();
            int n = this.dpCurrentDataPage.searchNext(iCondition);
            if (this.additionalDataRowVisible) {
                return n + 1;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int searchNext(ICondition iCondition, int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.sync();
            int n2 = this.dpCurrentDataPage.searchNext(iCondition, n);
            if (this.additionalDataRowVisible) {
                return n2 + 1;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int searchPrevious(ICondition iCondition) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.sync();
            int n = this.dpCurrentDataPage.searchPrevious(iCondition);
            if (this.additionalDataRowVisible) {
                return n + 1;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int searchPrevious(ICondition iCondition, int n) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.sync();
            int n2 = this.dpCurrentDataPage.searchPrevious(iCondition, n);
            if (this.additionalDataRowVisible) {
                return n2 + 1;
            }
            return n2;
        }
    }

    @Override
    public DataBookHandler eventBeforeRowSelected() {
        if (this.eventBeforeRowSelected == null) {
            this.eventBeforeRowSelected = new DataBookHandler();
        }
        return this.eventBeforeRowSelected;
    }

    @Override
    public DataBookHandler eventAfterRowSelected() {
        if (this.eventAfterRowSelected == null) {
            this.eventAfterRowSelected = new DataBookHandler();
        }
        return this.eventAfterRowSelected;
    }

    @Override
    public DataBookHandler eventBeforeInserting() {
        if (this.eventBeforeInserting == null) {
            this.eventBeforeInserting = new DataBookHandler();
        }
        return this.eventBeforeInserting;
    }

    @Override
    public DataBookHandler eventAfterInserting() {
        if (this.eventAfterInserting == null) {
            this.eventAfterInserting = new DataBookHandler();
        }
        return this.eventAfterInserting;
    }

    @Override
    public DataBookHandler eventBeforeInserted() {
        if (this.eventBeforeInserted == null) {
            this.eventBeforeInserted = new DataBookHandler();
        }
        return this.eventBeforeInserted;
    }

    @Override
    public DataBookHandler eventAfterInserted() {
        if (this.eventAfterInserted == null) {
            this.eventAfterInserted = new DataBookHandler();
        }
        return this.eventAfterInserted;
    }

    @Override
    public DataBookHandler eventBeforeUpdating() {
        if (this.eventBeforeUpdating == null) {
            this.eventBeforeUpdating = new DataBookHandler();
        }
        return this.eventBeforeUpdating;
    }

    @Override
    public DataBookHandler eventAfterUpdating() {
        if (this.eventAfterUpdating == null) {
            this.eventAfterUpdating = new DataBookHandler();
        }
        return this.eventAfterUpdating;
    }

    @Override
    public DataBookHandler eventBeforeUpdated() {
        if (this.eventBeforeUpdated == null) {
            this.eventBeforeUpdated = new DataBookHandler();
        }
        return this.eventBeforeUpdated;
    }

    @Override
    public DataBookHandler eventAfterUpdated() {
        if (this.eventAfterUpdated == null) {
            this.eventAfterUpdated = new DataBookHandler();
        }
        return this.eventAfterUpdated;
    }

    @Override
    public DataBookHandler eventBeforeDeleting() {
        if (this.eventBeforeDeleting == null) {
            this.eventBeforeDeleting = new DataBookHandler();
        }
        return this.eventBeforeDeleting;
    }

    @Override
    public DataBookHandler eventAfterDeleting() {
        if (this.eventAfterDeleting == null) {
            this.eventAfterDeleting = new DataBookHandler();
        }
        return this.eventAfterDeleting;
    }

    @Override
    public DataBookHandler eventBeforeDeleted() {
        if (this.eventBeforeDeleted == null) {
            this.eventBeforeDeleted = new DataBookHandler();
        }
        return this.eventBeforeDeleted;
    }

    @Override
    public DataBookHandler eventAfterDeleted() {
        if (this.eventAfterDeleted == null) {
            this.eventAfterDeleted = new DataBookHandler();
        }
        return this.eventAfterDeleted;
    }

    @Override
    public DataBookHandler eventBeforeRestore() {
        if (this.eventBeforeRestore == null) {
            this.eventBeforeRestore = new DataBookHandler();
        }
        return this.eventBeforeRestore;
    }

    @Override
    public DataBookHandler eventAfterRestore() {
        if (this.eventAfterRestore == null) {
            this.eventAfterRestore = new DataBookHandler();
        }
        return this.eventAfterRestore;
    }

    @Override
    public DataBookHandler eventBeforeReload() {
        if (this.eventBeforeReload == null) {
            this.eventBeforeReload = new DataBookHandler();
        }
        return this.eventBeforeReload;
    }

    @Override
    public DataBookHandler eventAfterReload() {
        if (this.eventAfterReload == null) {
            this.eventAfterReload = new DataBookHandler();
        }
        return this.eventAfterReload;
    }

    @Override
    public DataBookHandler eventBeforeFilterChanged() {
        if (this.eventBeforeFilterChanged == null) {
            this.eventBeforeFilterChanged = new DataBookHandler();
        }
        return this.eventBeforeFilterChanged;
    }

    @Override
    public DataBookHandler eventAfterFilterChanged() {
        if (this.eventAfterFilterChanged == null) {
            this.eventAfterFilterChanged = new DataBookHandler();
        }
        return this.eventAfterFilterChanged;
    }

    @Override
    public DataBookHandler eventBeforeSortChanged() {
        if (this.eventBeforeSortChanged == null) {
            this.eventBeforeSortChanged = new DataBookHandler();
        }
        return this.eventBeforeSortChanged;
    }

    @Override
    public DataBookHandler eventAfterSortChanged() {
        if (this.eventAfterSortChanged == null) {
            this.eventAfterSortChanged = new DataBookHandler();
        }
        return this.eventAfterSortChanged;
    }

    @Override
    public DataBookHandler eventBeforeColumnSelected() {
        if (this.eventBeforeColumnSelected == null) {
            this.eventBeforeColumnSelected = new DataBookHandler();
        }
        return this.eventBeforeColumnSelected;
    }

    @Override
    public DataBookHandler eventAfterColumnSelected() {
        if (this.eventAfterColumnSelected == null) {
            this.eventAfterColumnSelected = new DataBookHandler();
        }
        return this.eventAfterColumnSelected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addControl(IControl iControl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            super.addControl(iControl);
            this.invokeRepaintListeners = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowIndex() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            try {
                this.sync();
                return this.iSelectedRowIndex;
            }
            catch (ModelException modelException) {
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataPage getDataPage() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            try {
                this.sync();
                return this.dpCurrentDataPage;
            }
            catch (ModelException modelException) {
                return null;
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(String string) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return null;
            }
            this.sync();
            if (this.getSelectedRow() < 0) {
                return null;
            }
            return super.getValue(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String string, Object object) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (this.iSelectedRowIndex < -1 || !this.additionalDataRowVisible && this.iSelectedRowIndex < 0) {
                throw new ModelException("No selected row!");
            }
            if (this.additionalDataRowVisible && this.iSelectedRowIndex == -1) {
                this.getAdditionalDataRow().setValue(string, object);
            } else {
                this.update();
                super.setValue(string, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getValues(String[] stringArray) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return null;
            }
            this.sync();
            if (this.getSelectedRow() < 0) {
                return null;
            }
            return super.getValues(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataRow createDataRow(String[] stringArray) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                return this.createEmptyRow(stringArray);
            }
            this.sync();
            return super.createDataRow(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValues(String[] stringArray, Object[] objectArray) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (this.getSelectedRow() < 0) {
                throw new ModelException("No selected row!");
            }
            if (this.additionalDataRowVisible && this.getSelectedRow() == 0) {
                this.getAdditionalDataRow().setValues(stringArray, objectArray);
            } else {
                this.update();
                if (stringArray == null) {
                    stringArray = this.rdRowDefinition.getColumnNames();
                }
                super.setValues(stringArray, objectArray);
            }
        }
    }

    @Override
    public String toString() {
        IDataPage iDataPage;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Class           = ");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("\nName            = ");
        stringBuilder.append(this.sName);
        stringBuilder.append("\nisOpen          = ");
        stringBuilder.append(this.bIsOpen);
        if (this.rdRowDefinition != null) {
            stringBuilder.append("\nRowDefinition   = ");
            stringBuilder.append(this.rdRowDefinition);
        }
        if (this.rdMasterReference != null) {
            stringBuilder.append("\nMasterReference = ");
            stringBuilder.append(this.rdMasterReference);
        }
        if (this.cFilter != null) {
            stringBuilder.append("\nFilter          = ");
            stringBuilder.append(this.cFilter);
        }
        if (this.sSort != null) {
            stringBuilder.append("\nSortDefinition  = ");
            stringBuilder.append(this.sSort);
        }
        if (this.auDetailDataBooks != null && this.auDetailDataBooks.size() > 0) {
            stringBuilder.append("\nDetailBooks     = [");
            int n2 = 0;
            n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                iDataPage = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataPage == null) continue;
                if (n2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(iDataPage.getName());
                ++n2;
            }
            stringBuilder.append("]");
        }
        if (this.bIsOpen) {
            try {
                this.sync();
            }
            catch (ModelException modelException) {
                stringBuilder.append("\n");
                stringBuilder.append(ExceptionUtil.dump(modelException, true));
                return stringBuilder.toString();
            }
            if (this.treePath != null && this.treePath.length() > 0) {
                stringBuilder.append("\nTreePath        = ");
                stringBuilder.append(this.treePath);
            }
            stringBuilder.append("\nSelectedRow     = ");
            stringBuilder.append(this.iSelectedRowIndex);
            stringBuilder.append("\n\n== CURRENT DataPage ==\n\n");
            stringBuilder.append(this.dpCurrentDataPage);
            Enumeration<MemDataPage> enumeration = this.htDataPagesCache.elements();
            Enumeration<Object> enumeration2 = this.htDataPagesCache.keys();
            n = 1;
            while (enumeration.hasMoreElements()) {
                if (n != 0) {
                    stringBuilder.append("\n\n== DataPage CACHE ==\n");
                    n = 0;
                }
                stringBuilder.append("\n");
                iDataPage = enumeration.nextElement();
                Object object = enumeration2.nextElement();
                stringBuilder.append("Key      = ");
                stringBuilder.append(object);
                if (iDataPage != this.dpCurrentDataPage) {
                    stringBuilder.append(", Class = ");
                    stringBuilder.append(object.getClass().getName());
                    stringBuilder.append("\n");
                    stringBuilder.append(((MemDataPage)iDataPage).toString("           "));
                    continue;
                }
                stringBuilder.append(" => (CURRENT DataPage)");
                stringBuilder.append(", Class = ");
                stringBuilder.append(object.getClass().getName());
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRepaintControls() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.factory != null && this.invokeRepaintListeners && this.hasControls()) {
                this.invokeRepaintListeners = false;
                if (!this.invokeLaterRepaintListenersCalled) {
                    this.invokeLaterRepaintListenersCalled = true;
                    this.factory.invokeLater(new Runnable(){

                        public void run() {
                            MemDataBook.this.invokeRepaintListeners();
                            MemDataBook.this.invokeLaterRepaintListenersCalled = false;
                            MemDataBook.this.invokeRepaintListeners = true;
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveEditingControls() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.factory != null && this.invokeSaveEditingControls && this.hasControls()) {
                this.invokeSaveEditingControls = false;
                this.invokeSaveEditingControls();
                this.factory.invokeLater(new Runnable(){

                    public void run() {
                        MemDataBook.this.invokeSaveEditingControls = true;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelEditingControls() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.factory != null && this.invokeCancelEditingControls && this.hasControls()) {
                this.invokeCancelEditingControls = false;
                this.invokeCancelEditingControls();
                this.factory.invokeLater(new Runnable(){

                    public void run() {
                        MemDataBook.this.invokeCancelEditingControls = true;
                    }
                });
            }
        }
    }

    @Override
    public IRowDefinition getRowDefinition() {
        if (this.additionalDataRowVisible && this.iSelectedRowIndex == -1 && this.additionalRowDefinition != null) {
            return this.additionalRowDefinition;
        }
        return super.getRowDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTopDownAllRows(IDataBook iDataBook, IDataBook iDataBook2) throws ModelException {
        if (iDataBook == iDataBook2) {
            iDataBook.restoreAllRows();
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = iDataBook.getSelectedRow();
            IDataBook[] iDataBookArray = iDataBook.getDetailDataBooks();
            ArrayUtil<TreePath> arrayUtil = new ArrayUtil<TreePath>();
            if (iDataBookArray != null) {
                int n6 = iDataBookArray.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (!iDataBookArray[n4].isSelfJoined()) continue;
                    arrayUtil.add(iDataBookArray[n4].getTreePath());
                }
            }
            if ((n4 = iDataBook.isAdditionalDataRowVisible()) != 0) {
                iDataBook.setAdditionalDataRowVisible(false);
            }
            try {
                int[] nArray = iDataBook.getChangedDataRows();
                Arrays.sort(nArray);
                for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                    iDataBook.setSelectedRow(nArray[n3]);
                    if (!iDataBook.isDetailChanged()) continue;
                    if (iDataBookArray != null) {
                        n2 = iDataBookArray.length;
                        for (n = 0; n < n2 && iDataBook.isDetailChanged(); ++n) {
                            if (iDataBookArray[n].isSelfJoined()) {
                                iDataBookArray[n].setTreePath(null);
                            }
                            this.restoreTopDownAllRows(iDataBookArray[n], iDataBook2);
                        }
                    }
                    if (!iDataBook.isSelfJoined() || !iDataBook.isDetailChanged() || !iDataBook.hasDataPage(iDataBook)) continue;
                    TreePath treePath = iDataBook.getTreePath();
                    iDataBook.setTreePath(treePath.getChildPath(iDataBook.getSelectedRow()));
                    this.restoreTopDownAllRows(iDataBook, iDataBook2);
                    iDataBook.setTreePath(treePath);
                }
                Object var12_14 = null;
                if (n4 != 0) {
                    iDataBook.setAdditionalDataRowVisible(true);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (n4 != 0) {
                    iDataBook.setAdditionalDataRowVisible(true);
                }
                throw throwable;
            }
            iDataBook.setSelectedRow(n5);
            if (iDataBookArray != null) {
                int n7 = 0;
                n = iDataBookArray.length;
                n2 = arrayUtil.size();
                for (n3 = 0; n3 < n && n7 < n2; ++n3) {
                    if (!iDataBookArray[n3].isSelfJoined()) continue;
                    iDataBookArray[n3].setTreePath((TreePath)arrayUtil.get(n7));
                    ++n7;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreDataPage() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            int n = this.getSelectedRow();
            ArrayUtil<TreePath> arrayUtil = this.getAllDetailsTreePath();
            this.restoreDataPageIntern();
            if (n >= this.getRowCount()) {
                this.iSelectedRowIndex = n;
                this.correctSelectedRowAfterDelete();
            } else {
                if (this.getSelectedRow() != n) {
                    this.setSelectedRow(n);
                }
                this.setAllDetailsTreePath(arrayUtil);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDataPageIntern() throws ModelException {
        boolean bl;
        block9: {
            ICondition iCondition = null;
            bl = this.isAdditionalDataRowVisible();
            if (bl) {
                this.setAdditionalDataRowVisible(false);
            }
            try {
                int[] nArray;
                if (this.isMemFilter() && this.getWritebackIsolationLevel() != IDataBook.WriteBackIsolationLevel.DATA_ROW && this.getFilter() != null) {
                    iCondition = this.getFilter();
                    this.setFilter(null);
                    this.sync();
                }
                if ((nArray = this.dpCurrentDataPage.getChangedDataRows()).length > 0) {
                    Arrays.sort(nArray);
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        this.setSelectedRow(nArray[i]);
                        this.restoreRow();
                    }
                }
                Object var6_5 = null;
                if (iCondition == null) break block9;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (iCondition != null) {
                    this.setFilter(iCondition);
                }
                if (bl) {
                    this.setAdditionalDataRowVisible(true);
                }
                throw throwable;
            }
            this.setFilter(iCondition);
        }
        if (bl) {
            this.setAdditionalDataRowVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDataPageIntern() throws ModelException {
        boolean bl;
        block11: {
            ICondition iCondition = null;
            bl = this.isAdditionalDataRowVisible();
            if (bl) {
                this.setAdditionalDataRowVisible(false);
            }
            try {
                int[] nArray;
                if (this.isMemFilter() && this.getWritebackIsolationLevel() != IDataBook.WriteBackIsolationLevel.DATA_ROW && this.getFilter() != null) {
                    iCondition = this.getFilter();
                    this.setFilter(null);
                    this.sync();
                }
                if ((nArray = this.dpCurrentDataPage.getChangedDataRows()).length > 0) {
                    int n;
                    Arrays.sort(nArray);
                    for (n = nArray.length - 1; n >= 0; --n) {
                        if (!this.getDataRow(nArray[n]).isDeleting()) continue;
                        this.setSelectedRow(nArray[n]);
                        this.saveSelectedRowInternIncludeDetails();
                    }
                    nArray = this.dpCurrentDataPage.getChangedDataRows();
                    for (n = nArray.length - 1; n >= 0; --n) {
                        if (!this.getDataRow(nArray[n]).isUpdating()) continue;
                        this.setSelectedRow(nArray[n]);
                        this.saveSelectedRowInternIncludeDetails();
                        nArray = this.dpCurrentDataPage.getChangedDataRows();
                        if (n <= nArray.length) continue;
                        n = nArray.length;
                    }
                    nArray = this.dpCurrentDataPage.getChangedDataRows();
                    for (n = nArray.length - 1; n >= 0; --n) {
                        if (!this.getDataRow(nArray[n]).isInserting()) continue;
                        this.setSelectedRow(nArray[n]);
                        this.saveSelectedRowInternIncludeDetails();
                        nArray = this.dpCurrentDataPage.getChangedDataRows();
                        if (n <= nArray.length) continue;
                        n = nArray.length;
                    }
                }
                Object var6_5 = null;
                if (iCondition == null) break block11;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (iCondition != null) {
                    this.setFilter(iCondition);
                }
                if (bl) {
                    this.setAdditionalDataRowVisible(true);
                }
                throw throwable;
            }
            this.setFilter(iCondition);
        }
        if (bl) {
            this.setAdditionalDataRowVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTopDownAllRows(IDataBook iDataBook, IDataBook iDataBook2) throws ModelException {
        if (iDataBook == iDataBook2) {
            iDataBook.saveAllRows();
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = iDataBook.getSelectedRow();
            IDataBook[] iDataBookArray = iDataBook.getDetailDataBooks();
            ArrayUtil<TreePath> arrayUtil = new ArrayUtil<TreePath>();
            if (iDataBookArray != null) {
                int n6 = iDataBookArray.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (!iDataBookArray[n4].isSelfJoined()) continue;
                    arrayUtil.add(iDataBookArray[n4].getTreePath());
                }
            }
            if ((n4 = iDataBook.isAdditionalDataRowVisible()) != 0) {
                iDataBook.setAdditionalDataRowVisible(false);
            }
            try {
                int[] nArray = iDataBook.getChangedDataRows();
                Arrays.sort(nArray);
                for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                    iDataBook.setSelectedRow(nArray[n3]);
                    if (!iDataBook.isDetailChanged()) continue;
                    if (iDataBookArray != null) {
                        n2 = iDataBookArray.length;
                        for (n = 0; n < n2 && iDataBook.isDetailChanged(); ++n) {
                            if (iDataBookArray[n].isSelfJoined()) {
                                iDataBookArray[n].setTreePath(null);
                            }
                            this.saveTopDownAllRows(iDataBookArray[n], iDataBook2);
                        }
                    }
                    if (!iDataBook.isSelfJoined() || !iDataBook.isDetailChanged() || !iDataBook.hasDataPage(iDataBook)) continue;
                    TreePath treePath = iDataBook.getTreePath();
                    iDataBook.setTreePath(treePath.getChildPath(iDataBook.getSelectedRow()));
                    this.saveTopDownAllRows(iDataBook, iDataBook2);
                    iDataBook.setTreePath(treePath);
                }
                Object var12_14 = null;
                if (n4 != 0) {
                    iDataBook.setAdditionalDataRowVisible(true);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (n4 != 0) {
                    iDataBook.setAdditionalDataRowVisible(true);
                }
                throw throwable;
            }
            iDataBook.setSelectedRow(n5);
            if (iDataBookArray != null) {
                int n7 = 0;
                n = iDataBookArray.length;
                n2 = arrayUtil.size();
                for (n3 = 0; n3 < n && n7 < n2; ++n3) {
                    if (!iDataBookArray[n3].isSelfJoined()) continue;
                    iDataBookArray[n3].setTreePath((TreePath)arrayUtil.get(n7));
                    ++n7;
                }
            }
        }
    }

    private ArrayUtil<TreePath> getAllDetailsTreePath() {
        if (this.auDetailDataBooks != null) {
            ArrayUtil<TreePath> arrayUtil = new ArrayUtil<TreePath>();
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null || !iDataBook.isSelfJoined()) continue;
                arrayUtil.add(iDataBook.getTreePath());
            }
            return arrayUtil;
        }
        return null;
    }

    private void setAllDetailsTreePath(ArrayUtil<TreePath> arrayUtil) throws ModelException {
        if (this.auDetailDataBooks != null && arrayUtil != null) {
            int n = 0;
            int n2 = this.auDetailDataBooks.size();
            int n3 = arrayUtil.size();
            for (int i = 0; i < n2 && n < n3; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (!iDataBook.isSelfJoined()) continue;
                iDataBook.setTreePath(arrayUtil.get(n));
                ++n;
            }
        }
    }

    private void saveSelectedRowInternIncludeDetails() throws ModelException {
        this.saveSelectedRowIntern();
        if (this.isSelfJoined()) {
            this.saveSelfJoinedDetailRows();
        }
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.saveAllRows();
            }
        }
    }

    private void repositionCurrentDataRow() throws ModelException {
        if (this.sSort != null) {
            int n;
            ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.rdRowDefinition, this.oaStorage, this.dpCurrentDataPage, this.iSelectedRowIndex);
            this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
            int n2 = this.dpCurrentDataPage.getRowCount();
            for (n = 0; n < n2 && this.dpCurrentDataPage.getDataRow(n).compareTo(changeableDataRow, this.sSort) < 0; ++n) {
            }
            this.dpCurrentDataPage.insert(n, changeableDataRow);
            if (this.dpOldCurrentDataPageSaveAllRows == this.dpCurrentDataPage) {
                if (this.iOldSelectedRowSaveAllRows == this.iSelectedRowIndex) {
                    this.iOldSelectedRowSaveAllRows = n;
                } else if (this.iSelectedRowIndex > this.iOldSelectedRowSaveAllRows && n <= this.iOldSelectedRowSaveAllRows) {
                    ++this.iOldSelectedRowSaveAllRows;
                } else if (this.iSelectedRowIndex < this.iOldSelectedRowSaveAllRows && n > this.iOldSelectedRowSaveAllRows) {
                    --this.iOldSelectedRowSaveAllRows;
                }
            }
            this.setSelectedRowInternal(n);
            this.setDetailsChangedInMasterBook();
        }
    }

    private int addDataRowAtRightPosition(ChangeableDataRow changeableDataRow, MemDataPage memDataPage, int n) throws ModelException {
        boolean bl = true;
        if (this.isDataPageRefetchPossible()) {
            if (this.getFilter() != null && !this.isMemFilter() && !this.getFilter().isFulfilled(changeableDataRow)) {
                bl = false;
            }
            if (bl && this.getSort() != null && !this.isMemSort()) {
                int n2 = memDataPage.getRowCount();
                while (n < n2 && memDataPage.getDataRow(n).compareTo(changeableDataRow, this.sSort) <= 0) {
                    ++n;
                }
            }
        }
        if (bl) {
            memDataPage.insert(n, changeableDataRow);
            if (this.dpOldCurrentDataPageSaveAllRows == memDataPage && n <= this.iOldSelectedRowSaveAllRows) {
                ++this.iOldSelectedRowSaveAllRows;
            }
        }
        if (!this.isDataPageRefetchPossible()) {
            memDataPage.clear();
            String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
            if (stringArray == null) {
                stringArray = this.rdRowDefinition.getColumnNames();
            }
            n = memDataPage.searchNext(Filter.createEqualsFilter(changeableDataRow, stringArray));
        }
        if (bl && this.isSelfJoined()) {
            int n3;
            IDataBook iDataBook = null;
            if (this.rdTreeRootReference != null) {
                iDataBook = this.rdTreeRootReference.getReferencedDataBook();
            }
            IDataPage iDataPage = this.getDataPageWithRootRow(iDataBook);
            for (n3 = 0; memDataPage != iDataPage && iDataPage != null && n3 < this.treePath.length() - 1; ++n3) {
                IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(this.treePath.get(n3));
                iDataPage = iChangeableDataRow == null ? null : this.getDataPageIntern(iChangeableDataRow);
            }
            if (memDataPage == iDataPage && n <= this.treePath.get(n3)) {
                this.treePath = this.treePath.set(n3, this.treePath.get(n3) + 1);
            }
        }
        return n;
    }

    private void moveDataRowToCorrectMaster() throws ModelException {
        String[] stringArray = this.rdMasterReference.getReferencedColumnNames();
        IDataRow iDataRow = this.rdMasterReference.getReferencedDataBook().createEmptyRow(stringArray);
        iDataRow.setValues(stringArray, this.getValues(this.rdMasterReference.getColumnNames()));
        MemDataPage memDataPage = null;
        int n = 0;
        if (this.hasDataPage(iDataRow)) {
            memDataPage = (MemDataPage)this.getDataPage(iDataRow);
            ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.rdRowDefinition, this.oaStorage, memDataPage, n);
            this.addDataRowAtRightPosition(changeableDataRow, memDataPage, 0);
        } else if (!this.isDataPageRefetchPossible()) {
            memDataPage = (MemDataPage)this.getDataPage(iDataRow);
            ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.rdRowDefinition, this.oaStorage, memDataPage, n);
            memDataPage.insert(n, changeableDataRow);
        }
        if (this.dpOldCurrentDataPageSaveAllRows == this.dpCurrentDataPage && this.iSelectedRowIndex < this.iOldSelectedRowSaveAllRows) {
            --this.iOldSelectedRowSaveAllRows;
        }
        this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
        this.setDetailsChangedInMasterBook();
        this.correctSelectedRowAfterDelete();
    }

    private void saveSelectedRowIntern() throws ModelException {
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            return;
        }
        if (this.isDeleting()) {
            boolean bl = EventHandler.isDispatchable(this.eventBeforeDeleted);
            boolean bl2 = EventHandler.isDispatchable(this.eventAfterDeleted);
            boolean bl3 = EventHandler.isDispatchable(this.eventAfterRowSelected);
            IDataRow iDataRow = bl || bl2 || bl3 ? this.createDataRow(null) : null;
            if (bl) {
                this.eventBeforeDeleted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_DELETED, iDataRow));
            }
            if (this.isSelfJoined() && this.hasDataPage(this)) {
                if (this.isDeleteCascade()) {
                    TreePath treePath = this.getTreePath();
                    this.setTreePath(treePath.getChildPath(this.iSelectedRowIndex));
                    this.deleteAllDataRows();
                    this.setTreePath(treePath);
                    this.saveSelfJoinedDetailRows();
                } else if (this.treePath != null) {
                    this.removeDataPage(null, this.treePath.getChildPath(this.getSelectedRow()));
                } else {
                    this.removeDataPage(null, null);
                }
            }
            if (this.auDetailDataBooks != null) {
                int n = this.auDetailDataBooks.size();
                for (int i = 0; i < n; ++i) {
                    IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                    if (iDataBook == null) continue;
                    if (iDataBook.isDeleteCascade()) {
                        iDataBook.deleteAllDataRows();
                        iDataBook.saveAllRows();
                        continue;
                    }
                    iDataBook.removeDataPage(this, null);
                }
            }
            if (this.isWritebackEnabled()) {
                this.executeDelete(this);
            }
            this.store();
            this.correctSelectedRowAfterDelete();
            if (bl2) {
                this.eventAfterDeleted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_DELETED, iDataRow));
            }
            if (bl3) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iDataRow));
            }
        } else if (this.isUpdating()) {
            String[] stringArray;
            boolean bl = EventHandler.isDispatchable(this.eventBeforeUpdated);
            boolean bl4 = EventHandler.isDispatchable(this.eventAfterUpdated);
            IDataRow iDataRow = bl || bl4 || this.rdMasterReference != null ? this.getOriginalRow() : null;
            if (bl) {
                this.eventBeforeUpdated.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_UPDATED, iDataRow));
            }
            if (this.isWritebackEnabled() && this.isWritableColumnChanged() && (stringArray = this.executeUpdate(this)) != null) {
                this.setValuesIntern(null, stringArray.getValues(null));
            }
            this.store();
            this.invokeMasterChangedDetailsListeners();
            if (this.rdMasterReference != null) {
                stringArray = this.rdMasterReference.getColumnNames();
                if (!iDataRow.equals(this, stringArray)) {
                    this.moveDataRowToCorrectMaster();
                } else {
                    this.repositionCurrentDataRow();
                }
            } else {
                this.repositionCurrentDataRow();
            }
            if (bl4) {
                this.eventAfterUpdated.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_UPDATED, iDataRow));
            }
        } else if (this.isInserting()) {
            String[] stringArray;
            if (EventHandler.isDispatchable(this.eventBeforeInserted)) {
                this.eventBeforeInserted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_INSERTED, null));
            }
            if (this.rdMasterReference != null) {
                String[] stringArray2 = stringArray = this.isSelfJoined() ? this.getRootReference() : this.rdMasterReference;
                if (stringArray != null && stringArray.getReferencedDataBook().isInserting()) {
                    IDataBook iDataBook = stringArray.getReferencedDataBook();
                    if (iDataBook instanceof MemDataBook) {
                        ((MemDataBook)stringArray.getReferencedDataBook()).saveSelectedRowIntern();
                    } else {
                        ((MemDataBook)stringArray.getReferencedDataBook()).saveSelectedRowIntern();
                    }
                    this.syncDetails();
                }
            }
            if (this.isSelfJoined()) {
                stringArray = this.getTreePath();
                int n = this.iSelectedRowIndex;
                if (stringArray != null && stringArray.length() > 0) {
                    this.setTreePathInternal(stringArray.getParentPath());
                    this.setSelectedRow(stringArray.getLast());
                    this.saveSelectedRowIntern();
                    this.setTreePathInternal((TreePath)stringArray);
                    this.setSelectedRowInternal(n);
                }
            }
            this.copyMasterColumnsToCurrentDetail(true);
            if (this.isWritebackEnabled() && (stringArray = this.executeInsert(this)) != null) {
                this.setValuesIntern(null, stringArray.getValues(null));
            }
            this.store();
            if (this.isSelfJoined() && this.hasDataPage(this)) {
                this.notifyMasterChanged();
                this.bMasterChanged = false;
            }
            this.invokeMasterChangedDetailsListeners();
            this.setUID(null);
            if (this.rdMasterReference != null) {
                boolean bl;
                stringArray = this.rdMasterReference.getColumnNames();
                IDataRow iDataRow = this.createDataRow(stringArray);
                IDataRow iDataRow2 = this.createEmptyRow(stringArray);
                iDataRow2.setValues(stringArray, this.dpCurrentDataPage.getMasterDataRow().getValues(this.rdMasterReference.getReferencedColumnNames()));
                boolean bl5 = bl = iDataRow2.compareTo(iDataRow) == 0;
                if (!bl) {
                    this.moveDataRowToCorrectMaster();
                } else {
                    this.repositionCurrentDataRow();
                }
            } else {
                this.repositionCurrentDataRow();
            }
            if (EventHandler.isDispatchable(this.eventAfterInserted)) {
                this.eventAfterInserted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_INSERTED, null));
            }
        }
    }

    private void saveSelfJoinedDetailRows() throws ModelException {
        if (this.isSelfJoined() && this.hasDataPage(this) && this.iSelectedRowIndex >= 0) {
            TreePath treePath = this.getTreePath();
            int n = this.iSelectedRowIndex;
            if (this.isDetailChanged()) {
                this.setTreePathInternal(treePath.getChildPath(this.iSelectedRowIndex));
                this.saveDataPageIntern();
                this.setTreePathInternal(treePath);
                if (n != this.iSelectedRowIndex) {
                    this.setSelectedRow(n);
                }
            }
        }
    }

    protected void reloadIntern() throws ModelException {
        this.executeRefresh();
        this.invokeMasterChangedDetailsListeners();
        if (EventHandler.isDispatchable(this.eventAfterReload)) {
            this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadDataPage(IDataBook.SelectionMode selectionMode) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.bIsOpen && !this.ignoreReload) {
                this.handleStoreSelection(selectionMode);
                if (EventHandler.isDispatchable(this.eventBeforeReload)) {
                    this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
                }
                if (!this.isOutOfSync()) {
                    this.restoreDataPageIntern();
                    this.executeRefreshDataPage();
                }
                if (!this.isOutOfSync()) {
                    this.correctSelectedRow();
                }
                this.notifyRepaintControls();
                this.notifyMasterChanged();
                if (EventHandler.isDispatchable(this.eventAfterReload)) {
                    this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanges() {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (this.dpCurrentDataPage != null && this.dpCurrentDataPage.hasChanges() || this.temporaryMasterDataPage != null && this.temporaryMasterDataPage.hasChanges()) {
                return true;
            }
            if (this.rdMasterReference != null) {
                for (MemDataPage memDataPage : this.htDataPagesCache.values()) {
                    if (!memDataPage.hasChanges()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            IDataRow iDataRow2 = this.getMasterDataRowFromRootDataRow(iDataRow);
            MemDataPage memDataPage = this.htDataPagesCache.get(iDataRow2);
            if (memDataPage == null && iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
                memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow).getUID());
            }
            if (treePath == null) {
                return memDataPage != null;
            }
            for (int i = 0; i < treePath.length(); ++i) {
                int n = treePath.get(i);
                if (n >= 0 && n < memDataPage.getRowCount()) {
                    iDataRow2 = this.getMasterDataRow(memDataPage.getDataRow(n));
                    if ((memDataPage = this.htDataPagesCache.get(iDataRow2)) == null && iDataRow2 instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow2).getUID() != null) {
                        memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow2).getUID());
                    }
                    if (memDataPage != null) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
    }

    protected MemDataPage createAndCacheDataPage(IDataRow iDataRow) throws ModelException {
        MemDataPage memDataPage = this.createDataPage(iDataRow);
        if (iDataRow instanceof ChangeableDataRow && ((ChangeableDataRow)iDataRow).getUID() != null) {
            this.htDataPagesCache.put(((ChangeableDataRow)iDataRow).getUID(), memDataPage);
        } else {
            this.htDataPagesCache.put(iDataRow, memDataPage);
        }
        return memDataPage;
    }

    protected MemDataPage createDataPage(IDataRow iDataRow) {
        return new MemDataPage(this, iDataRow);
    }

    protected boolean isMemSort() {
        return this.bMemSort;
    }

    protected void setMemSort(boolean bl) {
        this.bMemSort = bl;
    }

    protected boolean isMemFilter() {
        return this.bMemFilter;
    }

    protected void setMemFilter(boolean bl) {
        this.bMemFilter = bl;
    }

    protected boolean isWritebackEnabled() {
        return this.bWritebackEnabled;
    }

    protected void setWritebackEnabled(boolean bl) {
        this.bWritebackEnabled = bl;
    }

    private ArrayUtil<IDataRow> getStoredSelection() {
        return this.auStoredSelection;
    }

    public boolean isLockAndRefetchEnabled() {
        return this.bLockAndRefetchEnabled;
    }

    public void setLockAndRefetchEnabled(boolean bl) {
        this.bLockAndRefetchEnabled = bl;
    }

    public int getReadAhead() {
        return this.iReadAheadRowCount;
    }

    public void setReadAhead(int n) {
        if (n >= 0) {
            this.iReadAheadRowCount = n;
        }
    }

    private void setStoredSelection(IDataRow iDataRow) throws ModelException {
        this.auStoredSelection.clear();
        if (iDataRow == null) {
            return;
        }
        this.auStoredSelection.add(iDataRow);
        if (iDataRow != this.additionalDataRow && this.isSelfJoined() && this.treePath != null) {
            String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
            if (stringArray == null) {
                stringArray = this.rdRowDefinition.getColumnNames();
            }
            TreePath treePath = this.treePath;
            for (int i = treePath.length() - 1; i >= 0; --i) {
                this.setTreePath(treePath.getParentPath());
                if (stringArray == null || stringArray.length <= 0) continue;
                this.auStoredSelection.add(this.getDataRow(treePath.get(i)).createDataRow(stringArray));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEstimatedRowCount() throws ModelException {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            if (!this.bIsOpen) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            return this.dpCurrentDataPage.getEstimatedRowCount();
        }
    }

    protected IDataRow executeInsert(IChangeableDataRow iChangeableDataRow) throws ModelException {
        return null;
    }

    protected IDataRow executeUpdate(IChangeableDataRow iChangeableDataRow) throws ModelException {
        return null;
    }

    protected void executeDelete(IChangeableDataRow iChangeableDataRow) throws ModelException {
    }

    protected IDataRow executeLockAndRefetch(IChangeableDataRow iChangeableDataRow) throws ModelException {
        return null;
    }

    private void lockAndRefetchIntern() throws ModelException {
        IDataRow iDataRow = this.executeLockAndRefetch(this);
        if (iDataRow != null && !iDataRow.equals(this)) {
            this.setValuesIntern(null, iDataRow.getValues(null));
            this.notifyRepaintControls();
        }
    }

    private void invokeMasterChangedDetailsListeners() {
        this.notifyRepaintControls();
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.notifyMasterChanged();
            }
        }
    }

    @Override
    public IDataBook getRootDataBook() {
        return this.rootDataBook;
    }

    protected IDataBook getRootDataBookIntern() {
        ReferenceDefinition referenceDefinition;
        IDataBook iDataBook = this;
        ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
        while (referenceDefinition != null) {
            iDataBook = referenceDefinition.getReferencedDataBook();
            referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
        }
        return iDataBook;
    }

    protected void invokeTreeSaveEditingControls() throws ModelException {
        if (this.factory != null && this.invokeSaveEditingControls) {
            IDataBook iDataBook = this;
            if (!this.isReadOnly()) {
                ReferenceDefinition referenceDefinition;
                ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
                while (referenceDefinition != null) {
                    iDataBook = referenceDefinition.getReferencedDataBook();
                    referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
                }
            }
            this.invokeTopDownSaveEditingControls(iDataBook);
        }
    }

    private void invokeTopDownSaveEditingControls(IDataBook iDataBook) throws ModelException {
        iDataBook.saveEditingControls();
        IDataBook[] iDataBookArray = iDataBook.getDetailDataBooks();
        for (int i = 0; i < iDataBookArray.length; ++i) {
            this.invokeTopDownSaveEditingControls(iDataBookArray[i]);
        }
    }

    protected void invokeTreeCancelEditingControls() {
        if (this.factory != null && this.invokeCancelEditingControls) {
            IDataBook iDataBook = this;
            if (!this.isReadOnly()) {
                ReferenceDefinition referenceDefinition;
                ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
                while (referenceDefinition != null) {
                    iDataBook = referenceDefinition.getReferencedDataBook();
                    referenceDefinition = iDataBook.isSelfJoined() ? iDataBook.getRootReference() : iDataBook.getMasterReference();
                }
            }
            this.invokeTopDownCancelEditingControls(iDataBook);
        }
    }

    private void invokeTopDownCancelEditingControls(IDataBook iDataBook) {
        iDataBook.cancelEditingControls();
        IDataBook[] iDataBookArray = iDataBook.getDetailDataBooks();
        for (int i = 0; i < iDataBookArray.length; ++i) {
            this.invokeTopDownCancelEditingControls(iDataBookArray[i]);
        }
    }

    private void syncDetails() throws ModelException {
        this.sync();
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.getSelectedRow();
            }
        }
    }

    private IDataRow getMasterDataRow(IDataRow iDataRow) throws ModelException {
        if (iDataRow == null) {
            return new DataRow(this.rdMasterReference.getReferencedDataBook().getRowDefinition().createRowDefinition(this.rdMasterReference.getReferencedColumnNames()));
        }
        return iDataRow.createDataRow(this.rdMasterReference.getReferencedColumnNames());
    }

    private MemDataPage getDataPageIntern(IDataRow iDataRow) throws ModelException {
        Object object;
        MemDataPage memDataPage = null;
        if (iDataRow instanceof ChangeableDataRow && (object = ((ChangeableDataRow)iDataRow).getUID()) != null) {
            memDataPage = this.htDataPagesCache.get(object);
            if (memDataPage != null) {
                return memDataPage;
            }
            return this.createAndCacheDataPage(iDataRow);
        }
        object = this.getMasterDataRow(iDataRow);
        memDataPage = this.htDataPagesCache.get(object);
        if (memDataPage == null) {
            IChangeableDataRow iChangeableDataRow = null;
            if (iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
                iChangeableDataRow = (IChangeableDataRow)iDataRow;
                memDataPage = this.htDataPagesCache.get(iChangeableDataRow.getUID());
            }
            if (memDataPage == null) {
                return this.createAndCacheDataPage((IDataRow)object);
            }
        }
        return memDataPage;
    }

    private IChangeableDataRow getDataRowInternal(int n) throws ModelException {
        if (n < 0 || this.dpCurrentDataPage == this.dpEmptyDataPage) {
            return null;
        }
        return this.dpCurrentDataPage.getDataRow(n);
    }

    private void correctSelectedRow() throws ModelException {
        ArrayUtil<IDataRow> arrayUtil = this.getStoredSelection();
        if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
            this.setSelectedRowInternal(-1);
        } else if ((this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_SETFILTER || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED_SETFILTER) && arrayUtil != null && arrayUtil.size() > 0) {
            if (arrayUtil.size() > 0 && arrayUtil.get(0) == this) {
                this.setSelectedRowInternal(-1);
            } else if (arrayUtil.size() == 1 && arrayUtil.get(0) == this.additionalDataRow) {
                if (this.additionalDataRowVisible) {
                    this.setSelectedRowInternal(0);
                } else {
                    this.setSelectedRowInternal(-1);
                }
            } else {
                String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
                if (stringArray == null) {
                    stringArray = this.rdRowDefinition.getColumnNames();
                }
                if (this.isSelfJoined() && arrayUtil.size() > 0) {
                    this.setTreePath(null);
                }
                int n = 0;
                IChangeableDataRow iChangeableDataRow = this.getDataRow(n);
                for (int i = arrayUtil.size() - 1; i >= 0; --i) {
                    IDataRow iDataRow = arrayUtil.get(i);
                    while (iChangeableDataRow != null && !iDataRow.equals(iChangeableDataRow, stringArray)) {
                        iChangeableDataRow = this.getDataRow(++n);
                    }
                    if (iChangeableDataRow == null) {
                        n = this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW ? 0 : -1;
                    }
                    this.setSelectedRowInternal(n);
                    if (this.isSelfJoined() && i - 1 >= 0) {
                        this.setTreePath(this.getTreePath().getChildPath(n));
                    }
                    n = 0;
                    iChangeableDataRow = this.getDataRow(n);
                }
            }
        } else if (this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED_SETFILTER) {
            this.setSelectedRowInternal(-1);
        } else {
            this.setSelectedRowInternal(0);
        }
        this.setStoredSelection(null);
        if (EventHandler.isDispatchable(this.eventAfterRowSelected)) {
            this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, null));
        }
    }

    private void correctSelectedRowAfterDelete() throws ModelException {
        int n = this.iSelectedRowIndex;
        if (this.iSelectedRowIndex >= this.getRowCount()) {
            n = this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED_SETFILTER ? -1 : this.getRowCount() - 1;
        }
        this.setSelectedRowInternal(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() throws ModelException {
        if (this.dpEmptyDataPage == null) {
            this.dpEmptyDataPage = new MemDataPage(this, null);
        }
        if (this.rdMasterReference == null) {
            if (this.dpCurrentDataPage == null) {
                this.ignoreReload = true;
                try {
                    this.dpCurrentDataPage = this.dpEmptyDataPage;
                    this.iSelectedRowIndex = -1;
                    if (this.temporaryMasterDataPage != null) {
                        this.dpCurrentDataPage = this.temporaryMasterDataPage;
                        this.temporaryMasterDataPage = null;
                    } else {
                        this.dpCurrentDataPage = this.createDataPage(null);
                    }
                    this.correctSelectedRow();
                    Object var2_1 = null;
                    this.ignoreReload = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.ignoreReload = false;
                    throw throwable;
                }
            }
        } else if (this.bMasterChanged) {
            this.bMasterChanged = false;
            this.ignoreReload = true;
            try {
                ReferenceDefinition referenceDefinition;
                if (this.dpCurrentDataPage == null) {
                    this.dpCurrentDataPage = this.dpEmptyDataPage;
                    this.iSelectedRowIndex = -1;
                    this.treePath = TreePath.EMPTY;
                }
                ReferenceDefinition referenceDefinition2 = referenceDefinition = this.isSelfJoined() ? this.getRootReference() : this.rdMasterReference;
                if (referenceDefinition != null && referenceDefinition.getReferencedDataBook().getSelectedRow() < 0) {
                    if (this.dpCurrentDataPage != this.dpEmptyDataPage) {
                        this.dpCurrentDataPage = this.dpEmptyDataPage;
                        this.iSelectedRowIndex = -1;
                        this.treePath = TreePath.EMPTY;
                        this.setSelectedRowInternal(-1);
                        this.setStoredSelection(null);
                        if (EventHandler.isDispatchable(this.eventAfterRowSelected)) {
                            this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, null));
                        }
                    }
                } else if (this.isSelfJoined()) {
                    IDataPage iDataPage;
                    if (this.dpCurrentDataPage != this.dpEmptyDataPage && referenceDefinition != null && !this.getMasterDataRowFromRootDataRow(referenceDefinition.getReferencedDataBook()).equals(this.dpCurrentDataPage.getMasterDataRow(), this.saTreeRootMasterColumnNames)) {
                        this.treePath = TreePath.EMPTY;
                    }
                    if ((iDataPage = this.getDataPage(this.treePath)) != this.dpCurrentDataPage) {
                        this.iSelectedRowIndex = -1;
                        this.treePath = TreePath.EMPTY;
                        this.dpCurrentDataPage = (MemDataPage)this.getDataPage(this.treePath);
                        this.correctSelectedRow();
                    }
                } else {
                    MemDataPage memDataPage = this.getDataPageIntern(this.rdMasterReference.getReferencedDataBook());
                    if (memDataPage != this.dpCurrentDataPage) {
                        this.dpCurrentDataPage = memDataPage;
                        this.iSelectedRowIndex = -1;
                        this.treePath = TreePath.EMPTY;
                        this.correctSelectedRow();
                    }
                }
                Object var4_7 = null;
                this.ignoreReload = false;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.ignoreReload = false;
                throw throwable;
            }
        }
    }

    protected void executeRefresh() throws ModelException {
        this.clearFilterSortInMemDataPages();
    }

    protected void executeRefreshDataPage() throws ModelException {
        this.clearFilterSortInCurrentMemDataPage();
    }

    protected void clear() throws ModelException {
        this.dpCurrentDataPage = null;
        this.temporaryMasterDataPage = null;
        this.bMasterChanged = true;
        this.htDataPagesCache.clear();
        this.iSelectedRowIndex = -1;
        this.oaStorage = null;
    }

    protected void clearCurrentDataPage() throws ModelException {
        if (!this.isOutOfSync()) {
            if (this.getMasterReference() != null) {
                this.htDataPagesCache.remove(this.getMasterDataRow());
                this.bMasterChanged = true;
            }
            this.dpCurrentDataPage = null;
            this.temporaryMasterDataPage = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedRowInternal(int n) throws ModelException {
        if (this.additionalDataRowVisible) {
            --n;
        }
        try {
            this.oaStorage = n < 0 ? null : this.dpCurrentDataPage.getDataRowStorage(n);
            Object var3_2 = null;
            if (this.oaStorage != null) {
                this.iSelectedRowIndex = n;
            } else if (this.additionalDataRowVisible && n == -1) {
                this.oaStorage = this.getAdditionalDataRow().oaStorage;
                this.iSelectedRowIndex = -1;
            } else {
                this.iSelectedRowIndex = this.additionalDataRowVisible ? -2 : -1;
            }
            this.invokeMasterChangedDetailsListeners();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.oaStorage != null) {
                this.iSelectedRowIndex = n;
            } else if (this.additionalDataRowVisible && n == -1) {
                this.oaStorage = this.getAdditionalDataRow().oaStorage;
                this.iSelectedRowIndex = -1;
            } else {
                this.iSelectedRowIndex = this.additionalDataRowVisible ? -2 : -1;
            }
            this.invokeMasterChangedDetailsListeners();
            throw throwable;
        }
    }

    static int getNextUID() {
        return ++iUID;
    }

    private void insertInternal(boolean bl) throws ModelException {
        if (!bl && this.dpCurrentDataPage.getRowCount() > 0) {
            ++this.iSelectedRowIndex;
        }
        if (this.iSelectedRowIndex < 0) {
            this.iSelectedRowIndex = 0;
        }
        this.setInserting();
        this.setUID(MemDataBook.getNextUID());
        this.setDefaultValues();
        this.dpCurrentDataPage.insert(this.iSelectedRowIndex, this);
        this.setDetailsChangedInMasterBook();
        this.invokeMasterChangedDetailsListeners();
    }

    private boolean deleteInternal() throws ModelException {
        boolean bl = this.isInserting();
        if (bl) {
            this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
        } else {
            this.setDeleting();
            this.dpCurrentDataPage.setDataRow(this.iSelectedRowIndex, this);
        }
        this.setDetailsChangedInMasterBook();
        this.notifyRepaintControls();
        return bl;
    }

    private void setDetailsChangedInMasterBook() throws ModelException {
        if (this.rdMasterReference != null) {
            ReferenceDefinition referenceDefinition;
            IDataPage iDataPage;
            boolean bl = this.isUpdating() || this.isInserting() || this.isDeleting() || this.isDetailChanged();
            int[] nArray = this.dpCurrentDataPage.getChangedDataRows();
            if (!(bl && nArray.length <= 1 || !bl && nArray.length <= 0)) {
                return;
            }
            TreePath treePath = this.treePath;
            if (this.isSelfJoined() && treePath.length() > 0) {
                boolean bl2;
                boolean bl3 = bl2 = nArray.length > 0;
                while (treePath.length() > 0) {
                    iDataPage = (MemDataPage)this.getDataPage(treePath.getParentPath());
                    int n = treePath.getLast();
                    ChangeableDataRow changeableDataRow = (ChangeableDataRow)((MemDataPage)iDataPage).getDataRow(n);
                    if (this.auDetailDataBooks != null) {
                        for (int i = this.auDetailDataBooks.size() - 1; !bl2 && i >= 0; --i) {
                            int[] nArray2;
                            IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                            if (iDataBook == null || (nArray2 = iDataBook.isSelfJoined() ? iDataBook.getDataPage(changeableDataRow, TreePath.EMPTY).getChangedDataRows() : iDataBook.getDataPage(changeableDataRow).getChangedDataRows()).length <= 0) continue;
                            bl2 = true;
                        }
                    }
                    if (bl2 != changeableDataRow.isDetailChanged()) {
                        changeableDataRow.setDetailChanged(bl2);
                        ((MemDataPage)iDataPage).setDataRow(n, changeableDataRow);
                        treePath = treePath.getParentPath();
                        bl2 = ((MemDataPage)iDataPage).getChangedDataRows().length > 0;
                        continue;
                    }
                    treePath = TreePath.EMPTY;
                }
            }
            ReferenceDefinition referenceDefinition2 = referenceDefinition = this.isSelfJoined() ? this.getRootReference() : this.rdMasterReference;
            if (referenceDefinition != null) {
                iDataPage = referenceDefinition.getReferencedDataBook();
                if (!bl || bl && !iDataPage.isDetailChanged()) {
                    iDataPage.notifyDetailChanged();
                }
            }
        }
    }

    private void copyMasterColumnsToCurrentDetail(boolean bl) throws ModelException {
        if (this.rdMasterReference != null) {
            Object[] objectArray = this.getValues(this.rdMasterReference.getColumnNames());
            boolean bl2 = true;
            if (bl && objectArray != null) {
                int n = objectArray.length;
                for (int i = 0; bl2 && i < n; ++i) {
                    if (objectArray[i] == null) continue;
                    bl2 = false;
                }
            }
            if (!bl || bl && bl2) {
                Object[] objectArray2 = this.dpCurrentDataPage.getMasterDataRow().getValues(this.rdMasterReference.getReferencedColumnNames());
                this.setValuesIntern(this.rdMasterReference.getColumnNames(), objectArray2);
                if (this.isSelfJoined() && this.rdTreeRootReference != null) {
                    objectArray2 = this.rdTreeRootReference.getReferencedDataBook().getValues(this.rdTreeRootReference.getReferencedColumnNames());
                    this.setValuesIntern(this.rdTreeRootReference.getColumnNames(), objectArray2);
                }
            }
        }
    }

    private void saveDataRowLevel(IDataBook iDataBook) throws ModelException {
        ReferenceDefinition referenceDefinition;
        IDataBook iDataBook2 = this;
        ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
        while (iDataBook2.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW && referenceDefinition != null) {
            iDataBook2 = referenceDefinition.getReferencedDataBook();
            referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
        }
        ((MemDataBook)iDataBook2).saveDataRowLevelDetails(iDataBook);
    }

    private void saveDataRowLevelDetails(IDataBook iDataBook) throws ModelException {
        if (this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
            this.saveDetails(iDataBook);
        } else if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook2 == null) continue;
                ((MemDataBook)iDataBook2).saveDataRowLevelDetails(iDataBook);
            }
        }
    }

    private void saveDetails(IDataBook iDataBook) throws ModelException {
        if (this != iDataBook) {
            this.saveSelectedRowIntern();
        }
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook2 == null) continue;
                ((MemDataBook)iDataBook2).saveDetails(iDataBook);
            }
        }
    }

    private void restoreSaveAllDetails() throws ModelException {
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                if (iDataBook.isDeleteCascade()) {
                    iDataBook.restoreAllRows();
                    ((MemDataBook)iDataBook).restoreSaveAllDetails();
                    continue;
                }
                if (iDataBook.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                    iDataBook.saveAllRows();
                }
                ((MemDataBook)iDataBook).restoreSaveAllDetails();
            }
        }
    }

    private void handleStoreSelection(IDataBook.SelectionMode selectionMode) throws ModelException {
        if (this.bIsOpen && !this.isOutOfSync()) {
            if (selectionMode == IDataBook.SelectionMode.CURRENT_ROW || selectionMode == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_SETFILTER || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED_SETFILTER) {
                if (this.getSelectedRow() < 0) {
                    if (this.dpCurrentDataPage.getRowCount() == 0) {
                        this.setStoredSelection(null);
                    } else {
                        this.setStoredSelection(this);
                    }
                } else if (this.additionalDataRowVisible && this.getSelectedRow() == 0) {
                    this.setStoredSelection(this.getAdditionalDataRow());
                } else {
                    String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
                    if (stringArray == null || stringArray.length > 0) {
                        IDataRow iDataRow = this.dpCurrentDataPage.getDataRow(this.iSelectedRowIndex);
                        if (iDataRow != null) {
                            iDataRow = iDataRow.createDataRow(stringArray);
                        }
                        this.setStoredSelection(iDataRow);
                    }
                }
            } else {
                this.setStoredSelection(null);
            }
        }
    }

    private void restoreAllDetails() throws ModelException {
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.restoreAllRows();
            }
        }
        if (this.isSelfJoined()) {
            if (this.treePath != null) {
                this.removeDataPage(null, this.treePath.getChildPath(this.getSelectedRow()));
            } else {
                this.removeDataPage(null, null);
            }
        }
    }

    private void restoreRow() throws ModelException {
        boolean bl = EventHandler.isDispatchable(this.eventBeforeRestore);
        boolean bl2 = EventHandler.isDispatchable(this.eventAfterRestore);
        boolean bl3 = EventHandler.isDispatchable(this.eventAfterRowSelected);
        IDataRow iDataRow = bl || bl2 || bl3 ? this.createDataRow(null) : null;
        if (bl) {
            this.eventBeforeRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RESTORE, iDataRow));
        }
        if (this.isInserting()) {
            this.restoreAllDetails();
            if (this.auDetailDataBooks != null) {
                int n = this.auDetailDataBooks.size();
                for (int i = 0; i < n; ++i) {
                    IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                    if (iDataBook == null) continue;
                    iDataBook.removeDataPage(this, null);
                }
            }
            this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
            this.correctSelectedRowAfterDelete();
            this.setDetailsChangedInMasterBook();
            if (bl2) {
                this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iDataRow));
            }
            if (bl3) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iDataRow));
            }
        } else {
            this.restore();
            this.dpCurrentDataPage.setDataRow(this.iSelectedRowIndex, this);
            this.setDetailsChangedInMasterBook();
            if (bl2) {
                this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iDataRow));
            }
        }
    }

    @Override
    protected void store() throws ModelException {
        if (this.isDeleting()) {
            this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
        } else {
            super.store();
            this.dpCurrentDataPage.setDataRow(this.iSelectedRowIndex, this);
        }
        this.setDetailsChangedInMasterBook();
    }

    protected void clearFilterSortInMemDataPages() throws ModelException {
        if (this.rdMasterReference != null) {
            Enumeration<MemDataPage> enumeration = this.htDataPagesCache.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().clear();
            }
            this.dpCurrentDataPage = null;
            this.bMasterChanged = true;
        } else if (!this.isOutOfSync()) {
            this.dpCurrentDataPage.clear();
            this.temporaryMasterDataPage = this.dpCurrentDataPage;
            this.dpCurrentDataPage = null;
        }
    }

    protected void clearFilterSortInCurrentMemDataPage() throws ModelException {
        if (!this.isOutOfSync()) {
            this.dpCurrentDataPage.clear();
            this.temporaryMasterDataPage = this.dpCurrentDataPage;
            this.dpCurrentDataPage = null;
            this.bMasterChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnlyWithoutSave(boolean bl) {
        IDataBook iDataBook = this.rootDataBook;
        synchronized (iDataBook) {
            this.bReadOnly = bl;
            this.notifyRepaintControls();
        }
    }

    private IDataRow getMasterDataRowFromRootDataRow(IDataRow iDataRow) throws ModelException {
        ChangeableDataRow changeableDataRow = new ChangeableDataRow(this.rdMasterReference.getReferencedDataBook().getRowDefinition().createRowDefinition(this.rdMasterReference.getReferencedColumnNames()));
        if (this.rdTreeRootReference != null && iDataRow != null) {
            changeableDataRow.setValues(this.saTreeRootMasterColumnNames, iDataRow.getValues(this.rdTreeRootReference.getReferencedColumnNames()));
            if (iDataRow instanceof IChangeableDataRow) {
                changeableDataRow.setUID(((IChangeableDataRow)iDataRow).getUID());
            }
        }
        return changeableDataRow;
    }

    private void setTreePathInternal(TreePath treePath) throws ModelException {
        if (!this.treePath.equals(treePath) || this.bMasterChanged) {
            this.sync();
            boolean bl = EventHandler.isDispatchable(this.eventBeforeRowSelected);
            boolean bl2 = EventHandler.isDispatchable(this.eventAfterRowSelected);
            IDataRow iDataRow = bl || bl2 ? this.createDataRow(null) : null;
            if (bl) {
                this.eventBeforeRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_ROW_SELECTED, iDataRow));
            }
            this.treePath = treePath == null ? TreePath.EMPTY : treePath;
            this.dpCurrentDataPage = (MemDataPage)this.getDataPage(this.treePath);
            if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED || this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW_DESELECTED_SETFILTER) {
                this.setSelectedRowInternal(-1);
            } else {
                this.setSelectedRowInternal(0);
            }
            if (bl2) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iDataRow));
            }
        }
    }

    protected boolean isDataPageRefetchPossible() {
        return false;
    }
}

