/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.ExceptionUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.event.DataRowEvent;
import javax.rad.model.event.DataRowHandler;
import javax.rad.model.ui.IControl;
import javax.rad.util.EventHandler;

public class DataRow
implements IDataRow,
Serializable {
    protected IRowDefinition rdRowDefinition;
    protected Object[] oaStorage = null;
    private transient ArrayUtil<WeakReference<IControl>> auControls;
    private transient Map<String, DataRowHandler> hmpEventValuesChanged;

    public DataRow() {
        this(null, null);
    }

    public DataRow(IRowDefinition iRowDefinition) {
        this(iRowDefinition, null);
    }

    protected DataRow(IRowDefinition iRowDefinition, Object[] objectArray) {
        this.rdRowDefinition = iRowDefinition == null ? new RowDefinition() : iRowDefinition;
        this.oaStorage = objectArray;
    }

    public IRowDefinition getRowDefinition() {
        return this.rdRowDefinition;
    }

    public Object getValue(int n) throws ModelException {
        if (n < 0 || n >= this.rdRowDefinition.getColumnCount()) {
            throw new ModelException("Column index '" + n + "' doesn't exist!");
        }
        return this.getValueIntern(n);
    }

    public Object getValue(String string) throws ModelException {
        int n = this.rdRowDefinition.getColumnDefinitionIndex(string);
        if (n < 0) {
            throw new ModelException("Column name '" + string + "' doesn't exist!");
        }
        return this.getValueIntern(n);
    }

    public String getValueAsString(String string) throws ModelException {
        Object object = this.getValue(string);
        return this.rdRowDefinition.getColumnDefinition(string).getDataType().convertToString(object);
    }

    public void setValue(String string, Object object) throws ModelException {
        DataRowHandler dataRowHandler;
        DataRowHandler dataRowHandler2;
        boolean bl;
        boolean bl2 = bl = this.hmpEventValuesChanged != null;
        if (bl) {
            dataRowHandler2 = this.hmpEventValuesChanged.get(null);
            dataRowHandler = this.hmpEventValuesChanged.get(string);
            bl = EventHandler.isDispatchable(dataRowHandler2) || EventHandler.isDispatchable(dataRowHandler);
        } else {
            dataRowHandler2 = null;
            dataRowHandler = null;
        }
        IDataRow iDataRow = bl ? this.createDataRow(null) : null;
        int n = this.rdRowDefinition.getColumnDefinitionIndex(string);
        if (n < 0) {
            throw new ModelException("Column name doesn't exist! - " + string);
        }
        this.setValueIntern(n, object, this.rdRowDefinition.getColumnDefinition(n));
        if (bl) {
            String[] stringArray = new String[]{string};
            if (EventHandler.isDispatchable(dataRowHandler2)) {
                dataRowHandler2.dispatchEvent(new DataRowEvent(this, stringArray, iDataRow));
            }
            if (EventHandler.isDispatchable(dataRowHandler)) {
                dataRowHandler.dispatchEvent(new DataRowEvent(this, stringArray, iDataRow));
            }
        }
        this.notifyRepaintControls();
    }

    public Object[] getValues(String[] stringArray) throws ModelException {
        if (stringArray == null || stringArray == this.rdRowDefinition.getColumnNames()) {
            Object[] objectArray = new Object[this.rdRowDefinition.getColumnCount()];
            if (this.oaStorage != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.getValueIntern(i);
                }
            }
            return objectArray;
        }
        Object[] objectArray = new Object[stringArray.length];
        if (this.oaStorage != null) {
            int[] nArray = this.rdRowDefinition.getColumnDefinitionIndexes(stringArray);
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = this.getValueIntern(nArray[i]);
            }
        }
        return objectArray;
    }

    public String[] getValuesAsString(String[] stringArray) throws ModelException {
        String[] stringArray2 = stringArray == null ? this.rdRowDefinition.getColumnNames() : stringArray;
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = this.getValueAsString(stringArray2[i]);
        }
        return stringArray3;
    }

    public void setValues(String[] stringArray, Object[] objectArray) throws ModelException {
        Object object;
        DataRowHandler dataRowHandler;
        boolean bl;
        if (stringArray == null) {
            stringArray = this.rdRowDefinition.getColumnNames();
        } else if (stringArray.length == 0) {
            return;
        }
        boolean bl2 = bl = this.hmpEventValuesChanged != null;
        if (bl) {
            dataRowHandler = this.hmpEventValuesChanged.get(null);
            bl = EventHandler.isDispatchable(dataRowHandler);
            for (int i = 0; !bl && i < stringArray.length; ++i) {
                object = this.hmpEventValuesChanged.get(stringArray[i]);
                bl = EventHandler.isDispatchable((EventHandler)object);
            }
        } else {
            dataRowHandler = null;
        }
        object = bl ? this.createDataRow(null) : null;
        this.setValuesIntern(stringArray, objectArray);
        if (bl) {
            if (EventHandler.isDispatchable(dataRowHandler)) {
                dataRowHandler.dispatchEvent(new DataRowEvent(this, stringArray, (IDataRow)object));
            }
            for (String string : stringArray) {
                dataRowHandler = this.hmpEventValuesChanged.get(string);
                if (!EventHandler.isDispatchable(dataRowHandler)) continue;
                dataRowHandler.dispatchEvent(new DataRowEvent(this, stringArray, (IDataRow)object));
            }
        }
        this.notifyRepaintControls();
    }

    public IDataRow createDataRow(String[] stringArray) throws ModelException {
        return new DataRow(this.rdRowDefinition.createRowDefinition(stringArray), this.getValuesIntern(stringArray));
    }

    public IDataRow createEmptyRow(String[] stringArray) throws ModelException {
        return new DataRow(this.rdRowDefinition.createRowDefinition(stringArray));
    }

    public boolean equals(Object object) {
        if (object instanceof IDataRow) {
            return this.compareTo((IDataRow)object) == 0;
        }
        return super.equals(object);
    }

    public int compareTo(IDataRow iDataRow) {
        return this.compareTo(iDataRow, null);
    }

    public int compareTo(IDataRow iDataRow, SortDefinition sortDefinition) {
        boolean[] blArray;
        String[] stringArray;
        if (iDataRow == null) {
            return 1;
        }
        IRowDefinition iRowDefinition = iDataRow.getRowDefinition();
        if (sortDefinition == null) {
            stringArray = iRowDefinition.getColumnNames();
            blArray = null;
        } else {
            stringArray = sortDefinition.getColumns();
            blArray = sortDefinition.isAscending();
        }
        int[] nArray = this.rdRowDefinition.getColumnDefinitionIndexes(stringArray);
        int[] nArray2 = iRowDefinition.getColumnDefinitionIndexes(stringArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n >= 0) {
                try {
                    int n2 = this.rdRowDefinition.getColumnDefinition(n).getDataType().compareTo(this.getValue(n), iDataRow.getValue(nArray2[i]));
                    if (n2 == 0) continue;
                    if (blArray != null && i < blArray.length && !blArray[i]) {
                        return -n2;
                    }
                    return n2;
                }
                catch (ModelException modelException) {
                    return -1;
                }
            }
            throw new IllegalArgumentException("Column with the name '" + stringArray[i] + "' does not exist!");
        }
        return 0;
    }

    public boolean equals(IDataRow iDataRow, String[] stringArray) {
        return this.compareTo(iDataRow, new SortDefinition(stringArray)) == 0;
    }

    public void addControl(IControl iControl) {
        if (this.auControls == null) {
            this.auControls = new ArrayUtil();
        } else {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                if (this.auControls.get(i).get() != null) continue;
                this.auControls.remove(i);
            }
        }
        if (this.auControls.indexOf(iControl) < 0) {
            this.auControls.add(new WeakReference<IControl>(iControl));
        }
        this.rdRowDefinition.addControl(iControl);
    }

    public void removeControl(IControl iControl) {
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl2 = (IControl)this.auControls.get(i).get();
                if (iControl2 != null && iControl2 != iControl) continue;
                this.auControls.remove(i);
            }
        }
        this.rdRowDefinition.removeControl(iControl);
    }

    public IControl[] getControls() {
        ArrayUtil<IControl> arrayUtil = new ArrayUtil<IControl>();
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl = (IControl)this.auControls.get(i).get();
                if (iControl == null) {
                    this.auControls.remove(i);
                    continue;
                }
                arrayUtil.add(0, iControl);
            }
        }
        return arrayUtil.toArray(new IControl[arrayUtil.size()]);
    }

    public DataRowHandler eventValuesChanged() {
        return this.eventValuesChanged(null);
    }

    public DataRowHandler eventValuesChanged(String string) {
        DataRowHandler dataRowHandler;
        if (this.hmpEventValuesChanged == null) {
            this.hmpEventValuesChanged = new HashMap<String, DataRowHandler>();
        }
        if ((dataRowHandler = this.hmpEventValuesChanged.get(string)) == null) {
            dataRowHandler = new DataRowHandler();
            this.hmpEventValuesChanged.put(string, dataRowHandler);
        }
        return dataRowHandler;
    }

    public void notifyRepaintControls() {
        this.invokeRepaintListeners();
    }

    public void saveEditingControls() throws ModelException {
        this.invokeSaveEditingControls();
    }

    public void cancelEditingControls() {
        this.invokeCancelEditingControls();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.rdRowDefinition.getColumnNames();
        try {
            stringBuilder.append("{");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
                stringBuilder.append("=");
                stringBuilder.append(this.getValue(string));
            }
            stringBuilder.append("}");
        }
        catch (ModelException modelException) {
            stringBuilder.append("\n");
            stringBuilder.append(ExceptionUtil.dump(modelException, true));
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        String[] stringArray = this.rdRowDefinition.getColumnNames();
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                n *= 37;
                Object object = this.getValue(stringArray[i]);
                if (object == null) continue;
                n += object.hashCode();
            }
        }
        catch (ModelException modelException) {
            return n;
        }
        return n;
    }

    private final Object getValueIntern(int n) throws ModelException {
        if (n < 0 || n >= this.rdRowDefinition.getColumnCount()) {
            return null;
        }
        Object object = this.oaStorage == null || n >= this.oaStorage.length ? null : this.oaStorage[n];
        Object object2 = this.rdRowDefinition.getColumnDefinition(n).getDataType().prepareValue(object);
        if (object2 != object) {
            if (object2 != null && object != null && object.getClass() != object2.getClass()) {
                this.oaStorage[n] = object2;
            }
            return object2;
        }
        return object;
    }

    private final Object[] getValuesIntern(String[] stringArray) {
        if (this.oaStorage == null) {
            return null;
        }
        if (stringArray == null || stringArray == this.rdRowDefinition.getColumnNames()) {
            return (Object[])this.oaStorage.clone();
        }
        Object[] objectArray = new Object[stringArray.length];
        int[] nArray = this.rdRowDefinition.getColumnDefinitionIndexes(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.oaStorage.length) continue;
            objectArray[i] = this.oaStorage[n];
        }
        return objectArray;
    }

    protected void setValueIntern(int n, Object object, ColumnDefinition columnDefinition) throws ModelException {
        if (object == null) {
            if (this.oaStorage != null && n < this.oaStorage.length) {
                this.oaStorage[n] = object;
            }
        } else {
            if (this.oaStorage == null || n >= this.oaStorage.length) {
                Object[] objectArray = new Object[this.rdRowDefinition.getColumnCount()];
                if (this.oaStorage != null) {
                    System.arraycopy(this.oaStorage, 0, objectArray, 0, this.oaStorage.length);
                }
                this.oaStorage = objectArray;
            }
            this.oaStorage[n] = columnDefinition.getDataType().convertAndCheckToTypeClass(object);
        }
    }

    protected void setValuesIntern(String[] stringArray, Object[] objectArray) throws ModelException {
        if (stringArray == null || stringArray == this.rdRowDefinition.getColumnNames()) {
            if (objectArray == null) {
                int n = this.rdRowDefinition.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    this.setValueIntern(i, null, this.rdRowDefinition.getColumnDefinition(i));
                }
            } else {
                int n = this.rdRowDefinition.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    this.setValueIntern(i, i < objectArray.length ? objectArray[i] : null, this.rdRowDefinition.getColumnDefinition(i));
                }
            }
        } else {
            int[] nArray = this.rdRowDefinition.getColumnDefinitionIndexes(stringArray);
            if (objectArray == null) {
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (n < 0) {
                        throw new ModelException("Column name doesn't exist! - " + stringArray[i]);
                    }
                    this.setValueIntern(n, null, this.rdRowDefinition.getColumnDefinition(n));
                }
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (n < 0) {
                        throw new ModelException("Column name doesn't exist! - " + stringArray[i]);
                    }
                    this.setValueIntern(n, i < objectArray.length ? objectArray[i] : null, this.rdRowDefinition.getColumnDefinition(n));
                }
            }
        }
    }

    protected void invokeRepaintListeners() {
        if (this.auControls != null) {
            IControl[] iControlArray = this.getControls();
            for (int i = 0; i < iControlArray.length; ++i) {
                iControlArray[i].notifyRepaint();
            }
        }
    }

    protected void invokeSaveEditingControls() throws ModelException {
        if (this.auControls != null) {
            IControl[] iControlArray = this.getControls();
            for (int i = 0; i < iControlArray.length; ++i) {
                iControlArray[i].saveEditing();
            }
        }
    }

    protected void invokeCancelEditingControls() {
        if (this.auControls != null) {
            IControl[] iControlArray = this.getControls();
            for (int i = 0; i < iControlArray.length; ++i) {
                iControlArray[i].cancelEditing();
            }
        }
    }

    public void setDefaultValues() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnDefinition columnDefinition = this.rdRowDefinition.getColumnDefinition(i);
            Object object = columnDefinition.getDefaultValue();
            if (object == null) continue;
            this.setValueIntern(i, object, columnDefinition);
        }
    }

    protected boolean hasControls() {
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl = (IControl)this.auControls.get(i).get();
                if (iControl != null) {
                    return true;
                }
                this.auControls.remove(i);
            }
            return true;
        }
        return false;
    }
}

