/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.rad.model.mem.DataRow;
import com.sibvisions.util.type.ExceptionUtil;
import java.io.Serializable;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;

public class ChangeableDataRow
extends DataRow
implements IChangeableDataRow,
Serializable {
    protected static final int INTERNAL_OFFSET = 3;
    protected static final Integer INSERTING = 1;
    protected static final Integer UPDATING = 2;
    protected static final Integer WRITABLE_COLUMN_CHANGED = 3;
    protected static final Integer DELETING = 4;
    protected static final Integer DETAILS_CHANGED = 1;
    private transient IDataPage dpDataPage = null;
    private transient int iRowIndex = -1;

    protected ChangeableDataRow() {
    }

    public ChangeableDataRow(IRowDefinition iRowDefinition) {
        this(iRowDefinition, null, null, -1);
    }

    protected ChangeableDataRow(IRowDefinition iRowDefinition, Object[] objectArray, IDataPage iDataPage, int n) {
        super(iRowDefinition, objectArray);
        this.dpDataPage = iDataPage;
        this.iRowIndex = n;
    }

    public IDataPage getDataPage() {
        return this.dpDataPage;
    }

    public int getRowIndex() {
        return this.iRowIndex;
    }

    public Object getUID() throws ModelException {
        int n;
        if (this.oaStorage != null && this.oaStorage.length > (n = this.rdRowDefinition.getColumnCount())) {
            return this.oaStorage[n];
        }
        return null;
    }

    public boolean isInserting() throws ModelException {
        if (this.oaStorage == null) {
            return false;
        }
        int n = this.rdRowDefinition.getColumnCount() + 1;
        if (this.oaStorage.length <= n) {
            return false;
        }
        return this.oaStorage[n] == INSERTING;
    }

    public boolean isUpdating() throws ModelException {
        if (this.oaStorage == null) {
            return false;
        }
        int n = this.rdRowDefinition.getColumnCount() + 1;
        if (this.oaStorage.length <= n) {
            return false;
        }
        Object object = this.oaStorage[n];
        return object == UPDATING || object == WRITABLE_COLUMN_CHANGED;
    }

    public boolean isDeleting() throws ModelException {
        if (this.oaStorage == null) {
            return false;
        }
        int n = this.rdRowDefinition.getColumnCount() + 1;
        if (this.oaStorage.length <= n) {
            return false;
        }
        return this.oaStorage[n] == DELETING;
    }

    public boolean isDetailChanged() throws ModelException {
        if (this.oaStorage == null) {
            return false;
        }
        int n = this.rdRowDefinition.getColumnCount() + 2;
        if (this.oaStorage.length <= n) {
            return false;
        }
        Object object = this.oaStorage[n];
        return object != null;
    }

    public IDataRow getOriginalRow() throws ModelException {
        if (this.oaStorage == null) {
            return null;
        }
        int n = this.rdRowDefinition.getColumnCount();
        if (this.oaStorage.length <= n) {
            return null;
        }
        Object object = this.oaStorage[n + 1];
        if (object == DELETING) {
            return this;
        }
        if (object == UPDATING || object == WRITABLE_COLUMN_CHANGED) {
            Object[] objectArray = new Object[n];
            if (this.oaStorage.length > 3 + n) {
                System.arraycopy(this.oaStorage, 3 + n, objectArray, 0, this.oaStorage.length - 3 - n);
            }
            return new DataRow(this.rdRowDefinition, objectArray);
        }
        return null;
    }

    public boolean isWritableColumnChanged() throws ModelException {
        if (this.oaStorage == null) {
            return false;
        }
        int n = this.rdRowDefinition.getColumnCount() + 1;
        if (this.oaStorage.length <= n) {
            return false;
        }
        return this.oaStorage[n] == WRITABLE_COLUMN_CHANGED;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        try {
            if (stringBuilder.length() > 2) {
                stringBuilder.insert(1, ", ");
            }
            stringBuilder.insert(1, "UID=" + this.getUID());
            String string = this.isInserting() ? "I" : (this.isDeleting() ? "D" : (this.isUpdating() ? "U" : " "));
            String string2 = this.isDetailChanged() ? "DC" : "  ";
            stringBuilder.insert(stringBuilder.length() - 1, ", CHANGES=" + string + string2);
        }
        catch (ModelException modelException) {
            stringBuilder.append("\n");
            stringBuilder.append(ExceptionUtil.dump(modelException, true));
        }
        return stringBuilder.toString();
    }

    protected void setValueIntern(int n, Object object, ColumnDefinition columnDefinition) throws ModelException {
        super.setValueIntern(n, object, columnDefinition);
        this.setWritableColumnChanged(n, columnDefinition);
    }

    protected void setUID(Object object) {
        this.extentStorage();
        this.oaStorage[this.rdRowDefinition.getColumnCount()] = object;
    }

    protected void setInserting() {
        this.oaStorage = null;
        this.extentStorage();
        this.oaStorage[this.rdRowDefinition.getColumnCount() + 1] = INSERTING;
    }

    protected void setUpdating() {
        int n = this.rdRowDefinition.getColumnCount();
        int n2 = n * 2 + 3;
        if (this.oaStorage == null || this.oaStorage.length < n2) {
            Object[] objectArray = new Object[n2];
            if (this.oaStorage != null) {
                System.arraycopy(this.oaStorage, 0, objectArray, 0, this.oaStorage.length);
            }
            this.oaStorage = objectArray;
        }
        System.arraycopy(this.oaStorage, 0, this.oaStorage, 3 + n, n);
        this.oaStorage[n + 1] = UPDATING;
    }

    protected void setDeleting() {
        this.extentStorage();
        this.oaStorage[this.rdRowDefinition.getColumnCount() + 1] = DELETING;
    }

    protected void restore() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount();
        if (this.isUpdating()) {
            System.arraycopy(this.oaStorage, 3 + n, this.oaStorage, 0, n);
        }
        for (int i = n + 3; i < this.oaStorage.length; ++i) {
            this.oaStorage[i] = null;
        }
        this.oaStorage[n + 1] = null;
    }

    protected void store() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount();
        for (int i = n + 3; i < this.oaStorage.length; ++i) {
            this.oaStorage[i] = null;
        }
        this.oaStorage[n + 1] = null;
    }

    protected void setDetailChanged(boolean bl) {
        this.extentStorage();
        this.oaStorage[this.rdRowDefinition.getColumnCount() + 2] = bl ? DETAILS_CHANGED : null;
    }

    private void extentStorage() {
        int n = this.rdRowDefinition.getColumnCount();
        if (this.oaStorage == null || this.oaStorage.length <= n) {
            Object[] objectArray = new Object[n + 3];
            if (this.oaStorage != null) {
                System.arraycopy(this.oaStorage, 0, objectArray, 0, n);
            }
            this.oaStorage = objectArray;
        }
    }

    private void setWritableColumnChanged(int n, ColumnDefinition columnDefinition) throws ModelException {
        int n2;
        if (this.oaStorage != null && this.oaStorage.length > (n2 = this.rdRowDefinition.getColumnCount() + 1) && this.oaStorage[n2] == UPDATING && columnDefinition.isWritable()) {
            this.oaStorage[n2] = WRITABLE_COLUMN_CHANGED;
        }
    }
}

