/*
 * Copyright 2012 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 20.07.2012 - [JR] - creation
 */
package com.sibvisions.rad.persist.jdbc.param;

/**
 * The <code>InParam</code> defines a simple input parameter. The value is not changed due to a JDBC call.
 * Only manual value updates are possible.
 * 
 * @author Ren Jahn
 */
public class InParam extends AbstractParam
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>InParam</code> with the given value.
	 * 
	 * @param pValue the input value
	 */
	public InParam(Object pValue)
	{
		super(ParameterType.In, SQLTYPE_AUTOMATIC, pValue);
	}
	
	/**
	 * Creates a new instance of <code>InParam</code> for the given sql type.
	 * 
	 * @param pSqlType the sql type. All {@link java.sql.Types} are supported.
	 */
	public InParam(int pSqlType)
	{
		super(ParameterType.In, pSqlType, null);
	}

	/**
	 * Creates a new instance of <code>InParam</code> for the given value and sql type.
	 * 
	 * @param pValue the input value
	 * @param pSqlType the sql type. All {@link java.sql.Types} are supported.
	 */
	public InParam(int pSqlType, Object pValue)
	{
		super(ParameterType.In, pSqlType, pValue);
	}
	
	/**
	 * Creates a new instance of <code>InParam</code> for the given array type.
	 * 
	 * @param pArrayType the array type. 
	 */
	public InParam(String pArrayType)
	{
		super(ParameterType.InOut, pArrayType, null);
	}

	/**
	 * Creates a new instance of <code>InParam</code> for the given value and array type.
	 * 
	 * @param pValue the input value
	 * @param pArrayType the array type.
	 */
	public InParam(String pArrayType, Object pValue)
	{
		super(ParameterType.InOut, pArrayType, pValue);
	}
	
}	// InParam
