/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.type.bean;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.rad.type.bean.AbstractBeanType;
import javax.rad.type.bean.IBean;
import javax.rad.type.bean.IBeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<C extends IBeanType>
extends AbstractMap<String, Object>
implements IBean {
    protected C beanType;
    private transient EntrySet entrySet;

    protected AbstractBean(C c) {
        if (c == null) {
            throw new IllegalArgumentException("The bean type may not be null!");
        }
        this.beanType = c;
    }

    public abstract Object get(int var1);

    public C getBeanType() {
        return this.beanType;
    }

    @Override
    public Object get(String string) {
        int n = this.beanType.getPropertyIndex(string);
        if (n < 0) {
            return null;
        }
        return this.get(n);
    }

    @Override
    public Object put(String string, Object object) {
        int n = this.beanType.getPropertyIndex(string);
        if (n < 0) {
            if (this.beanType instanceof AbstractBeanType) {
                n = this.beanType.getPropertyCount();
                ((AbstractBeanType)this.beanType).addPropertyDefinition(string);
            } else {
                throw new IllegalArgumentException("The property [" + string + "] does not exist!");
            }
        }
        Object object2 = this.get(n);
        this.put(n, object);
        return object2;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public void put(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<String, Object>>,
    Map.Entry<String, Object> {
        private String[] propertyNames;
        private int index;
        private String propertyName;

        private EntryIterator() {
            this.propertyNames = AbstractBean.this.beanType.getPropertyNames();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.propertyNames.length;
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.propertyName = this.propertyNames[this.index++];
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getKey() {
            return this.propertyName;
        }

        @Override
        public Object getValue() {
            return AbstractBean.this.get(this.propertyName);
        }

        @Override
        public Object setValue(Object object) {
            return AbstractBean.this.put(this.propertyName, object);
        }

        public String toString() {
            return this.propertyName + "=" + AbstractBean.this.get(this.propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return AbstractBean.this.beanType.getPropertyCount();
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            int n;
            if (object instanceof Map.Entry && (n = AbstractBean.this.beanType.getPropertyIndex((String)(entry = (Map.Entry)object).getKey())) >= 0) {
                Object v;
                Object object2 = AbstractBean.this.get(n);
                return object2 == (v = entry.getValue()) || object2 != null && object2.equals(v);
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

