/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.io;

import javax.rad.io.IDownloadExecutor;
import javax.rad.io.IUploadExecutor;

public class TransferContext {
    private static ThreadLocal<TransferContext> instance = new ThreadLocal();
    private IDownloadExecutor download;
    private IUploadExecutor upload;

    public TransferContext(IDownloadExecutor iDownloadExecutor, IUploadExecutor iUploadExecutor) {
        this.download = iDownloadExecutor;
        this.upload = iUploadExecutor;
        this.setInstance(this);
    }

    public IDownloadExecutor getDownloadExecutor() {
        return this.download;
    }

    public IUploadExecutor getUploadExecutor() {
        return this.upload;
    }

    public static IDownloadExecutor getCurrentDownloadExecutor() {
        TransferContext transferContext = TransferContext.getCurrentInstance();
        if (transferContext != null) {
            return transferContext.getDownloadExecutor();
        }
        return null;
    }

    public static IUploadExecutor getCurrentUploadExecutor() {
        TransferContext transferContext = TransferContext.getCurrentInstance();
        if (transferContext != null) {
            return transferContext.getUploadExecutor();
        }
        return null;
    }

    public static TransferContext getCurrentInstance() {
        return instance.get();
    }

    protected synchronized void setInstance(TransferContext transferContext) {
        instance.set(transferContext);
    }

    public final synchronized void release() {
        instance.set(null);
    }

    public boolean isReleased() {
        return instance.get() == null;
    }
}

