/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.type.CommonUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static ImageIcon getScaledIcon(Icon icon, int n, int n2, boolean bl) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ImageUtil.getScaledIcon((ImageIcon)icon, n, n2, bl);
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return new ImageIcon(ImageUtil.getScaledImage(bufferedImage, n, n2, bl));
    }

    public static ImageIcon getScaledIcon(ImageIcon imageIcon, int n, int n2, boolean bl) {
        if (imageIcon == null) {
            return null;
        }
        Image image = ImageUtil.getScaledImage(imageIcon.getImage(), n, n2, bl);
        if (image == imageIcon.getImage()) {
            return imageIcon;
        }
        return new ImageIcon(image);
    }

    public static Image getScaledImage(InputStream inputStream, int n, int n2, boolean bl) throws IOException {
        return ImageUtil.getScaledImage(ImageIO.read(inputStream), n, n2, bl);
    }

    public static Image getScaledImage(Image image, int n, int n2, boolean bl) {
        int n3;
        if (image instanceof BufferedImage) {
            n3 = ((BufferedImage)image).getType();
            if (n3 == 0) {
                n3 = 2;
            }
        } else {
            n3 = 2;
        }
        return ImageUtil.getScaledImage(image, n3, n, n2, bl);
    }

    public static Image getScaledImage(Image image, int n, int n2, int n3, boolean bl) {
        if (image == null) {
            return null;
        }
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (n4 <= n2 && n5 <= n3) {
            return image;
        }
        if (bl) {
            if (n4 > n5) {
                n3 = n5 * n2 / n4;
            } else {
                n2 = n4 * n3 / n5;
            }
        }
        while (n4 > n2 || n5 > n3) {
            if (n4 > n2 && (n4 /= 2) < n2) {
                n4 = n2;
            }
            if (n5 > n3 && (n5 /= 2) < n3) {
                n5 = n3;
            }
            BufferedImage bufferedImage = new BufferedImage(Math.max(1, n4), Math.max(1, n5), n);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(image, 0, 0, n4, n5, null);
            graphics2D.dispose();
            image = bufferedImage;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createScaledImage(InputStream inputStream, int n, int n2, boolean bl, OutputStream outputStream, String string) throws IOException {
        Image image = ImageUtil.getScaledImage(inputStream, n, n2, bl);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (!iterator.hasNext()) {
            throw new RuntimeException("No image writer available for '" + string + "'!");
        }
        ImageWriter imageWriter = iterator.next();
        if (imageWriter == null) {
            throw new IOException("Output format '" + string + "' is not supported!");
        }
        ImageOutputStream imageOutputStream = null;
        try {
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            if (imageWriteParam != null && imageWriteParam.canWriteCompressed()) {
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(1.0f);
            }
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage((BufferedImage)image, null, null), imageWriteParam);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            CommonUtil.close(imageOutputStream);
            imageWriter.dispose();
            throw throwable;
        }
        CommonUtil.close(imageOutputStream);
        imageWriter.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFormat getImageFormat(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream;
        block39: {
            int n;
            int n2;
            int n3;
            int n4;
            block37: {
                block35: {
                    block33: {
                        block31: {
                            block29: {
                                block27: {
                                    block25: {
                                        block23: {
                                            ImageFormat imageFormat;
                                            byteArrayInputStream = null;
                                            try {
                                                byteArrayInputStream = new ByteArrayInputStream(byArray);
                                                n4 = byteArrayInputStream.read();
                                                n3 = byteArrayInputStream.read();
                                                n2 = byteArrayInputStream.read();
                                                n = byteArrayInputStream.read();
                                                if (n4 != 71 || n3 != 73 || n2 != 70) break block23;
                                                imageFormat = ImageFormat.GIF;
                                                Object var12_16 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var12_26 = null;
                                                try {
                                                    byteArrayInputStream.close();
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                byteArrayInputStream = null;
                                                throw throwable;
                                            }
                                            try {
                                                byteArrayInputStream.close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            byteArrayInputStream = null;
                                            return imageFormat;
                                        }
                                        if (n4 != 255 || n3 != 216) break block25;
                                        ImageFormat imageFormat = ImageFormat.JPG;
                                        Object var12_17 = null;
                                        try {
                                            byteArrayInputStream.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        byteArrayInputStream = null;
                                        return imageFormat;
                                    }
                                    if (n4 != 0 || n3 != 0 || n2 != 0 || n != 12) break block27;
                                    ImageFormat imageFormat = ImageFormat.JPG2000;
                                    Object var12_18 = null;
                                    try {
                                        byteArrayInputStream.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    byteArrayInputStream = null;
                                    return imageFormat;
                                }
                                if (n4 != 255 || n3 != 79 || n2 != 255 || n != 81) break block29;
                                ImageFormat imageFormat = ImageFormat.JPG2000;
                                Object var12_19 = null;
                                try {
                                    byteArrayInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                byteArrayInputStream = null;
                                return imageFormat;
                            }
                            if (n4 != 137 || n3 != 80 || n2 != 78 || n != 71) break block31;
                            ImageFormat imageFormat = ImageFormat.PNG;
                            Object var12_20 = null;
                            try {
                                byteArrayInputStream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            byteArrayInputStream = null;
                            return imageFormat;
                        }
                        if (n4 != 215 || n3 != 205) break block33;
                        ImageFormat imageFormat = ImageFormat.WMF;
                        Object var12_21 = null;
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        byteArrayInputStream = null;
                        return imageFormat;
                    }
                    if (n4 != 66 || n3 != 77) break block35;
                    ImageFormat imageFormat = ImageFormat.BMP;
                    Object var12_22 = null;
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    byteArrayInputStream = null;
                    return imageFormat;
                }
                if ((n4 != 77 || n3 != 77 || n2 != 0 || n != 42) && (n4 != 73 || n3 != 73 || n2 != 42 || n != 0)) break block37;
                ImageFormat imageFormat = ImageFormat.TIFF;
                Object var12_23 = null;
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                byteArrayInputStream = null;
                return imageFormat;
            }
            if (n4 != 151 || n3 != 74 || n2 != 66 || n != 50) break block39;
            int n5 = byteArrayInputStream.read();
            int n6 = byteArrayInputStream.read();
            int n7 = byteArrayInputStream.read();
            int n8 = byteArrayInputStream.read();
            if (n5 != 13 || n6 != 10 || n7 != 26 || n8 != 10) break block39;
            ImageFormat imageFormat = ImageFormat.JBIG2;
            Object var12_24 = null;
            try {
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            byteArrayInputStream = null;
            return imageFormat;
        }
        ImageFormat imageFormat = ImageFormat.UNKNOWN;
        Object var12_25 = null;
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byteArrayInputStream = null;
        return imageFormat;
    }

    public static void save(ImageIcon imageIcon, ImageFormat imageFormat, OutputStream outputStream) throws IOException {
        if (imageIcon != null) {
            ImageUtil.save(imageIcon.getImage(), imageIcon.getIconWidth(), imageIcon.getIconHeight(), imageFormat, outputStream);
        }
    }

    public static void save(Image image, ImageFormat imageFormat, OutputStream outputStream) throws IOException {
        if (image != null) {
            ImageUtil.save(image, image.getWidth(null), image.getHeight(null), imageFormat, outputStream);
        }
    }

    private static void save(Image image, int n, int n2, ImageFormat imageFormat, OutputStream outputStream) throws IOException {
        String string;
        switch (imageFormat) {
            case JPG: 
            case JPG2000: {
                string = "jpg";
                break;
            }
            case BMP: {
                string = "bmp";
                break;
            }
            case GIF: {
                string = "gif";
                break;
            }
            default: {
                string = "png";
            }
        }
        if (image instanceof RenderedImage) {
            ImageIO.write((RenderedImage)((Object)image), string, outputStream);
        } else {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            bufferedImage.getGraphics().drawImage(image, 0, 0, null);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageFormat {
        UNKNOWN,
        JPG,
        JPG2000,
        GIF,
        PNG,
        WMF,
        BMP,
        TIFF,
        JBIG2;

    }
}

