/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private int iMajor;
    private int iMinor;
    private int iBuild;
    private int iRevision;

    public Version(int n) {
        this(n, -1, -1, -1);
    }

    public Version(int n, int n2) {
        this(n, n2, -1, -1);
    }

    public Version(int n, int n2, int n3) {
        this(n, n2, n3, -1);
    }

    public Version(int n, int n2, int n3, int n4) {
        this.iMajor = n;
        this.iMinor = n2;
        this.iBuild = n3;
        this.iRevision = n4;
    }

    public String toString() {
        return this.toString(Level.Revision, false);
    }

    public int hashCode() {
        int n = 31 + this.iBuild;
        n = 31 * n + this.iMajor;
        n = 31 * n + this.iMinor;
        n = 31 * n + this.iRevision;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return this.iBuild == version.iBuild && this.iMajor == version.iMajor && this.iMinor == version.iMinor && this.iRevision == version.iRevision;
    }

    @Override
    public int compareTo(Version version) {
        return this.compareTo(version, Level.Revision);
    }

    public static Version parse(String string) {
        if (string == null) {
            return new Version(-1, -1, -1, -1);
        }
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[]{-1, -1, -1, -1};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Version(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public String toString(Level level, boolean bl) {
        if (level == null) {
            throw new IllegalArgumentException("Level can't be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = new int[]{this.iMajor, this.iMinor, this.iBuild, this.iRevision};
        int n = level.ordinal();
        for (int i = 0; i <= n; ++i) {
            int n2 = nArray[i];
            if (bl) {
                if (n2 < 0) {
                    for (int j = i + 1; j <= n && n2 < 0; ++j) {
                        if (nArray[j] < 0) continue;
                        n2 = 0;
                    }
                }
                if (n2 < 0) {
                    return stringBuilder.toString();
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(n2);
                continue;
            }
            if (i > 0) {
                stringBuilder.append(".");
            }
            if (n2 < 0) {
                stringBuilder.append(0);
                continue;
            }
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    public String toString(Level level) {
        return this.toString(level, false);
    }

    public String toString(boolean bl) {
        return this.toString(Level.Revision, bl);
    }

    public Level getLevel() {
        int[] nArray = new int[]{this.iMajor, this.iMinor, this.iBuild, this.iRevision};
        Level[] levelArray = new Level[]{Level.Major, Level.Minor, Level.Build, Level.Revision};
        Level level = null;
        for (int i = 0; i < 4; ++i) {
            if (nArray[i] < 0) continue;
            level = levelArray[i];
        }
        return level;
    }

    public boolean isUndefined() {
        return this.iMajor < 0 && this.iMinor < 0 && this.iBuild < 0 && this.iRevision < 0;
    }

    public int toNumber() {
        return this.toNumber(Level.Revision);
    }

    public int toNumber(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("Level can't be null");
        }
        int[] nArray = new int[]{this.iMajor, this.iMinor, this.iBuild, this.iRevision};
        int[] nArray2 = new int[]{1000, 100, 10, 1};
        int n = 0;
        int n2 = level.ordinal();
        for (int i = 0; i <= n2; ++i) {
            int n3 = nArray[i];
            if (n3 < 0) {
                n3 = 0;
            }
            n += nArray2[i] * n3;
        }
        return n;
    }

    public int compareTo(Version version, Level level) {
        int n;
        if (level == null) {
            throw new IllegalArgumentException("Level can't be null");
        }
        int n2 = this.toNumber(level);
        if (n2 < (n = version == null ? -1 : version.toNumber(level))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    public int getMajor() {
        return this.iMajor;
    }

    public int getMinor() {
        return this.iMinor;
    }

    public int getBuild() {
        return this.iBuild;
    }

    public int getRevision() {
        return this.iRevision;
    }

    public boolean isSmaller(Version version) {
        return this.compareTo(version) == -1;
    }

    public boolean isSmallerOrEqual(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isGreater(Version version) {
        return this.compareTo(version) == 1;
    }

    public boolean isGreaterOrEqual(Version version) {
        return this.compareTo(version) >= 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        Major,
        Minor,
        Build,
        Revision;

    }
}

