/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadManager {
    private ArrayUtil<WeakReference<Thread>> auCached = new ArrayUtil();
    private ArrayUtil<WeakReference<Thread>> auStopped = new ArrayUtil();

    public boolean add(Thread thread) {
        if (this.addIntern(thread)) {
            this.setThreadName(thread);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIntern(Thread thread) {
        ArrayUtil<WeakReference<Thread>> arrayUtil = this.auCached;
        synchronized (arrayUtil) {
            this.check(this.auCached);
            if (this.auCached.indexOf(thread) >= 0) {
                return false;
            }
            this.auCached.add(new WeakReference<Thread>(thread));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Thread thread) {
        ArrayUtil<WeakReference<Thread>> arrayUtil = this.auCached;
        synchronized (arrayUtil) {
            this.auCached.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread start(Runnable runnable) {
        if (runnable != null) {
            Thread thread;
            if (runnable instanceof Thread) {
                thread = (Thread)runnable;
                ArrayUtil<WeakReference<Thread>> arrayUtil = this.auCached;
                synchronized (arrayUtil) {
                    if (thread.isAlive() || this.auCached.indexOf(thread) >= 0) {
                        return thread;
                    }
                }
                if (thread.getState() == Thread.State.TERMINATED) {
                    throw new IllegalStateException("Thread may not be restarted!");
                }
            } else {
                thread = new Thread(runnable);
            }
            if (this.addIntern(thread)) {
                this.setThreadName(thread);
                thread.start();
                return thread;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread stop(Thread thread) {
        if (thread == null) {
            return null;
        }
        ArrayUtil<WeakReference<Thread>> arrayUtil = this.auStopped;
        synchronized (arrayUtil) {
            this.auStopped.add(new WeakReference<Thread>(thread));
        }
        thread.interrupt();
        this.remove(thread);
        this.check(this.auStopped);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ArrayUtil<WeakReference<Thread>> arrayUtil;
        Object object = this.auCached;
        synchronized (object) {
            arrayUtil = new ArrayUtil<WeakReference<Thread>>((Collection<WeakReference<Thread>>)this.auCached);
        }
        for (WeakReference weakReference : arrayUtil) {
            object = (Thread)weakReference.get();
            if (object == null) continue;
            this.stop((Thread)object);
        }
    }

    public boolean isStopped() {
        return this.isStopped(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped(Thread thread) {
        if (thread == null) {
            return true;
        }
        ArrayUtil<WeakReference<Thread>> arrayUtil = this.auStopped;
        synchronized (arrayUtil) {
            return this.auStopped.indexOf(thread) >= 0 || !thread.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(ArrayUtil<WeakReference<Thread>> arrayUtil) {
        ArrayUtil<WeakReference<Thread>> arrayUtil2;
        Object object = this.auCached;
        synchronized (object) {
            arrayUtil2 = new ArrayUtil<WeakReference<Thread>>((Collection<WeakReference<Thread>>)arrayUtil);
        }
        for (WeakReference weakReference : arrayUtil2) {
            object = (Thread)weakReference.get();
            if (object != null) continue;
            arrayUtil.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Thread> getAlive(ArrayUtil<WeakReference<Thread>> arrayUtil) {
        ArrayUtil<WeakReference<Thread>> arrayUtil2;
        Object object = arrayUtil;
        synchronized (object) {
            arrayUtil2 = new ArrayUtil<WeakReference<Thread>>((Collection<WeakReference<Thread>>)arrayUtil);
        }
        ArrayUtil<Thread> arrayUtil3 = new ArrayUtil<Thread>();
        Iterator iterator = arrayUtil2.iterator();
        while (iterator.hasNext()) {
            object = (Thread)((WeakReference)iterator.next()).get();
            if (object == null || !((Thread)object).isAlive()) {
                this.auStopped.remove(object);
                continue;
            }
            arrayUtil3.add((Thread)object);
        }
        return arrayUtil3;
    }

    public List<Thread> getPendingStoppedThreads() {
        return this.getAlive(this.auStopped);
    }

    public List<Thread> getRunningThreads() {
        return this.getAlive(this.auCached);
    }

    private void setThreadName(Thread thread) {
        String string = thread.getName();
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        String string2 = null;
        String string3 = this.getClass().getPackage().getName() + ".Thread";
        for (int i = 0; i < stackTraceElementArray.length && string2 == null; ++i) {
            if (stackTraceElementArray[i].getClassName().startsWith(string3)) continue;
            string2 = stackTraceElementArray[i].toString();
        }
        thread.setName((string != null ? string + ": " : "") + thread.getClass().getName() + " -> " + string2);
    }
}

