/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.awt.impl.AwtDimension;
import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxComboBase;
import com.sibvisions.rad.ui.swing.ext.JVxTable;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxComboCellEditor;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxIconRenderer;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxRendererContainer;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CommonUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.model.ui.IControl;
import javax.rad.ui.IAlignmentConstants;
import javax.rad.ui.IDimension;
import javax.rad.ui.celleditor.ILinkedCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxLinkedCellEditor
extends JVxComboCellEditor
implements ILinkedCellEditor,
ICellRenderer<JComponent> {
    private JVxRendererContainer cellRenderer = null;
    private DefaultTableCellRenderer textRenderer = null;
    private JVxIconRenderer iconRenderer = null;
    private ReferenceDefinition linkReference;
    private ICondition additionalCondition;
    private ColumnMapping searchColumnMapping;
    private ColumnView columnView = null;
    private IDimension popupSize = new AwtDimension(400, 200);
    private boolean sortByColumnName = false;
    private boolean tableReadonly = true;
    private boolean tableHeaderVisible = false;
    private boolean validationEnabled = true;
    private boolean searchTextAnywhere = true;
    private boolean automaticTableHeaderVisibility = true;
    private String displayReferencedColumnName = null;
    private Map<Object, String> displayValueCache = null;
    private WeakReference<IDataPage> lastPageForSearch = null;
    private String lastColumnForSearch = null;
    private String lastDisplayColumn = null;
    private int lastSearchRow = 0;

    public JVxLinkedCellEditor() {
        this(null);
    }

    public JVxLinkedCellEditor(ReferenceDefinition referenceDefinition) {
        this.setLinkReference(referenceDefinition);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, (ICellFormatterEditorListener)iCellEditorListener, iDataRow, string, this.displayReferencedColumnName);
    }

    @Override
    public boolean isDirectCellEditor() {
        return false;
    }

    @Override
    public ReferenceDefinition getLinkReference() {
        return this.linkReference;
    }

    @Override
    public void setLinkReference(ReferenceDefinition referenceDefinition) {
        this.linkReference = referenceDefinition;
    }

    @Override
    public ICondition getAdditionalCondition() {
        return this.additionalCondition;
    }

    @Override
    public void setAdditionalCondition(ICondition iCondition) {
        this.additionalCondition = iCondition;
    }

    @Override
    public ColumnMapping getSearchColumnMapping() {
        return this.searchColumnMapping;
    }

    @Override
    public void setSearchColumnMapping(ColumnMapping columnMapping) {
        this.searchColumnMapping = columnMapping;
    }

    @Override
    public boolean isSortByColumnName() {
        return this.sortByColumnName;
    }

    @Override
    public void setSortByColumnName(boolean bl) {
        this.sortByColumnName = bl;
    }

    @Override
    public boolean isTableReadonly() {
        return this.tableReadonly;
    }

    @Override
    public void setTableReadonly(boolean bl) {
        this.tableReadonly = bl;
    }

    @Override
    public boolean isTableHeaderVisible() {
        return this.tableHeaderVisible;
    }

    @Override
    public void setTableHeaderVisible(boolean bl) {
        this.automaticTableHeaderVisibility = false;
        this.tableHeaderVisible = bl;
    }

    @Override
    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    @Override
    public void setValidationEnabled(boolean bl) {
        this.validationEnabled = bl;
    }

    @Override
    public boolean isSearchTextAnywhere() {
        return this.searchTextAnywhere;
    }

    @Override
    public void setSearchTextAnywhere(boolean bl) {
        this.searchTextAnywhere = bl;
    }

    @Override
    public ColumnView getColumnView() {
        return this.columnView;
    }

    @Override
    public void setColumnView(ColumnView columnView) {
        this.columnView = columnView;
    }

    @Override
    public IDimension getPopupSize() {
        return this.popupSize;
    }

    @Override
    public void setPopupSize(IDimension iDimension) {
        this.popupSize = iDimension;
    }

    @Override
    public String getDisplayReferencedColumnName() {
        return this.displayReferencedColumnName;
    }

    @Override
    public void setDisplayReferencedColumnName(String string) {
        this.displayReferencedColumnName = string;
    }

    @Override
    public JComponent getCellRendererComponent(JComponent jComponent, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new JVxRendererContainer();
            this.textRenderer = new DefaultTableCellRenderer();
            this.textRenderer.setFont(null);
            this.textRenderer.setOpaque(false);
            this.iconRenderer = new JVxIconRenderer();
            this.iconRenderer.setImage(JVxUtil.getImage("/com/sibvisions/rad/ui/swing/ext/images/combobox.png"));
            this.iconRenderer.setOpaque(false);
            this.cellRenderer.add((Component)this.textRenderer, "Center");
            this.cellRenderer.add((Component)this.iconRenderer, "East");
        }
        this.textRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.textRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        IDataBook iDataBook = iDataPage.getDataBook();
        try {
            this.iconRenderer.setVisible(bl && !iDataBook.isReadOnly() && iDataBook.isUpdateAllowed() && !iDataBook.getRowDefinition().getColumnDefinition(string).isReadOnly());
        }
        catch (Exception exception) {
            this.iconRenderer.setVisible(false);
        }
        try {
            this.textRenderer.setText(this.getDisplayValue(iDataRow, string));
        }
        catch (Exception exception) {
            this.textRenderer.setText(null);
        }
        return this.cellRenderer;
    }

    private String getDisplayValue(IDataRow iDataRow, String string) throws ModelException {
        String string2 = null;
        if (this.displayReferencedColumnName != null && this.linkReference != null) {
            Object object;
            if (this.displayValueCache == null) {
                this.displayValueCache = new HashMap<Object, String>();
            }
            if ((object = iDataRow.getValue(string)) != null && object.getClass() != String.class) {
                object = object.toString();
            }
            if ((string2 = this.displayValueCache.get(object)) == null) {
                String[] stringArray = this.linkReference.getReferencedColumnNames();
                String string3 = this.linkReference.getColumnNames().length == 0 && stringArray.length == 1 ? stringArray[0] : this.linkReference.getReferencedColumnName(string);
                IDataBook iDataBook = this.linkReference.getReferencedDataBook();
                if (iDataBook.getFilter() != null) {
                    iDataBook.setFilter(null);
                }
                IDataPage iDataPage = iDataBook.getDataPage();
                if (this.lastPageForSearch != null && this.lastPageForSearch.get() != iDataPage || !CommonUtil.equals(string3, this.lastColumnForSearch) || !CommonUtil.equals(this.displayReferencedColumnName, this.lastDisplayColumn)) {
                    this.displayValueCache.clear();
                    this.lastPageForSearch = new WeakReference<IDataPage>(iDataPage);
                    this.lastColumnForSearch = string3;
                    this.lastDisplayColumn = this.displayReferencedColumnName;
                    this.lastSearchRow = 0;
                }
                IChangeableDataRow iChangeableDataRow = iDataBook.getDataRow(this.lastSearchRow);
                while (iChangeableDataRow != null && string2 == null) {
                    String string4;
                    Object object2 = iChangeableDataRow.getValue(string3);
                    if (object2 != null && object2.getClass() != String.class) {
                        object2 = object2.toString();
                    }
                    if ((string4 = iChangeableDataRow.getValueAsString(this.displayReferencedColumnName)) == null) {
                        string4 = "";
                    }
                    this.displayValueCache.put(object2, string4);
                    if (object == object2 || object != null && object.equals(object2)) {
                        string2 = string4;
                    }
                    ++this.lastSearchRow;
                    iChangeableDataRow = iDataBook.getDataRow(this.lastSearchRow);
                }
            }
        }
        if (string2 == null) {
            string2 = iDataRow.getValueAsString(string);
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellEditorHandler
    extends AbstractListModel
    implements ICellEditorHandler<JComponent>,
    ComboBoxModel,
    DocumentListener,
    KeyListener,
    PopupMenuListener,
    FocusListener,
    MouseListener,
    Runnable {
        private JVxLinkedCellEditor cellEditor;
        private ICellFormatterEditorListener cellEditorListener;
        private IDataRow dataRow;
        private int columnIndex;
        private String[] columnNames;
        private String[] referencedColumnNames;
        private String columnName;
        private String referencedColumnName;
        private String[] searchColumns;
        private String[] additionalClearColumns;
        private String[] referencedSearchColumns;
        private IDataBook referencedDataBook;
        private JVxComboBase cellEditorComponent;
        private IAlignmentConstants dynamicAlignment = null;
        private JVxTable table;
        private boolean ignoreEvent = false;
        private boolean firstEditingStarted = true;
        private boolean popupChanged = false;
        private String displayColumnName;

        public CellEditorHandler(JVxLinkedCellEditor jVxLinkedCellEditor, ICellFormatterEditorListener iCellFormatterEditorListener, IDataRow iDataRow, String string, String string2) {
            this.cellEditor = jVxLinkedCellEditor;
            this.cellEditorListener = iCellFormatterEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            this.displayColumnName = string2;
            this.columnNames = this.cellEditor.linkReference.getColumnNames();
            this.referencedColumnNames = this.cellEditor.linkReference.getReferencedColumnNames();
            if (this.columnNames.length == 0 && this.referencedColumnNames.length == 1) {
                this.columnNames = new String[]{string};
            }
            this.columnIndex = ArrayUtil.indexOf(this.columnNames, this.columnName);
            if (this.columnIndex < 0) {
                throw new IllegalArgumentException("The edited column " + this.columnName + " has to be part of in column names list in LinkReference!");
            }
            this.referencedColumnName = this.referencedColumnNames[this.columnIndex];
            if (this.cellEditor.searchColumnMapping == null) {
                this.searchColumns = null;
                this.referencedSearchColumns = null;
            } else {
                this.searchColumns = this.cellEditor.searchColumnMapping.getColumnNames();
                this.referencedSearchColumns = this.cellEditor.searchColumnMapping.getReferencedColumnNames();
            }
            this.referencedDataBook = this.cellEditor.linkReference.getReferencedDataBook();
            try {
                this.additionalClearColumns = this.searchForAdditionalClearColumns(this.dataRow.getRowDefinition(), this.columnNames, this.getConditionColumns(this.cellEditor.searchColumnMapping, this.cellEditor.additionalCondition));
                this.referencedDataBook.setReadOnly(this.cellEditor.isTableReadonly());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            this.referencedDataBook.setSelectionMode(IDataBook.SelectionMode.DESELECTED);
            this.table = new JVxTable();
            this.table.setDataBook(this.referencedDataBook);
            this.table.setBorder(BorderFactory.createEmptyBorder());
            this.table.setAutoResize(true);
            this.table.getJTable().setFocusable(false);
            this.cellEditorComponent = new JVxComboBase();
            this.cellEditorComponent.setPopupComponent(this.table);
            this.cellEditorComponent.setModel(this);
            if (this.cellEditor.getPopupSize() != null) {
                this.cellEditorComponent.setPopupSize((Dimension)this.cellEditor.getPopupSize().getResource());
            }
            if (this.cellEditorComponent.getEditorComponent() instanceof JTextField) {
                if (this.cellEditorListener instanceof IAlignmentConstants) {
                    this.dynamicAlignment = (IAlignmentConstants)((Object)this.cellEditorListener);
                } else {
                    ((JTextField)this.cellEditorComponent.getEditorComponent()).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
                }
            }
            this.cellEditorComponent.getEditorComponent().getDocument().addDocumentListener(this);
            this.cellEditorComponent.getEditorComponent().addKeyListener(this);
            this.cellEditorComponent.getEditorComponent().addFocusListener(this);
            this.cellEditorComponent.getEditorComponent().setFocusTraversalKeysEnabled(false);
            this.cellEditorComponent.addPopupMenuListener(this);
            this.table.getJTable().addMouseListener(this);
            this.updateEditor();
        }

        private String[] getConditionColumns(ColumnMapping columnMapping, ICondition iCondition) {
            ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
            if (columnMapping != null) {
                arrayUtil.addAll(columnMapping.getColumnNames());
            }
            this.fillInConditionColumns(iCondition, arrayUtil);
            int n = arrayUtil.size();
            if (n == 0) {
                return null;
            }
            return arrayUtil.toArray(new String[n]);
        }

        private void fillInConditionColumns(ICondition iCondition, List<String> list) {
            if (iCondition instanceof CompareCondition) {
                String string = ((CompareCondition)iCondition).getDataRowColumnName();
                if (!list.contains(string)) {
                    list.add(string);
                }
            } else if (iCondition instanceof OperatorCondition) {
                ICondition[] iConditionArray = ((OperatorCondition)iCondition).getConditions();
                for (int i = 0; i < iConditionArray.length; ++i) {
                    this.fillInConditionColumns(iConditionArray[i], list);
                }
            }
        }

        private String[] searchForAdditionalClearColumns(IRowDefinition iRowDefinition, String[] stringArray, String[] stringArray2) throws ModelException {
            String[] stringArray3;
            ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
            for (String string : stringArray3 = iRowDefinition.getColumnNames()) {
                String[] stringArray4;
                ICellEditor iCellEditor = iRowDefinition.getColumnDefinition(string).getDataType().getCellEditor();
                if (!(iCellEditor instanceof ILinkedCellEditor)) continue;
                ILinkedCellEditor iLinkedCellEditor = (ILinkedCellEditor)iCellEditor;
                ReferenceDefinition referenceDefinition = iLinkedCellEditor.getLinkReference();
                String[] stringArray5 = ArrayUtil.removeAll(this.getConditionColumns(iLinkedCellEditor.getSearchColumnMapping(), iLinkedCellEditor.getAdditionalCondition()), stringArray2);
                if (referenceDefinition == null || stringArray5 == null || ArrayUtil.intersect(stringArray, stringArray5).length <= 0) continue;
                for (String string2 : stringArray4 = ArrayUtil.removeAll(referenceDefinition.getColumnNames(), stringArray)) {
                    if (arrayUtil.contains(string2)) continue;
                    arrayUtil.add(string2);
                }
            }
            return arrayUtil.toArray(new String[arrayUtil.size()]);
        }

        @Override
        public void uninstallEditor() {
            this.cellEditorComponent.getEditorComponent().getDocument().removeDocumentListener(this);
            this.cellEditorComponent.getEditorComponent().removeKeyListener(this);
            this.cellEditorComponent.getEditorComponent().removeFocusListener(this);
            this.cellEditorComponent.removePopupMenuListener(this);
            this.table.getJTable().removeKeyListener(this);
            this.table.getJTable().removeMouseListener(this);
            this.table.setDataBook(null);
        }

        @Override
        public void updateEditor() {
            this.cellEditorComponent.setTranslation(((IControl)((Object)this.cellEditorListener)).getTranslation());
            this.cellEditorComponent.setTranslationEnabled(((IControl)((Object)this.cellEditorListener)).isTranslationEnabled());
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        private String getWildCardString(Object object) {
            if (this.cellEditor.isSearchTextAnywhere()) {
                return "*" + object + "*";
            }
            return object + "*";
        }

        private ICondition getSearchCondition(ICondition iCondition) {
            if (iCondition == null) {
                iCondition = this.cellEditor.additionalCondition;
            } else if (this.cellEditor.additionalCondition != null) {
                iCondition = iCondition.and(this.cellEditor.additionalCondition);
            }
            if (this.searchColumns != null) {
                for (int i = 0; i < this.searchColumns.length; ++i) {
                    Equals equals = new Equals(this.dataRow, this.searchColumns[i], this.referencedSearchColumns[i]);
                    iCondition = iCondition == null ? equals : iCondition.and(equals);
                }
            }
            return iCondition;
        }

        private void setValuesAndClearIfNecessary(Object[] objectArray) throws ModelException {
            IDataRow iDataRow = this.dataRow.createDataRow(this.columnNames);
            this.dataRow.setValues(this.columnNames, objectArray);
            if (!this.dataRow.equals(iDataRow, this.columnNames)) {
                this.dataRow.setValues(this.additionalClearColumns, null);
            }
        }

        @Override
        public void saveEditing() throws ModelException {
            if (this.popupChanged && this.referencedDataBook.getSelectedRow() >= 0) {
                this.setValuesAndClearIfNecessary(this.referencedDataBook.getValues(this.referencedColumnNames));
            } else {
                Object object = this.cellEditorComponent.getEditor().getItem();
                if (object == null || "".equals(object)) {
                    Object[] objectArray = new Object[this.referencedColumnNames.length];
                    this.setValuesAndClearIfNecessary(objectArray);
                } else {
                    this.referencedDataBook.setFilter(this.getSearchCondition(new Like(this.getRelevantSearchColumnName(), object)));
                    if (this.referencedDataBook.getDataRow(0) != null && this.referencedDataBook.getDataRow(1) == null) {
                        this.setValuesAndClearIfNecessary(this.referencedDataBook.getDataRow(0).getValues(this.referencedColumnNames));
                    } else if (this.cellEditor.isValidationEnabled()) {
                        this.referencedDataBook.setFilter(this.getSearchCondition(new LikeIgnoreCase(this.getRelevantSearchColumnName(), (Object)this.getWildCardString(object))));
                        if (this.referencedDataBook.getDataRow(0) != null && this.referencedDataBook.getDataRow(1) == null) {
                            this.setValuesAndClearIfNecessary(this.referencedDataBook.getDataRow(0).getValues(this.referencedColumnNames));
                        } else {
                            this.setValuesAndClearIfNecessary(this.dataRow.getValues(this.columnNames));
                        }
                    } else {
                        Object[] objectArray = new Object[this.referencedColumnNames.length];
                        objectArray[this.columnIndex] = object;
                        this.setValuesAndClearIfNecessary(objectArray);
                    }
                }
            }
            this.popupChanged = false;
        }

        @Override
        public void cancelEditing() throws ModelException {
            if (!this.ignoreEvent) {
                this.ignoreEvent = true;
                try {
                    try {
                        Font font;
                        Color color;
                        Object object;
                        boolean bl;
                        ColumnDefinition columnDefinition = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName);
                        this.cellEditorComponent.setSelectedItem(this.cellEditor.getDisplayValue(this.dataRow, this.columnName));
                        CellFormat cellFormat = null;
                        Container container = this.cellEditorComponent.getParent();
                        boolean bl2 = bl = container == null || container.isEnabled();
                        if (this.dataRow instanceof IDataBook) {
                            object = (IDataBook)this.dataRow;
                            this.cellEditorComponent.setEditorEditable(bl && object.isUpdateAllowed() && !columnDefinition.isReadOnly() && object.getSelectedRow() >= 0);
                            if (this.cellEditorListener.getCellFormatter() != null) {
                                try {
                                    cellFormat = this.cellEditorListener.getCellFormatter().getCellFormat((IDataBook)object, object.getDataPage(), (IDataRow)object, this.columnName, object.getSelectedRow(), -1);
                                }
                                catch (ModelException modelException) {}
                            }
                        } else {
                            this.cellEditorComponent.setEditorEditable(bl && !columnDefinition.isReadOnly());
                        }
                        if (cellFormat == null) {
                            object = null;
                            color = null;
                            font = null;
                        } else {
                            object = cellFormat.getBackground();
                            color = cellFormat.getForeground();
                            font = cellFormat.getFont();
                        }
                        if (font == null) {
                            font = ((Component)((Object)this.cellEditorListener)).getFont();
                        }
                        if (color == null && ((Component)((Object)this.cellEditorListener)).isForegroundSet()) {
                            color = ((Component)((Object)this.cellEditorListener)).getForeground();
                        }
                        if (object == null && ((Component)((Object)this.cellEditorListener)).isBackgroundSet()) {
                            object = ((Component)((Object)this.cellEditorListener)).getBackground();
                        }
                        this.cellEditorComponent.getEditorComponent().setFont(font);
                        if (this.cellEditorComponent.isEditorEditable()) {
                            if (object == null) {
                                object = columnDefinition.isNullable() ? JVxUtil.getSystemColor("IControl.background") : JVxUtil.getSystemColor("IControl.mandatoryBackground");
                            }
                            if (this.cellEditorComponent.getEditorComponent().hasFocus()) {
                                this.cellEditorComponent.getEditorComponent().selectAll();
                            } else {
                                this.cellEditorComponent.getEditorComponent().select(0, 0);
                            }
                        } else {
                            object = JVxUtil.getSystemColor("IControl.readOnlyBackground");
                            this.cellEditorComponent.getEditorComponent().select(0, 0);
                        }
                        this.cellEditorComponent.getEditorComponent().setBackground((Color)object);
                        this.cellEditorComponent.getEditorComponent().setForeground(color);
                        if (this.dynamicAlignment != null) {
                            int n = this.dynamicAlignment.getHorizontalAlignment();
                            if (n == -1) {
                                n = this.cellEditor.getHorizontalAlignment();
                            }
                            ((JTextField)this.cellEditorComponent.getEditorComponent()).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(n));
                        }
                        if (container instanceof JComponent) {
                            this.cellEditorComponent.getEditorComponent().putClientProperty("tabIndex", ((JComponent)container).getClientProperty("tabIndex"));
                        }
                        this.table.setCellFormatter(this.cellEditorListener.getCellFormatter());
                    }
                    catch (Exception exception) {
                        this.cellEditorComponent.setSelectedItem(null);
                        this.cellEditorComponent.setEditorEditable(false);
                        this.cellEditorComponent.getEditorComponent().setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
                        throw new ModelException("Editor cannot be restored!", exception);
                    }
                    Object var10_11 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                    throw throwable;
                }
            }
        }

        @Override
        public Object getSelectedItem() {
            try {
                if (this.popupChanged && this.referencedDataBook.getSelectedRow() >= 0) {
                    return this.referencedDataBook.getValue(this.referencedColumnName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.cellEditorComponent.getEditor().getItem();
        }

        @Override
        public void setSelectedItem(Object object) {
            try {
                if (this.firstEditingStarted) {
                    this.referencedDataBook.setFilter(this.getSearchCondition(null));
                    if (this.cellEditor.isSortByColumnName()) {
                        this.referencedDataBook.setSort(new SortDefinition(this.referencedColumnName));
                    }
                    if (object != null) {
                        String[] stringArray = new String[]{this.referencedColumnName};
                        IDataRow iDataRow = this.referencedDataBook.createEmptyRow(null);
                        iDataRow.setValue(this.referencedColumnName, object);
                        long l = System.currentTimeMillis();
                        this.referencedDataBook.setSelectedRow(-1);
                        int n = 0;
                        IChangeableDataRow iChangeableDataRow = this.referencedDataBook.getDataRow(n);
                        while (iChangeableDataRow != null && this.referencedDataBook.getSelectedRow() < 0 && System.currentTimeMillis() - l < 1000L) {
                            if (iDataRow.equals(iChangeableDataRow, stringArray)) {
                                this.referencedDataBook.setSelectedRow(n);
                                continue;
                            }
                            iChangeableDataRow = this.referencedDataBook.getDataRow(++n);
                        }
                    }
                } else if (object == null) {
                    this.referencedDataBook.setFilter(this.getSearchCondition(null));
                } else {
                    this.referencedDataBook.setFilter(this.getSearchCondition(new LikeIgnoreCase(this.getRelevantSearchColumnName(), (Object)this.getWildCardString(object))));
                }
                this.table.setColumnView(this.cellEditor.getColumnView());
                if (this.cellEditor.automaticTableHeaderVisibility) {
                    this.table.setTableHeaderVisible(this.referencedDataBook.getDataRow(0) != null && this.table.getColumnView().getColumnCount() > 2);
                } else {
                    this.table.setTableHeaderVisible(this.referencedDataBook.getDataRow(0) != null && this.cellEditor.isTableHeaderVisible());
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            this.popupChanged = false;
        }

        @Override
        public Object getElementAt(int n) {
            return null;
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        this.cellEditorComponent.setPopupCanceled(true);
                        this.cellEditorComponent.setPopupVisible(false);
                        this.fireEditingComplete("ESCAPE_KEY", true);
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        if (this.cellEditorComponent.isPopupVisible()) {
                            this.popupChanged = true;
                            this.fireEditingStarted();
                            this.cellEditorComponent.setPopupVisible(false);
                        }
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY", true);
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY", true);
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY", true);
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY", true);
                        break;
                    }
                    case 38: 
                    case 40: {
                        if (!this.cellEditorComponent.isPopupVisible()) break;
                        this.table.keyPressed(keyEvent);
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 38: 
                    case 40: {
                        if (!this.cellEditorComponent.isPopupVisible()) break;
                        this.table.keyReleased(keyEvent);
                        break;
                    }
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.fireEditingComplete("ESCAPE_KEY", false);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.cellEditorComponent.getEditorComponent().select(this.cellEditorComponent.getEditorComponent().getSelectionStart(), this.cellEditorComponent.getEditorComponent().getSelectionEnd());
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            try {
                this.referencedDataBook.setReadOnly(this.cellEditor.isTableReadonly());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            if (this.firstEditingStarted) {
                this.cellEditorComponent.getEditorComponent().selectAll();
            }
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.table.scrollToSelectedCell();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (!this.cellEditorComponent.isPopupVisible() && this.cellEditorComponent.isEditorEditable()) {
                this.cellEditorComponent.getEditorComponent().selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && !this.cellEditorComponent.isPopupFocusEvent(focusEvent)) {
                this.fireEditingComplete("FOCUS_LOST", true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.popupChanged = true;
            this.fireEditingStarted();
            this.fireEditingComplete("ENTER_KEY", true);
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
                if (this.cellEditor.isAutoOpenPopup() && !this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        protected void fireEditingComplete(String string, boolean bl) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                if (bl && this.cellEditorComponent.isPopupVisible()) {
                    this.ignoreEvent = true;
                    this.cellEditorComponent.setPopupCanceled(true);
                    this.cellEditorComponent.setPopupVisible(false);
                    this.ignoreEvent = false;
                }
                this.cellEditorListener.editingComplete(string);
            }
        }

        private String getRelevantSearchColumnName() {
            if (this.displayColumnName != null) {
                return this.displayColumnName;
            }
            return this.referencedColumnName;
        }
    }
}

