/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.config.DBObjects;
import com.sibvisions.rad.server.security.AbstractDBSecurityManager;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.UUID;
import javax.rad.remote.ChangePasswordException;
import javax.rad.server.ExpiredException;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;
import javax.rad.server.InactiveException;
import javax.rad.server.InvalidPasswordException;
import javax.rad.server.NotFoundException;

public class DBSecurityManager
extends AbstractDBSecurityManager {
    protected static final String TABLE_USERS = "USERS";
    protected static final String TABLE_AUTOLOGIN = "AUTOLOGIN";
    protected static final String VIEW_ACCESSRULES = "V_ACCESSRULES";
    private PreparedStatement psAutoLogin;
    private PreparedStatement psInsertAutoLogin;
    private PreparedStatement psDeleteAutoLoginKey;
    private PreparedStatement psDeleteAutoLoginUser;
    private PreparedStatement psUserId;
    private PreparedStatement psUserName;
    private PreparedStatement psAccessRule;
    private PreparedStatement psChangePwd;
    private PreparedStatement psChangePwdUnset;
    private String sUsersTable;
    private String sUsersId;
    private String sUsersName;
    private String sUsersChgPwd;
    private String sUsersPwd;
    private String sAutoLoginTable;
    private String sAutoLoginId;
    private String sAutoLoginKey;
    private String sAccessTable;
    private String sAccessUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void validateAuthentication(ISession iSession) throws Exception {
        String string = iSession.getApplicationName();
        String string2 = iSession.getUserName();
        IConfiguration iConfiguration = iSession.getConfig();
        ResultSet resultSet = null;
        boolean bl = false;
        Connection connection = this.openConnection(iSession);
        try {
            try {
                BigDecimal bigDecimal;
                boolean bl2;
                block35: {
                    Object object;
                    String string3;
                    block34: {
                        string3 = (String)iSession.getProperty("client.login.key");
                        if (this.psAutoLogin != null && string3 != null) {
                            object = null;
                            try {
                                Object var12_11;
                                block33: {
                                    try {
                                        this.psAutoLogin.clearParameters();
                                        this.psAutoLogin.setString(1, string3);
                                        object = this.psAutoLogin.executeQuery();
                                        if (!object.next()) break block33;
                                        this.psUserId.clearParameters();
                                        this.psUserId.setBigDecimal(1, object.getBigDecimal(1));
                                        resultSet = this.psUserId.executeQuery();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        this.debug(exception);
                                        var12_11 = null;
                                        object = (ResultSet)CommonUtil.close(object);
                                        break block34;
                                    }
                                }
                                var12_11 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_12 = null;
                                object = (ResultSet)CommonUtil.close(object);
                                throw throwable;
                            }
                            object = (ResultSet)CommonUtil.close(object);
                        }
                    }
                    if (resultSet == null) {
                        this.psUserName.clearParameters();
                        this.psUserName.setString(1, string2);
                        resultSet = this.psUserName.executeQuery();
                    }
                    this.validateUser(iSession, resultSet);
                    if (!bl) {
                        try {
                            object = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD"));
                        }
                        catch (SQLException sQLException) {
                            object = null;
                        }
                        if (!this.isPasswordValid(iSession, (String)object)) {
                            throw new InvalidPasswordException("Invalid password for '" + string2 + "' and application '" + string + "'");
                        }
                    }
                    try {
                        object = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD"));
                    }
                    catch (SQLException sQLException) {
                        object = null;
                    }
                    if (this.isChangePassword(iSession, (String)object)) {
                        throw new ChangePasswordException("Please change your password");
                    }
                    bl2 = Boolean.valueOf((String)iSession.getProperty("client.login.auto"));
                    bigDecimal = resultSet.getBigDecimal(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ID"));
                    if (string3 == null && bl2 && this.psAutoLogin != null && this.psDeleteAutoLoginUser != null && this.psInsertAutoLogin != null) {
                        string3 = UUID.randomUUID().toString();
                        boolean bl3 = connection.getAutoCommit();
                        try {
                            try {
                                if (bl3) {
                                    connection.setAutoCommit(false);
                                }
                                this.psDeleteAutoLoginUser.clearParameters();
                                this.psDeleteAutoLoginUser.setBigDecimal(1, bigDecimal);
                                if (this.psDeleteAutoLoginUser.execute()) {
                                    CommonUtil.close(this.psDeleteAutoLoginUser.getResultSet());
                                }
                                this.psInsertAutoLogin.clearParameters();
                                this.psInsertAutoLogin.setBigDecimal(1, bigDecimal);
                                this.psInsertAutoLogin.setString(2, string3);
                                if (this.psInsertAutoLogin.execute()) {
                                    CommonUtil.close(this.psInsertAutoLogin.getResultSet());
                                }
                                iSession.setProperty("client.login.key", string3);
                                connection.commit();
                            }
                            catch (Exception exception) {
                                connection.rollback();
                                this.error(exception);
                                Object var15_23 = null;
                                if (bl3) {
                                    connection.setAutoCommit(true);
                                }
                                break block35;
                            }
                            Object var15_22 = null;
                            if (!bl3) break block35;
                        }
                        catch (Throwable throwable) {
                            Object var15_24 = null;
                            if (!bl3) throw throwable;
                            connection.setAutoCommit(true);
                            throw throwable;
                        }
                        connection.setAutoCommit(true);
                    }
                }
                if (bl) {
                    if (iSession instanceof AbstractSession) {
                        try {
                            ((AbstractSession)iSession).setUserName(resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "USERNAME")));
                        }
                        catch (SQLException sQLException) {
                            throw new SecurityException("USERNAME column for application '" + string + "' was not found!");
                        }
                    }
                } else if (!bl2) {
                    iSession.setProperty("client.login.key", null);
                }
                this.postAuthentication(iSession, bigDecimal);
            }
            catch (SQLException sQLException) {
                this.error(sQLException);
                throw new SecurityException("Authentication for user '" + string2 + "' and application '" + string + "' is not possible");
            }
            Object var17_27 = null;
        }
        catch (Throwable throwable) {
            Object var17_28 = null;
            resultSet = (ResultSet)CommonUtil.close(resultSet);
            throw throwable;
        }
        resultSet = (ResultSet)CommonUtil.close(resultSet);
    }

    public synchronized void changePassword(ISession iSession) throws Exception {
        String string = (String)iSession.getProperty("client.oldpassword");
        String string2 = (String)iSession.getProperty("client.newpassword");
        this.validatePassword(iSession, string, string2);
        String string3 = iSession.getApplicationName();
        String string4 = iSession.getUserName();
        IConfiguration iConfiguration = iSession.getConfig();
        this.openConnection(iSession);
        ResultSet resultSet = null;
        try {
            try {
                String string5;
                this.psUserName.clearParameters();
                this.psUserName.setString(1, string4);
                resultSet = this.psUserName.executeQuery();
                this.validateUser(iSession, resultSet);
                try {
                    string5 = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD"));
                }
                catch (SQLException sQLException) {
                    string5 = null;
                }
                if ((iSession.getProperty("client.login.key") != null && iSession.getPassword() == null || this.comparePassword(iConfiguration, iSession.getPassword(), string)) && this.comparePassword(iConfiguration, string, string5)) {
                    boolean bl;
                    try {
                        resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD"));
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                    PreparedStatement preparedStatement = bl ? this.psChangePwdUnset : this.psChangePwd;
                    preparedStatement.clearParameters();
                    preparedStatement.setString(1, DBSecurityManager.getEncryptedPassword(iConfiguration, string2));
                    preparedStatement.setString(2, string4);
                    if (preparedStatement.execute()) {
                        CommonUtil.close(preparedStatement.getResultSet());
                    }
                    if (preparedStatement.getUpdateCount() != 1) {
                        throw new NotFoundException("User '" + string4 + "' was not found for application '" + string3 + "'");
                    }
                } else {
                    throw new InvalidPasswordException("Invalid password for '" + string4 + "' and application '" + string3 + "'");
                }
                Object var12_14 = null;
            }
            catch (SQLException sQLException) {
                this.debug(sQLException);
                throw new SecurityException("Error while changing password of '" + string4 + "' for application '" + string3 + "'");
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            resultSet = (ResultSet)CommonUtil.close(resultSet);
            throw throwable;
        }
        resultSet = (ResultSet)CommonUtil.close(resultSet);
    }

    public synchronized void logout(ISession iSession) {
        if (Boolean.valueOf((String)iSession.getProperty("userlogout")).booleanValue()) {
            try {
                String string = (String)iSession.getProperty("client.login.key");
                if (string != null) {
                    this.openConnection(iSession);
                    this.psDeleteAutoLoginKey.clearParameters();
                    this.psDeleteAutoLoginKey.setString(1, string);
                    if (this.psDeleteAutoLoginKey.execute()) {
                        CommonUtil.close(this.psDeleteAutoLoginKey.getResultSet());
                    }
                    iSession.setProperty("client.login.key", null);
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IAccessController getAccessController(ISession iSession) throws Exception {
        Object object;
        IConfiguration iConfiguration = iSession.getConfig();
        ResultSet resultSet = null;
        this.openConnection(iSession);
        if (this.psAccessRule == null) {
            return null;
        }
        try {
            this.psAccessRule.clearParameters();
            this.psAccessRule.setObject(1, iSession.getUserName());
            resultSet = this.psAccessRule.executeQuery();
            String string = DBSecurityManager.getSimpleEnvironmentName(iSession);
            String string2 = DBObjects.getYesValue(iConfiguration);
            IAccessController iAccessController = this.createAccessController(iSession);
            String string3 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "LIFECYCLENAME");
            String string4 = null;
            String string5 = null;
            String string6 = null;
            boolean bl = false;
            if (string != null) {
                string4 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_DESKTOP");
                string5 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_WEB");
                string6 = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "ENV_MOBILE");
                object = resultSet.getMetaData();
                int n = object.getColumnCount();
                for (int i = 1; i <= n && !bl; ++i) {
                    String string7 = object.getColumnName(i);
                    if (!string7.equals(string4) && !string7.equals(string5) && !string7.equals(string6)) continue;
                    bl = true;
                }
            }
            while (resultSet.next()) {
                boolean bl2 = true;
                if (bl) {
                    if (string.equals("DESKTOP")) {
                        if (!string2.equals(resultSet.getString(string4))) {
                            bl2 = false;
                        }
                    } else if (string.equals("WEB")) {
                        if (!string2.equals(resultSet.getString(string5))) {
                            bl2 = false;
                        }
                    } else if (string.equals("MOBILE") && !string2.equals(resultSet.getString(string6))) {
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                iAccessController.addAccess(resultSet.getString(string3));
            }
            object = iAccessController;
            Object var18_19 = null;
        }
        catch (SQLException sQLException) {
            IAccessController iAccessController;
            try {
                this.debug(sQLException);
                iAccessController = null;
                Object var18_20 = null;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                resultSet = (ResultSet)CommonUtil.close(resultSet);
                throw throwable;
            }
            resultSet = (ResultSet)CommonUtil.close(resultSet);
            return iAccessController;
        }
        resultSet = (ResultSet)CommonUtil.close(resultSet);
        return object;
    }

    protected void updateConfiguration(IConfiguration iConfiguration) throws Exception {
        this.sUsersTable = DBObjects.getTableName(iConfiguration, TABLE_USERS);
        this.sUsersId = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ID");
        this.sUsersName = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "USERNAME");
        this.sUsersChgPwd = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD");
        this.sUsersPwd = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD");
        this.sAutoLoginTable = DBObjects.getTableName(iConfiguration, TABLE_AUTOLOGIN);
        this.sAutoLoginId = DBObjects.getColumnName(iConfiguration, TABLE_AUTOLOGIN, "USER_ID");
        this.sAutoLoginKey = DBObjects.getColumnName(iConfiguration, TABLE_AUTOLOGIN, "LOGINKEY");
        this.sAccessTable = DBObjects.getTableName(iConfiguration, VIEW_ACCESSRULES);
        this.sAccessUser = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "USERNAME");
    }

    protected void closeStatements() {
        super.closeStatements();
        this.psUserId = null;
        this.psUserName = null;
        this.psChangePwd = null;
        this.psChangePwdUnset = null;
        this.psAutoLogin = null;
        this.psInsertAutoLogin = null;
        this.psDeleteAutoLoginKey = null;
        this.psDeleteAutoLoginUser = null;
        this.psAccessRule = null;
    }

    protected void initStatements(Connection connection) throws Exception {
        this.psUserId = this.prepareStatement(connection, "select * from " + this.sUsersTable + " u where u." + this.sUsersId + " = ?");
        this.psUserName = this.prepareStatement(connection, "select * from " + this.sUsersTable + " u where u." + this.sUsersName + " = ?");
        this.psChangePwd = this.prepareStatement(connection, "update " + this.sUsersTable + " u set u." + this.sUsersPwd + " = ? " + " where u." + this.sUsersName + " = ?");
        this.psChangePwdUnset = this.prepareStatement(connection, "update " + this.sUsersTable + " u set u." + this.sUsersPwd + " = ?, " + "u." + this.sUsersChgPwd + " = 'N' " + " where u." + this.sUsersName + " = ?");
        try {
            this.psAutoLogin = this.prepareStatement(connection, "select " + this.sAutoLoginId + " from " + this.sAutoLoginTable + " where " + this.sAutoLoginKey + " = ?");
            this.psInsertAutoLogin = this.prepareStatement(connection, "insert into " + this.sAutoLoginTable + "(" + this.sAutoLoginId + ", " + this.sAutoLoginKey + ") values (?, ?)");
            this.psDeleteAutoLoginKey = this.prepareStatement(connection, "delete from " + this.sAutoLoginTable + " where " + this.sAutoLoginKey + " = ?");
            this.psDeleteAutoLoginUser = this.prepareStatement(connection, "delete from " + this.sAutoLoginTable + " where " + this.sAutoLoginId + " = ?");
        }
        catch (SQLException sQLException) {
            this.close(this.psAutoLogin, this.psInsertAutoLogin, this.psDeleteAutoLoginKey, this.psDeleteAutoLoginUser);
            this.psAutoLogin = null;
            this.psInsertAutoLogin = null;
            this.psDeleteAutoLoginKey = null;
            this.psDeleteAutoLoginUser = null;
        }
        try {
            this.psAccessRule = this.prepareStatement(connection, "select * from " + this.sAccessTable + " where " + this.sAccessUser + " = ?");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String getAliveQuery() {
        return "select ID from " + this.sUsersTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateUser(ISession iSession, ResultSet resultSet) throws Exception {
        Timestamp timestamp;
        Timestamp timestamp2;
        String string;
        String string2 = iSession.getApplicationName();
        String string3 = iSession.getUserName();
        if (!resultSet.next()) throw new NotFoundException("User '" + string3 + "' was not found for application '" + string2 + "'");
        IConfiguration iConfiguration = iSession.getConfig();
        try {
            string = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ACTIVE"));
        }
        catch (SQLException sQLException) {
            string = null;
        }
        if (!this.isActive(iSession, string)) throw new InactiveException("User '" + string3 + "' is inactive for application '" + string2 + "'");
        try {
            timestamp2 = resultSet.getTimestamp(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "VALID_FROM"));
        }
        catch (SQLException sQLException) {
            timestamp2 = null;
        }
        try {
            timestamp = resultSet.getTimestamp(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "VALID_TO"));
        }
        catch (SQLException sQLException) {
            timestamp = null;
        }
        if (this.isValid(iSession, timestamp2, timestamp)) return;
        throw new ExpiredException("User '" + string3 + "' is expired for application '" + string2 + "'");
    }

    protected boolean isActive(ISession iSession, String string) throws Exception {
        if (string == null) {
            return true;
        }
        return DBObjects.getYesValue(iSession.getConfig()).equals(string);
    }

    protected boolean isValid(ISession iSession, Timestamp timestamp, Timestamp timestamp2) {
        long l = System.currentTimeMillis();
        return !(timestamp != null && timestamp.getTime() > l || timestamp2 != null && timestamp2.getTime() <= l);
    }

    protected boolean isPasswordValid(ISession iSession, String string) throws Exception {
        return this.comparePassword(iSession.getConfig(), iSession.getPassword(), string);
    }

    protected boolean isChangePassword(ISession iSession, String string) throws Exception {
        if (string == null) {
            return false;
        }
        return DBObjects.getYesValue(iSession.getConfig()).equals(string);
    }

    protected void postAuthentication(ISession iSession, BigDecimal bigDecimal) throws Exception {
    }

    public static String getSimpleEnvironmentName(ISession iSession) {
        int n;
        String string = (String)iSession.getProperty("client.Launcher.environment");
        if (!StringUtil.isEmpty(string) && (n = string.indexOf(":")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }
}

