/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.http.rest;

import com.sibvisions.rad.server.DirectServerSession;
import com.sibvisions.rad.server.http.rest.LifeCycleConnector;
import com.sibvisions.rad.server.http.rest.RESTAdapter;
import com.sibvisions.util.log.LoggerFactory;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public class SecurityManagerVerifier
implements Verifier {
    private RESTAdapter adapter;

    public SecurityManagerVerifier(RESTAdapter rESTAdapter) {
        this.adapter = rESTAdapter;
    }

    public int verify(Request request, Response response) {
        if (request.getChallengeResponse() == null) {
            return 0;
        }
        String string = (String)request.getAttributes().get("APP_NAME");
        if (string == null) {
            return 0;
        }
        String string2 = this.getIdentifier(request, response);
        String string3 = new String(this.getSecret(request, response));
        DirectServerSession directServerSession = null;
        try {
            directServerSession = DirectServerSession.createMasterSession(string, string2, string3);
            request.getClientInfo().setUser((User)new LifeCycleConnector(this.adapter, directServerSession, (String)request.getAttributes().get("LCO_CLASS")));
            return 4;
        }
        catch (Throwable throwable) {
            LoggerFactory.getInstance(SecurityManagerVerifier.class).error(throwable);
            if (directServerSession != null) {
                try {
                    directServerSession.destroy();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    protected String getIdentifier(Request request, Response response) {
        return request.getChallengeResponse().getIdentifier();
    }

    protected char[] getSecret(Request request, Response response) {
        return request.getChallengeResponse().getSecret();
    }
}

