/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.util.xml.XmlNode;
import java.io.File;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationZone
extends Zone {
    private ServerZone zoneServer = null;

    ApplicationZone(File file) throws Exception {
        super(ApplicationZone.checkCaseSensitive(file));
    }

    ApplicationZone(InputStream inputStream) throws Exception {
        super(inputStream);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ApplicationZone applicationZone = (ApplicationZone)super.clone();
        if (this.zoneServer != null) {
            applicationZone.zoneServer = (ServerZone)this.zoneServer.clone();
        }
        return applicationZone;
    }

    @Override
    public synchronized String getProperty(String string, String string2) throws Exception {
        String string3 = super.getProperty(string, null);
        if (string3 == null && (string3 = this.getServerZone().getProperty("/server" + string.substring(12), string2)) == null) {
            return string2;
        }
        return string3;
    }

    @Override
    public synchronized List<String> getProperties(String string) throws Exception {
        List<String> list = super.getProperties(string);
        List<String> list2 = this.getServerZone().getProperties("/server" + string.substring(12));
        if (list == null) {
            return list2;
        }
        if (list2 != null) {
            for (String string2 : list2) {
                if (list.contains(string2)) continue;
                list.add(string2);
            }
        }
        return list;
    }

    @Override
    public synchronized List<XmlNode> getNodes(String string) throws Exception {
        List<XmlNode> list = super.getNodes(string);
        List<XmlNode> list2 = this.getServerZone().getNodes("/server" + string.substring(12));
        if (list == null) {
            return list2;
        }
        if (list2 != null) {
            list2.addAll(list);
            return list2;
        }
        return list;
    }

    @Override
    public synchronized XmlNode getNode(String string) throws Exception {
        XmlNode xmlNode = super.getNode(string);
        if (xmlNode == null) {
            return this.getServerZone().getNode("/server" + string.substring(12));
        }
        return xmlNode;
    }

    @Override
    public void setUpdateEnabled(boolean bl) {
        if (bl) {
            this.zoneServer = null;
        } else if (this.zoneServer == null) {
            ServerZone serverZone = Configuration.getServerZone();
            try {
                serverZone = (ServerZone)serverZone.clone();
                serverZone.setUpdateEnabled(false);
                this.zoneServer = serverZone;
            }
            catch (Exception exception) {
                throw new SecurityException("Invalid server configuration!", exception);
            }
        }
        super.setUpdateEnabled(bl);
    }

    public String getName() {
        File file = this.getDirectory();
        return file != null ? file.getName() : null;
    }

    public ServerZone getServerZone() {
        if (this.zoneServer == null) {
            return Configuration.getServerZone();
        }
        return this.zoneServer;
    }

    private static File checkCaseSensitive(File file) throws Exception {
        File file2;
        if (file != null && (file2 = file.getCanonicalFile()) != null && !file.getName().equals(file2.getName())) {
            throw new Exception("Invalid application. Directory name is case sensitive!");
        }
        return file;
    }
}

